/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.misctype.DataBuffer;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.WAVEDescriptor;
import tv.amwa.maj.model.impl.AAFFileDescriptorImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=11264, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="WAVEDescriptor", description="The WAVEDescriptor class specifies that a File SourcePackage is associated with audio essence formatted according to the RIFF Waveform Audio File Format (WAVE).", symbol="WAVEDescriptor")
public class WAVEDescriptorImpl
extends AAFFileDescriptorImpl
implements WAVEDescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3439854186002522302L;
    private byte[] waveSummary;

    public WAVEDescriptorImpl() {
    }

    public WAVEDescriptorImpl(ContainerDefinition containerFormat, @DataBuffer byte[] summary) throws NullPointerException {
        if (summary == null) {
            throw new NullPointerException("Cannot create a new WAVE descriptor with a null summary value");
        }
        this.setContainerFormat(containerFormat);
        this.setWAVESummary(summary);
    }

    @Override
    @MediaProperty(uuid1=0x3030302, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="WAVESummary", aliases={"Summary", "WAVEDescriptorSummary"}, typeName="DataValue", optional=false, uniqueIdentifier=false, pid=14337, symbol="WAVESummary")
    public byte[] getWAVESummary() {
        return (byte[])this.waveSummary.clone();
    }

    @Override
    @MediaPropertySetter(value="WAVESummary")
    public void setWAVESummary(byte[] waveSummary) throws NullPointerException {
        this.waveSummary = (byte[])waveSummary.clone();
    }

    public static final byte[] initializeWAVESummary() {
        return new byte[0];
    }

    @Override
    public int getWAVESummaryBufferSize() {
        return this.waveSummary.length;
    }

    @Override
    public WAVEDescriptor clone() {
        return (WAVEDescriptor)super.clone();
    }
}

