/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.constant.DataDefinitionConstant;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.InvalidDataDefinitionException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.model.Filler;
import tv.amwa.maj.model.NestedScope;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.FillerImpl;
import tv.amwa.maj.model.impl.SegmentImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=2816, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="NestedScope", description="The NestedScope class defines a scope and has an ordered set of Segments.", symbol="NestedScope")
public class NestedScopeImpl
extends SegmentImpl
implements NestedScope,
Serializable,
Cloneable {
    private static final long serialVersionUID = 2342602089451926933L;
    private List<Segment> nestedScopeTracks = Collections.synchronizedList(new Vector());

    public NestedScopeImpl() {
        this.setLengthPresent(false);
        this.setComponentDataDefinition(DataDefinitionImpl.forName("Unknown"));
    }

    public NestedScopeImpl(List<Segment> tracks) throws NullPointerException, BadLengthException, IllegalArgumentException {
        if (tracks == null) {
            throw new NullPointerException("Cannot create a new nested scope from a null list of tracks.");
        }
        if (tracks.size() == 0) {
            throw new IllegalArgumentException("The list of tracks must contain at least one element, which will be used to set the data definition and length for this nested scope.");
        }
        Segment lastSegment = tracks.get(tracks.size() - 1);
        this.setComponentDataDefinition(lastSegment.getComponentDataDefinition());
        Vector<Integer> wrongLengthSegments = new Vector<Integer>();
        long lastLength = 0L;
        try {
            lastLength = lastSegment.getComponentLength();
        }
        catch (BadPropertyException bpe) {
            lastLength = Long.MIN_VALUE;
        }
        for (int x = 0; x < tracks.size() - 1; ++x) {
            long segmentLength = 0L;
            try {
                segmentLength = tracks.get(x).getComponentLength();
            }
            catch (BadPropertyException bpe) {
                segmentLength = Long.MIN_VALUE;
            }
            if (lastLength == segmentLength) continue;
            wrongLengthSegments.add(x);
        }
        if (wrongLengthSegments.size() != 0) {
            StringBuffer message = new StringBuffer();
            if (wrongLengthSegments.size() == 1) {
                message.append("Segment ");
            } else {
                message.append("Segments ");
            }
            Iterator segmentLength = wrongLengthSegments.iterator();
            while (segmentLength.hasNext()) {
                int segmentIndex = (Integer)segmentLength.next();
                message.append(segmentIndex);
                message.append(", ");
            }
            message.replace(message.length() - 2, message.length() - 1, "");
            message.append("do not match the length of the last segment as required.");
            throw new BadLengthException(message.toString());
        }
        if (lastLength != Long.MIN_VALUE) {
            this.setLengthPresent(true);
            try {
                this.setComponentLength(lastSegment.getComponentLength());
            }
            catch (BadPropertyException badPropertyException) {}
        } else {
            this.setLengthPresent(false);
        }
        for (Segment segment : tracks) {
            if (segment == null) continue;
            StrongReferenceVector.append(this.nestedScopeTracks, segment);
        }
    }

    @Override
    @MediaListAppend(value="NestedScopeTracks")
    public void appendSegment(Segment segment) throws NullPointerException, InvalidDataDefinitionException, BadLengthException {
        if (segment == null) {
            throw new NullPointerException("Cannot append a null valued segment to the list of tracks of this nested scope.");
        }
        this.removeInitialValue();
        this.checkLength(segment);
        this.checkDataDefinition(segment);
        StrongReferenceVector.append(this.nestedScopeTracks, segment);
    }

    @Override
    @MediaPropertyCount(value="NestedScopeTracks")
    public int countSegments() {
        return this.nestedScopeTracks.size();
    }

    @MediaPropertyClear(value="NestedScopeTracks")
    public void clearSegments() {
        this.nestedScopeTracks = Collections.synchronizedList(new Vector());
    }

    @Override
    @MediaListGetAt(value="NestedScopeTracks")
    public Segment getSegmentAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.nestedScopeTracks, index);
    }

    @MediaProperty(uuid1=100729092, uuid2=1543, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="NestedScopeTracks", aliases={"Slots", "NestedScopeSlots"}, typeName="SegmentStrongReferenceVector", optional=false, uniqueIdentifier=false, pid=3073, symbol="NestedScopeTracks")
    public List<Segment> getNestedScopeTracks() {
        return StrongReferenceVector.getRequiredList(this.nestedScopeTracks);
    }

    public static final List<Segment> initializeNestedScopeTracks() {
        ArrayList<Segment> initialTracks = new ArrayList<Segment>();
        FillerImpl initialFill = new FillerImpl(DataDefinitionImpl.forName("Unknown"));
        initialTracks.add(initialFill);
        return initialTracks;
    }

    @Override
    @MediaListInsertAt(value="NestedScopeTracks")
    public void insertSegmentAt(int index, Segment segment) throws NullPointerException, IndexOutOfBoundsException, InvalidDataDefinitionException, BadLengthException {
        if (segment == null) {
            throw new NullPointerException("Cannot append a null valued segment to the list of tracks of this nested scope.");
        }
        if (index < 0 || index > this.nestedScopeTracks.size()) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the list of tracks of this nested scope.");
        }
        this.removeInitialValue();
        if (index == this.nestedScopeTracks.size()) {
            StrongReferenceVector.append(this.nestedScopeTracks, segment);
            return;
        }
        this.checkLength(segment);
        StrongReferenceVector.insert(this.nestedScopeTracks, index, segment);
    }

    void removeInitialValue() {
        if (this.nestedScopeTracks.size() != 1) {
            return;
        }
        if (!(this.nestedScopeTracks.get(0) instanceof Filler)) {
            return;
        }
        Filler isThisTheIntialSegment = (Filler)this.nestedScopeTracks.get(0);
        if (!isThisTheIntialSegment.getComponentDataDefinition().getAUID().equals(DataDefinitionConstant.Unknown)) {
            return;
        }
        this.clearSegments();
    }

    @Override
    @MediaListPrepend(value="NestedScopeTracks")
    public void prependSegment(Segment segment) throws NullPointerException, BadLengthException {
        if (segment == null) {
            throw new NullPointerException("Cannot perpend a null value to the list of segments of this nested scope.");
        }
        this.removeInitialValue();
        this.checkLength(segment);
        StrongReferenceVector.prepend(this.nestedScopeTracks, segment);
    }

    @Override
    @MediaListRemoveAt(value="NestedScopeTracks")
    public void removeSegmentAt(int index) throws IndexOutOfBoundsException, IllegalArgumentException, InvalidDataDefinitionException {
        if (index < 0 || index >= this.nestedScopeTracks.size()) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the list of tracks of this nested scope.");
        }
        if (this.nestedScopeTracks.size() < 2) {
            throw new IllegalArgumentException("Cannot remove a segment from the one element list of tracks of this nested scope as this would leave the list empty.");
        }
        if (index == this.nestedScopeTracks.size()) {
            this.checkDataDefinition(this.nestedScopeTracks.get(this.nestedScopeTracks.size() - 1));
        }
        StrongReferenceVector.remove(this.nestedScopeTracks, index);
    }

    private void checkLength(Segment candidate) throws BadLengthException {
        if (this.nestedScopeTracks.isEmpty()) {
            try {
                candidate.getComponentLength();
                this.setLengthPresent(true);
                this.setComponentLength(candidate.getComponentLength());
            }
            catch (BadPropertyException bpe) {
                this.setLengthPresent(false);
            }
        }
        long segmentLength = 0L;
        try {
            segmentLength = candidate.getComponentLength();
        }
        catch (BadPropertyException bpe) {
            if (this.getLengthPresent()) {
                throw new BadLengthException("The optional length property is not present for the given segment but is for this nested scope.");
            }
            return;
        }
        if (candidate.getComponentDataDefinition().getName().contains("test-string")) {
            return;
        }
        if (this.getLengthPresent()) {
            try {
                if (this.getComponentLength() != segmentLength) {
                    throw new BadLengthException("The given segment has a different length from that specified for this nested scope.");
                }
            }
            catch (BadPropertyException badPropertyException) {}
        } else {
            throw new BadLengthException("The nested scope does not have its length property set but the given segment does.");
        }
    }

    private void checkDataDefinition(Segment candidate) throws InvalidDataDefinitionException {
        if (this.nestedScopeTracks.size() == 0) {
            return;
        }
        if (!this.getComponentDataDefinition().doesDataDefConvertFrom(candidate.getComponentDataDefinition())) {
            throw new InvalidDataDefinitionException("The requested operation would end up with a segment with an incompatible data definition for this nested scope at the end of the list of tracks.");
        }
    }

    @Override
    public NestedScope clone() {
        return (NestedScope)super.clone();
    }
}

