/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.BadTypeException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.exception.ObjectNotFoundException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyContains;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertyRemove;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionObjectReference;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionStrongObjectReference;
import tv.amwa.maj.meta.impl.MethodBag;
import tv.amwa.maj.meta.impl.PropertyDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionObjectReferenceImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=522, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionSet", description="The TypeDefinitionSet class defines a property type that has a collection of object references to uniquely identified objects. The order of the objects has no meaning.", symbol="TypeDefinitionSet")
public final class TypeDefinitionSetImpl
extends TypeDefinitionImpl
implements TypeDefinitionSet,
Serializable,
Cloneable {
    private static final long serialVersionUID = 7032285999083401616L;
    private WeakReference<TypeDefinition> setElementType;

    protected TypeDefinitionSetImpl() {
    }

    public TypeDefinitionSetImpl(AUID identification, @AAFString String typeName, TypeDefinition elementType) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new set type definition with a null identification.");
        }
        if (elementType == null) {
            throw new NullPointerException("Cannot create a new set type definition with a null element type.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.setElementType(elementType);
    }

    @Override
    public void addElement(PropertyValue setPropertyValue, PropertyValue elementPropertyValue) throws NullPointerException, IllegalPropertyValueException {
        if (setPropertyValue == null) {
            throw new NullPointerException("Cannot add an element to a null set property value.");
        }
        if (!this.equals(setPropertyValue.getType())) {
            throw new IllegalPropertyValueException("The type of the given set property value does not match this set type definition.");
        }
        if (elementPropertyValue == null) {
            throw new NullPointerException("Cannot add a null element property value to a set.");
        }
        if (!this.setElementType.equals(elementPropertyValue.getType())) {
            throw new IllegalPropertyValueException("The type of the given element property value does not match the element type of this set type definition.");
        }
        if (elementPropertyValue instanceof TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue) {
            ((SetValue)setPropertyValue).value.add(elementPropertyValue);
        } else {
            ((SetValue)setPropertyValue).value.add(elementPropertyValue.getValue());
        }
    }

    @Override
    public boolean containsElement(PropertyValue setPropertyValue, PropertyValue elementPropertyValue) throws NullPointerException, IllegalPropertyValueException {
        if (setPropertyValue == null) {
            throw new NullPointerException("Cannot check containment in a null set property value.");
        }
        if (!this.equals(setPropertyValue.getType())) {
            throw new IllegalPropertyValueException("The type of the given set property value does not match this set type definition.");
        }
        if (elementPropertyValue == null) {
            throw new NullPointerException("Cannot check to see whether a null element property value is contained in a set.");
        }
        if (!this.setElementType.equals(elementPropertyValue.getType())) {
            return false;
        }
        return ((SetValue)setPropertyValue).getValue().contains(elementPropertyValue.getValue());
    }

    @Override
    public int getCount(PropertyValue setPropertyValue) throws NullPointerException, IllegalPropertyValueException {
        if (setPropertyValue == null) {
            throw new NullPointerException("Cannot count the elements in a null set property value.");
        }
        if (!this.equals(setPropertyValue.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this set type definition.");
        }
        Object setValue = ((SetValue)setPropertyValue).getValue();
        if (setValue == null) {
            return -1;
        }
        return setValue.size();
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=3584, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="SetElementType", aliases={"ElementType"}, typeName="TypeDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=26, symbol="SetElementType")
    public TypeDefinition getElementType() {
        return this.setElementType.getTarget();
    }

    @MediaPropertySetter(value="SetElementType")
    public void setElementType(TypeDefinition elementType) throws NullPointerException {
        if (elementType == null) {
            throw new NullPointerException("Cannot set the element type of this set type definition to null.");
        }
        this.setElementType = new WeakReference<TypeDefinition>(elementType);
    }

    public static final TypeDefinition initializeSetElementType() {
        return TypeDefinitions.UTF16String;
    }

    @Override
    public Set<PropertyValue> getElements(PropertyValue setPropertyValue) throws NullPointerException, IllegalPropertyValueException {
        HashSet<PropertyValue> elementValues;
        if (setPropertyValue == null) {
            throw new NullPointerException("Cannot extract the elements of a null set property value.");
        }
        if (!this.equals(setPropertyValue.getType())) {
            throw new IllegalPropertyValueException("The type of the given property does not match this set property value.");
        }
        Object setValue = ((SetValue)setPropertyValue).getValue();
        if (setValue != null) {
            elementValues = new HashSet(setValue.size());
            Iterator iterator = setValue.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                elementValues.add(this.setElementType.getTarget().createValue(element));
            }
        } else {
            elementValues = new HashSet<PropertyValue>();
        }
        return elementValues;
    }

    @Override
    public void removeElement(PropertyValue setPropertyValue, PropertyValue elementPropertyValue) throws NullPointerException, IllegalPropertyValueException, BadTypeException, ObjectNotFoundException {
        if (setPropertyValue == null) {
            throw new NullPointerException("Cannot remove an element from a null set property value.");
        }
        if (!this.equals(setPropertyValue.getType())) {
            throw new IllegalPropertyValueException("The type of the given property does not match this set property value.");
        }
        if (elementPropertyValue == null) {
            throw new NullPointerException("Cannot remove an element from a set property value using a null element property value.");
        }
        if (!this.setElementType.equals(elementPropertyValue.getType())) {
            throw new BadTypeException("The type of the given element property value does not match the element type of this set type definition.");
        }
        Object setValue = ((SetValue)setPropertyValue).getValue();
        if (setValue == null || !setValue.contains(elementPropertyValue.getValue())) {
            throw new ObjectNotFoundException("The given set property value does not contain the given element to remove.");
        }
        setValue.remove(elementPropertyValue.getValue());
    }

    @Override
    public PropertyValue createEmptySet() {
        return new SetValue(this, Collections.synchronizedSet(new HashSet()));
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        if (javaValue == null) {
            throw new ClassCastException("Cannot create a null set. Use createEmptySet() to create an empty set for use in optional properties.");
        }
        Set<Object> creation = null;
        if (javaValue instanceof PropertyValue) {
            if (!((PropertyValue)((Object)javaValue)).getType().equals(this.setElementType)) {
                throw new ClassCastException("Cannot cast the given property value to the value of a singleton set as its value does not match the element type of this type definition.");
            }
            creation = Collections.synchronizedSet(new HashSet());
            creation.add(((PropertyValue)((Object)javaValue)).getValue());
        } else if (!javaValue.getClass().isArray() && !(javaValue instanceof Collection)) {
            this.setElementType.getTarget().createValue(javaValue);
            creation = Collections.synchronizedSet(new HashSet());
            creation.add(javaValue);
        }
        if (javaValue.getClass().isArray()) {
            Vector<Object> objectList = new Vector<Object>(Array.getLength(javaValue));
            for (int u = 0; u < Array.getLength(javaValue); ++u) {
                objectList.add(Array.get(javaValue, u));
            }
            javaValue = objectList;
        }
        if (javaValue instanceof Collection) {
            Collection javaCollection = javaValue;
            creation = Collections.synchronizedSet(new HashSet());
            for (Object element : javaCollection) {
                if (element instanceof PropertyValue) {
                    if (!((PropertyValue)element).getType().equals(this.setElementType)) {
                        throw new ClassCastException("An element of the given collection to create a new set with has a type that does not match the property type of this set type definition.");
                    }
                    creation.add(((PropertyValue)element).getValue());
                    continue;
                }
                this.setElementType.getTarget().createValue(element);
                creation.add(element);
            }
        }
        if (creation != null) {
            return new SetValue(this, creation);
        }
        throw new ClassCastException("Cannot cast the given Java value to a set property value.");
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.Set;
    }

    @Override
    MethodBag makeMethodBag(Method getter, Method[] candidateMethods, String propertyName) {
        return new SetMethodBag(getter, candidateMethods, propertyName);
    }

    @Override
    public void setPropertyValue(MetadataObject metadataObject, PropertyDefinition property, PropertyValue value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        SetMethodBag methods = (SetMethodBag)((PropertyDefinitionImpl)property).getMethodBag();
        methods.clear(metadataObject);
        if (methods.hasSetter()) {
            methods.set(metadataObject, (Set<Object>)((SetValue)value).getValue());
            return;
        }
        for (PropertyValue nextElement : this.getElements(value)) {
            methods.add(metadataObject, nextElement.getValue());
        }
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws EndOfDataException {
        PropertyValue setValue = this.createEmptySet();
        try {
            int setCount = buffer.getInt();
            int elementSize = buffer.getInt();
            for (int u = 0; u < setCount; ++u) {
                PropertyValue elementValue = this.setElementType.getTarget().createFromBytes(buffer);
                this.addElement(setValue, elementValue);
            }
        }
        catch (BufferUnderflowException bue) {
            throw new EndOfDataException("Buffer too small to write a set value. Buffer underflow exception: " + bue.getMessage());
        }
        return setValue;
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        long length = 8L;
        if (this.getCount(value) == 0) {
            return length;
        }
        PropertyValue sampleElement = null;
        Iterator<PropertyValue> iterator = this.getElements(value).iterator();
        if (iterator.hasNext()) {
            PropertyValue temporaryElement;
            sampleElement = temporaryElement = iterator.next();
        }
        return length += sampleElement.getType().lengthAsBytes(sampleElement) * (long)this.getCount(value);
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        if ((long)buffer.remaining() < this.lengthAsBytes(value)) {
            throw new InsufficientSpaceException("Insufficient space to write the given set value to the given buffer.");
        }
        int count = this.getCount(value);
        buffer.putInt(count);
        if (count == 0) {
            buffer.putInt(16);
            return null;
        }
        PropertyValue sampleElement = null;
        Iterator<PropertyValue> iterator = this.getElements(value).iterator();
        if (iterator.hasNext()) {
            PropertyValue temporaryElement;
            sampleElement = temporaryElement = iterator.next();
        }
        buffer.putInt((int)sampleElement.getType().lengthAsBytes(sampleElement));
        Vector<PropertyValue> setStrongReferences = new Vector<PropertyValue>(count);
        for (PropertyValue elementValue : this.getElements(value)) {
            elementValue.getType().writeAsBytes(elementValue, buffer);
            if (!(elementValue.getType() instanceof TypeDefinitionStrongObjectReference)) continue;
            setStrongReferences.add(elementValue);
        }
        return setStrongReferences;
    }

    @Override
    public boolean resolveReferences(PropertyValue value, Map<AUID, MetadataObject> referenceMap) throws NullPointerException, IllegalPropertyValueException {
        super.resolveReferences(value, referenceMap);
        boolean allResolved = true;
        Object setValue = ((SetValue)value).getValue();
        Vector elements = new Vector(setValue);
        for (Object element : elements) {
            if (!(element instanceof TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue)) continue;
            TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue unresolvedReference = (TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue)element;
            if (referenceMap.containsKey(unresolvedReference.getValue())) {
                setValue.remove(element);
                setValue.add(referenceMap.get(unresolvedReference.getValue()));
                continue;
            }
            System.err.println("Unable to resolve reference " + unresolvedReference.getValue().toString() + " for a set.");
            allResolved = false;
        }
        return allResolved;
    }

    @Override
    public String nameToAAFName(String name) {
        if (this.getElementType() instanceof TypeDefinitionObjectReference) {
            return "kAAFTypeID_" + super.nameToAAFName(name);
        }
        return super.nameToAAFName(name);
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionSet");
        super.appendMetadictXML(typeElement, namespace, prefix);
        XMLBuilder.appendElement((Node)typeElement, namespace, prefix, "ElementType", this.setElementType.getTarget().getName());
    }

    @Override
    public TypeDefinitionSet clone() {
        return (TypeDefinitionSet)super.clone();
    }

    public static class SetValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionSetImpl type;
        private Set<Object> value;

        private SetValue(TypeDefinitionSetImpl type, Set<Object> value) {
            this.type = type;
            this.setValue(value);
        }

        @Override
        public TypeDefinition getType() {
            return this.type;
        }

        @Override
        public Set<Object> getValue() {
            return this.value;
        }

        public boolean isDefinedType() {
            return true;
        }

        private void setValue(Set<Object> value) {
            this.value = value;
        }
    }

    public static class SetMethodBag
    extends MethodBag {
        private Method add = null;
        private Method count = null;
        private Method contains = null;
        private Method remove = null;
        private Method clear = null;
        private Method setter = null;

        public SetMethodBag(Method getter, Method[] candidateMethods, String propertyName) {
            super(getter, candidateMethods, propertyName);
            for (Method candidate : candidateMethods) {
                MediaSetAdd addCandidate = candidate.getAnnotation(MediaSetAdd.class);
                if (addCandidate != null && addCandidate.value().equals(propertyName)) {
                    this.add = candidate;
                    continue;
                }
                MediaPropertyCount countCandidate = candidate.getAnnotation(MediaPropertyCount.class);
                if (countCandidate != null && countCandidate.value().equals(propertyName)) {
                    this.count = candidate;
                    continue;
                }
                MediaPropertyContains containsCandidate = candidate.getAnnotation(MediaPropertyContains.class);
                if (containsCandidate != null && containsCandidate.value().equals(propertyName)) {
                    this.contains = candidate;
                    continue;
                }
                MediaPropertyRemove removeCandidate = candidate.getAnnotation(MediaPropertyRemove.class);
                if (removeCandidate != null && removeCandidate.value().equals(propertyName)) {
                    this.remove = candidate;
                    continue;
                }
                MediaPropertyClear clearCandidate = candidate.getAnnotation(MediaPropertyClear.class);
                if (clearCandidate != null && clearCandidate.value().equals(propertyName)) {
                    this.clear = candidate;
                    continue;
                }
                MediaPropertySetter setterCandidate = candidate.getAnnotation(MediaPropertySetter.class);
                if (setterCandidate == null || !setterCandidate.value().equals(propertyName)) continue;
                this.setter = candidate;
            }
        }

        public void add(MetadataObject metadataObject, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.add.invoke((Object)metadataObject, value);
        }

        public int count(MetadataObject metadataObject) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return (Integer)this.count.invoke((Object)metadataObject, new Object[0]);
        }

        public void contains(MetadataObject metadataObject, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.contains.invoke((Object)metadataObject, value);
        }

        public void remove(MetadataObject metadataObject, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.remove.invoke((Object)metadataObject, value);
        }

        public void clear(MetadataObject metadataObject) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.clear != null) {
                this.clear.invoke((Object)metadataObject, new Object[0]);
            }
        }

        public void set(MetadataObject metadataObject, Set<Object> values) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.setter.invoke((Object)metadataObject, values);
        }

        public boolean hasSetter() {
            return this.setter != null;
        }

        public String getAddName() {
            if (this.add == null) {
                return null;
            }
            return this.add.getName();
        }

        public String getCountName() {
            if (this.count == null) {
                return null;
            }
            return this.count.getName();
        }

        public String getClearName() {
            if (this.clear == null) {
                return null;
            }
            return this.clear.getName();
        }

        public String getContainsName() {
            if (this.contains == null) {
                return null;
            }
            return this.contains.getName();
        }

        public String getRemoveName() {
            if (this.remove == null) {
                return null;
            }
            return this.remove.getName();
        }
    }
}

