/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.aaf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSDocument;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyTable;
import org.apache.poi.poifs.property.RootProperty;
import org.apache.poi.poifs.storage.BlockAllocationTableReader;
import org.apache.poi.poifs.storage.BlockList;
import org.apache.poi.poifs.storage.HeaderBlockReader;
import org.apache.poi.poifs.storage.RawDataBlockList;
import org.apache.poi.poifs.storage.SmallBlockTableReader;
import tv.amwa.maj.io.aaf.AAFReaderEvent;
import tv.amwa.maj.io.aaf.AAFReaderListener;

public class AAFReader
extends POIFSReader {
    private AAFReaderListener readerListener = null;
    private boolean registryClosed = false;

    public void registerListener(POIFSReaderListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.registryClosed) {
            throw new IllegalStateException();
        }
        if (listener instanceof AAFReaderListener) {
            this.readerListener = (AAFReaderListener)listener;
        } else {
            super.registerListener(listener);
        }
    }

    public void read(InputStream stream) throws IOException {
        if (this.readerListener == null) {
            super.read(stream);
            return;
        }
        this.registryClosed = true;
        HeaderBlockReader header_block_reader = new HeaderBlockReader(stream);
        RawDataBlockList data_blocks = new RawDataBlockList(stream, header_block_reader.getBigBlockSize());
        new BlockAllocationTableReader(header_block_reader.getBigBlockSize(), header_block_reader.getBATCount(), header_block_reader.getBATArray(), header_block_reader.getXBATCount(), header_block_reader.getXBATIndex(), (BlockList)data_blocks);
        PropertyTable properties = new PropertyTable(header_block_reader.getBigBlockSize(), header_block_reader.getPropertyStart(), data_blocks);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks((POIFSBigBlockSize)header_block_reader.getBigBlockSize(), (RawDataBlockList)data_blocks, (RootProperty)properties.getRoot(), (int)header_block_reader.getSBATStart()), (BlockList)data_blocks, properties.getRoot().getChildren(), new POIFSDocumentPath());
    }

    private void processProperties(BlockList small_blocks, BlockList big_blocks, Iterator<Property> properties, POIFSDocumentPath path) throws IOException {
        while (properties.hasNext()) {
            Property property = properties.next();
            String name = property.getName();
            if (property.isDirectory()) {
                POIFSDocumentPath new_path = new POIFSDocumentPath(path, new String[]{name});
                this.readerListener.processPOIFSReaderEvent(new AAFReaderEvent(null, path, property));
                this.processProperties(small_blocks, big_blocks, ((DirectoryProperty)property).getChildren(), new_path);
                this.readerListener.processDirectoryEnd();
                continue;
            }
            int startBlock = property.getStartBlock();
            if (this.readerListener != null) {
                int size = property.getSize();
                POIFSDocument document = null;
                document = property.shouldUseSmallBlocks() ? new POIFSDocument(name, small_blocks.fetchBlocks(startBlock, -1), size) : new POIFSDocument(name, big_blocks.fetchBlocks(startBlock, -1), size);
                this.readerListener.processPOIFSReaderEvent(new AAFReaderEvent(new DocumentInputStream(document), path, property));
                continue;
            }
            if (property.shouldUseSmallBlocks()) {
                small_blocks.fetchBlocks(startBlock, -1);
                continue;
            }
            big_blocks.fetchBlocks(startBlock, -1);
        }
    }
}

