/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionCharacter;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=547, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionCharacter", description="The TypeDefinitionCharacter class defines a property type that has a value of a single 2-byte character.", symbol="TypeDefinitionCharacter")
public final class TypeDefinitionCharacterImpl
extends SingletonTypeDefinitionImpl
implements TypeDefinitionCharacter,
Serializable {
    private static final long serialVersionUID = -7854052728814156013L;

    protected TypeDefinitionCharacterImpl() {
    }

    public TypeDefinitionCharacterImpl(AUID identification, @AAFString String typeName) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new character type definition using a null identification value.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
    }

    @Override
    public PropertyValue createValueFromCharacter(char character) {
        return new CharacterValue(this, Character.valueOf(character));
    }

    @Override
    public char getCharacter(PropertyValue characterProperty) throws NullPointerException, IllegalPropertyValueException {
        if (characterProperty == null) {
            throw new NullPointerException("Cannot extract a character value from a null property value.");
        }
        if (!this.equals(characterProperty.getType())) {
            throw new IllegalPropertyValueException("The given character property does not match this kind of character type definition.");
        }
        return ((Character)characterProperty.getValue()).charValue();
    }

    @Override
    public void setCharacter(PropertyValue characterProperty, char character) throws NullPointerException, IllegalPropertyValueException {
        if (characterProperty == null) {
            throw new NullPointerException("Cannot set a character value into a null property value.");
        }
        if (!this.equals(characterProperty.getType())) {
            throw new IllegalPropertyValueException("The given character property does not match this kind of character type definition.");
        }
        ((CharacterValue)characterProperty).setValue(Character.valueOf(character));
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.Character;
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        if (javaValue == null) {
            throw new ClassCastException("Cannot cast a null value to a character type property.");
        }
        if (javaValue instanceof ByteBuffer) {
            return new CharacterValue(this, Character.valueOf(((ByteBuffer)javaValue).getChar()));
        }
        if (javaValue instanceof CharacterValue) {
            return new CharacterValue(this, ((CharacterValue)javaValue).getValue());
        }
        if (!(javaValue instanceof Character)) {
            throw new ClassCastException("Cannot create a character type property value with a non java.lang.Character value.");
        }
        return new CharacterValue(this, (Character)javaValue);
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        super.createFromBytes(buffer);
        if (buffer.remaining() < 2) {
            throw new EndOfDataException("Insufficient data in the given buffer to read a character value.");
        }
        return new CharacterValue(this, Character.valueOf(buffer.getChar()));
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        if (buffer.remaining() < 2) {
            throw new InsufficientSpaceException("Not enough space remaining in the given buffer to write a character value.");
        }
        buffer.putChar(((CharacterValue)value).getValue().charValue());
        return null;
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        return 2L;
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionCharacter");
        super.appendMetadictXML(typeElement, namespace, prefix);
    }

    @Override
    public TypeDefinitionCharacter clone() {
        return (TypeDefinitionCharacter)super.clone();
    }

    public static final class CharacterValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private Character value;
        private final TypeDefinitionCharacterImpl type;

        private CharacterValue(TypeDefinitionCharacterImpl type, Character value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public TypeDefinition getType() {
            return this.type;
        }

        public boolean isDefinedType() {
            return true;
        }

        @Override
        public Character getValue() {
            return this.value;
        }

        private void setValue(Character value) {
            this.value = value;
        }
    }
}

