/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.BadSizeException;
import tv.amwa.maj.exception.BadTypeException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionCharacter;
import tv.amwa.maj.meta.TypeDefinitionInteger;
import tv.amwa.maj.meta.TypeDefinitionString;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionCharacterImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=523, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionString", description="The TypeDefinitionString class defines a property type that consists of a zero-terminated array of the underlying character or integer type.", symbol="TypeDefinitionString")
public final class TypeDefinitionStringImpl
extends SingletonTypeDefinitionImpl
implements TypeDefinitionString,
Serializable,
Cloneable {
    private static final long serialVersionUID = -362492942547562578L;
    private WeakReference<TypeDefinition> elementType;
    private transient Charset charSet = Charset.forName("UTF-16");

    protected TypeDefinitionStringImpl() {
    }

    public TypeDefinitionStringImpl(AUID identification, @AAFString String typeName, TypeDefinition typeDefinition) throws NullPointerException, IllegalArgumentException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new string type definition with a null identification.");
        }
        if (typeDefinition == null) {
            throw new NullPointerException("Cannot create a new string type definition with a null element type.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.setElementType(typeDefinition);
    }

    @Override
    public void appendElements(PropertyValue stringProperty, PropertyValue[] elements) throws NullPointerException, IllegalPropertyValueException, BadTypeException, BadSizeException {
        if (stringProperty == null) {
            throw new NullPointerException("Cannot append to the value of a null string property.");
        }
        if (!this.equals(stringProperty.getType())) {
            throw new IllegalPropertyValueException("Cannot append to a string property value with a type does not match the type of this type definition.");
        }
        if (elements == null) {
            return;
        }
        for (PropertyValue property : elements) {
            if (this.elementType.equals(property.getType())) continue;
            throw new BadTypeException("The given array of property values contains at least one element of a type that does not match the underlying element type of this string type definition.");
        }
        if (this.elementType.getTarget() instanceof TypeDefinitionCharacter) {
            StringBuffer backToStringLike = new StringBuffer();
            for (PropertyValue property : elements) {
                backToStringLike.append((Character)property.getValue());
            }
            this.appendString(stringProperty, backToStringLike.toString());
            return;
        }
        TypeDefinitionInteger integerType = (TypeDefinitionInteger)this.elementType.getTarget();
        switch (integerType.getSize()) {
            case 1: {
                ByteBuffer bytes = ByteBuffer.allocate(elements.length);
                bytes.order(((ByteArrayStringValue)stringProperty).getByteOrder());
                for (int x = 0; x < elements.length; ++x) {
                    bytes.put((Byte)elements[x].getValue());
                }
                this.appendElements(stringProperty, bytes);
                break;
            }
            case 2: {
                ShortBuffer shorts = ShortBuffer.allocate(elements.length);
                for (int x = 0; x < elements.length; ++x) {
                    shorts.put(((Byte)elements[x].getValue()).byteValue());
                }
                this.appendElements(stringProperty, shorts);
                break;
            }
            case 4: {
                IntBuffer ints = IntBuffer.allocate(elements.length);
                for (int x = 0; x < elements.length; ++x) {
                    ints.put((Integer)elements[x].getValue());
                }
                this.appendElements(stringProperty, ints);
                break;
            }
            case 8: {
                LongBuffer longs = LongBuffer.allocate(elements.length);
                for (int x = 0; x < elements.length; ++x) {
                    longs.put((Long)elements[x].getValue());
                }
                this.appendElements(stringProperty, longs);
                break;
            }
            default: {
                throw new BadSizeException("Unexpextedly, the number of bytes per integer of the underlying element type of this string type definition is not supported by this implementation.");
            }
        }
    }

    @Override
    public void appendElements(PropertyValue stringProperty, Buffer elements) throws NullPointerException, IllegalArgumentException, IllegalPropertyValueException {
        if (stringProperty == null) {
            throw new NullPointerException("Cannot append to the value of a null string property.");
        }
        if (!this.equals(stringProperty.getType())) {
            throw new IllegalPropertyValueException("Cannot append to a string property value with a type that does not match this type definition.");
        }
        if (elements == null) {
            return;
        }
        if (stringProperty.getValue() == null) {
            this.setString(stringProperty, elements);
            return;
        }
        ByteBuffer buffer = this.convertBuffer(elements);
        if (this.elementType.getTarget() instanceof TypeDefinitionCharacter) {
            CharacterStringValue existing = (CharacterStringValue)stringProperty;
            StringBuffer extended = new StringBuffer(existing.getValue());
            extended.append(this.charSet.decode(buffer));
            existing.setValue(extended.toString());
            return;
        }
        ByteBuffer extensionBuffer = this.convertBuffer(elements);
        ByteArrayStringValue byteArrayValue = (ByteArrayStringValue)stringProperty;
        ByteBuffer existingBuffer = ByteBuffer.wrap(byteArrayValue.getValue());
        existingBuffer.order(byteArrayValue.getByteOrder());
        ByteBuffer extendedBuffer = ByteBuffer.allocate(existingBuffer.capacity() + existingBuffer.capacity());
        extendedBuffer.put(existingBuffer);
        extendedBuffer.put(extensionBuffer);
        byteArrayValue.setValue(extendedBuffer.array());
    }

    @Override
    public int getCount(PropertyValue stringProperty) throws NullPointerException, IllegalPropertyValueException {
        String countMe = this.getString(stringProperty);
        if (countMe == null) {
            return 0;
        }
        return this.getString(stringProperty).length();
    }

    @Override
    public Buffer getElements(PropertyValue stringProperty) throws NullPointerException, IllegalPropertyValueException, BadSizeException {
        if (stringProperty == null) {
            throw new NullPointerException("Cannot retrieve the value of a null string property.");
        }
        if (!this.equals(stringProperty.getType())) {
            throw new IllegalPropertyValueException("Cannot retrieve the value of a string property with a different type definition to this one.");
        }
        if (stringProperty.getValue() == null) {
            return null;
        }
        if (this.elementType.getTarget() instanceof TypeDefinitionCharacter) {
            String stringValue = (String)stringProperty.getValue();
            return CharBuffer.wrap(stringValue).asReadOnlyBuffer();
        }
        ByteArrayStringValue byteStringValue = (ByteArrayStringValue)stringProperty;
        ByteBuffer bytes = ByteBuffer.wrap(byteStringValue.getValue());
        bytes.order(byteStringValue.getByteOrder());
        switch (((TypeDefinitionInteger)this.elementType.getTarget()).getSize()) {
            case 1: {
                return bytes.asReadOnlyBuffer();
            }
            case 2: {
                return bytes.asShortBuffer().asReadOnlyBuffer();
            }
            case 4: {
                return bytes.asIntBuffer().asReadOnlyBuffer();
            }
            case 8: {
                return bytes.asLongBuffer().asReadOnlyBuffer();
            }
        }
        throw new BadSizeException("Unexpextedly, the number of bytes per integer of the underlying element type of this string type definition is not supported by this implementation.");
    }

    @Override
    public String getString(PropertyValue stringProperty) throws NullPointerException, IllegalPropertyValueException {
        if (stringProperty == null) {
            throw new NullPointerException("Cannot extract a Java string value from a null string property.");
        }
        if (!this.equals(stringProperty.getType())) {
            throw new IllegalPropertyValueException("Cannot extract a Java string value from a string with a different type definition to this one.");
        }
        if (this.elementType.getTarget() instanceof TypeDefinitionCharacterImpl) {
            return ((CharacterStringValue)stringProperty).getValue();
        }
        ByteArrayStringValue byteArrayValue = (ByteArrayStringValue)stringProperty;
        ByteBuffer bytes = ByteBuffer.wrap(byteArrayValue.getValue());
        bytes.order(byteArrayValue.getByteOrder());
        return this.charSet.decode(bytes).toString();
    }

    @Override
    public PropertyValue[] getPropertyValues(PropertyValue stringProperty) throws NullPointerException, IllegalPropertyValueException, BadSizeException {
        if (stringProperty == null) {
            throw new NullPointerException("Cannot extract a Java string value from a null string property.");
        }
        if (!this.equals(stringProperty.getType())) {
            throw new IllegalPropertyValueException("Cannot extract a Java string value from a string with a different type definition to this one.");
        }
        if (stringProperty.getValue() == null) {
            return null;
        }
        if (this.elementType.getTarget() instanceof TypeDefinitionCharacter) {
            TypeDefinitionCharacter characterType = (TypeDefinitionCharacter)this.elementType.getTarget();
            String stringValue = ((CharacterStringValue)stringProperty).getValue();
            PropertyValue[] stringAsArray = new PropertyValue[stringValue.length()];
            for (int x = 0; x < stringAsArray.length; ++x) {
                stringAsArray[x] = characterType.createValueFromCharacter(stringValue.charAt(x));
            }
            return stringAsArray;
        }
        TypeDefinitionInteger integerType = (TypeDefinitionInteger)this.elementType.getTarget();
        ByteArrayStringValue byteArrayValue = (ByteArrayStringValue)stringProperty;
        ByteBuffer bytes = ByteBuffer.wrap(byteArrayValue.getValue());
        bytes.order(byteArrayValue.getByteOrder());
        switch (integerType.getSize()) {
            case 1: {
                PropertyValue[] propertyArray = new PropertyValue[bytes.capacity()];
                for (int x = 0; x < propertyArray.length; ++x) {
                    propertyArray[x] = integerType.createValue(bytes.get());
                }
                return propertyArray;
            }
            case 2: {
                ShortBuffer shorts = bytes.asShortBuffer();
                PropertyValue[] propertyArray = new PropertyValue[shorts.capacity()];
                for (int x = 0; x < propertyArray.length; ++x) {
                    propertyArray[x] = integerType.createValue(shorts.get());
                }
                return propertyArray;
            }
            case 4: {
                IntBuffer ints = bytes.asIntBuffer();
                PropertyValue[] propertyArray = new PropertyValue[ints.capacity()];
                for (int x = 0; x < propertyArray.length; ++x) {
                    propertyArray[x] = integerType.createValue(ints.get());
                }
                return propertyArray;
            }
            case 8: {
                LongBuffer longs = bytes.asLongBuffer();
                PropertyValue[] propertyArray = new PropertyValue[longs.capacity()];
                for (int x = 0; x < propertyArray.length; ++x) {
                    propertyArray[x] = integerType.createValue(longs.get());
                }
                return propertyArray;
            }
        }
        throw new BadSizeException("Unexpextedly, the number of bytes per integer of the underlying element type of this string type definition is not supported by this implementation.");
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=3840, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="StringElementType", aliases={"ElementType"}, typeName="TypeDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=27, symbol="StringElementType")
    public TypeDefinition getElementType() {
        return this.elementType.getTarget();
    }

    @MediaPropertySetter(value="StringElementType")
    public void setElementType(TypeDefinition type) throws NullPointerException, IllegalArgumentException {
        if (type == null) {
            throw new NullPointerException("Cannot set the element type for this type definition to a null value.");
        }
        if (!(type instanceof TypeDefinitionCharacter) && !(type instanceof TypeDefinitionInteger)) {
            throw new IllegalArgumentException("Cannot create a new string type definition with an underlying element type other than character or integer.");
        }
        this.elementType = new WeakReference<TypeDefinition>(type);
    }

    public static final TypeDefinition initializeStringElementType() {
        return TypeDefinitions.Character;
    }

    @Override
    public void appendString(PropertyValue stringProperty, String extension) throws NullPointerException, IllegalPropertyValueException {
        if (stringProperty == null) {
            throw new NullPointerException("Cannot append to the value of a null string property.");
        }
        if (!this.equals(stringProperty.getType())) {
            throw new IllegalPropertyValueException("Cannot append to a string property value with a type that does not match this type definition.");
        }
        if (extension == null) {
            return;
        }
        if (stringProperty.getValue() == null) {
            this.setString(stringProperty, extension);
            return;
        }
        if (this.elementType.getTarget() instanceof TypeDefinitionCharacter) {
            String existing = (String)stringProperty.getValue();
            ((CharacterStringValue)stringProperty).setValue(existing + extension);
            return;
        }
        ByteBuffer bytes = this.charSet.encode(extension);
        this.appendElements(stringProperty, bytes);
    }

    @Override
    public PropertyValue createValueFromString(String initData) {
        if (this.elementType.getTarget() instanceof TypeDefinitionCharacter) {
            return new CharacterStringValue(this, initData);
        }
        if (initData == null) {
            return new ByteArrayStringValue(this, null, ByteOrder.BIG_ENDIAN);
        }
        byte[] stringData = this.charSet.encode(initData).array();
        return new ByteArrayStringValue(this, stringData, ByteOrder.nativeOrder());
    }

    @Override
    public PropertyValue createValueFromString(Buffer initData) throws IllegalArgumentException {
        ByteBuffer buffer = this.convertBuffer(initData);
        if (this.elementType.getTarget() instanceof TypeDefinitionCharacter) {
            if (buffer == null) {
                return new CharacterStringValue(this, null);
            }
            String stringData = this.charSet.decode(buffer).toString();
            return new CharacterStringValue(this, stringData);
        }
        if (buffer == null) {
            return new ByteArrayStringValue(this, null, ByteOrder.nativeOrder());
        }
        return new ByteArrayStringValue(this, buffer.array(), buffer.order());
    }

    private ByteBuffer convertBuffer(Buffer buffer) throws IllegalArgumentException {
        if (buffer == null) {
            return null;
        }
        if (buffer instanceof ByteBuffer) {
            return (ByteBuffer)buffer.position(0);
        }
        if (buffer instanceof ShortBuffer) {
            ShortBuffer shorts = (ShortBuffer)buffer;
            ByteBuffer convertedBytes = ByteBuffer.allocate(shorts.capacity() * 2);
            convertedBytes.order(shorts.order());
            while (shorts.hasRemaining()) {
                convertedBytes.putShort(shorts.get());
            }
            convertedBytes.position(0);
            return convertedBytes;
        }
        if (buffer instanceof IntBuffer) {
            IntBuffer ints = (IntBuffer)buffer;
            ByteBuffer convertedBytes = ByteBuffer.allocate(ints.capacity() * 4);
            convertedBytes.order(ints.order());
            while (ints.hasRemaining()) {
                convertedBytes.putInt(ints.get());
            }
            convertedBytes.position(0);
            return convertedBytes;
        }
        if (buffer instanceof LongBuffer) {
            LongBuffer longs = (LongBuffer)buffer;
            ByteBuffer convertedBytes = ByteBuffer.allocate(longs.capacity() * 8);
            convertedBytes.order(longs.order());
            while (longs.hasRemaining()) {
                convertedBytes.putLong(longs.get());
            }
            convertedBytes.position(0);
            return convertedBytes;
        }
        if (buffer instanceof CharBuffer) {
            CharBuffer chars = (CharBuffer)buffer;
            ByteBuffer convertedBytes = ByteBuffer.allocate(chars.capacity() * 2);
            convertedBytes.order(chars.order());
            while (chars.hasRemaining()) {
                convertedBytes.putChar(chars.get());
            }
            convertedBytes.position(0);
            return convertedBytes;
        }
        throw new IllegalArgumentException("The given buffer must be of an appropriate type for conversion to the underlying element type for this string type definition.");
    }

    @Override
    public String getCharacterSet() {
        return this.charSet.toString();
    }

    @Override
    public void setCharacterSet(String charSet) throws NullPointerException, IllegalCharsetNameException {
        if (charSet == null) {
            throw new NullPointerException("Cannot set the character set for this string type definition using a null character set name.");
        }
        try {
            this.charSet = Charset.forName(charSet);
        }
        catch (IllegalCharsetNameException uce) {
            throw new IllegalCharsetNameException("The requested character set is not supported on this platform for this string type definition.");
        }
    }

    @Override
    public void setString(PropertyValue stringProperty, String data) throws NullPointerException, IllegalPropertyValueException {
        if (stringProperty == null) {
            throw new NullPointerException("Cannot set the value of a null string property.");
        }
        if (!this.equals(stringProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value does not match this string type definition.");
        }
        if (this.elementType.getTarget() instanceof TypeDefinitionCharacter) {
            ((CharacterStringValue)stringProperty).setValue(data);
            return;
        }
        ByteArrayStringValue byteStringValue = (ByteArrayStringValue)stringProperty;
        if (data == null) {
            byteStringValue.setValue(null);
        } else {
            ByteBuffer buffer = this.charSet.encode(data);
            byteStringValue.setValue(buffer.array());
        }
    }

    @Override
    public void setString(PropertyValue stringProperty, Buffer data) throws NullPointerException, IllegalPropertyValueException, IllegalArgumentException {
        if (stringProperty == null) {
            throw new NullPointerException("Cannot append to the value of a null string property.");
        }
        if (!this.equals(stringProperty.getType())) {
            throw new IllegalPropertyValueException("Cannot append to the value of the given string property as its type does not match this type definition.");
        }
        if (data == null) {
            if (stringProperty instanceof CharacterStringValue) {
                ((CharacterStringValue)stringProperty).setValue(null);
            } else {
                ((ByteArrayStringValue)stringProperty).setValue(null);
            }
            return;
        }
        ByteBuffer buffer = this.convertBuffer(data);
        if (this.elementType.getTarget() instanceof TypeDefinitionCharacter) {
            String stringValue = this.charSet.decode(buffer).toString();
            ((CharacterStringValue)stringProperty).setValue(stringValue);
            return;
        }
        ByteArrayStringValue existing = (ByteArrayStringValue)stringProperty;
        buffer.order(existing.getByteOrder());
        ((ByteArrayStringValue)stringProperty).setValue(buffer.array());
    }

    @Override
    public void appendString(PropertyValue stringProperty, Buffer extension) throws NullPointerException, IllegalArgumentException, IllegalPropertyValueException {
        this.appendElements(stringProperty, extension);
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.String;
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        if (javaValue instanceof CharSequence) {
            return this.createValueFromString(((CharSequence)javaValue).toString());
        }
        try {
            if (javaValue instanceof Buffer) {
                return this.createValueFromString((Buffer)javaValue);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ClassCastException("Illegal argument exception thrown when creating a string property value: " + e.getMessage());
        }
        if (javaValue instanceof byte[]) {
            return this.createValueFromString(ByteBuffer.wrap((byte[])javaValue));
        }
        throw new ClassCastException("Cannot create a new string property value from the given java value.");
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) {
        char[] characters = new char[buffer.remaining() / 2];
        for (int u = 0; u < characters.length; ++u) {
            characters[u] = buffer.getChar();
        }
        String checkForNulls = new String(characters);
        int firstNull = checkForNulls.indexOf(0);
        if (firstNull != -1) {
            checkForNulls = checkForNulls.substring(0, firstNull);
        }
        return this.createValue(checkForNulls);
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        return 2 * ((String)value.getValue()).length() + 2;
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        char[] characters;
        super.writeAsBytes(value, buffer);
        String toWrite = (String)value.getValue();
        if (buffer.remaining() < 2 * toWrite.length() + 2) {
            throw new InsufficientSpaceException("Not enough remaining space in the given buffer to write a string value of length " + toWrite.length() + ".");
        }
        for (char c : characters = toWrite.toCharArray()) {
            buffer.putChar(c);
        }
        buffer.putChar('\u0000');
        return null;
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionString");
        super.appendMetadictXML(typeElement, namespace, prefix);
        XMLBuilder.appendElement((Node)typeElement, namespace, prefix, "ElementType", this.elementType.getTarget().getName());
    }

    @Override
    public TypeDefinitionString clone() {
        return (TypeDefinitionString)super.clone();
    }

    public static class ByteArrayStringValue
    extends BaseStringValue
    implements PropertyValue {
        private byte[] value;
        private ByteOrder order;

        private ByteArrayStringValue(TypeDefinitionStringImpl type, byte[] value, ByteOrder order) {
            this.setType(type);
            this.setValue(value);
            this.order = order;
        }

        public byte[] getValue() {
            return this.value;
        }

        private void setValue(byte[] value) {
            this.value = value;
        }

        public ByteOrder getByteOrder() {
            return this.order;
        }
    }

    public static class CharacterStringValue
    extends BaseStringValue
    implements PropertyValue {
        private String value;

        private CharacterStringValue(TypeDefinitionStringImpl type, String value) {
            this.setType(type);
            this.setValue(value);
        }

        @Override
        public String getValue() {
            return this.value;
        }

        private void setValue(String value) {
            this.value = value;
        }
    }

    public static abstract class BaseStringValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionStringImpl type;

        protected void setType(TypeDefinitionStringImpl type) {
            this.type = type;
        }

        @Override
        public TypeDefinitionStringImpl getType() {
            return this.type;
        }

        public boolean isDefinedType() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (o instanceof PropertyValue) {
                return this.getValue().equals(((PropertyValue)o).getValue());
            }
            return this.getValue().equals(o);
        }
    }
}

