/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.ScopeReference;
import tv.amwa.maj.model.impl.SegmentImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=3328, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="ScopeReference", description="The ScopeReference class refers to a section in the specified Track or NestedScope slot.", symbol="ScopeReference")
public class ScopeReferenceImpl
extends SegmentImpl
implements ScopeReference,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7722714463453700733L;
    private int relativeScope;
    private int relativeTrack;

    public ScopeReferenceImpl() {
    }

    public ScopeReferenceImpl(DataDefinition dataDefinition, @UInt32 int relativeScope, @UInt32 int relativeSlot) throws NullPointerException, IllegalArgumentException {
        if (dataDefinition == null) {
            throw new NullPointerException("Cannot create a scope reference from a null data definition.");
        }
        this.setComponentDataDefinition(dataDefinition);
        this.setRelativeScope(relativeScope);
        this.setRelativeTrack(relativeSlot);
    }

    @Override
    @MediaProperty(uuid1=100729091, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="RelativeScope", typeName="UInt32", optional=false, uniqueIdentifier=false, pid=3585, symbol="RelativeScope")
    public int getRelativeScope() {
        return this.relativeScope;
    }

    @Override
    @MediaPropertySetter(value="RelativeScope")
    public void setRelativeScope(int relativeScope) throws IllegalArgumentException {
        if (relativeScope < 0) {
            throw new IllegalArgumentException("Relative scope values for scope references must be greater than of equal to 0.");
        }
        this.relativeScope = relativeScope;
    }

    public static final int initializeRelativeScope() {
        return 0;
    }

    @Override
    @MediaProperty(uuid1=100729091, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="RelativeTrack", aliases={"RelativeSlot"}, typeName="UInt32", optional=false, uniqueIdentifier=false, pid=3586, symbol="RelativeTrack")
    public int getRelativeTrack() {
        return this.relativeTrack;
    }

    @Override
    @MediaPropertySetter(value="RelativeTrack")
    public void setRelativeTrack(int relativeTrack) throws IllegalArgumentException {
        if (relativeTrack < 0) {
            throw new IllegalArgumentException("Relative slot values for scope references must be greater than of equal to 0.");
        }
        this.relativeTrack = relativeTrack;
    }

    public static final int initializeRelativeTrack() {
        return 0;
    }

    @Override
    public ScopeReference clone() {
        return (ScopeReference)super.clone();
    }
}

