/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tv.amwa.maj.exception.ObjectAlreadyAttachedException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.model.BWFImportDescriptor;
import tv.amwa.maj.model.RIFFChunk;
import tv.amwa.maj.model.impl.ImportDescriptorImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=20480, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="BWFImportDescriptor", description="Specifies audio essence represented according to the Broadcast Wave specifications.", symbol="BWFImportDescriptor")
public class BWFImportDescriptorImpl
extends ImportDescriptorImpl
implements BWFImportDescriptor,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = -4831327473408052331L;
    private Integer qltyFileSecurityReport = null;
    private Integer qltyFileSecurityWave = null;
    private String bextCodingHistory = null;
    private String qltyBasicData = null;
    private String qltyStartOfModulation = null;
    private String qltyQualityEvent = null;
    private String qltyEndOfModulation = null;
    private String qltyQualityParameter = null;
    private String qltyOperatorComment = null;
    private String qltyCueSheet = null;
    private List<RIFFChunk> unknownBWFChunks = Collections.synchronizedList(new ArrayList());

    @Override
    @MediaProperty(uuid1=67241218, uuid2=513, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="QltyBasicData", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=15650, symbol="QltyBasicData")
    public String getBasicData() throws PropertyNotPresentException {
        if (this.qltyBasicData == null) {
            throw new PropertyNotPresentException("The optional basic data property is not present in this BWF import descriptor.");
        }
        return this.qltyBasicData;
    }

    @Override
    @MediaPropertySetter(value="QltyBasicData")
    public void setBasicData(String basicData) {
        this.qltyBasicData = basicData;
    }

    @Override
    @MediaProperty(uuid1=67241218, uuid2=257, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="BextCodingHistory", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=15649, symbol="BextCodingHistory")
    public String getCodingHistory() throws PropertyNotPresentException {
        if (this.bextCodingHistory == null) {
            throw new PropertyNotPresentException("The optional coding history property is not present in this BWF import descriptor.");
        }
        return this.bextCodingHistory;
    }

    @Override
    @MediaPropertySetter(value="BextCodingHistory")
    public void setCodingHistory(String codingHistory) {
        this.bextCodingHistory = codingHistory;
    }

    @Override
    @MediaProperty(uuid1=67241218, uuid2=2049, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="QltyCueSheet", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=15656, symbol="QltyCueSheet")
    public String getCueSheet() throws PropertyNotPresentException {
        if (this.qltyCueSheet == null) {
            throw new PropertyNotPresentException("The optional cue sheet property is not present in this BWF import descriptor.");
        }
        return this.qltyCueSheet;
    }

    @Override
    @MediaPropertySetter(value="QltyCueSheet")
    public void setCueSheet(String cueSheet) {
        this.qltyCueSheet = cueSheet;
    }

    @Override
    @MediaProperty(uuid1=67241218, uuid2=1281, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="QltyEndOfModulation", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=15653, symbol="QltyEndOfModulation")
    public String getEndOfModulation() throws PropertyNotPresentException {
        if (this.qltyEndOfModulation == null) {
            throw new PropertyNotPresentException("The optional end of modulation property is not present in this BWF descriptor.");
        }
        return this.qltyEndOfModulation;
    }

    @Override
    @MediaPropertySetter(value="QltyEndOfModulation")
    public void setEndOfModulation(String endOfModulation) {
        this.qltyEndOfModulation = endOfModulation;
    }

    @Override
    @MediaProperty(uuid1=67240706, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="QltyFileSecurityReport", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=15637, symbol="QltyFileSecurityReport")
    public int getFileSecurityReport() throws PropertyNotPresentException {
        if (this.qltyFileSecurityReport == null) {
            throw new PropertyNotPresentException("The optional file security report value is not present this BWF import descriptor.");
        }
        return this.qltyFileSecurityReport;
    }

    @Override
    @MediaPropertySetter(value="QltyFileSecurityReport")
    public void setFileSecurityReport(Integer fileSecurityReport) {
        this.qltyFileSecurityReport = fileSecurityReport;
    }

    @Override
    @MediaProperty(uuid1=67240706, uuid2=1536, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="QltyFileSecurityWave", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=15638, symbol="QltyFileSecurityWave")
    public int getFileSecurityWave() throws PropertyNotPresentException {
        if (this.qltyFileSecurityWave == null) {
            throw new PropertyNotPresentException("The optional file security wave property is not present in this BWF import descriptor.");
        }
        return this.qltyFileSecurityWave;
    }

    @Override
    @MediaPropertySetter(value="QltyFileSecurityWave")
    public void setFileSecurityWave(Integer fileSecurityWave) {
        this.qltyFileSecurityWave = fileSecurityWave;
    }

    @Override
    @MediaProperty(uuid1=67241218, uuid2=1793, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="QltyOperatorComment", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=15655, symbol="QltyOperatorComment")
    public String getOperatorComment() throws PropertyNotPresentException {
        if (this.qltyOperatorComment == null) {
            throw new PropertyNotPresentException("The optional operator comment property is not present in this BWF import descriptor.");
        }
        return this.qltyOperatorComment;
    }

    @Override
    @MediaPropertySetter(value="QltyOperatorComment")
    public void setOperatorComment(String operatorComment) {
        this.qltyOperatorComment = operatorComment;
    }

    @Override
    @MediaProperty(uuid1=67241218, uuid2=1025, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="QltyQualityEvent", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=15652, symbol="QltyQualityEvent")
    public String getQualityEvent() throws PropertyNotPresentException {
        if (this.qltyQualityEvent == null) {
            throw new PropertyNotPresentException("The optional quality event property is not present in this BWF import descriptor.");
        }
        return this.qltyQualityEvent;
    }

    @Override
    @MediaPropertySetter(value="QltyQualityEvent")
    public void setQualityEvent(String qualityEvent) {
        this.qltyQualityEvent = qualityEvent;
    }

    @Override
    @MediaProperty(uuid1=67241218, uuid2=1537, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="QltyQualityParameter", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=15654, symbol="QltyQualityParameter")
    public String getQualityParameter() throws PropertyNotPresentException {
        if (this.qltyQualityParameter == null) {
            throw new PropertyNotPresentException("The optional quality parameter is not present in this MWF import descriptor.");
        }
        return this.qltyQualityParameter;
    }

    @Override
    @MediaPropertySetter(value="QltyQualityParameter")
    public void setQualityParameter(String qualityParameter) {
        this.qltyQualityParameter = qualityParameter;
    }

    @Override
    @MediaProperty(uuid1=67241218, uuid2=769, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="QltyStartOfModulation", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=15651, symbol="QltyStartOfModulation")
    public String getStartOfModulation() throws PropertyNotPresentException {
        if (this.qltyStartOfModulation == null) {
            throw new PropertyNotPresentException("The optional start of modulation property is not present in this BWF import descriptor.");
        }
        return this.qltyStartOfModulation;
    }

    @Override
    @MediaPropertySetter(value="QltyStartOfModulation")
    public void setStartOfModulation(String startOfModulation) {
        this.qltyStartOfModulation = startOfModulation;
    }

    @MediaProperty(uuid1=100729092, uuid2=1551, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="UnknownBWFChunks", typeName="RIFFChunkStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=15667, symbol="UnknownBWFChunks")
    public List<RIFFChunk> getUnknownBWFChunks() throws PropertyNotPresentException {
        if (this.unknownBWFChunks.size() == 0) {
            throw new PropertyNotPresentException("The optional list of unknown BWF chunks is not present for this BWF import descripto.");
        }
        return StrongReferenceVector.getOptionalList(this.unknownBWFChunks);
    }

    @Override
    @MediaListAppend(value="UnknownBWFChunks")
    public void appendUnknownBWFChunk(RIFFChunk chunk) throws NullPointerException, ObjectAlreadyAttachedException {
        if (chunk == null) {
            throw new NullPointerException("Cannot append a null value to the list of unknown BWF chunks of this BWF import descriptor.");
        }
        if (this.unknownBWFChunks.contains(chunk)) {
            throw new ObjectAlreadyAttachedException("The given RIFF chunk is already in the list of BWF chunks of this BWF import descriptor.");
        }
        StrongReferenceVector.append(this.unknownBWFChunks, chunk);
    }

    @Override
    @MediaPropertyCount(value="UnknownBWFChunks")
    public int countUnknownBWFChunks() {
        return this.unknownBWFChunks.size();
    }

    @Override
    @MediaPropertyClear(value="UnknownBWFChunks")
    public void clearUnknownBWFChunks() {
        this.unknownBWFChunks = Collections.synchronizedList(new ArrayList());
    }

    @Override
    @MediaListGetAt(value="UnknownBWFChunks")
    public RIFFChunk getUnknownBWFChunkAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.unknownBWFChunks, index);
    }

    @Override
    @MediaListInsertAt(value="UnknownBWFChunks")
    public void insertUnknownBWFChunkAt(int index, RIFFChunk chunk) throws NullPointerException, IndexOutOfBoundsException, ObjectAlreadyAttachedException {
        if (chunk == null) {
            throw new NullPointerException("Cannot insert a null value into the list of unknown BWF chunks of this BWF import descriptor.");
        }
        if (this.unknownBWFChunks.contains(chunk)) {
            throw new ObjectAlreadyAttachedException("The given chunk is already contained in the list of unknown BWF chunks of this BWF import descriptor.");
        }
        StrongReferenceVector.insert(this.unknownBWFChunks, index, chunk);
    }

    @Override
    @MediaListPrepend(value="UnknownBWFChunks")
    public void prependUnknownBWFChunk(RIFFChunk chunk) throws NullPointerException, ObjectAlreadyAttachedException {
        if (chunk == null) {
            throw new NullPointerException("Cannot prepend a null value to the list of unknown BWF chunks of this BWF import descriptor.");
        }
        if (this.unknownBWFChunks.contains(chunk)) {
            throw new ObjectAlreadyAttachedException("The given chunk is already contained within the list of unknown BWF chunks of this BWF import descriptor.");
        }
        StrongReferenceVector.prepend(this.unknownBWFChunks, chunk);
    }

    @Override
    @MediaListRemoveAt(value="UnknownBWFChunks")
    public void removeUnknownBWFChunkAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.unknownBWFChunks, index);
    }

    @Override
    public BWFImportDescriptor clone() {
        return (BWFImportDescriptor)super.clone();
    }
}

