/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.io.Serializable;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import tv.amwa.maj.integer.Int8;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.integer.UInt32Array;
import tv.amwa.maj.integer.UInt8;
import tv.amwa.maj.io.mxf.DeltaEntry;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.impl.TypeDefinitionRecordImpl;

public class DeltaEntryImpl
implements DeltaEntry,
Cloneable,
Serializable,
XMLSerializable {
    private static final long serialVersionUID = -1341008782583700631L;
    @Int8
    private byte posTableIndex = 0;
    @UInt8
    private byte slice = 0;
    @UInt32
    private int elementDelta;
    public static final String DELTAENTRY_TAG = "DeltaEntry";
    static final String POSTABLEINDEX_TAG = "PosTableIndex";
    static final String SLICE_TAG = "Slice";
    static final String ELEMENTDELTA_TAG = "ElementDelta";
    private static final Pattern posTableIndexPattern;
    private static final Pattern slicePattern;
    private static final Pattern elementDeltaPattern;

    public DeltaEntryImpl() {
    }

    public DeltaEntryImpl(@UInt32 int elementDelta) throws IllegalArgumentException {
        this.setElementDelta(elementDelta);
    }

    public DeltaEntryImpl(@Int8 byte posTableIndex, @UInt8 byte slice, @UInt32 int elementDelta) throws IllegalArgumentException {
        this.setPosTableIndex(posTableIndex);
        this.setSlice(slice);
        this.setElementDelta(elementDelta);
    }

    public static final DeltaEntry[] makeDeltaEntryArray(@UInt32Array int[] elementDeltas) throws NullPointerException, IllegalArgumentException {
        if (elementDeltas == null) {
            throw new NullPointerException("Cannot make an array of delta entries from a null value.");
        }
        for (int elementDelta : elementDeltas) {
            if (elementDelta >= 0) continue;
            throw new IllegalArgumentException("Cannot set an element delta value to a negative value.");
        }
        DeltaEntry[] deltaEntries = new DeltaEntry[elementDeltas.length];
        for (int x = 0; x < elementDeltas.length; ++x) {
            deltaEntries[x] = new DeltaEntryImpl(elementDeltas[x]);
        }
        return deltaEntries;
    }

    @Override
    @Int8
    public byte getPosTableIndex() {
        return this.posTableIndex;
    }

    @Override
    @UInt8
    public void setPosTableIndex(@UInt8 byte posTableIndex) throws IllegalArgumentException {
        if (posTableIndex < -1) {
            throw new IllegalArgumentException("A position table index cannot be less than -1.");
        }
        this.posTableIndex = posTableIndex;
    }

    @Override
    @UInt8
    public byte getSlice() {
        return this.slice;
    }

    @Override
    public void setSlice(@UInt8 byte slice) throws IllegalArgumentException {
        if (slice < 0) {
            throw new IllegalArgumentException("Cannot set the value of the slice number to a negative value.");
        }
        this.slice = slice;
    }

    @Override
    @UInt32
    public int getElementDelta() {
        return this.elementDelta;
    }

    @Override
    public void setElementDelta(@UInt32 int elementDelta) throws IllegalArgumentException {
        if (elementDelta < 0) {
            throw new IllegalArgumentException("Cannot set the delta from the element delta offset to a negative value.");
        }
        this.elementDelta = elementDelta;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeltaEntry)) {
            return false;
        }
        DeltaEntry testEntry = (DeltaEntry)o;
        if (testEntry.getElementDelta() != this.elementDelta) {
            return false;
        }
        if (testEntry.getPosTableIndex() != this.posTableIndex) {
            return false;
        }
        return testEntry.getSlice() == this.slice;
    }

    @Override
    public DeltaEntry clone() {
        try {
            return (DeltaEntry)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    public String toString() {
        return XMLBuilder.toXMLNonMetadata(this);
    }

    public int hashCode() {
        return this.posTableIndex << 24 ^ this.slice << 16 ^ this.elementDelta;
    }

    @Override
    public void appendXMLChildren(Node parent) {
        Node deltaEntryElement = parent instanceof DocumentFragment ? XMLBuilder.createChild(parent, "http://www.smpte-ra.org/rp210", "mxf", DELTAENTRY_TAG) : parent;
        XMLBuilder.appendElement(deltaEntryElement, "http://www.smpte-ra.org/rp210", "mxf", POSTABLEINDEX_TAG, this.posTableIndex);
        XMLBuilder.appendElement(deltaEntryElement, "http://www.smpte-ra.org/rp210", "mxf", SLICE_TAG, this.slice);
        XMLBuilder.appendElement(deltaEntryElement, "http://www.smpte-ra.org/rp210", "mxf", ELEMENTDELTA_TAG, this.elementDelta);
    }

    public static final DeltaEntry parseFactory(String deltaEntryString) throws NullPointerException, ParseException {
        if (deltaEntryString == null) {
            throw new NullPointerException("Cannot create a delta entry from a null value.");
        }
        Matcher matcher = null;
        byte posTableIndex = 0;
        byte slice = 0;
        int elementDelta = 0;
        try {
            matcher = posTableIndexPattern.matcher(deltaEntryString);
            if (matcher.find()) {
                boolean posTableNegative;
                String posTableIndexString = matcher.group(1);
                boolean bl = posTableNegative = posTableIndexString.startsWith("-");
                if (posTableNegative) {
                    posTableIndexString = posTableIndexString.substring(1);
                }
                posTableIndex = posTableIndexString.startsWith("0x") ? Byte.parseByte(posTableIndexString.substring(2), 16) : Byte.parseByte(posTableIndexString);
                if (posTableNegative) {
                    posTableIndex = -posTableIndex;
                }
            }
            if ((matcher = slicePattern.matcher(deltaEntryString)).find()) {
                String sliceString = matcher.group(1);
                slice = sliceString.startsWith("0x") ? Byte.parseByte(sliceString.substring(2), 16) : Byte.parseByte(sliceString);
            }
            if (!(matcher = elementDeltaPattern.matcher(deltaEntryString)).find()) {
                throw new ParseException("A delta entry must have an element delta value specified.", 0);
            }
            String elementDeltaString = matcher.group(1);
            elementDelta = elementDeltaString.startsWith("0x") ? Integer.parseInt(elementDeltaString, 16) : Integer.parseInt(elementDeltaString);
            return new DeltaEntryImpl(posTableIndex, slice, elementDelta);
        }
        catch (Exception e) {
            throw new ParseException(e.getClass().getName() + " thrown when parsing a delta entry: " + e.getMessage(), 0);
        }
    }

    @Override
    public String getComment() {
        return null;
    }

    static {
        TypeDefinitionRecordImpl.registerInterfaceMapping(DeltaEntry.class, DeltaEntryImpl.class);
        posTableIndexPattern = Pattern.compile("<\\w*\\:?PosTableIndex\\>(-?\\d+|(-?0x[0-9a-fA-F]+))\\<\\/\\w*\\:?PosTableIndex\\>");
        slicePattern = Pattern.compile("<\\w*\\:?Slice\\>(\\d+|(0x[0-9a-fA-F]+))\\<\\/\\w*\\:?Slice\\>");
        elementDeltaPattern = Pattern.compile("<\\w*\\:?ElementDelta\\>(\\d+|(0x[0-9a-fA-F]+))\\<\\/\\w*\\:?ElementDelta\\>");
    }
}

