/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.meta.ExtensionScheme;
import tv.amwa.maj.model.DescriptiveFramework;
import tv.amwa.maj.model.DescriptiveMarker;
import tv.amwa.maj.model.impl.CommentMarkerImpl;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=16640, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="DescriptiveMarker", description="The DescriptiveMarker class specifies descriptive metadata that is associated with a point in time.", symbol="DescriptiveMarker")
public class DescriptiveMarkerImpl
extends CommentMarkerImpl
implements DescriptiveMarker,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3140208650608144638L;
    private static final Set<Integer> dataBaseAllTracksDescribed = new HashSet<Integer>();
    private Set<Integer> describedTrackIDs = Collections.synchronizedSet(new HashSet());
    private DescriptiveFramework descriptiveFrameworkObject = null;

    public DescriptiveMarkerImpl() {
        this.setComponentDataDefinition(DataDefinitionImpl.forName("DescriptiveMetadata"));
        this.setPositionPresent(true);
    }

    @Override
    @MediaProperty(uuid1=17236229, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="DescribedTrackIDs", aliases={"DescribedSlots", "DescribedSlotIDs", "DescribedTracks"}, typeName="UInt32Set", optional=true, uniqueIdentifier=false, pid=24834, symbol="DescribedTrackIDs")
    public Set<Integer> getDescribedTrackIDs() throws PropertyNotPresentException {
        if (this.describedTrackIDs == null) {
            throw new PropertyNotPresentException("The optional described tracks property is not present in this descriptive marker.");
        }
        if (this.describedTrackIDs == AllTracksDescribed) {
            return this.describedTrackIDs;
        }
        return new HashSet<Integer>(this.describedTrackIDs);
    }

    @Override
    @MediaPropertySetter(value="DescribedTrackIDs")
    public void setDescribedTrackIDs(Set<Integer> describedTrackIDs) throws IllegalArgumentException {
        if (describedTrackIDs == null) {
            this.describedTrackIDs = null;
            return;
        }
        if (describedTrackIDs == AllTracksDescribed) {
            this.describedTrackIDs = AllTracksDescribed;
            return;
        }
        this.describedTrackIDs = Collections.synchronizedSet(new HashSet());
        for (int trackID : describedTrackIDs) {
            if (trackID >= 0) {
                this.describedTrackIDs.add(trackID);
                continue;
            }
            throw new IllegalArgumentException("A track id of " + trackID + " cannot be used as it is negative.");
        }
    }

    @MediaSetAdd(value="DescribedTrackIDs")
    public void addDescribedTrackID(@UInt32 int trackID) throws IllegalArgumentException {
        if (trackID < 0) {
            throw new IllegalArgumentException("The track identifier cannot be negative.");
        }
        if (this.describedTrackIDs == null) {
            this.describedTrackIDs = Collections.synchronizedSet(new HashSet());
        }
        if (this.describedTrackIDs.equals(AllTracksDescribed)) {
            return;
        }
        this.describedTrackIDs.add(trackID);
    }

    @Override
    public int getDescribedTrackIDsSize() throws PropertyNotPresentException {
        if (this.describedTrackIDs == null) {
            throw new PropertyNotPresentException("The optional described tracks property is not present in this descriptive marker.");
        }
        return this.describedTrackIDs.size();
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=524, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="DescriptiveFrameworkObject", aliases={"Description", "DescriptiveMarkerDescription"}, typeName="DescriptiveFrameworkStrongReference", optional=true, uniqueIdentifier=false, pid=24833, symbol="DescriptiveFrameworkObject")
    public DescriptiveFramework getDescriptiveFrameworkObject() throws PropertyNotPresentException {
        if (this.descriptiveFrameworkObject == null) {
            throw new PropertyNotPresentException("The optional descriptive framework property is not present in this descriptive marker.");
        }
        return this.descriptiveFrameworkObject;
    }

    @Override
    @MediaPropertySetter(value="DescriptiveFrameworkObject")
    public void setDescriptiveFrameworkObject(DescriptiveFramework descriptiveFrameworkObject) {
        if (descriptiveFrameworkObject == null) {
            this.descriptiveFrameworkObject = null;
            return;
        }
        this.descriptiveFrameworkObject = descriptiveFrameworkObject;
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=3584, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="DescriptiveMetadataPluginID", aliases={"DescriptiveMetadataPlug-InID"}, typeName="AUID", optional=true, uniqueIdentifier=false, pid=0, symbol="DescriptiveMetadataPluginID", description="Immutable identifier for this descriptive metadata plugin instance.")
    public AUID getDescriptiveMetadataPluginID() throws PropertyNotPresentException {
        return null;
    }

    @Override
    @MediaPropertySetter(value="DescriptiveMetadataPluginID")
    public void setDescriptiveMetadataPluginID(AUID descriptiveMetadataPluginID) {
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=4096, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="DescriptiveMetadataApplicationEnvironmentID", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, symbol="DescriptiveMetadataApplicationEnvironmentID", description="Application environment identifier, an Uniform Resource Identifier (RFC 3986) that identifies the application to which the information in this plugin object applies.")
    public String getDescriptiveMetadataApplicationEnvironmentID() throws PropertyNotPresentException {
        return null;
    }

    @Override
    @MediaPropertySetter(value="DescriptiveMetadataApplicationEnvironmentID")
    public void setDescriptiveMetadataApplicationEnvironmentID(String descriptiveMetadataApplicationEnvironmentID) {
    }

    @Override
    @MediaProperty(uuid1=67504132, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="DescriptiveMetadataScheme", typeName="ExtensionSchemeWeakReference", optional=true, uniqueIdentifier=false, pid=0, symbol="DescriptiveMetadataScheme", description="Descriptive metadata scheme that is referenced by the descriptive framework object.")
    public ExtensionScheme getDescriptiveMetadataScheme() throws PropertyNotPresentException {
        return null;
    }

    @Override
    @MediaPropertySetter(value="DescriptiveMetadataScheme")
    public void setDescriptiveMetadataScheme(ExtensionScheme extensionScheme) {
    }

    @Override
    public DescriptiveMarker clone() {
        return (DescriptiveMarker)super.clone();
    }

    static {
        dataBaseAllTracksDescribed.add(-1);
    }
}

