/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.misctype.LengthType;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.OperationGroup;
import tv.amwa.maj.model.Transition;
import tv.amwa.maj.model.impl.ComponentImpl;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.OperationDefinitionImpl;
import tv.amwa.maj.model.impl.OperationGroupImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=5888, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Transition", description="The Transition class specifies that the two adjacent Segments should be overlapped when they are played and the overlapped sections should be combined using the specified effect.", symbol="Transition")
public class TransitionImpl
extends ComponentImpl
implements Transition,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8175422126688427171L;
    private OperationGroup transitionOperation;
    private long cutPoint;

    public TransitionImpl() {
    }

    public TransitionImpl(DataDefinition dataDefinition, @LengthType long length, OperationGroup operationGroup, @PositionType long cutPoint) throws NullPointerException, BadLengthException {
        if (dataDefinition == null) {
            throw new NullPointerException("Cannot create a transition with a null data definition value.");
        }
        if (operationGroup == null) {
            throw new NullPointerException("Cannot create a transition with a null operation group value.");
        }
        this.setComponentDataDefinition(dataDefinition);
        this.setLengthPresent(true);
        this.setComponentLength(length);
        this.setTransitionOperation(operationGroup);
        this.setCutPoint(cutPoint);
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=262, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="CutPoint", typeName="PositionType", optional=false, uniqueIdentifier=false, pid=6146, symbol="CutPoint")
    public long getCutPoint() {
        return this.cutPoint;
    }

    @Override
    @MediaPropertySetter(value="CutPoint")
    public void setCutPoint(long cutPoint) {
        this.cutPoint = cutPoint;
    }

    public static final long initializeCutPoint() {
        return 0L;
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=517, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TransitionOperation", aliases={"OperationGroup", "TransitionOperationGroup"}, typeName="OperationGroupStrongReference", optional=false, uniqueIdentifier=false, pid=6145, symbol="TransitionOperation")
    public OperationGroup getTransitionOperation() {
        return this.transitionOperation;
    }

    @Override
    @MediaPropertySetter(value="TransitionOperation")
    public void setTransitionOperation(OperationGroup transitionOperation) throws NullPointerException {
        if (transitionOperation == null) {
            throw new NullPointerException("Cannot set the operation group for this transition using a null value.");
        }
        this.transitionOperation = transitionOperation;
    }

    public static final OperationGroup initializeTransitionOperation() {
        return new OperationGroupImpl(DataDefinitionImpl.forName("Unknown"), 0L, OperationDefinitionImpl.forName("Unknown"));
    }

    @Override
    public Transition clone() {
        return (Transition)super.clone();
    }
}

