/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyContains;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertyRemove;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.meta.ExtensionScheme;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=550, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="ExtensionScheme", symbol="ExtensionScheme", description="Groups together a collection of meta definitions for an extension to a file and provides a globally unique identifier for the collection.", namespace="http://www.smpte-ra.org/schemas/2001-2/2007/aaf", prefix="aaf")
public class ExtensionSchemeImpl
implements ExtensionScheme,
Cloneable,
Serializable,
MetadataObject,
WeakReferenceTarget {
    private static final long serialVersionUID = 8353597427037923656L;
    private AUID schemeID;
    private String schemeURI;
    private String preferredPrefix = null;
    private String extensionDescription = null;
    private Map<AUID, MetaDefinition> metaDefinitions = Collections.synchronizedMap(new HashMap());
    private Map<String, AUID> metaDefinitionNames = Collections.synchronizedMap(new HashMap());

    @Override
    @MediaProperty(uuid1=100729095, uuid2=6912, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 13}, definedName="SchemeID", aliases={"ExtensionSchemeID"}, typeName="AUID", optional=false, uniqueIdentifier=true, pid=36, symbol="SchemeID", description="Globally unique identification of the extension scheme.")
    public AUID getSchemeID() {
        return this.schemeID.clone();
    }

    @Override
    @MediaPropertySetter(value="SchemeID")
    public void setSchemeID(AUID schemeID) throws NullPointerException {
        if (schemeID == null) {
            throw new NullPointerException("Cannot set the scheme identifier using a null value.");
        }
        this.schemeID = schemeID.clone();
    }

    @Override
    public AUID getAUID() {
        return this.schemeID.clone();
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=7168, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 13}, definedName="SchemeURI", aliases={"ExtensionSchemeURI", "SymbolSpaceURI", "ExtensionSymbolSpaceURI"}, typeName="UTF16String", optional=false, uniqueIdentifier=false, pid=37, symbol="SchemeURI", description="Namespace URI for the extension scheme.")
    public String getSchemeURI() {
        return this.schemeURI;
    }

    @Override
    @MediaPropertySetter(value="SchemeURI")
    public void setSchemeURI(String schemeURI) throws NullPointerException {
        if (schemeURI == null) {
            throw new NullPointerException("Cannot set the scheme URI using a null value.");
        }
        this.schemeURI = schemeURI;
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=7424, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 13}, definedName="PreferredPrefix", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=38, symbol="PreferredPrefix", description="Preferred namespace tag when SMPTE Reg-XML encoding is used.")
    public String getPreferredPrefix() throws PropertyNotPresentException {
        if (this.preferredPrefix == null) {
            throw new PropertyNotPresentException("The optional preferred prefix property is not present for this extension scheme.");
        }
        return this.preferredPrefix;
    }

    @Override
    @MediaPropertySetter(value="PreferredPrefix")
    public void setPreferredPrefix(String preferredPrefix) {
        this.preferredPrefix = preferredPrefix;
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=7680, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 13}, definedName="ExtensionDescription", aliases={"Description"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=39, symbol="ExtensionDescription", description="Description of the extension scheme.")
    public String getExtensionDescription() throws PropertyNotPresentException {
        if (this.extensionDescription == null) {
            throw new PropertyNotPresentException("The optional extension description property is not present for this extension scheme.");
        }
        return this.extensionDescription;
    }

    @Override
    @MediaPropertySetter(value="ExtensionDescription")
    public void setExtensionDescription(String extensionDescription) {
        this.extensionDescription = extensionDescription;
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=7936, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 13}, definedName="MetaDefinitions", typeName="MetaDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=40, symbol="MetaDefinitions", description="Set of meta definitions that form the extensions scheme. The meta definitions are the class definitions, property definitions and type definitions} that define extensions classes and properties for use in descriptive frameworks, descriptive objects, application plugin objects and application referenced objects.")
    public Set<MetaDefinition> getMetaDefinitions() throws PropertyNotPresentException {
        if (this.metaDefinitions.size() == 0) {
            throw new NullPointerException("The optional meta definitions property is not present for this extension scheme.");
        }
        return new HashSet<MetaDefinition>(this.metaDefinitions.values());
    }

    @Override
    @MediaSetAdd(value="MetaDefinitions")
    public void addMetaDefinition(MetaDefinition metaDefinition) throws NullPointerException {
        if (metaDefinition == null) {
            throw new NullPointerException("Cannot add a null meta definition to the set of meta definitions.");
        }
        this.metaDefinitions.put(metaDefinition.getAUID(), metaDefinition);
        this.metaDefinitionNames.put(metaDefinition.getName(), metaDefinition.getAUID());
    }

    @Override
    @MediaPropertyClear(value="MetaDefinitions")
    public void clearMetaDefinitions() {
        this.metaDefinitions.clear();
    }

    @Override
    @MediaPropertyContains(value="MetaDefinitions")
    public boolean containsMetaDefinition(MetaDefinition metaDefinition) throws NullPointerException {
        if (metaDefinition == null) {
            throw new NullPointerException("Cannot check for a meta definition using a null value.");
        }
        return this.metaDefinitions.containsKey(metaDefinition.getAUID());
    }

    @Override
    public boolean containsMetaDefinition(AUID metaDefinitionID) throws NullPointerException {
        if (metaDefinitionID == null) {
            throw new NullPointerException("Cannot check for a meta definition using a null identifier.");
        }
        return this.metaDefinitions.containsKey(metaDefinitionID);
    }

    @Override
    public boolean containsMetaDefinition(String metaDefinitionName) throws NullPointerException {
        if (metaDefinitionName == null) {
            throw new NullPointerException("Cannot check for a meta definition using a null name.");
        }
        return this.metaDefinitionNames.containsKey(metaDefinitionName);
    }

    @Override
    public MetaDefinition lookupMetaDefinition(AUID metaDefinitionID) throws NullPointerException {
        if (metaDefinitionID == null) {
            throw new NullPointerException("Cannot lookup a meta definition using a null identifier.");
        }
        return this.metaDefinitions.get(metaDefinitionID);
    }

    @Override
    public MetaDefinition lookupMetaDefinition(String metaDefinitionName) throws NullPointerException {
        if (metaDefinitionName == null) {
            throw new NullPointerException("Cannot lookup a meta definition using a null name.");
        }
        if (!this.metaDefinitionNames.containsKey(metaDefinitionName)) {
            return null;
        }
        return this.metaDefinitions.get(this.metaDefinitionNames.get(metaDefinitionName));
    }

    @Override
    public AUID lookupMetaDefinitionIdentifier(String metaDefinitionName) throws NullPointerException {
        if (metaDefinitionName == null) {
            throw new NullPointerException("Cannot lookup a meta definition using a null name.");
        }
        return this.metaDefinitionNames.get(metaDefinitionName).clone();
    }

    @Override
    @MediaPropertyCount(value="MetaDefinitions")
    public int countMetaDefinitions() {
        return this.metaDefinitions.size();
    }

    @Override
    @MediaPropertyRemove(value="MetaDefinitions")
    public boolean removeMetaDefinition(MetaDefinition metaDefinition) throws NullPointerException {
        if (metaDefinition == null) {
            throw new NullPointerException("Cannot remove a meta definition using a null value.");
        }
        return this.metaDefinitions.remove(metaDefinition.getAUID()) != null;
    }

    @Override
    public boolean removeMetaDefinition(AUID metaDefinitionID) throws NullPointerException {
        if (metaDefinitionID == null) {
            throw new NullPointerException("Cannot remove a meta definition using a null value.");
        }
        return this.metaDefinitions.remove(metaDefinitionID) != null;
    }

    @Override
    public String getWeakTargetReference() {
        return this.schemeID.toString();
    }

    public int hashCode() {
        return MediaEngine.hashCode(this);
    }

    public String toString() {
        return MediaEngine.toString(this);
    }

    public boolean equals(Object o) {
        return MediaEngine.equals(this, o);
    }

    public boolean deepEquals(Object o) {
        return MediaEngine.deepEquals(this, o);
    }

    @Override
    public ExtensionScheme clone() {
        try {
            return (ExtensionScheme)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }
}

