/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf;

import tv.amwa.maj.io.mxf.UL;

public enum UnitType {
    Unknown,
    HeaderClosedCompletePartitionPack,
    HeaderClosedIncompletePartitionPack,
    HeaderOpenCompletePartitionPack,
    HeaderOpenIncompletePartitionPack,
    BodyClosedCompletePartitionPack,
    BodyClosedIncompletePartitionPack,
    BodyOpenCompletePartitionPack,
    BodyOpenIncompletePartitionPack,
    FooterClosedCompletePartitionPack,
    FooterClosedIncompletePartitionPack,
    HeaderMetadata,
    IndexTableSegment,
    GenericContainerEssenceElement,
    GenericContainerSystemItem,
    GenericContainerPicture,
    GenericContainerSound,
    GenericContainerData,
    GenericContainerCompound,
    GenericStreamPartitionPack,
    ContentPackageEssenceElement,
    ContentPackageSystemItem,
    ContentPackagePicture,
    ContentPackageSound,
    ContentPackageData,
    RandomIndexPack;

    static final byte[] smpteKeyStart;
    static final int[] constantBytes;

    public static final UnitType typeFromKey(UL key) {
        byte[] keyBytes = key.getUniversalLabel();
        for (int constantIndex : constantBytes) {
            if (smpteKeyStart[constantIndex] == keyBytes[constantIndex]) continue;
            return Unknown;
        }
        switch (keyBytes[10]) {
            case 2: {
                switch (keyBytes[13]) {
                    case 2: {
                        switch (keyBytes[14]) {
                            case 1: {
                                return HeaderOpenIncompletePartitionPack;
                            }
                            case 2: {
                                return HeaderClosedIncompletePartitionPack;
                            }
                            case 3: {
                                return HeaderOpenCompletePartitionPack;
                            }
                            case 4: {
                                return HeaderClosedCompletePartitionPack;
                            }
                        }
                        return Unknown;
                    }
                    case 3: {
                        switch (keyBytes[14]) {
                            case 1: {
                                return BodyOpenIncompletePartitionPack;
                            }
                            case 2: {
                                return BodyClosedIncompletePartitionPack;
                            }
                            case 3: {
                                return BodyOpenCompletePartitionPack;
                            }
                            case 4: {
                                return BodyClosedCompletePartitionPack;
                            }
                        }
                        return Unknown;
                    }
                    case 4: {
                        switch (keyBytes[14]) {
                            case 2: {
                                return FooterClosedIncompletePartitionPack;
                            }
                            case 4: {
                                return FooterClosedCompletePartitionPack;
                            }
                        }
                        return Unknown;
                    }
                    case 5: {
                        return HeaderMetadata;
                    }
                    case 16: {
                        return IndexTableSegment;
                    }
                    case 17: {
                        return RandomIndexPack;
                    }
                }
                return Unknown;
            }
            case 3: {
                switch (keyBytes[12]) {
                    case 4: {
                        return ContentPackageSystemItem;
                    }
                    case 5: {
                        return ContentPackagePicture;
                    }
                    case 6: {
                        return ContentPackageSound;
                    }
                    case 7: {
                        return ContentPackageData;
                    }
                    case 20: {
                        return GenericContainerSystemItem;
                    }
                    case 21: {
                        return GenericContainerPicture;
                    }
                    case 22: {
                        return GenericContainerSound;
                    }
                    case 23: {
                        return GenericContainerData;
                    }
                    case 24: {
                        return GenericContainerCompound;
                    }
                }
                return Unknown;
            }
        }
        return Unknown;
    }

    static {
        smpteKeyStart = new byte[]{6, 14, 43, 52, 2, 0, 1, 0, 13, 1, 0, 1};
        constantBytes = new int[]{0, 1, 2, 3, 6, 8, 9, 11};
    }
}

