/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.industry;

import java.util.List;
import java.util.Vector;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaEntity;

public class StrongReferenceVector {
    private StrongReferenceVector() {
    }

    public static final <T extends MediaEntity> void append(List<T> list, T item) throws NullPointerException {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        if (item == null) {
            throw new NullPointerException("Cannot append a null value to a list of strong references.");
        }
        list.add(item.clone());
        item.setPersistentIndex(list.size() - 1);
    }

    public static final <T extends MediaEntity> void appendNoClone(List<T> list, T item) throws NullPointerException {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        if (item == null) {
            throw new NullPointerException("Cannot append a null value to a list of strong references.");
        }
        list.add(item);
        item.setPersistentIndex(list.size() - 1);
    }

    public static final <T extends MediaEntity> void prepend(List<T> list, T item) throws NullPointerException {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        if (item == null) {
            throw new NullPointerException("Cannot prepend a null value to a list of strong references.");
        }
        list.add(0, item.clone());
        item.setPersistentIndex(0);
        for (int u = 1; u < list.size(); ++u) {
            ((MediaEntity)list.get(u)).setPersistentIndex(u);
        }
    }

    public static final <T extends MediaEntity> void prependNoClone(List<T> list, T item) throws NullPointerException {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        if (item == null) {
            throw new NullPointerException("Cannot prepend a null value to a list of strong references.");
        }
        list.add(0, item);
        item.setPersistentIndex(0);
        for (int u = 1; u < list.size(); ++u) {
            ((MediaEntity)list.get(u)).setPersistentIndex(u);
        }
    }

    public static final <T extends MediaEntity> void insert(List<T> list, int index, T item) throws NullPointerException, IndexOutOfBoundsException {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        if (item == null) {
            throw new NullPointerException("Cannot insert a null value to a list of strong references.");
        }
        try {
            list.add(index, item.clone());
            item.setPersistentIndex(index);
            for (int u = index + 1; u < list.size(); ++u) {
                ((MediaEntity)list.get(u)).setPersistentIndex(u);
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the current strong reference list.");
        }
    }

    public static final <T extends MediaEntity> void insertNoClone(List<T> list, int index, T item) throws NullPointerException, IndexOutOfBoundsException {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        if (item == null) {
            throw new NullPointerException("Cannot insert a null value to a list of strong references.");
        }
        try {
            list.add(index, item);
            item.setPersistentIndex(index);
            for (int u = index + 1; u < list.size(); ++u) {
                ((MediaEntity)list.get(u)).setPersistentIndex(u);
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the current strong reference list.");
        }
    }

    public static final <T extends MediaEntity> T getAt(List<T> list, int index) throws NullPointerException, IndexOutOfBoundsException {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        try {
            return (T)((MediaEntity)list.get(index)).clone();
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the current strong reference list.");
        }
    }

    public static final <T extends MediaEntity> boolean contains(List<T> list, T item) throws NullPointerException {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        if (item == null) {
            throw new NullPointerException("Cannot check whether a strong reference list contains a null value.");
        }
        return list.contains(item);
    }

    public static final <T extends MediaEntity> void remove(List<T> list, int index) throws NullPointerException, IndexOutOfBoundsException {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        try {
            list.remove(index);
            for (int u = index; u < list.size(); ++u) {
                ((MediaEntity)list.get(u)).setPersistentIndex(u);
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the current strong reference list.");
        }
    }

    public static final <T extends MediaEntity> boolean remove(List<T> list, T item) throws NullPointerException {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        if (item == null) {
            throw new NullPointerException("Cannot remove a null value from a list of strong references.");
        }
        return list.remove(item);
    }

    public static final <T extends MediaEntity> List<T> getOptionalList(List<T> list) throws PropertyNotPresentException {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        if (list.size() == 0) {
            throw new NullPointerException("The optional strong reference list property is not present.");
        }
        return new Vector<T>(list);
    }

    public static final <T extends MediaEntity> List<T> getRequiredList(List<T> list) {
        if (list == null) {
            throw new NullPointerException("Cannot work with a null-valued list.");
        }
        return new Vector<T>(list);
    }
}

