/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.record.impl;

import java.io.Serializable;
import java.text.ParseException;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.integer.Int8;
import tv.amwa.maj.record.VersionType;

public final class VersionTypeImpl
implements VersionType,
Serializable,
Comparable<VersionType>,
Cloneable,
CommonConstants {
    private static final long serialVersionUID = 1648329801097298111L;
    @Int8
    private byte major;
    @Int8
    private byte minor;
    public static final String MYSQL_COLUMN_DEFINITION = "VARCHAR(14) CHARACTER SET ascii COLLATE ascii_general_ci";

    public VersionTypeImpl(@Int8 byte major, @Int8 byte minor) {
        this.major = major;
        this.minor = minor;
    }

    public VersionTypeImpl() {
        this.major = 0;
        this.minor = 0;
    }

    @Override
    public final byte getMajor() {
        return this.major;
    }

    @Override
    public final void setMajor(byte major) {
        this.major = major;
    }

    @Override
    public final byte getMinor() {
        return this.minor;
    }

    @Override
    public void setMinor(byte minor) {
        this.minor = minor;
    }

    @Override
    public final String toString() {
        return VersionTypeImpl.format(this);
    }

    public static final VersionTypeImpl parseFactory(String versionAsString) throws NullPointerException, ParseException {
        if (versionAsString == null) {
            throw new NullPointerException("Cannot convert a null string into a value of the version type.");
        }
        int dotIndex = versionAsString.indexOf(46);
        if (dotIndex == -1) {
            throw new ParseException("The given version value does not contain a major/minor separator dot.", 0);
        }
        String majorString = versionAsString.substring(0, dotIndex);
        String minorString = versionAsString.substring(dotIndex + 1);
        try {
            int major = Integer.parseInt(majorString);
            if (major < -128 || major > 127) {
                throw new NumberFormatException("The major part of the version number must be between -128 and 127.");
            }
            int minor = Integer.parseInt(minorString);
            if (minor < -128 || minor > 127) {
                throw new NumberFormatException("The minor part of the version number must be between -128 and 127.");
            }
            return new VersionTypeImpl((byte)major, (byte)minor);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Unable to parse the major or minor parts of a version type value: " + nfe.getMessage(), 0);
        }
    }

    public final int hashCode() {
        return this.major * 1024 + this.minor;
    }

    @Override
    public final int compareTo(VersionType o) throws NullPointerException {
        if (o == null) {
            throw new NullPointerException("Cannot compare this version number to a null value.");
        }
        byte majorThis = this.major;
        byte minorThis = this.minor;
        byte majorToTest = o.getMajor();
        byte minorToTest = o.getMinor();
        byte majorTest = majorToTest;
        byte minorTest = minorToTest;
        if (majorThis < majorTest) {
            return -1;
        }
        if (majorThis > majorTest) {
            return 1;
        }
        if (minorThis < minorTest) {
            return -1;
        }
        if (minorThis > minorTest) {
            return 1;
        }
        return 0;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof VersionType)) {
            return false;
        }
        VersionType testVersion = (VersionType)o;
        if (this.major != testVersion.getMajor()) {
            return false;
        }
        return this.minor == testVersion.getMinor();
    }

    @Override
    public final VersionType clone() {
        try {
            return (VersionType)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public static final String format(VersionTypeImpl version) throws NullPointerException {
        if (version == null) {
            throw new NullPointerException("Cannot format a null version number value.");
        }
        StringBuffer formatted = new StringBuffer(10);
        formatted.append(version.getMajor());
        formatted.append('.');
        formatted.append(version.getMinor());
        return formatted.toString();
    }

    public String getEventComment() {
        return null;
    }

    public static final String toPersistentForm(VersionType version) {
        if (version == null) {
            return null;
        }
        return version.toString();
    }

    public static final VersionType fromPersistentForm(String version) {
        if (version == null) {
            return null;
        }
        try {
            return VersionTypeImpl.parseFactory(version);
        }
        catch (ParseException pe) {
            return null;
        }
    }
}

