/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import tv.amwa.maj.enumeration.ByteOrder;
import tv.amwa.maj.enumeration.CriteriaType;
import tv.amwa.maj.enumeration.PackageKind;
import tv.amwa.maj.exception.DuplicatePackageIDException;
import tv.amwa.maj.exception.EssenceNotFoundException;
import tv.amwa.maj.exception.InvalidParameterException;
import tv.amwa.maj.exception.ObjectNotAttachedException;
import tv.amwa.maj.exception.ObjectNotFoundException;
import tv.amwa.maj.exception.PackageNotFoundException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.extensions.quantel.QPreface;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyContains;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertyRemove;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.model.AAFFileDescriptor;
import tv.amwa.maj.model.ContentStorage;
import tv.amwa.maj.model.Dictionary;
import tv.amwa.maj.model.EssenceData;
import tv.amwa.maj.model.EssenceDescriptor;
import tv.amwa.maj.model.Identification;
import tv.amwa.maj.model.MultipleDescriptor;
import tv.amwa.maj.model.Package;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.model.SourcePackage;
import tv.amwa.maj.model.impl.ContentStorageImpl;
import tv.amwa.maj.model.impl.DictionaryImpl;
import tv.amwa.maj.model.impl.IdentificationImpl;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.model.impl.SourcePackageImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.ProductVersion;
import tv.amwa.maj.record.TimeStamp;
import tv.amwa.maj.record.VersionType;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.record.impl.TimeStampImpl;
import tv.amwa.maj.record.impl.VersionTypeImpl;
import tv.amwa.maj.union.SearchCriteria;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=12032, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Preface", aliases={"Header"}, description="The Preface class provides file-wide information and indexes.", symbol="Preface")
public class PrefaceImpl
extends InterchangeObjectImpl
implements Preface,
QPreface,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3343754479545511683L;
    private ByteOrder byteOrder;
    private TimeStamp fileLastModified;
    private VersionType formatVersion;
    private Integer objectModelVersion = null;
    private AUID operationalPattern = null;
    private Set<AUID> essenceContainers = Collections.synchronizedSet(new HashSet());
    private Set<AUID> descriptiveSchemes = Collections.synchronizedSet(new HashSet());
    private Set<AUID> applicationSchemes = Collections.synchronizedSet(new HashSet());
    private ContentStorage contentStorageObject;
    private List<Identification> identificationList = Collections.synchronizedList(new Vector());
    private Dictionary dictionaries;
    private WeakReference<Package> primaryPackage;
    private Integer archiveDatabaseType = null;

    public PrefaceImpl() {
        this.byteOrder = ByteOrder.Big;
        this.fileLastModified = new TimeStampImpl();
        this.dictionaries = new DictionaryImpl();
        this.formatVersion = new VersionTypeImpl(1, 0);
        IdentificationImpl madeInP4MsAPI = new IdentificationImpl("portability 4 media", "MAJ API", "0.0.1 development", IdentificationImpl.APIProductID);
        StrongReferenceVector.append(this.identificationList, madeInP4MsAPI);
        this.contentStorageObject = new ContentStorageImpl();
    }

    @Override
    @MediaSetAdd(value="DescriptiveSchemes")
    public void addDescriptiveScheme(AUID descriptiveSchemeID) throws NullPointerException {
        if (descriptiveSchemeID == null) {
            throw new NullPointerException("Cannot add a null value to the set of descriptive schemes.");
        }
        this.descriptiveSchemes.add(descriptiveSchemeID.clone());
    }

    @Override
    public void addEssenceData(EssenceData essenceData) throws DuplicatePackageIDException, NullPointerException {
        this.contentStorageObject.addEssenceDataObject(essenceData);
    }

    @Override
    public void addPackage(Package packageToAdd) throws NullPointerException, DuplicatePackageIDException {
        EssenceDescriptor descriptor;
        this.contentStorageObject.addPackage(packageToAdd);
        if (packageToAdd instanceof SourcePackageImpl && (descriptor = ((SourcePackageImpl)packageToAdd).getEssenceDescription()) instanceof AAFFileDescriptor) {
            this.addContainersForDescriptor((AAFFileDescriptor)descriptor);
        }
    }

    @Override
    @MediaListAppend(value="IdentificationList")
    public void appendIdentification(Identification identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot append a null identification to this header.");
        }
        this.removeInitialID();
        StrongReferenceVector.append(this.identificationList, identification);
    }

    void removeInitialID() {
        if (this.identificationList.size() != 1) {
            return;
        }
        Identification isThisTheDefaultIdent = this.identificationList.get(0);
        if (!isThisTheDefaultIdent.getApplicationName().equals("DefaultProductName")) {
            return;
        }
        if (!isThisTheDefaultIdent.getApplicationVersionString().equals("DefaultProductVersion")) {
            return;
        }
        if (!isThisTheDefaultIdent.getApplicationSupplierName().equals("DefaultCompanyName")) {
            return;
        }
        this.clearIdentificationList();
    }

    @MediaListPrepend(value="IdentificationList")
    public void prependIdentification(Identification ident) throws NullPointerException {
        if (ident == null) {
            throw new NullPointerException("Cannot prepend a null identification to this header.");
        }
        StrongReferenceVector.prepend(this.identificationList, ident);
    }

    @Override
    @MediaPropertyCount(value="DescriptiveSchemes")
    public int countDescriptiveSchemes() {
        return this.descriptiveSchemes.size();
    }

    @Override
    @MediaPropertyCount(value="EssenceContainers")
    public int countEssenceContainers() throws PropertyNotPresentException {
        return this.essenceContainers.size();
    }

    @Override
    public int countEssenceData() {
        return this.contentStorageObject.countEssenceDataObjects();
    }

    @Override
    @MediaPropertyCount(value="IdentificationList")
    public int countIdentifications() {
        return this.identificationList.size();
    }

    @MediaPropertyClear(value="IdentificationList")
    public void clearIdentificationList() {
        this.identificationList = Collections.synchronizedList(new Vector());
    }

    @Override
    public int countPackages(PackageKind packageKind) throws NullPointerException {
        return this.contentStorageObject.countPackages(packageKind);
    }

    @Override
    public Set<? extends EssenceData> enumEssenceData() {
        return this.getEssenceData(CriteriaType.AnyRepresentation);
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=513, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ContentStorageObject", aliases={"Content"}, typeName="ContentStorageStrongReference", optional=false, uniqueIdentifier=false, pid=15107, symbol="ContentStorageObject")
    public ContentStorage getContentStorageObject() {
        return this.contentStorageObject;
    }

    @MediaPropertySetter(value="ContentStorageObject")
    public void setContentStorageObject(ContentStorage contentStorageObject) throws NullPointerException {
        if (contentStorageObject == null) {
            throw new NullPointerException("Cannot set the content for this header to null.");
        }
        this.contentStorageObject = contentStorageObject;
    }

    public static final ContentStorage initializeContentStorageObject() {
        return new ContentStorageImpl();
    }

    @Override
    @MediaProperty(uuid1=0x1020210, uuid2=514, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="DescriptiveSchemes", aliases={"DMSchemes"}, typeName="AUIDSet", optional=false, uniqueIdentifier=false, pid=15115, symbol="DescriptiveSchemes")
    public Set<AUID> getDescriptiveSchemes() throws PropertyNotPresentException {
        return new HashSet<AUID>(this.descriptiveSchemes);
    }

    @Override
    @MediaPropertyClear(value="DescriptiveSchemes")
    public void clearDescriptiveSchemes() {
        this.descriptiveSchemes = Collections.synchronizedSet(new HashSet());
    }

    @Override
    @MediaProperty(uuid1=0x1020210, uuid2=513, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="EssenceContainers", typeName="AUIDSet", optional=true, uniqueIdentifier=false, pid=15114, symbol="EssenceContainers")
    public Set<AUID> getEssenceContainers() throws PropertyNotPresentException {
        if (this.essenceContainers.size() == 0) {
            throw new PropertyNotPresentException("The optional essence containers property is not present in this header.");
        }
        return new HashSet<AUID>(this.essenceContainers);
    }

    @Override
    @MediaSetAdd(value="EssenceContainers")
    public void addEssenceContainer(AUID containerID) throws NullPointerException {
        if (containerID == null) {
            throw new NullPointerException("Cannot add a null essence container to this header.");
        }
        this.essenceContainers.add(containerID.clone());
    }

    @MediaPropertyRemove(value="EssenceContainers")
    public void removeEssenceContainer(AUID essenceContainerID) throws NullPointerException, InvalidParameterException, PropertyNotPresentException {
        if (essenceContainerID == null) {
            throw new NullPointerException("Cannot remove a essence container with a null id from this header.");
        }
        if (this.essenceContainers.size() == 0) {
            throw new PropertyNotPresentException("The optional essence containers property is not present in this header.");
        }
        if (!this.essenceContainers.contains(essenceContainerID)) {
            throw new InvalidParameterException("The given essence container is not present in this header.");
        }
        this.essenceContainers.remove(essenceContainerID);
    }

    @Override
    @MediaPropertyClear(value="EssenceContainers")
    public void clearEssenceContainers() {
        this.essenceContainers = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public Set<? extends EssenceData> getEssenceData(CriteriaType mediaCriteria) throws NullPointerException {
        if (mediaCriteria == null) {
            throw new NullPointerException("The given media criteria for filtering essence data to retrieve from this preface is null.");
        }
        return this.contentStorageObject.getEssenceDataObjects(mediaCriteria);
    }

    @Override
    public Set<? extends EssenceData> getEssenceData() {
        try {
            return this.contentStorageObject.getEssenceDataObjects();
        }
        catch (PropertyNotPresentException pnpe) {
            return new HashSet();
        }
    }

    @Override
    @MediaProperty(uuid1=50397697, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FormatVersion", aliases={"Version"}, typeName="VersionType", optional=false, uniqueIdentifier=false, pid=15109, symbol="FormatVersion")
    public VersionType getFormatVersion() {
        return this.formatVersion.clone();
    }

    @MediaPropertySetter(value="FormatVersion")
    public void setFormatVersion(VersionType formatVersion) throws NullPointerException {
        if (formatVersion == null) {
            throw new NullPointerException("Cannot set the version to a null value.");
        }
        this.formatVersion = formatVersion.clone();
    }

    public static final VersionType initializeFormatVersion() {
        return new VersionTypeImpl(1, 1);
    }

    @Override
    @MediaListGetAt(value="IdentificationList")
    public Identification getIdentificationAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.identificationList, index);
    }

    @MediaProperty(uuid1=100729092, uuid2=1540, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="IdentificationList", typeName="IdentificationStrongReferenceVector", optional=false, uniqueIdentifier=false, pid=15110, symbol="IdentificationList")
    public List<Identification> getIdentifications() {
        return StrongReferenceVector.getRequiredList(this.identificationList);
    }

    public static final List<Identification> initializeIdentificationList() {
        ArrayList<Identification> initialIDs = new ArrayList<Identification>(1);
        initialIDs.add(new IdentificationImpl("DefaultCompanyName", "DefaultProductName", "DefaultProductVersion", AUIDImpl.randomAUID()));
        return initialIDs;
    }

    void setIdentificationListValue(List<Identification> identificaitonList) {
        this.identificationList = Collections.synchronizedList(identificaitonList);
    }

    void blankIdentificationsList() {
        this.identificationList = Collections.synchronizedList(new Vector());
    }

    @Override
    public Identification getLastIdentification() {
        return this.identificationList.get(this.identificationList.size() - 1);
    }

    @Override
    @MediaProperty(uuid1=117571856, uuid2=516, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FileLastModified", aliases={"LastModified"}, typeName="TimeStamp", optional=false, uniqueIdentifier=false, pid=15106, symbol="FileLastModified")
    public TimeStamp getFileLastModified() {
        return this.fileLastModified.clone();
    }

    @Override
    @MediaPropertySetter(value="FileLastModified")
    public void setFileLastModified(TimeStamp fileLastModified) throws NullPointerException {
        if (fileLastModified == null) {
            throw new NullPointerException("Cannot set the file last modified time of this header to a null value.");
        }
        this.fileLastModified = fileLastModified.clone();
    }

    public static final TimeStamp initializeFileLastModified() {
        return new TimeStampImpl();
    }

    @Override
    public Set<? extends Package> getPackages(SearchCriteria searchCriteria) {
        return this.contentStorageObject.getPackages(searchCriteria);
    }

    @Override
    public Set<? extends Package> getPackages() {
        return this.contentStorageObject.getPackages();
    }

    @Override
    @MediaProperty(uuid1=16908803, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="OperationalPattern", typeName="AUID", optional=true, uniqueIdentifier=false, pid=15113, symbol="OperationalPattern")
    public AUID getOperationalPattern() throws PropertyNotPresentException {
        if (this.operationalPattern == null) {
            throw new PropertyNotPresentException("The operational pattern property is not present in this header.");
        }
        return this.operationalPattern.clone();
    }

    @Override
    @MediaPropertySetter(value="OperationalPattern")
    public void setOperationalPattern(AUID operationalPatternID) {
        if (operationalPatternID == null) {
            this.operationalPattern = null;
            return;
        }
        this.operationalPattern = operationalPatternID.clone();
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=264, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="PrimaryPackage", typeName="PackageWeakReference", optional=true, uniqueIdentifier=false, pid=15112, symbol="PrimaryPackage")
    public Package getPrimaryPackage() throws PropertyNotPresentException {
        if (this.primaryPackage == null) {
            throw new PropertyNotPresentException("The optional primary package property is not present for this preface.");
        }
        return this.primaryPackage.getTarget();
    }

    @Override
    @MediaPropertySetter(value="PrimaryPackage")
    public void setPrimaryPackage(Package primaryPackage) {
        if (primaryPackage == null) {
            this.primaryPackage = null;
            return;
        }
        this.primaryPackage = new WeakReference<Package>(primaryPackage);
    }

    @Override
    public ProductVersion getMajApiVersion() {
        return this.getLastIdentification().getRefImplVersion();
    }

    @Override
    @MediaPropertyContains(value="DescriptiveSchemes")
    public boolean isDescriptiveSchemePresent(AUID descriptiveSchemeID) throws NullPointerException {
        if (descriptiveSchemeID == null) {
            throw new NullPointerException("Cannot check for a descriptive scheme with a null id.");
        }
        return this.descriptiveSchemes.contains(descriptiveSchemeID);
    }

    @Override
    @MediaPropertyContains(value="EssenceContainers")
    public boolean isEssenceContainerPresent(AUID essenceContainerID) throws NullPointerException {
        if (essenceContainerID == null) {
            throw new NullPointerException("Cannot check for the presence of an essence container using a null identifier.");
        }
        return this.essenceContainers.contains(essenceContainerID);
    }

    @Override
    public boolean isEssenceDataPresent(PackageID filPackageID) throws NullPointerException, InvalidParameterException {
        try {
            Package filePackage = this.contentStorageObject.lookupPackage(filPackageID);
            if (!(filePackage instanceof SourcePackageImpl)) {
                throw new InvalidParameterException("The given package id does not correspond to a source package.");
            }
            EssenceDescriptor descriptor = ((SourcePackageImpl)filePackage).getEssenceDescription();
            if (!(descriptor instanceof AAFFileDescriptor)) {
                throw new InvalidParameterException("The given package id does not correspond to a file source package.");
            }
        }
        catch (PackageNotFoundException mnfe) {
            return false;
        }
        return true;
    }

    @Override
    public EssenceData lookupEssenceData(PackageID packageID) throws NullPointerException, PackageNotFoundException {
        return this.contentStorageObject.lookupEssenceDataObject(packageID);
    }

    @Override
    public Identification lookupIdentification(AUID generation) throws NullPointerException, ObjectNotFoundException {
        if (generation == null) {
            throw new NullPointerException("Cannot look up an identification using a null AUID.");
        }
        for (Identification identificationItem : this.identificationList) {
            if (!identificationItem.getLinkedGenerationID().equals(generation)) continue;
            return identificationItem;
        }
        throw new ObjectNotFoundException("An identification matching the given id could not be found.");
    }

    @Override
    public Package lookupPackage(PackageID packageID) throws NullPointerException, PackageNotFoundException {
        return this.contentStorageObject.lookupPackage(packageID);
    }

    @Override
    @MediaPropertyRemove(value="DescriptiveSchemes")
    public void removeDescriptiveScheme(AUID descriptiveSchemeID) throws NullPointerException, InvalidParameterException, PropertyNotPresentException {
        if (descriptiveSchemeID == null) {
            throw new NullPointerException("Cannot remove a descriptive scheme with a null value.");
        }
        if (this.descriptiveSchemes.size() == 0) {
            throw new PropertyNotPresentException("The optional descriptive schemes property is not present in this header.");
        }
        if (!this.descriptiveSchemes.contains(descriptiveSchemeID)) {
            throw new InvalidParameterException("The given descriptive scheme is not present in this header.");
        }
        this.descriptiveSchemes.remove(descriptiveSchemeID);
    }

    @Override
    public void removeEssenceData(EssenceData essenceData) throws NullPointerException, EssenceNotFoundException {
        this.contentStorageObject.removeEssenceDataObject(essenceData);
    }

    @Override
    public void removePackage(Package packageToRemove) throws NullPointerException, PackageNotFoundException {
        if (packageToRemove == null) {
            throw new NullPointerException("Cannot remove a null package value.");
        }
        this.contentStorageObject.removePackage(packageToRemove);
        this.updateEssenceContainers();
        if (packageToRemove.getPackageID().equals(this.primaryPackage.getTarget().getPackageID())) {
            this.primaryPackage = null;
        }
    }

    @Override
    public void updateEssenceContainers() {
        this.essenceContainers = Collections.synchronizedSet(new HashSet());
        Set<? extends Package> packages = this.getPackages(null);
        for (Package package_ : packages) {
            EssenceDescriptor packageDescriptor;
            if (!(package_ instanceof SourcePackage) || !((packageDescriptor = ((SourcePackage)package_).getEssenceDescription()) instanceof AAFFileDescriptor)) continue;
            this.addContainersForDescriptor((AAFFileDescriptor)packageDescriptor);
        }
    }

    private void addContainersForDescriptor(AAFFileDescriptor descriptor) {
        if (descriptor instanceof MultipleDescriptor) {
            for (AAFFileDescriptor aAFFileDescriptor : ((MultipleDescriptor)descriptor).getFileDescriptors()) {
                this.addContainersForDescriptor(aAFFileDescriptor);
            }
        } else {
            this.essenceContainers.add(descriptor.getContainerFormat().getAUID());
        }
    }

    @Override
    public Identification getGeneration() throws InvalidParameterException, ObjectNotAttachedException {
        return this.getLastIdentification();
    }

    @Override
    public AUID getLinkedGenerationID() {
        return this.getLastIdentification().getLinkedGenerationID();
    }

    @Override
    @MediaProperty(uuid1=50397697, uuid2=512, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="ByteOrder", typeName="Int16", optional=false, uniqueIdentifier=false, pid=15105, symbol="ByteOrder")
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @MediaPropertySetter(value="ByteOrder")
    public void setByteOrder(Object byteOrder) throws NullPointerException {
        if (byteOrder == null) {
            throw new NullPointerException("Cannot set the byte order of a header using a null value.");
        }
        if (byteOrder instanceof ByteOrder) {
            this.byteOrder = (ByteOrder)byteOrder;
        }
        if (byteOrder instanceof Short) {
            this.byteOrder = ByteOrder.getByteOrderFromAAFCode((Short)byteOrder);
        }
    }

    public static final ByteOrder initializeByteOrder() {
        return ByteOrder.Big;
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=514, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Dictionaries", aliases={"Dictionary", "HeaderDictionary"}, typeName="DictionaryStrongReference", optional=false, uniqueIdentifier=false, pid=15108, symbol="Dictionaries")
    public Dictionary getDictionaries() {
        return this.dictionaries;
    }

    @MediaPropertySetter(value="Dictionaries")
    public void setDictionaries(Dictionary dictionaries) throws NullPointerException {
        if (dictionaries == null) {
            throw new NullPointerException("Cannot set the dictionaries for this header to a null value.");
        }
        this.dictionaries = dictionaries;
    }

    public static final Dictionary initializeDictionaries() {
        return new DictionaryImpl();
    }

    @Override
    @MediaProperty(uuid1=50397697, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ObjectModelVersion", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=15111, symbol="ObjectModelVersion")
    public int getObjectModelVersion() {
        if (this.objectModelVersion == null) {
            return 1;
        }
        return this.objectModelVersion;
    }

    @MediaPropertySetter(value="ObjectModelVersion")
    public void setObjectModelVersion(Integer objectModelVersion) throws IllegalArgumentException {
        if (objectModelVersion == null) {
            this.objectModelVersion = null;
            return;
        }
        if (objectModelVersion < 0) {
            throw new IllegalArgumentException("Cannot set the object model version of this header to a negative value.");
        }
        this.objectModelVersion = objectModelVersion;
    }

    @Override
    @MediaProperty(uuid1=0x1020210, uuid2=515, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="ApplicationSchemes", aliases={"ApplicationMetadataSchemes", "ApplicationSchemesBatch"}, typeName="AUIDSet", optional=true, uniqueIdentifier=false, pid=0, symbol="ApplicationSchemes")
    public Set<AUID> getApplicationSchemes() throws PropertyNotPresentException {
        if (this.applicationSchemes.size() == 0) {
            throw new PropertyNotPresentException("The optional application schemes property is not present for this preface.");
        }
        return new HashSet<AUID>(this.applicationSchemes);
    }

    @Override
    @MediaSetAdd(value="ApplicationSchemes")
    public void addApplicationScheme(AUID applicationSchemeID) throws NullPointerException {
        if (applicationSchemeID == null) {
            throw new NullPointerException("Cannot add an application metadata scheme using a null identifier.");
        }
        this.applicationSchemes.add(applicationSchemeID.clone());
    }

    @Override
    @MediaPropertyClear(value="ApplicationSchemes")
    public void clearApplicationSchemes() {
        this.applicationSchemes.clear();
    }

    @Override
    @MediaPropertyCount(value="ApplicationScehemes")
    public int countApplicationSchemes() {
        return this.applicationSchemes.size();
    }

    @Override
    @MediaPropertyContains(value="ApplicationSchemes")
    public boolean isApplicationSchemePresent(AUID applicationSchemeID) throws PropertyNotPresentException, NullPointerException {
        if (applicationSchemeID == null) {
            throw new NullPointerException("Cannot check for an application scheme ID using a null value.");
        }
        if (this.applicationSchemes.size() == 0) {
            throw new PropertyNotPresentException("The optional application schemes property is not present for this preface.");
        }
        return this.applicationSchemes.contains(applicationSchemeID);
    }

    @Override
    @MediaPropertyRemove(value="ApplicationSchemes")
    public void removeApplicationScheme(AUID applicationSchemeID) throws NullPointerException, InvalidParameterException, PropertyNotPresentException {
        if (applicationSchemeID == null) {
            throw new NullPointerException("Cannot remove an application metadata scheme using a null value.");
        }
        if (this.applicationSchemes.size() == 0) {
            throw new PropertyNotPresentException("The optional application schemes property is not present for this preface.");
        }
        if (!this.applicationSchemes.contains(applicationSchemeID)) {
            throw new InvalidParameterException("The given application schemes identifier is not contained in the set of this preface.");
        }
        this.applicationSchemes.remove(applicationSchemeID);
    }

    @Override
    public boolean updateDictionaries() {
        boolean success = true;
        for (Package package_ : this.getPackages()) {
            success &= this.dictionaries.addDefinitions(package_);
        }
        return success;
    }

    @Override
    public Preface clone() {
        return (Preface)super.clone();
    }

    public String getFileLastModifiedString() {
        return TimeStampImpl.toPersistentForm(this.fileLastModified);
    }

    public void setFileLastModifiedString(String fileLastModified) {
        this.fileLastModified = TimeStampImpl.fromPersistentForm(fileLastModified);
    }

    public String getFormatVersionString() {
        return VersionTypeImpl.toPersistentForm(this.formatVersion);
    }

    public void setFormatVersionString(String formatVersion) {
        this.formatVersion = VersionTypeImpl.fromPersistentForm(formatVersion);
    }

    public String getOperationalPatternString() {
        return AUIDImpl.toPersistentForm(this.operationalPattern);
    }

    public void setOperationPatternString(String operationalPattern) {
        this.operationalPattern = AUIDImpl.fromPersistentForm(operationalPattern);
    }

    public Set<String> getEssenceContainersStringSet() {
        return PrefaceImpl.auidSetToStringSet(this.essenceContainers);
    }

    public void setEssenceContainersStringSet(Set<String> essenceContainers) {
        this.essenceContainers = PrefaceImpl.stringSetToAUIDSet(essenceContainers);
    }

    public Set<String> getDescriptiveSchemesStringSet() {
        return PrefaceImpl.auidSetToStringSet(this.descriptiveSchemes);
    }

    public void setDescriptiveSchemesStringSet(Set<String> descriptiveSchemes) {
        this.descriptiveSchemes = PrefaceImpl.stringSetToAUIDSet(descriptiveSchemes);
    }

    private static final Set<String> auidSetToStringSet(Set<AUID> auidSet) {
        if (auidSet == null) {
            return null;
        }
        HashSet<String> stringSet = new HashSet<String>(auidSet.size());
        for (AUID auid : auidSet) {
            stringSet.add(AUIDImpl.toPersistentForm(auid));
        }
        return stringSet;
    }

    private static final Set<AUID> stringSetToAUIDSet(Set<String> stringSet) {
        if (stringSet == null) {
            return null;
        }
        Set<AUID> auidSet = Collections.synchronizedSet(new HashSet(stringSet.size()));
        for (String auid : stringSet) {
            auidSet.add(AUIDImpl.fromPersistentForm(auid));
        }
        return auidSet;
    }

    @Override
    @MediaProperty(uuid1=-718985234, uuid2=-17763, uuid3=19755, uuid4={-110, -66, -23, 58, 42, 7, 61, 102}, definedName="Archive database type", symbol="Archive_database_type", aliases={"Archive_database_type"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getArchiveDatabaseType() throws PropertyNotPresentException {
        if (this.archiveDatabaseType == null) {
            throw new PropertyNotPresentException("The optional archive database type property is not present for this Quantel preface.");
        }
        return this.archiveDatabaseType;
    }

    @Override
    @MediaPropertySetter(value="Archive database type")
    public void setArchiveDatabaseType(@Int32 Integer archiveDatabaseType) {
        this.archiveDatabaseType = archiveDatabaseType;
    }
}

