/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.InvalidParameterException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyContains;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertyRemove;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.DescriptiveClip;
import tv.amwa.maj.model.impl.SourceClipImpl;
import tv.amwa.maj.union.SourceReferenceValue;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=17664, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="DescriptiveClip", description="A descriptive clip specifies what is being described and references a package to provide that description.", symbol="DescriptiveClip")
public class DescriptiveClipImpl
extends SourceClipImpl
implements DescriptiveClip,
Serializable,
Cloneable {
    private static final long serialVersionUID = -6668716126007849274L;
    private Set<Integer> descriptiveClipDescribedTrackIDs = Collections.synchronizedSet(new HashSet());

    public DescriptiveClipImpl() {
    }

    public DescriptiveClipImpl(DataDefinition dataDefinition, long length, SourceReferenceValue sourceReference) throws NullPointerException, BadLengthException {
        if (dataDefinition == null) {
            throw new NullPointerException("Cannot create a new descriptive clip using a null data definition.");
        }
        if (sourceReference == null) {
            throw new NullPointerException("Cannot create a new descriptive clip with a null source reference.");
        }
        if (length < 0L) {
            throw new BadLengthException("Cannot create a new descriptive clip with a negative length.");
        }
        this.setComponentDataDefinition(dataDefinition);
        this.setLengthPresent(true);
        this.setComponentLength(length);
        this.setSourceReference(sourceReference);
    }

    @Override
    @MediaProperty(uuid1=17236230, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="DescriptiveClipDescribedTrackIDs", aliases={"DescribedSlotIDs"}, typeName="UInt32Set", optional=true, uniqueIdentifier=false, pid=24835, symbol="DescriptiveClipDescribedTrackIDs")
    public Set<Integer> getDescribedTrackIDs() {
        return new HashSet<Integer>(this.descriptiveClipDescribedTrackIDs);
    }

    @Override
    @MediaSetAdd(value="DescriptiveClipDescribedTrackIDs")
    public void addDescribedTrackID(int describedTrackID) throws IllegalArgumentException, InvalidParameterException {
        if (describedTrackID < 0) {
            throw new IllegalArgumentException("A track id cannot be negative and so cannot be added to the set of descrived track ids of this descriptive clip.");
        }
        if (this.descriptiveClipDescribedTrackIDs.contains(describedTrackID)) {
            throw new InvalidParameterException("Cannot add the given described track id to the set of described track ids referenced by this descriptive clip already contains it.");
        }
        this.descriptiveClipDescribedTrackIDs.add(describedTrackID);
    }

    @Override
    @MediaPropertyCount(value="DescriptiveClipDescribedTrackIDs")
    public int countDescribedTrackIDs() {
        return this.descriptiveClipDescribedTrackIDs.size();
    }

    @Override
    @MediaPropertyContains(value="DescriptiveClipDescribedTrackIDs")
    public boolean isDescribedTrackIDPresent(int describedTrackID) throws IllegalArgumentException {
        if (describedTrackID < 0) {
            throw new IllegalArgumentException("Cannot check for a negative track id value in the set of described slots ids referenced by this descriptive clip.");
        }
        return this.descriptiveClipDescribedTrackIDs.contains(describedTrackID);
    }

    @Override
    @MediaPropertyRemove(value="DescriptiveClipDescribedTrackIDs")
    public void removeDescribedTrackID(int describedTrackID) throws IllegalArgumentException, InvalidParameterException {
        if (describedTrackID < 0) {
            throw new IllegalArgumentException("Cannot remove an illegal negative track id value from the set of described slots ids referenced by this descriptive clip.");
        }
        if (!this.descriptiveClipDescribedTrackIDs.contains(describedTrackID)) {
            throw new InvalidParameterException("Cannot remove the given described track id value from the set of described track ids referenced by this descriptive clip as it is not currently contained.");
        }
        this.descriptiveClipDescribedTrackIDs.remove(describedTrackID);
    }

    @Override
    @MediaPropertyClear(value="DescriptiveClipDescribedTrackIDs")
    public void clearDescribedTrackIDs() {
        this.descriptiveClipDescribedTrackIDs = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public DescriptiveClip clone() {
        return (DescriptiveClip)super.clone();
    }
}

