/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.industry;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.enumeration.Boolean;
import tv.amwa.maj.exception.BadParameterException;
import tv.amwa.maj.exception.IllegalPropertyException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.AAFSpecifiedClasses;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.LocalFileResolver;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.industry.StreamResolver;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionFixedArray;
import tv.amwa.maj.meta.TypeDefinitionInteger;
import tv.amwa.maj.meta.TypeDefinitionRecord;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.record.AUID;

public final class MediaEngine
implements CommonConstants {
    private static boolean aafInitialized = false;
    private static Set<AUID> baselineIDs = new HashSet<AUID>();
    private static StreamResolver resolver = new LocalFileResolver();

    private MediaEngine() {
    }

    public static final void initializeAAF() {
        if (aafInitialized) {
            return;
        }
        for (Class<?> aafClass : AAFSpecifiedClasses.interchangeable) {
            Warehouse.lookForClass(aafClass);
        }
        for (Class<?> aafClass : AAFSpecifiedClasses.meta) {
            Warehouse.lookForClass(aafClass);
        }
        for (Class<?> typeClass : Warehouse.typeDefinitionClasses) {
            Warehouse.registerTypes(typeClass, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf");
        }
        try {
            for (Class<?> extEnum : Warehouse.extensibleEnumerationClasses) {
                Warehouse.registerExtendibleEnumerationElements(extEnum);
            }
        }
        catch (Exception e) {
            System.err.println("Unexpected exception in static initilizer for ExtensibleEnumerationFactory.");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        MediaEngine.buildBaselineClasses();
        aafInitialized = true;
    }

    private static final void buildBaselineClasses() {
        for (Class<?> baselineClass : AAFSpecifiedClasses.interchangeable) {
            MediaEngine.addBaselineIDs(Warehouse.lookForClass(baselineClass));
        }
        for (Class<?> baselineClass : AAFSpecifiedClasses.abstractInterchangeable) {
            MediaEngine.addBaselineIDs(Warehouse.lookForClass(baselineClass));
        }
        for (Class<?> baselineClass : AAFSpecifiedClasses.meta) {
            MediaEngine.addBaselineIDs(Warehouse.lookForClass(baselineClass));
        }
        for (Class<?> baselineClass : AAFSpecifiedClasses.abstractMeta) {
            MediaEngine.addBaselineIDs(Warehouse.lookForClass(baselineClass));
        }
        MediaEngine.addBaselineTypeDefinitions();
    }

    private static final void addBaselineIDs(ClassDefinition aafClass) {
        baselineIDs.add(aafClass.getAUID());
        for (PropertyDefinition propertyDefinition : aafClass.getPropertyDefinitions()) {
            if (!propertyDefinition.getNamespace().equals("http://www.smpte-ra.org/schemas/2001-2/2007/aaf")) continue;
            baselineIDs.add(propertyDefinition.getAUID());
        }
    }

    private static final void addBaselineTypeDefinitions() {
        for (Field field : TypeDefinitions.class.getDeclaredFields()) {
            try {
                TypeDefinition type = (TypeDefinition)field.get(null);
                baselineIDs.add(type.getAUID());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static final boolean isBaseline(MetaDefinition metaDefinition) {
        if (metaDefinition == null) {
            throw new NullPointerException("Cannot determine if a definition is baseline using a null value.");
        }
        try {
            return baselineIDs.contains(metaDefinition.getAUID());
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public static final boolean isBaseline(AUID metaDefinitionID) throws NullPointerException {
        if (metaDefinitionID == null) {
            throw new NullPointerException("Cannot check whether a class is baseline using a null identifier.");
        }
        return baselineIDs.contains(metaDefinitionID);
    }

    public static boolean equals(MetadataObject first, Object second) {
        if (!MediaEngine.basicEqualityChecks(first, second)) {
            return false;
        }
        if (first == second) {
            return true;
        }
        ClassDefinition firstClass = Warehouse.lookForClass(first.getClass());
        ClassDefinition secondClass = Warehouse.lookForClass(second.getClass());
        if (firstClass.isUniquelyIdentified() && secondClass.isUniquelyIdentified()) {
            return firstClass.getUniqueIdentifierValue(first).getValue().equals(secondClass.getUniqueIdentifierValue((MetadataObject)second).getValue());
        }
        return MediaEngine.propertyByPropertyEquality(firstClass, first, secondClass, (MetadataObject)second);
    }

    private static final boolean basicEqualityChecks(MetadataObject first, Object second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        if (first == second) {
            return true;
        }
        if (!(second instanceof MetadataObject)) {
            return false;
        }
        return first.getClass().isInstance(second) || second.getClass().isInstance(first);
    }

    private static final boolean propertyByPropertyEquality(ClassDefinition firstClass, MetadataObject first, ClassDefinition secondClass, MetadataObject second) {
        SortedMap<? extends PropertyDefinition, ? extends PropertyValue> firstValues = firstClass.getProperties(first);
        SortedMap<? extends PropertyDefinition, ? extends PropertyValue> secondValues = secondClass.getProperties(second);
        if (firstValues.size() != secondValues.size()) {
            return false;
        }
        for (PropertyDefinition propertyDefinition : firstValues.keySet()) {
            if (secondValues.containsKey(propertyDefinition)) continue;
            return false;
        }
        for (PropertyDefinition propertyDefinition : firstValues.keySet()) {
            PropertyValue secondValue;
            PropertyValue firstValue = (PropertyValue)firstValues.get(propertyDefinition);
            if (firstValue.equals(secondValue = (PropertyValue)secondValues.get(propertyDefinition))) continue;
            return false;
        }
        return true;
    }

    public static final boolean deepEquals(MetadataObject first, Object second) {
        if (!MediaEngine.basicEqualityChecks(first, second)) {
            return false;
        }
        ClassDefinition firstClass = Warehouse.lookForClass(first.getClass());
        ClassDefinition secondClass = Warehouse.lookForClass(second.getClass());
        return MediaEngine.propertyByPropertyEquality(firstClass, first, secondClass, (MetadataObject)second);
    }

    public static final int hashCode(MetadataObject value) {
        if (value == null) {
            return 0;
        }
        ClassDefinition metaClass = Warehouse.lookForClass(value.getClass());
        if (metaClass.isUniquelyIdentified()) {
            PropertyDefinition uniqueIdentifierProperty = metaClass.getUniqueIdentifierProperty();
            PropertyValue valueUniqueID = uniqueIdentifierProperty.getPropertyValue(value);
            return valueUniqueID.getValue().hashCode();
        }
        SortedMap<? extends PropertyDefinition, ? extends PropertyValue> propertyValues = metaClass.getProperties(value);
        int hashCode = 0;
        for (PropertyValue propertyValue : propertyValues.values()) {
            hashCode ^= propertyValue.hashCode();
        }
        return hashCode;
    }

    public static final <T> T getPropertyValue(MetadataObject target, String propertyName) throws NullPointerException, IllegalPropertyException, ClassCastException, PropertyNotPresentException {
        try {
            PropertyValue candidateValue = MediaEngine.getWrappedPropertyValue(target, propertyName);
            if (candidateValue.getType().equals(TypeDefinitions.Boolean)) {
                Boolean boolValue = (Boolean)candidateValue.getValue();
                if (boolValue == Boolean.True) {
                    return (T)java.lang.Boolean.valueOf(true);
                }
                return (T)java.lang.Boolean.valueOf(false);
            }
            if (candidateValue.getValue() instanceof Collection) {
                TypeDefinition elementType = null;
                switch (candidateValue.getType().getTypeCategory()) {
                    case VariableArray: {
                        elementType = ((TypeDefinitionVariableArray)candidateValue.getType()).getType();
                        break;
                    }
                    case Set: {
                        elementType = ((TypeDefinitionSet)candidateValue.getType()).getElementType();
                        if (elementType instanceof TypeDefinitionInteger) {
                            return (T)candidateValue.getValue();
                        }
                        if (!(elementType instanceof TypeDefinitionRecord)) break;
                        return (T)candidateValue.getValue();
                    }
                    case FixedArray: {
                        elementType = ((TypeDefinitionFixedArray)candidateValue.getType()).getType();
                        break;
                    }
                    default: {
                        return (T)candidateValue.getValue();
                    }
                }
                Collection candidateCollection = (Collection)candidateValue.getValue();
                switch (elementType.getTypeCategory()) {
                    case Int: {
                        switch (((TypeDefinitionInteger)elementType).getSize()) {
                            case 1: {
                                byte[] bytes = new byte[candidateCollection.size()];
                                int x1 = 0;
                                for (Object byteElement : candidateCollection) {
                                    bytes[x1++] = (Byte)byteElement;
                                }
                                return (T)bytes;
                            }
                            case 2: {
                                short[] shorts = new short[candidateCollection.size()];
                                int x2 = 0;
                                for (Object shortElement : candidateCollection) {
                                    shorts[x2++] = (Short)shortElement;
                                }
                                return (T)shorts;
                            }
                            case 4: {
                                int[] ints = new int[candidateCollection.size()];
                                int x3 = 0;
                                for (Object intElement : candidateCollection) {
                                    ints[x3++] = (Integer)intElement;
                                }
                                return (T)ints;
                            }
                        }
                        long[] longs = new long[candidateCollection.size()];
                        int x4 = 0;
                        for (Object longElement : candidateCollection) {
                            longs[x4++] = (Long)longElement;
                        }
                        return (T)longs;
                    }
                    case Enum: 
                    case Record: {
                        return (T)candidateCollection.toArray();
                    }
                }
                return (T)candidateValue.getValue();
            }
            return (T)candidateValue.getValue();
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Class cast exception when trying to convert property " + propertyName + " to a value of the required type: " + cce.getMessage());
        }
    }

    public static final PropertyValue getWrappedPropertyValue(MetadataObject target, String propertyName) throws NullPointerException, IllegalPropertyException, PropertyNotPresentException {
        if (target == null) {
            throw new NullPointerException("Cannot get a property value from a null target value.");
        }
        if (propertyName == null) {
            throw new NullPointerException("Cannot get a property value from the given metadata object using a null property name.");
        }
        ClassDefinition targetClass = Warehouse.lookForClass(target.getClass());
        try {
            PropertyDefinition targetProperty = targetClass.lookupPropertyDefinition(propertyName);
            return targetProperty.getPropertyValue(target);
        }
        catch (BadParameterException bpe) {
            throw new IllegalPropertyException("The given property name does not match that of a known property for class " + targetClass.getName() + ".");
        }
    }

    public static final ClassDefinition getClassDefinition(MetadataObject target) throws NullPointerException, IllegalArgumentException {
        return Warehouse.lookForClass(target.getClass());
    }

    public static final PropertyDefinition getPropertyDefinition(MetadataObject target, String propertyName) throws NullPointerException, IllegalPropertyException, IllegalArgumentException {
        if (target == null) {
            throw new NullPointerException("Cannot get a property definition from a null value.");
        }
        if (propertyName == null) {
            throw new NullPointerException("Cannot get a property definition from the given metadata object using a null value.");
        }
        ClassDefinition targetClass = Warehouse.lookForClass(target.getClass());
        try {
            return targetClass.lookupPropertyDefinition(propertyName);
        }
        catch (BadParameterException bpe) {
            throw new IllegalPropertyException("The given property name does not match that of a known property for class " + targetClass.getName() + ".");
        }
    }

    public static final void setPropertyValue(MetadataObject target, String propertyName, Object propertyValue) throws NullPointerException, IllegalPropertyException, IllegalArgumentException {
        PropertyDefinition targetDefinition = MediaEngine.getPropertyDefinition(target, propertyName);
        targetDefinition.setPropertyValue(target, targetDefinition.getTypeDefinition().createValue(propertyValue));
    }

    public static final void setPropertyValue(MetadataObject target, String propertyName, PropertyValue propertyValue) throws NullPointerException, IllegalPropertyException, IllegalArgumentException {
        PropertyDefinition targetDefinition = MediaEngine.getPropertyDefinition(target, propertyName);
        targetDefinition.setPropertyValue(target, propertyValue);
    }

    public static final String toString(MetadataObject metadataOject) {
        return XMLBuilder.toXML(metadataOject);
    }

    public static final <T extends MetadataObject> T make(Class<T> type, boolean strict, Object ... properties) throws NullPointerException, IllegalArgumentException {
        return Forge.make(type, strict, properties);
    }

    public static final <T extends MetadataObject> T make(Class<T> type, Object ... properties) throws NullPointerException, IllegalArgumentException {
        return Forge.make(type, properties);
    }

    public static final <T extends MetadataObject> T makeByName(String namespace, String typeName, boolean strict, Object ... properties) throws NullPointerException, IllegalArgumentException {
        return Forge.makeByName(namespace, typeName, strict, properties);
    }

    public static final <T extends MetadataObject> T makeByName(String namespace, String typeName, Object ... properties) throws NullPointerException, IllegalArgumentException {
        return Forge.makeByName(namespace, typeName, properties);
    }

    public static final <T extends MetadataObject> T makeAAF(String typeName, Object ... properties) throws NullPointerException, IllegalArgumentException {
        return Forge.makeAAF(typeName, properties);
    }

    public static final boolean isPropertyPresent(MetadataObject target, String propertyName) throws NullPointerException, IllegalPropertyException {
        if (target == null) {
            throw new NullPointerException("Cannot check for for the presence of a property using a null value.");
        }
        if (propertyName == null) {
            throw new NullPointerException("Cannot get a property value from the given metadata object using a null property name.");
        }
        ClassDefinition targetClass = Warehouse.lookForClass(target.getClass());
        try {
            PropertyDefinition targetProperty = targetClass.lookupPropertyDefinition(propertyName);
            return targetProperty.isPropertyPresent(target);
        }
        catch (BadParameterException bpe) {
            throw new IllegalPropertyException("The given property name " + propertyName + " does not match that of a known property for class " + targetClass.getName() + ".");
        }
    }

    public static final void omitOptionalProperty(MetadataObject target, String propertyName) throws NullPointerException, IllegalPropertyException, IllegalArgumentException {
        if (target == null) {
            throw new NullPointerException("Cannot omit a property using a null value.");
        }
        if (propertyName == null) {
            throw new NullPointerException("Cannot omit a property from the given metadata object using a null property name.");
        }
        ClassDefinition targetClass = Warehouse.lookForClass(target.getClass());
        try {
            PropertyDefinition targetProperty = targetClass.lookupPropertyDefinition(propertyName);
            targetProperty.omitOptionalProperty(target);
        }
        catch (BadParameterException bpe) {
            throw new IllegalPropertyException("The given property name " + propertyName + " does not match that of a known property for class " + targetClass.getName() + ".");
        }
    }

    public static final Stream resolveStream(URI streamReference) throws NullPointerException {
        return resolver.resolveStream(streamReference);
    }

    public static final Stream resolveStream(URI streamReference, String accept) throws NullPointerException, IllegalArgumentException {
        return resolver.resolveStream(streamReference, accept);
    }

    public static final URI makeSpecific(URI streamReference, String accept) throws NullPointerException, IllegalArgumentException {
        return resolver.makeSpecific(streamReference, accept);
    }

    public static final void registerMapping(URI canonicalForm, URI location) throws NullPointerException, IllegalArgumentException {
        resolver.registerMapping(canonicalForm, location);
    }

    public static final boolean removeLocation(URI identifier) throws NullPointerException {
        return resolver.removeLocation(identifier);
    }

    public static final StreamResolver getStreamResolver() {
        return resolver;
    }

    public static final void changeStreamResolver(StreamResolver newResolver) throws NullPointerException {
        if (resolver == null) {
            throw new NullPointerException("Cannot set a null stream resolver.");
        }
        resolver = newResolver;
    }
}

