/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import tv.amwa.maj.enumeration.EditHintType;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.exception.RationalRangeException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.model.ControlPoint;
import tv.amwa.maj.model.VaryingValue;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.RationalImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=6400, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="ControlPoint", description="The ControlPoint class specifies a value and a time point and is used to specify an effect control value.", symbol="ControlPoint")
public class ControlPointImpl
extends InterchangeObjectImpl
implements ControlPoint,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = -5739560488672782553L;
    private AUID valueType;
    private Serializable controlPointValue;
    private Rational controlPointTime;
    private EditHintType editHint = null;

    public ControlPointImpl() {
    }

    public ControlPointImpl(VaryingValue varyingValue, Rational controlPointTime, PropertyValue controlPointValue) throws NullPointerException, RationalRangeException {
        if (varyingValue == null) {
            throw new NullPointerException("Cannot create a control point with a null varying value.");
        }
        if (controlPointTime == null) {
            throw new NullPointerException("Cannot create a control point with a null time value.");
        }
        if (controlPointValue == null) {
            throw new NullPointerException("Cannot create a control point with a null value.");
        }
        this.setTypeDefinition(varyingValue.getTypeDefinition());
        this.setControlPointTime(controlPointTime);
        this.setControlPointValue(controlPointValue);
    }

    public ControlPointImpl(TypeDefinition varyingValueType, Rational controlPointTime, PropertyValue controlPointValue) {
        if (varyingValueType == null) {
            throw new NullPointerException("Cannot create a control point with a null varying value type.");
        }
        if (controlPointTime == null) {
            throw new NullPointerException("Cannot create a control point with a null time value.");
        }
        if (controlPointValue == null) {
            throw new NullPointerException("Cannot create a control point with a null value.");
        }
        this.setTypeDefinition(varyingValueType);
        this.setControlPointTime(controlPointTime);
        this.setControlPointValue(controlPointValue);
    }

    @Override
    @MediaProperty(uuid1=87033096, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="EditHint", typeName="EditHintType", optional=true, uniqueIdentifier=false, pid=6660, symbol="EditHint")
    public EditHintType getEditHint() throws PropertyNotPresentException {
        if (this.editHint == null) {
            throw new PropertyNotPresentException("Edit hint property not yet set for control point.");
        }
        return this.editHint;
    }

    @Override
    @MediaPropertySetter(value="EditHint")
    public void setEditHint(EditHintType editHint) {
        this.editHint = editHint;
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=4098, uuid3=256, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ControlPointTime", aliases={"Time"}, typeName="Rational", optional=false, uniqueIdentifier=false, pid=6659, symbol="ControlPointTime")
    public Rational getTime() {
        return this.controlPointTime.clone();
    }

    @Override
    @MediaPropertySetter(value="ControlPointTime")
    public void setControlPointTime(Rational controlPointTime) throws RationalRangeException, NullPointerException {
        if (controlPointTime == null) {
            throw new NullPointerException("Cannot set the time for a control point from a null value.");
        }
        double rangeCheckValue = controlPointTime.doubleValue();
        if (rangeCheckValue < 0.0 || rangeCheckValue > 1.0) {
            throw new RationalRangeException("Time value is outside the acceptable inclusive range of 0.0 to 1.0.");
        }
        this.controlPointTime = controlPointTime.clone();
    }

    public static final Rational initializeControlPointTime() {
        return new RationalImpl(0, 1);
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return Warehouse.lookForType(this.valueType).clone();
    }

    void setTypeDefinition(TypeDefinition valueType) {
        this.valueType = valueType.getAUID().clone();
    }

    @Override
    @MediaProperty(uuid1=87033101, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ControlPointValue", aliases={"Value"}, typeName="Indirect", optional=false, uniqueIdentifier=false, pid=6658, symbol="ControlPointValue")
    public PropertyValue getControlPointValue() {
        return Warehouse.lookForType(this.valueType).createValue(this.controlPointValue);
    }

    @Override
    @MediaPropertySetter(value="ControlPointValue")
    public void setControlPointValue(PropertyValue controlPointValue) throws NullPointerException, ClassCastException {
        if (controlPointValue == null) {
            throw new NullPointerException("Cannot set a control point value to null.");
        }
        if (controlPointValue.getType() == null) {
            throw new NullPointerException("Cannot set a control point value with a null type in a property value.");
        }
        if (controlPointValue.getType().equals(TypeDefinitions.Indirect)) {
            controlPointValue = (PropertyValue)controlPointValue.getValue();
        }
        if (!(controlPointValue.getValue() instanceof Serializable)) {
            throw new ClassCastException("The value of a control point must implement java.io.Serializable.");
        }
        this.valueType = controlPointValue.getType().getAUID().clone();
        this.controlPointValue = (Serializable)controlPointValue.getValue();
    }

    public static final PropertyValue initializeControlPointValue() {
        return TypeDefinitions.Int32.createValue(0);
    }

    @Override
    public ControlPoint clone() {
        return (ControlPoint)super.clone();
    }

    @Override
    public String getComment() {
        return "local control point persistent id: " + this.getPersistentID();
    }

    public String getControlPointTimeString() {
        return RationalImpl.toPersistentForm(this.controlPointTime);
    }

    public void setControlPointTimeString(String controlPointTime) {
        this.controlPointTime = RationalImpl.fromPersistentForm(controlPointTime);
    }

    public byte[] getControlPointValuePersist() throws NotSerializableException, NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        if (this.controlPointValue == null || this.valueType == null) {
            return null;
        }
        PropertyValue typedValue = this.getControlPointValue();
        PropertyValue indirectValue = TypeDefinitions.Indirect.createValueFromActualValue(typedValue);
        ByteBuffer buffer = ByteBuffer.allocate((int)TypeDefinitions.Indirect.lengthAsBytes(indirectValue));
        TypeDefinitions.Indirect.writeAsBytes(indirectValue, buffer);
        buffer.rewind();
        return buffer.array();
    }

    public void setControlPointValuePersist(byte[] indirectBytes) {
        if (indirectBytes == null) {
            this.controlPointValue = null;
            this.valueType = null;
            return;
        }
        PropertyValue indirectValue = TypeDefinitions.Indirect.createFromBytes(ByteBuffer.wrap(indirectBytes));
        PropertyValue typedValue = (PropertyValue)indirectValue.getValue();
        this.controlPointValue = (Serializable)typedValue.getValue();
        this.valueType = typedValue.getType().getAUID();
    }
}

