/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.misctype.Bool;
import tv.amwa.maj.misctype.DataValue;
import tv.amwa.maj.misctype.JPEGTableIDType;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.TIFFDescriptor;
import tv.amwa.maj.model.impl.AAFFileDescriptorImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=11008, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TIFFDescriptor", description="The TIFFDescriptor class specifies that a File SourcePackage is associated with video essence formatted according to the TIFF specification.", symbol="TIFFDescriptor")
public class TIFFDescriptorImpl
extends AAFFileDescriptorImpl
implements TIFFDescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = 258831607340293352L;
    private static final int JT_NULL = 0;
    private boolean isUniform;
    private boolean isContiguous;
    private Integer leadingLines = null;
    private Integer trailingLines = null;
    @JPEGTableIDType
    private Integer jpegTableID = 0;
    private byte[] tiffSummary;

    public TIFFDescriptorImpl() {
    }

    public TIFFDescriptorImpl(ContainerDefinition containerFormat, @Bool boolean isUniform, @Bool boolean isContiguous, @DataValue byte[] summary) throws NullPointerException {
        if (summary == null) {
            throw new NullPointerException("Cannot create a new TIFF descriptor using a null summary.");
        }
        this.setContainerFormat(containerFormat);
        this.setIsUniform(isUniform);
        this.setIsContiguous(isContiguous);
        this.setTIFFSummary(summary);
    }

    @Override
    @MediaProperty(uuid1=101188097, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="IsContiguous", typeName="Boolean", optional=false, uniqueIdentifier=false, pid=14082, symbol="IsContiguous")
    public boolean getIsContiguous() {
        return this.isContiguous;
    }

    @Override
    @MediaPropertySetter(value="IsContiguous")
    public void setIsContiguous(boolean isContiguous) {
        this.isContiguous = isContiguous;
    }

    public static final boolean initializeIsContiguous() {
        return false;
    }

    @Override
    @MediaProperty(uuid1=84017411, uuid2=257, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="IsUniform", typeName="Boolean", optional=false, uniqueIdentifier=false, pid=14081, symbol="IsUniform")
    public boolean getIsUniform() {
        return this.isUniform;
    }

    @Override
    @MediaPropertySetter(value="IsUniform")
    public void setIsUniform(boolean isUniform) {
        this.isUniform = isUniform;
    }

    public static final boolean initializeIsUniform() {
        return false;
    }

    @Override
    @MediaProperty(uuid1=84017411, uuid2=258, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="JPEGTableID", typeName="JPEGTableIDType", optional=true, uniqueIdentifier=false, pid=14085, symbol="JPEGTableID")
    public int getJPEGTableID() throws PropertyNotPresentException {
        if (this.jpegTableID == null) {
            throw new PropertyNotPresentException("The optional JPEG table id property is not present in TIFF descriptor.");
        }
        return this.jpegTableID;
    }

    @Override
    @MediaPropertySetter(value="JPEGTableID")
    public void setJPEGTableID(Integer jpegTableID) {
        this.jpegTableID = jpegTableID;
    }

    @Override
    @MediaProperty(uuid1=67175170, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="LeadingLines", typeName="Int32", optional=true, uniqueIdentifier=false, pid=14083, symbol="LeadingLines")
    public int getLeadingLines() {
        if (this.leadingLines == null) {
            return 0;
        }
        return this.leadingLines;
    }

    @Override
    @MediaPropertySetter(value="LeadingLines")
    public void setLeadingLines(Integer leadingLines) {
        this.leadingLines = leadingLines;
    }

    @Override
    @MediaProperty(uuid1=0x3030302, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TIFFSummary", aliases={"Summary", "TIFFDescriptorSummary"}, typeName="DataValue", optional=false, uniqueIdentifier=false, pid=14086, symbol="TIFFSummary")
    public byte[] getTIFFSummary() {
        return (byte[])this.tiffSummary.clone();
    }

    @Override
    @MediaPropertySetter(value="TIFFSummary")
    public void setTIFFSummary(byte[] tiffSummary) throws NullPointerException {
        if (tiffSummary == null) {
            throw new NullPointerException("Cannot set the summary of a TIFF descriptor to a null value.");
        }
        this.tiffSummary = (byte[])tiffSummary.clone();
    }

    @Override
    public int getSummaryBufferSize() {
        return this.tiffSummary.length;
    }

    public static final byte[] initializeTIFFSummary() {
        return new byte[0];
    }

    @Override
    @MediaProperty(uuid1=67175170, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="TrailingLines", typeName="Int32", optional=true, uniqueIdentifier=false, pid=14084, symbol="TrailingLines")
    public int getTrailingLines() {
        if (this.trailingLines == null) {
            return 0;
        }
        return this.trailingLines;
    }

    @Override
    @MediaPropertySetter(value="TrailingLines")
    public void setTrailingLines(Integer trailingLines) {
        this.trailingLines = trailingLines;
    }

    @Override
    public TIFFDescriptor clone() {
        return (TIFFDescriptor)super.clone();
    }
}

