/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.Boolean;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.exception.InvalidParameterException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaEnumerationValue;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionEnumeration;
import tv.amwa.maj.meta.TypeDefinitionInteger;
import tv.amwa.maj.meta.impl.PropertyDefinitionImpl;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=519, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionEnumeration", description="The TypeDefinitionEnumeration class defines a property type that can have one of a set of integer values.", symbol="TypeDefinitionEnumeration")
public final class TypeDefinitionEnumerationImpl
extends SingletonTypeDefinitionImpl
implements TypeDefinitionEnumeration,
Serializable,
Cloneable {
    private static final long serialVersionUID = 5104190354150925255L;
    private Class<Enum<?>> elements;
    private MediaEnumerationValue[] elementArray;
    private Map<String, MediaEnumerationValue> nameMap = Collections.synchronizedMap(new HashMap());
    private Map<Long, MediaEnumerationValue> valueMap = Collections.synchronizedMap(new HashMap());
    private WeakReference<TypeDefinition> elementType;

    protected TypeDefinitionEnumerationImpl() {
    }

    public TypeDefinitionEnumerationImpl(AUID identification, @AAFString String typeName, Class<?> enumeration, TypeDefinition elementType) throws NullPointerException, IllegalArgumentException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new enumeration type definition with a null identification.");
        }
        if (enumeration == null) {
            throw new NullPointerException("Cannot create a new enumeration type definition with a null Java enumeration.");
        }
        if (!enumeration.isEnum()) {
            throw new IllegalArgumentException("The class provided to describe this enumeration is not a Java enumeration.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.setElementType(elementType);
        this.setElements(enumeration);
    }

    void setElements(Class<Enum<?>> enumeration) throws NullPointerException, IllegalArgumentException {
        if (enumeration == null) {
            throw new NullPointerException("Cannot set the elements for this type definiton using a null enumeration class.");
        }
        this.elements = enumeration;
        Enum<?>[] constants = enumeration.getEnumConstants();
        this.elementArray = new MediaEnumerationValue[constants.length];
        int elementCounter = 0;
        try {
            for (Enum<?> item : constants) {
                MediaEnumerationValue itemValue = (MediaEnumerationValue)((Object)item);
                this.nameMap.put(itemValue.name(), itemValue);
                this.nameMap.put(itemValue.symbol(), itemValue);
                this.valueMap.put(itemValue.value(), itemValue);
                this.elementArray[elementCounter++] = itemValue;
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Java enumerations representing AAF enumerations must implement the AAFEnumerationValue interface.");
        }
    }

    @Override
    public int countElements() {
        return this.elementArray.length;
    }

    @Override
    public PropertyValue createValueFromName(String name) throws NullPointerException, InvalidParameterException {
        if (name == null) {
            throw new NullPointerException("Cannot create a new enumeration value from a null name.");
        }
        if (!this.nameMap.containsKey(name)) {
            throw new InvalidParameterException("An enumeration value of the given name of " + name + " is not present in this enumeration type definition.");
        }
        return new EnumerationValue(this, this.nameMap.get(name));
    }

    @Override
    public PropertyValue createValueFromOrdinal(Number ordinal) throws NullPointerException, InvalidParameterException {
        if (ordinal == null) {
            throw new NullPointerException("Cannot create a new enumeration value from a null ordinal value.");
        }
        long ordinalLong = ordinal.longValue();
        if (!((TypeDefinitionInteger)this.elementType.getTarget()).isSigned()) {
            switch (((TypeDefinitionInteger)this.elementType.getTarget()).getSize()) {
                case 1: {
                    ordinalLong = ordinalLong < 0L ? 256L + ordinalLong : ordinalLong;
                    break;
                }
                case 2: {
                    ordinalLong = ordinalLong < 0L ? 65536L + ordinalLong : ordinalLong;
                    break;
                }
                case 4: {
                    ordinalLong = ordinalLong < 0L ? 0x100000000L + ordinalLong : ordinalLong;
                    break;
                }
                case 8: {
                    long l = ordinalLong = ordinalLong < 0L ? 0L : ordinalLong;
                }
            }
        }
        if (!this.valueMap.containsKey(ordinalLong)) {
            throw new InvalidParameterException("An enumeration value with the given ordinal value of " + ordinal.toString() + " is not present in this enumeration.");
        }
        return new EnumerationValue(this, this.valueMap.get(ordinalLong));
    }

    @Override
    public String getElementName(int index) throws IndexOutOfBoundsException {
        try {
            return this.elementArray[index].name();
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The index into the array of elements of this enumeration type definition is outside the acceptable range.");
        }
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=2816, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ElementType", aliases={"EnumElementType"}, typeName="TypeDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=20, symbol="ElementType")
    public TypeDefinition getElementType() {
        return this.elementType.getTarget();
    }

    @MediaPropertySetter(value="ElementType")
    public void setElementType(TypeDefinition elementType) throws NullPointerException, IllegalArgumentException {
        if (elementType == null) {
            throw new NullPointerException("Cannot set the element type of this enumeration type definition with a null reference.");
        }
        if (!(elementType instanceof TypeDefinitionInteger)) {
            throw new IllegalArgumentException("Cannot set the element type this enumeration to a non integer type.");
        }
        this.elementType = new WeakReference<TypeDefinition>(elementType);
    }

    public static final TypeDefinition initializeElementType() {
        return TypeDefinitions.UInt8;
    }

    @MediaProperty(uuid1=50397699, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ElementNames", aliases={"EnumElementNames"}, typeName="UTF16StringArray", optional=false, uniqueIdentifier=false, pid=21, symbol="ElementNames")
    public String[] getElementNames() {
        String[] names = new String[this.elementArray.length];
        for (int x = 0; x < names.length; ++x) {
            names[x] = this.elementArray[x].symbol();
        }
        return names;
    }

    public static final String[] initializeElementNames() {
        return new String[0];
    }

    @MediaPropertyClear(value="ElementNames")
    public void clearElementNames() {
    }

    @MediaListAppend(value="ElementNames")
    public void appendElementName(String elementName) {
    }

    @MediaProperty(uuid1=50397699, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ElementValues", aliases={"EnumElementValues"}, typeName="Int64Array", optional=false, uniqueIdentifier=false, pid=22, symbol="ElementValues")
    public long[] getElementValues() {
        long[] values = new long[this.elementArray.length];
        for (int x = 0; x < values.length; ++x) {
            values[x] = this.elementArray[x].value();
        }
        return values;
    }

    public static final long[] initializeElementValues() {
        return new long[0];
    }

    @MediaPropertyClear(value="ElementValues")
    public void clearElementValues() {
    }

    @MediaListAppend(value="ElementValues")
    public void appendElementValue(long elementValue) {
    }

    @Override
    public long getElementValue(int index) throws IndexOutOfBoundsException {
        try {
            return this.elementArray[index].value();
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The index into the array of elements of this enumeration type definition is outside the acceptable range.");
        }
    }

    @Override
    public Class<Enum<?>> getEnumeration() {
        return this.elements;
    }

    @Override
    public long getIntegerValue(PropertyValue enumerationProperty) throws NullPointerException, IllegalPropertyValueException {
        if (enumerationProperty == null) {
            throw new NullPointerException("Cannot extract the integer value from a null enumeration property value.");
        }
        if (!this.equals(enumerationProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this enumeration type definition.");
        }
        return ((EnumerationValue)enumerationProperty).getValue().value();
    }

    @Override
    public String getNameFromInteger(long value) throws IllegalArgumentException {
        if (!this.valueMap.containsKey(value)) {
            throw new IllegalArgumentException("This enumeration type definition does not contain an element with the given value.");
        }
        return this.valueMap.get(value).name();
    }

    @Override
    public String getNameFromValue(PropertyValue enumerationProperty) throws NullPointerException, IllegalPropertyValueException {
        if (enumerationProperty == null) {
            throw new NullPointerException("Cannot extract the element name from a null enumeration property value.");
        }
        if (!this.equals(enumerationProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this enumeration type definition.");
        }
        return ((EnumerationValue)enumerationProperty).getValue().name();
    }

    public String getSymbolFromValue(PropertyValue enumerationProperty) throws NullPointerException, IllegalPropertyValueException {
        if (enumerationProperty == null) {
            throw new NullPointerException("Cannot extract the element symbol from a null enumeration property value.");
        }
        if (!this.equals(enumerationProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this enumeration type definition.");
        }
        return ((EnumerationValue)enumerationProperty).getValue().symbol();
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        MediaEnumerationValue enumerationValue;
        Enum<?>[] propertyValue;
        if (javaValue == null) {
            throw new ClassCastException("Cannot create a new enumeration property value from a null value.");
        }
        if (javaValue instanceof PropertyValue && (propertyValue = (Enum<?>[])javaValue).getType().equals(this)) {
            return new EnumerationValue(this, (MediaEnumerationValue)propertyValue.getValue());
        }
        if (javaValue instanceof MediaEnumerationValue) {
            for (Enum<?> constants : this.elements.getEnumConstants()) {
                if (!((Enum)javaValue).equals(constants)) continue;
                return new EnumerationValue(this, (MediaEnumerationValue)javaValue);
            }
        }
        try {
            if (javaValue instanceof String) {
                try {
                    javaValue = Long.parseLong((String)javaValue);
                }
                catch (NumberFormatException nfe) {
                    return this.createValueFromName((String)javaValue);
                }
            }
            if (javaValue instanceof Number) {
                return this.createValueFromOrdinal((Number)javaValue);
            }
            if (javaValue instanceof java.lang.Boolean) {
                return this.createValueFromName((java.lang.Boolean)javaValue != false ? "True" : "False");
            }
        }
        catch (NullPointerException e) {
            throw new ClassCastException("Cannot create a new enumeration property value from a null value.");
        }
        catch (InvalidParameterException e) {
            throw new ClassCastException("Cannot create a new enumeration property value due to an illegal parameter exception: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ClassCastException("Unexpetedly, this enumeration type definition does not equal this enumeration type definition!");
        }
        if (javaValue instanceof MediaEnumerationValue && this.nameMap.containsKey((enumerationValue = (MediaEnumerationValue)javaValue).name()) && this.valueMap.containsKey(enumerationValue.value())) {
            return new EnumerationValue(this, (MediaEnumerationValue)javaValue);
        }
        throw new ClassCastException("Cannot create a new enumeration property value from the given Java object.");
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.Enum;
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        super.createFromBytes(buffer);
        PropertyValue valueFromBuffer = this.elementType.getTarget().createFromBytes(buffer);
        return this.createValue(valueFromBuffer.getValue());
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        TypeDefinition elementTypeResolved = this.elementType.getTarget();
        PropertyValue elementValue = elementTypeResolved.createValue(((EnumerationValue)value).getValue().value());
        if (elementTypeResolved.lengthAsBytes(elementValue) > (long)buffer.remaining()) {
            throw new InsufficientSpaceException("Not enough space remaining in the given buffer to write an emumeration value with element type " + elementTypeResolved.getName() + ".");
        }
        elementTypeResolved.writeAsBytes(elementValue, buffer);
        return null;
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        TypeDefinition elementTypeResolved = this.elementType.getTarget();
        if (elementTypeResolved instanceof TypeDefinitionInteger) {
            return ((TypeDefinitionInteger)elementTypeResolved).getSize();
        }
        PropertyValue elementValue = elementTypeResolved.createValue(((EnumerationValue)value).getValue().value());
        return elementTypeResolved.lengthAsBytes(elementValue);
    }

    @Override
    public void setPropertyValue(MetadataObject metadataObject, PropertyDefinition property, PropertyValue value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        SingletonTypeDefinitionImpl.SingletonMethodBag methods = (SingletonTypeDefinitionImpl.SingletonMethodBag)((PropertyDefinitionImpl)property).getMethodBag();
        if (value.getValue() instanceof Boolean) {
            methods.set(metadataObject, (Boolean)value.getValue() == Boolean.True);
        } else {
            methods.set(metadataObject, value.getValue());
        }
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionEnumeration");
        super.appendMetadictXML(typeElement, namespace, prefix);
        XMLBuilder.appendElement((Node)typeElement, namespace, prefix, "ElementType", this.elementType.getTarget().getName());
        Element elements = XMLBuilder.createChild(typeElement, namespace, prefix, "Elements");
        for (MediaEnumerationValue enumValue : this.elementArray) {
            XMLBuilder.appendElement((Node)elements, namespace, prefix, "Name", enumValue.name());
            XMLBuilder.appendElement((Node)elements, namespace, prefix, "Value", enumValue.value());
        }
    }

    @Override
    public TypeDefinitionEnumeration clone() {
        return (TypeDefinitionEnumeration)super.clone();
    }

    public static class EnumerationValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionEnumerationImpl type;
        private MediaEnumerationValue value;

        private EnumerationValue(TypeDefinitionEnumerationImpl type, MediaEnumerationValue value) {
            this.type = type;
            this.setValue(value);
        }

        @Override
        public TypeDefinition getType() {
            return this.type;
        }

        @Override
        public MediaEnumerationValue getValue() {
            return this.value;
        }

        public boolean isDefinedType() {
            return true;
        }

        private void setValue(MediaEnumerationValue value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (o instanceof PropertyValue) {
                return this.getValue().equals(((PropertyValue)o).getValue());
            }
            return this.getValue().equals(o);
        }
    }
}

