/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import tv.amwa.maj.exception.BadRateException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.integer.UInt64;
import tv.amwa.maj.integer.UInt8;
import tv.amwa.maj.io.mxf.DeltaEntry;
import tv.amwa.maj.io.mxf.IndexEntry;
import tv.amwa.maj.io.mxf.IndexTable;
import tv.amwa.maj.io.mxf.IndexTableSegment;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.PrimerPack;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.UnitType;
import tv.amwa.maj.io.mxf.impl.DeltaEntryImpl;
import tv.amwa.maj.io.mxf.impl.ResolutionEntry;
import tv.amwa.maj.misctype.LengthType;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=218169857, uuid2=272, uuid3=256, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="IndexTableSegment", description="Index tables are represented as one or more index table segments.", namespace="http://www.smpte-ra.org/rp210", prefix="mxf", symbol="IndexTableSegment")
public class IndexTableSegmentImpl
implements MetadataObject,
IndexTableSegment,
Cloneable {
    private Rational indexEditRate;
    @PositionType
    private long indexStartPosition;
    @LengthType
    private long indexDuration;
    @UInt32
    private int editUnitByteCount = 0;
    @UInt32
    private int indexSID;
    @UInt32
    private int bodySID;
    @UInt8
    private byte sliceCount = 0;
    @UInt8
    private Byte posTableCount = null;
    private DeltaEntry[] deltaEntryArray = null;
    private IndexEntry[] indexEntryArray = null;
    @UInt64
    private Long extStartOffset = null;
    @UInt64
    private Long vbeByteCount = null;
    private static final PrimerPack indexPrimer = IndexTable.indexPrimer;
    private static final Map<AUIDImpl, MetadataObject> referenceTable = new HashMap<AUIDImpl, MetadataObject>();
    private static final List<ResolutionEntry> resolutions = new Vector<ResolutionEntry>();

    public IndexTableSegmentImpl() {
    }

    public IndexTableSegmentImpl(Rational indexEditRate, @PositionType long indexStartPosition, @LengthType long indexDuration, @UInt32 int indexSID, @UInt32 int bodySID) throws NullPointerException, BadRateException, IllegalArgumentException {
        this.setIndexEditRate(indexEditRate);
        this.setIndexStartPosition(indexStartPosition);
        this.setIndexDuration(indexDuration);
        this.setIndexSID(indexSID);
        this.setBodySID(bodySID);
    }

    @Override
    @MediaProperty(uuid1=87032838, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="Index Edit Rate", typeName="Rational", optional=false, uniqueIdentifier=false, pid=16139, symbol="IndexEditRate")
    public Rational getIndexEditRate() {
        return this.indexEditRate.clone();
    }

    @Override
    @MediaPropertySetter(value="Index Edit Rate")
    public void setIndexEditRate(Rational indexEditRate) throws NullPointerException, BadRateException {
        if (indexEditRate == null) {
            throw new NullPointerException("Cannot set the index edit rate using a null value.");
        }
        if (indexEditRate.getDenominator() == 0) {
            throw new BadRateException("The given edit rate has a zero demonminator that could cause divide by zero errors.");
        }
        this.indexEditRate = indexEditRate.clone();
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=266, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="Index Start Position", typeName="PositionType", optional=false, uniqueIdentifier=false, pid=16140, symbol="IndexStartPosition")
    @PositionType
    public long getIndexStartPosition() {
        return this.indexStartPosition;
    }

    @Override
    @MediaPropertySetter(value="Index Start Position")
    public void setIndexStartPosition(@PositionType long indexStartPosition) {
        this.indexStartPosition = indexStartPosition;
    }

    @Override
    @MediaProperty(uuid1=117572097, uuid2=258, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="Index Duration", typeName="LengthType", optional=false, uniqueIdentifier=false, pid=16141, symbol="IndexDuration")
    @LengthType
    public long getIndexDuration() {
        return this.indexDuration;
    }

    @Override
    @MediaPropertySetter(value="Index Duration")
    public void setIndexDuration(@LengthType long indexDuration) {
        this.indexDuration = indexDuration;
    }

    @Override
    @MediaProperty(uuid1=67502593, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="Edit Unit Byte Count", typeName="UInt32", optional=false, uniqueIdentifier=false, pid=16133, symbol="EditUnitByteCount")
    @UInt32
    public int getEditUnitByteCount() {
        return this.editUnitByteCount;
    }

    @Override
    @MediaPropertySetter(value="Edit Unit Byte Count")
    public void setEditUnitByteCount(@UInt32 int editUnitByteCount) throws IllegalArgumentException {
        if (editUnitByteCount < 0) {
            throw new IllegalArgumentException("The edit unit byte count cannot be a negative value.");
        }
        this.editUnitByteCount = editUnitByteCount;
    }

    @Override
    @MediaProperty(uuid1=16974853, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="IndexSID", aliases={"Index Stream ID", "IndexStreamID"}, typeName="UInt32", optional=false, uniqueIdentifier=false, pid=16134, symbol="IndexSID")
    @UInt32
    public int getIndexSID() {
        return this.indexSID;
    }

    @Override
    @MediaPropertySetter(value="IndexSID")
    public void setIndexSID(@UInt32 int indexSID) throws IllegalArgumentException {
        if (indexSID < 0) {
            throw new IllegalArgumentException("Cannot set the index stream ID to a negative value.");
        }
        this.indexSID = indexSID;
    }

    @Override
    @MediaProperty(uuid1=16974852, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="BodySID", aliases={"Essence Stream ID", "EssenceStreamID"}, typeName="UInt32", optional=false, uniqueIdentifier=false, pid=16135, symbol="BodySID")
    public int getBodySID() {
        return this.bodySID;
    }

    @Override
    @MediaPropertySetter(value="BodySID")
    public void setBodySID(@UInt32 int bodySID) throws IllegalArgumentException {
        if (bodySID < 0) {
            throw new IllegalArgumentException("Cannot set the body stream ID to a negative value.");
        }
        this.bodySID = bodySID;
    }

    @Override
    @MediaProperty(uuid1=0x4040401, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="Slice Count", typeName="UInt8", optional=false, uniqueIdentifier=false, pid=16136, symbol="SliceCount")
    @UInt8
    public byte getSliceCount() {
        return this.sliceCount;
    }

    @Override
    @MediaPropertySetter(value="Slice Count")
    public void setSliceCount(@UInt8 byte sliceCount) throws IllegalArgumentException {
        if (sliceCount < 0) {
            throw new IllegalArgumentException("Cannot set the slice count to a negative value.");
        }
        this.sliceCount = sliceCount;
    }

    @Override
    @MediaProperty(uuid1=0x4040401, uuid2=1792, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="PosTableCount", typeName="UInt8", optional=true, uniqueIdentifier=false, pid=16142, symbol="PosTableCount")
    @UInt8
    public byte getPosTableCount() throws PropertyNotPresentException {
        if (this.posTableCount == null) {
            throw new PropertyNotPresentException("The optional position table count property is not present for this index table segment.");
        }
        return this.posTableCount;
    }

    @Override
    @MediaPropertySetter(value="PosTableCount")
    public void setPosTableCount(@UInt8 Byte posTableCount) throws IllegalArgumentException {
        if (posTableCount == null) {
            this.posTableCount = null;
            return;
        }
        if (posTableCount < 0) {
            throw new IllegalArgumentException("Cannot set the position table count to a negative value.");
        }
        this.posTableCount = posTableCount;
    }

    @Override
    @MediaProperty(uuid1=0x4040401, uuid2=1536, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="Delta Entry Array", typeName="DeltaEntryArray", optional=true, uniqueIdentifier=false, pid=16137, symbol="DeltaEntryArray")
    public DeltaEntry[] getDeltaEntryArray() throws PropertyNotPresentException {
        if (this.deltaEntryArray == null || this.deltaEntryArray.length == 0) {
            throw new PropertyNotPresentException("The optional delta entry array property is not presnt for this index table segment.");
        }
        return (DeltaEntry[])this.deltaEntryArray.clone();
    }

    @Override
    @MediaPropertySetter(value="Delta Entry Array")
    public void setDeltaEntryArray(DeltaEntry[] deltaEntryArray) throws NullPointerException {
        if (deltaEntryArray == null) {
            this.deltaEntryArray = null;
            return;
        }
        DeltaEntry[] copiedArray = new DeltaEntry[deltaEntryArray.length];
        for (int x = 0; x < copiedArray.length; ++x) {
            if (deltaEntryArray[x] == null) {
                throw new NullPointerException("Element " + x + " of the given delta entry array is null.");
            }
            copiedArray[x] = deltaEntryArray[x].clone();
        }
        this.deltaEntryArray = copiedArray;
    }

    @Override
    public void setDeltaEntries(int[] elementDeltas) throws NullPointerException, IllegalArgumentException {
        DeltaEntry[] entries = DeltaEntryImpl.makeDeltaEntryArray(elementDeltas);
        this.setDeltaEntryArray(entries);
    }

    @Override
    @MediaProperty(uuid1=0x4040402, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="Index Entry Array", typeName="IndexEntryArray", optional=true, uniqueIdentifier=false, pid=16138, symbol="IndexEntryArray")
    public IndexEntry[] getIndexEntryArray() throws PropertyNotPresentException {
        if (this.indexEntryArray == null || this.indexEntryArray.length == 0) {
            throw new PropertyNotPresentException("The optional index entry array property is not present for this index table segment.");
        }
        return (IndexEntry[])this.indexEntryArray.clone();
    }

    @Override
    @MediaPropertySetter(value="Index Entry Array")
    public void setIndexEntryArray(IndexEntry[] indexEntryArray) throws NullPointerException {
        if (indexEntryArray == null) {
            this.indexEntryArray = null;
            return;
        }
        for (IndexEntry indexEntry : indexEntryArray) {
            try {
                indexEntry.resolveBytes(this);
            }
            catch (EndOfDataException ede) {
                System.err.println("Warning: Error resolving bytes for index table segment for index " + this.indexSID + ".");
            }
        }
        IndexEntry[] copiedArray = new IndexEntry[indexEntryArray.length];
        for (int x = 0; x < copiedArray.length; ++x) {
            if (indexEntryArray[x] == null) {
                throw new NullPointerException("Element " + x + " of the given delta entry array is null.");
            }
            copiedArray[x] = indexEntryArray[x].clone();
        }
        this.indexEntryArray = copiedArray;
    }

    @Override
    @MediaProperty(uuid1=67502596, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 10}, definedName="ExtStartOffset", typeName="UInt64", optional=true, uniqueIdentifier=false, pid=16143, symbol="ExtStartOffset")
    @UInt64
    public long getExtStartOffset() throws PropertyNotPresentException {
        if (this.extStartOffset == 0L) {
            throw new PropertyNotPresentException("The optional external start offset property is not present for this index table segment.");
        }
        return this.extStartOffset;
    }

    @Override
    @MediaPropertySetter(value="ExtStartOffset")
    public void setExtStartOffset(@UInt64 Long extStartOffset) throws IllegalArgumentException {
        if (extStartOffset == null) {
            this.extStartOffset = null;
            return;
        }
        if (extStartOffset < 0L) {
            throw new IllegalArgumentException("The external start offset property cannot be negative.");
        }
        this.extStartOffset = extStartOffset;
    }

    @Override
    @MediaProperty(uuid1=67502597, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 10}, definedName="VBEByteCount", typeName="UInt64", optional=true, uniqueIdentifier=false, pid=16144, symbol="VBEByteCount")
    @UInt64
    public long getVBEByteCount() throws PropertyNotPresentException {
        if (this.vbeByteCount == null) {
            throw new PropertyNotPresentException("The optional VBE byte count property is not present for this index table segment.");
        }
        return this.vbeByteCount;
    }

    @Override
    @MediaPropertySetter(value="VBEByteCount")
    public void setVBEByteCount(@UInt64 Long vbeByteCount) throws IllegalArgumentException {
        if (vbeByteCount == null) {
            this.vbeByteCount = null;
            return;
        }
        if (vbeByteCount < 0L) {
            throw new IllegalArgumentException("The optional VBE byte count property cannot be negative.");
        }
        this.vbeByteCount = vbeByteCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IndexTableSegment createFromBuffer(ByteBuffer buffer) throws NullPointerException, BufferUnderflowException {
        if (buffer == null) {
            throw new NullPointerException("Cannot create an index table from a null value.");
        }
        int preserveLimit = buffer.limit();
        IndexTableSegment nextSegment = null;
        MXFBuilder.skipKLVFill(buffer);
        UL key = MXFBuilder.readKey(buffer);
        long length = MXFBuilder.readBERLength(buffer);
        int limit = (int)((long)buffer.position() + length);
        if (!key.equals(IndexTableSegment.key)) {
            buffer.position(limit);
            buffer.limit(preserveLimit);
            return null;
        }
        buffer.limit(limit);
        try {
            nextSegment = (IndexTableSegment)MXFBuilder.readLocalSet(key, buffer, indexPrimer, referenceTable, resolutions);
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + " thrown when trying to read an index table segment: " + e.getMessage());
        }
        finally {
            buffer.limit(preserveLimit);
            buffer.position(limit);
        }
        MXFBuilder.skipKLVFill(buffer);
        referenceTable.clear();
        resolutions.clear();
        return nextSegment;
    }

    public int hashCode() {
        return MediaEngine.hashCode(this);
    }

    public String toString() {
        return MediaEngine.toString(this);
    }

    public boolean equals(Object o) {
        return MediaEngine.equals(this, o);
    }

    @Override
    public UnitType getUnitType() {
        return UnitType.IndexTableSegment;
    }

    @Override
    public IndexTableSegmentImpl clone() {
        try {
            return (IndexTableSegmentImpl)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }
}

