/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.industry;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.io.xml.XMLBuilder;

public class WeakReferenceVector<T extends WeakReferenceTarget> {
    private List<WeakReference<T>> vector = Collections.synchronizedList(new Vector());
    private long persistentID = 0L;

    public void append(T item) throws NullPointerException {
        if (item == null) {
            throw new NullPointerException("Cannot append to a list of weak references with a null value.");
        }
        WeakReference<T> weakReference = new WeakReference<T>(item);
        this.vector.add(weakReference);
        weakReference.setPersistentIndex(this.vector.size() - 1);
    }

    public void append(WeakReference<T> reference) throws NullPointerException {
        if (reference == null) {
            throw new NullPointerException("Cannot append to a list of weak references with a null value.");
        }
        this.vector.add(reference);
        reference.setPersistentIndex(this.vector.size() - 1);
    }

    public void prepend(T item) throws NullPointerException {
        if (item == null) {
            throw new NullPointerException("Cannot prepend to a list of weak references with a null value.");
        }
        WeakReference<T> weakReference = new WeakReference<T>(item);
        this.vector.add(0, weakReference);
        weakReference.setPersistentIndex(0);
        for (int u = 1; u < this.vector.size(); ++u) {
            this.vector.get(u).setPersistentIndex(u);
        }
    }

    public void insert(int index, T item) throws NullPointerException, IndexOutOfBoundsException {
        if (item == null) {
            throw new NullPointerException("Cannot insert to a list of weak references with a null value.");
        }
        try {
            WeakReference<T> weakReference = new WeakReference<T>(item);
            this.vector.add(index, weakReference);
            weakReference.setPersistentIndex(index);
            for (int u = index + 1; u < this.vector.size(); ++u) {
                this.vector.get(u).setPersistentIndex(u);
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new IndexOutOfBoundsException("The given index is out of bounds for the current list of weak object references.");
        }
    }

    public List<T> getRequiredList() {
        Vector<T> resolvedList = new Vector<T>(this.vector.size());
        for (WeakReference<T> referenceItem : this.vector) {
            resolvedList.add(referenceItem.getTarget());
        }
        return resolvedList;
    }

    public List<T> getOptionalList() throws PropertyNotPresentException {
        if (this.vector.size() == 0) {
            throw new PropertyNotPresentException("The optional weak reference list property is not present.");
        }
        return this.getRequiredList();
    }

    public boolean contains(T item) {
        for (WeakReference<T> referenceItem : this.vector) {
            if (!referenceItem.getTarget().equals(item.getAUID())) continue;
            return true;
        }
        return false;
    }

    public T getAt(int index) throws IndexOutOfBoundsException {
        try {
            return this.vector.get(index).getTarget();
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new IndexOutOfBoundsException("The given index is out of bounds for the current list of weak object references.");
        }
    }

    public void removeAt(int index) {
        try {
            this.vector.remove(index);
            for (int u = 0; u < this.vector.size(); ++u) {
                this.vector.get(u).setPersistentIndex(u);
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new IndexOutOfBoundsException("The given index is out of bounds for the current list of weak object references.");
        }
    }

    public boolean remove(T essenceKind) throws NullPointerException {
        if (essenceKind == null) {
            throw new NullPointerException("Cannot remove a null value from a list of weak references.");
        }
        for (WeakReference<T> weakReference : this.vector) {
            if (!weakReference.equals(essenceKind.getAUID())) continue;
            return this.vector.remove(weakReference);
        }
        return false;
    }

    public void clear() {
        this.vector.clear();
    }

    public int count() {
        return this.vector.size();
    }

    public long getPersistentID() {
        return this.persistentID;
    }

    public static final void generateWeakReferenceORM(Node parent, String namespace, String prefix) {
        Element entity = XMLBuilder.createChild(parent, namespace, prefix, "entity");
        XMLBuilder.setAttribute(entity, namespace, prefix, "class", WeakReferenceVector.class.getCanonicalName());
        XMLBuilder.setAttribute(entity, namespace, prefix, "access", "FIELD");
        Element attributes = XMLBuilder.createChild(entity, namespace, prefix, "attributes");
        Element persistentID = XMLBuilder.createChild(attributes, namespace, prefix, "id");
        XMLBuilder.setAttribute(persistentID, namespace, prefix, "name", "persistentID");
        XMLBuilder.createChild(persistentID, namespace, prefix, "generated-id");
        Element persistentIDColumn = XMLBuilder.createChild(persistentID, namespace, prefix, "column");
        XMLBuilder.setAttribute(persistentIDColumn, namespace, prefix, "name", "PersistentID");
        Element vector = XMLBuilder.createChild(attributes, namespace, prefix, "one-to-many");
        XMLBuilder.setAttribute(vector, namespace, prefix, "name", "vector");
        XMLBuilder.setAttribute(vector, namespace, prefix, "targetEntity", WeakReference.class.getCanonicalName());
        XMLBuilder.appendElement((Node)vector, namespace, prefix, "order-by", "persistentIndex ASC");
        XMLBuilder.createChild(vector, namespace, prefix, "cascade-all");
        Element vectorJoinColumn = XMLBuilder.createChild(vector, namespace, prefix, "join-column");
        XMLBuilder.setAttribute(vectorJoinColumn, namespace, prefix, "name", "WeakVectorID");
    }
}

