/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import tv.amwa.maj.constant.InterpolationConstant;
import tv.amwa.maj.constant.InterpolationDescription;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.InterpolationDefinition;
import tv.amwa.maj.model.impl.DefinitionObjectImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=8448, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="InterpolationDefinition", description="The InterpolationDefinition class specifies the mechanism used to calculate the values produced by a VaryingValue using the specified ControlPoints.", symbol="InterpolationDefinition")
public class InterpolationDefinitionImpl
extends DefinitionObjectImpl
implements InterpolationDefinition,
Serializable,
InterpolationConstant,
Cloneable {
    private static final long serialVersionUID = -959360620943627125L;
    private static final Map<String, InterpolationDefinition> definitionsByName = new HashMap<String, InterpolationDefinition>(20);
    private static final Map<AUID, InterpolationDefinition> definitionsById = new HashMap<AUID, InterpolationDefinition>(10);

    public static final int registerInterpolationsFromClass(Class<?> classWithInterpolations) throws NullPointerException {
        Field[] fields;
        if (classWithInterpolations == null) {
            throw new NullPointerException("Cannot register parameter definitions using a null class.");
        }
        int registered = 0;
        for (Field field : fields = classWithInterpolations.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) continue;
            try {
                Object value = field.get(null);
                if (!(value instanceof AUID) || !field.isAnnotationPresent(InterpolationDescription.class)) continue;
                InterpolationDescription interpolationMetadata = field.getAnnotation(InterpolationDescription.class);
                InterpolationDefinitionImpl definedInterpolation = new InterpolationDefinitionImpl((AUID)value, field.getName());
                if (interpolationMetadata.description().length() > 0) {
                    definedInterpolation.setDescription(interpolationMetadata.description());
                }
                InterpolationDefinitionImpl.registerInterpolationDefinition(definedInterpolation);
                for (String alias : interpolationMetadata.aliases()) {
                    definitionsByName.put(alias, definedInterpolation);
                }
                ++registered;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return registered;
    }

    public static final boolean registerInterpolationDefinition(InterpolationDefinition definedInterpolation) throws NullPointerException {
        if (definedInterpolation == null) {
            throw new NullPointerException("Cannot register a new interpolation definition using a null value.");
        }
        boolean alreadyContained = definitionsById.containsKey(definedInterpolation.getAUID());
        definitionsByName.put(definedInterpolation.getName(), definedInterpolation);
        definitionsByName.put("InterpolationDef_" + definedInterpolation.getName(), definedInterpolation);
        definitionsById.put(definedInterpolation.getAUID(), definedInterpolation);
        return alreadyContained;
    }

    public static final InterpolationDefinition forName(String interpolationName) throws NullPointerException {
        if (interpolationName == null) {
            throw new NullPointerException("Cannot retrieve an interpolation definition with a null name.");
        }
        return definitionsByName.get(interpolationName);
    }

    public static final InterpolationDefinition forIdentification(AUID identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot retrieve a parameter definition with a null identification.");
        }
        return definitionsById.get(identification);
    }

    public static final InterpolationDefinition forAUID(AUID identification) throws NullPointerException {
        return InterpolationDefinitionImpl.forIdentification(identification);
    }

    public static final Collection<String> inventory() {
        TreeSet<String> inventory = new TreeSet<String>();
        for (AUID definitionID : definitionsById.keySet()) {
            inventory.add(definitionsById.get(definitionID).getName());
        }
        return inventory;
    }

    public static final int count() {
        return definitionsById.size();
    }

    public InterpolationDefinitionImpl() {
    }

    public InterpolationDefinitionImpl(AUID identification, @AAFString String name) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create an interpolation definition with a null id.");
        }
        this.setAUID(identification);
        this.setName(name);
    }

    @Override
    public InterpolationDefinition clone() {
        return (InterpolationDefinition)super.clone();
    }

    @Override
    public String getLocalizedUID() {
        if (this.getName().startsWith("InterpolationDef_")) {
            return this.getName();
        }
        return "InterpolationDef_" + this.getName();
    }

    static {
        InterpolationDefinitionImpl.registerInterpolationsFromClass(InterpolationConstant.class);
    }
}

