/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.BadParameterException;
import tv.amwa.maj.exception.BadTypeException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionEnumeration;
import tv.amwa.maj.meta.TypeDefinitionExtendibleEnumeration;
import tv.amwa.maj.meta.TypeDefinitionFixedArray;
import tv.amwa.maj.meta.TypeDefinitionInteger;
import tv.amwa.maj.meta.TypeDefinitionRecord;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=520, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionFixedArray", description="The TypeDefinitionFixedArray class defines a property type that has a fixed number of values of the underlying type. The order of the values is meaningful.", symbol="TypeDefinitionFixedArray")
public final class TypeDefinitionFixedArrayImpl
extends SingletonTypeDefinitionImpl
implements TypeDefinitionFixedArray,
Serializable,
Cloneable {
    private static final long serialVersionUID = 2221149495149931508L;
    private int elementCount;
    private WeakReference<TypeDefinition> elementType;

    protected TypeDefinitionFixedArrayImpl() {
    }

    public TypeDefinitionFixedArrayImpl(AUID identification, @AAFString String typeName, TypeDefinition elementType, @UInt32 int numberElements) throws NullPointerException, IllegalArgumentException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new fixed array type definition using a null identification value.");
        }
        if (elementType == null) {
            throw new NullPointerException("Cannot create a new fixed array type definition using a null element type.");
        }
        if (numberElements < 0) {
            throw new IllegalArgumentException("Cannot create a new fixed array type definition with a negative number of elements.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.setElementType(elementType);
        this.setElementCount(numberElements);
    }

    @Override
    public PropertyValue createValueFromValues(PropertyValue[] elementValues) throws NullPointerException, BadParameterException, BadTypeException {
        if (elementValues == null) {
            throw new NullPointerException("Cannot create a new fixed size array property value from a null array of element values.");
        }
        if (elementValues.length != this.getCount()) {
            throw new BadParameterException("Cannot create a new fixed size array property value from an array of elements of a different length.");
        }
        for (PropertyValue value : elementValues) {
            if (this.elementType.getTarget().equals(value.getType())) continue;
            throw new BadTypeException("Cannot create a new fixed size array property value when at least one member of the given element values array is of a type that is not compatable with the element type of this type definition.");
        }
        Object[] values = new Object[this.elementCount];
        for (int u = 0; u < this.elementCount; ++u) {
            values[u] = elementValues[u].getValue();
        }
        return new FixedArrayValue(this, values);
    }

    @Override
    @MediaProperty(uuid1=50397699, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ElementCount", typeName="UInt32", optional=false, uniqueIdentifier=false, pid=24, symbol="ElementCount")
    public int getCount() {
        return this.elementCount;
    }

    @MediaPropertySetter(value="ElementCount")
    public void setElementCount(int elementCount) throws IllegalArgumentException {
        if (elementCount < 0) {
            throw new IllegalArgumentException("Cannot set the element count of a fixed array type definition to a negative value.");
        }
        this.elementCount = elementCount;
    }

    public static final int initializeElementCount() {
        return 2;
    }

    @Override
    public PropertyValue getElementValue(PropertyValue arrayProperty, int index) throws NullPointerException, IndexOutOfBoundsException, IllegalPropertyValueException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot retrieve an element from a null fixed size array property.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given fixed array property type does not match this fixed size array property.");
        }
        try {
            Object[] values = ((FixedArrayValue)arrayProperty).getValue();
            return this.elementType.getTarget().createValue(values[index]);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for this fixed sized array, which has a length of " + this.getCount() + ".");
        }
    }

    @Override
    public List<PropertyValue> getElements(PropertyValue arrayProperty) throws NullPointerException, IllegalPropertyValueException {
        Object[] values;
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot retrieve elements from a null fixed size array property.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given fixed array property type does not match this fixed size array property.");
        }
        Vector<PropertyValue> valueList = new Vector<PropertyValue>();
        for (Object value : values = ((FixedArrayValue)arrayProperty).getValue()) {
            valueList.add(this.elementType.getTarget().createValue(value));
        }
        return valueList;
    }

    @Override
    public Object[] getArray(PropertyValue arrayProperty) throws NullPointerException, IllegalPropertyValueException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot retrieve elements from a null fixed size array property.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given fixed array property type does not match this fixed size array property.");
        }
        Object[] values = ((FixedArrayValue)arrayProperty).getValue();
        return (Object[])values.clone();
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=3072, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FixedArrayElementType", aliases={"ElementType"}, typeName="TypeDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=23, symbol="FixedArrayElementType")
    public TypeDefinition getType() {
        return this.elementType.getTarget();
    }

    @MediaPropertySetter(value="FixedArrayElementType")
    public void setElementType(TypeDefinition elementType) throws NullPointerException, IllegalArgumentException {
        if (elementType == null) {
            throw new NullPointerException("Cannot set the element type of this fixed array type definition with a null element type.");
        }
        if (!(elementType instanceof TypeDefinitionInteger || elementType instanceof TypeDefinitionRecord || elementType instanceof TypeDefinitionEnumeration || elementType instanceof TypeDefinitionExtendibleEnumeration || elementType instanceof TypeDefinitionFixedArray)) {
            throw new IllegalArgumentException("The given element type is not acceptable for a fixed array type definition.");
        }
        this.elementType = new WeakReference<TypeDefinition>(elementType);
    }

    public static final TypeDefinition initializeFixedArrayElementType() {
        return TypeDefinitions.Int32;
    }

    @Override
    public void setElementValue(PropertyValue arrayProperty, int index, PropertyValue memberProperty) throws NullPointerException, IllegalPropertyValueException, IndexOutOfBoundsException, BadTypeException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot set an element in a null fixed size array property.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given fixed array property type does not match this fixed size array property.");
        }
        if (!this.elementType.getTarget().equals(memberProperty.getType())) {
            throw new BadTypeException("The given property to set in the fixed sized array is not of a compatable type for the element typee of this fixed array type definition.");
        }
        try {
            Object[] values = ((FixedArrayValue)arrayProperty).getValue();
            values[index] = memberProperty.getValue();
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for a fixed size array of " + this.getCount() + " elements.");
        }
    }

    @Override
    public void setArray(PropertyValue arrayProperty, Object[] data) throws NullPointerException, IllegalPropertyValueException, BadParameterException, BadTypeException, ClassCastException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot set the value of a null fixed size array property value.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property to set in the fixed sized array is not of a compatable type for the element typee of this fixed array type definition.");
        }
        if (data == null) {
            throw new NullPointerException("Cannot set the value of a fixed size array value from a null object array.");
        }
        if (data.length != this.getCount()) {
            throw new BadParameterException("Cannot set the value of a fixed size array value from an array of objects of a different length to that of this fixed size array definition.");
        }
        try {
            for (int x = 0; x < this.elementCount; ++x) {
                this.elementType.getTarget().createValue(data[x]);
            }
            ((FixedArrayValue)arrayProperty).setValue((Object[])data.clone());
        }
        catch (ClassCastException cce) {
            throw new BadTypeException("Class cast exception thrown when trying to set array elements on a fixed size array property value: " + cce.getMessage());
        }
    }

    @Override
    public PropertyValue createValueFromArray(Object[] initData) throws NullPointerException, BadParameterException, BadTypeException {
        if (initData == null) {
            throw new NullPointerException("Cannot create a new fixed size array value from a null object array.");
        }
        if (initData.length != this.getCount()) {
            throw new BadParameterException("Cannot create a new fixed size array value from an array of objects of a different length to that of this fixed size array definition.");
        }
        try {
            for (int x = 0; x < initData.length; ++x) {
                this.elementType.getTarget().createValue(initData[x]);
            }
            return new FixedArrayValue(this, (Object[])initData.clone());
        }
        catch (ClassCastException cce) {
            throw new BadTypeException("Class cast exception thrown when trying to add values to a new fixed size array property value: " + cce.getMessage());
        }
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.FixedArray;
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        Object[] values;
        if (javaValue == null) {
            throw new ClassCastException("Cannot cast a null value to a fixed size array property value.");
        }
        if (javaValue instanceof Collection) {
            javaValue = ((Collection)javaValue).toArray();
        }
        if (javaValue.getClass().isArray()) {
            Object[] javaArray = javaValue;
            if (javaArray.length != this.getCount()) {
                throw new ClassCastException("Cannot cast the given value to a fixed size array property as the given array has " + javaArray.length + " elements and exactly " + this.getCount() + " are required.");
            }
            values = new Object[javaArray.length];
            for (int x = 0; x < values.length; ++x) {
                Object value;
                if (javaArray[x] instanceof PropertyValue) {
                    if (!((PropertyValue)javaArray[x]).getType().equals(this.elementType.getTarget())) {
                        throw new ClassCastException("Cannot cast a property value element of the given Java array at index " + x + " to a new fixed array as its type does not match the element type of this fixed size array.");
                    }
                    value = ((PropertyValue)javaArray[x]).getValue();
                } else {
                    this.elementType.getTarget().createValue(javaArray[x]);
                    value = javaArray[x];
                }
                values[x] = value;
            }
        } else if (this.getCount() == 1) {
            if (javaValue instanceof PropertyValue) {
                PropertyValue propertyValue = (PropertyValue)javaValue;
                if (!propertyValue.getType().equals(this.elementType.getTarget())) {
                    throw new ClassCastException("Cannot cast the given property value to a value of this fixed size array type as its type does not match the element type of this fixed size array type definition.");
                }
                values = new Object[]{propertyValue.getValue()};
            } else {
                this.elementType.getTarget().createValue(javaValue);
                values = new Object[]{javaValue};
            }
        } else {
            throw new ClassCastException("Cannot cast the given value to a fixed size array property value as the fixed array must have " + this.elementCount + " elements.");
        }
        return new FixedArrayValue(this, values);
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        super.createFromBytes(buffer);
        PropertyValue[] values = new PropertyValue[this.elementCount];
        for (int u = 0; u < this.elementCount; ++u) {
            values[u] = this.elementType.getTarget().createFromBytes(buffer);
        }
        return this.createValue(values);
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        TypeDefinition elementTypeResolved = this.elementType.getTarget();
        if (elementTypeResolved.lengthAsBytes(this.getElementValue(value, 0)) * (long)this.elementCount > (long)buffer.remaining()) {
            throw new InsufficientSpaceException("Insuficient space in the given buffer to write a value of " + this.getName() + " type.");
        }
        for (int u = 0; u < this.elementCount; ++u) {
            elementTypeResolved.writeAsBytes(this.getElementValue(value, u), buffer);
        }
        return null;
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        long elementLength = this.elementType.getTarget().lengthAsBytes(this.getElementValue(value, 0));
        return (long)this.elementCount * elementLength;
    }

    @Override
    public String nameToAAFName(String name) {
        return "aaf" + super.nameToAAFName(name);
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionFixedArray");
        super.appendMetadictXML(typeElement, namespace, prefix);
        XMLBuilder.appendElement((Node)typeElement, namespace, prefix, "ElementCount", this.elementCount);
        XMLBuilder.appendElement((Node)typeElement, namespace, prefix, "ElementType", this.elementType.getTarget().getName());
    }

    @Override
    public TypeDefinitionFixedArray clone() {
        return (TypeDefinitionFixedArray)super.clone();
    }

    public static class FixedArrayValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionFixedArrayImpl type;
        private Object[] value;

        private FixedArrayValue(TypeDefinitionFixedArrayImpl type, Object[] value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public TypeDefinition getType() {
            return this.type;
        }

        public Object[] getValue() {
            return this.value;
        }

        public boolean isDefinedType() {
            return true;
        }

        private void setValue(Object[] value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyValue)) {
                return false;
            }
            PropertyValue testValue = (PropertyValue)o;
            if (!this.type.equals(testValue.getType())) {
                return false;
            }
            if (this.value == null && testValue.getValue() == null) {
                return true;
            }
            return Arrays.equals(this.value, ((FixedArrayValue)testValue).getValue());
        }

        @Override
        public int hashCode() {
            if (this.value == null) {
                return this.type.hashCode();
            }
            return this.type.hashCode() ^ Arrays.hashCode(this.value);
        }
    }
}

