/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.xml;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.util.List;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import tv.amwa.maj.exception.BadParameterException;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.io.xml.MasterContentHandler;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionFixedArray;
import tv.amwa.maj.meta.TypeDefinitionObjectReference;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionStrongObjectReference;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.meta.TypeDefinitionWeakObjectReference;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.util.Utilities;

public class MetadataObjectHandler
extends MasterContentHandler
implements ContentHandler {
    private StringBuffer characterBuffer = new StringBuffer(65536);
    private ClassDefinition definingClass = null;
    private PropertyDefinition scanningValue = null;
    private MetadataObject resultInstance;
    private String recordEndTag = null;
    private MasterContentHandler childHandler = null;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.scanningValue != null) {
            this.characterBuffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.recordEndTag != null) {
            if (!localName.equals(this.recordEndTag)) {
                this.characterBuffer.append("</" + localName + ">\n");
                return;
            }
            this.recordEndTag = null;
        }
        if (uri.equals(this.getNamespace()) && localName.equals(this.getElementName())) {
            if (this.definingClass != null && this.resultInstance == null) {
                this.resultInstance = this.definingClass.createInstance();
            }
            if (this.resultInstance instanceof WeakReferenceTarget) {
                WeakReference.registerTarget((WeakReferenceTarget)((Object)this.resultInstance));
            }
            this.setResult(this.resultInstance);
            this.getXMLReader().setContentHandler(this.getParentHandler());
            return;
        }
        if (this.definingClass == null || this.scanningValue == null) {
            this.characterBuffer.setLength(0);
            this.scanningValue = null;
            return;
        }
        if (this.resultInstance == null) {
            this.resultInstance = this.definingClass.createInstance();
        }
        TypeDefinition propertyType = this.scanningValue.getTypeDefinition();
        try {
            switch (propertyType.getTypeCategory()) {
                case StrongObjRef: {
                    TypeDefinitionStrongObjectReference strongType = (TypeDefinitionStrongObjectReference)propertyType;
                    PropertyValue propertyValue = strongType.createValue(this.childHandler.getResult());
                    this.scanningValue.setPropertyValue(this.resultInstance, propertyValue);
                    break;
                }
                case WeakObjRef: {
                    if (uri.equals("http://www.smpte-ra.org/schemas/2001-2/2007/aaf") && localName.equals("ObjectClass")) break;
                    TypeDefinitionWeakObjectReference weakType = (TypeDefinitionWeakObjectReference)propertyType;
                    Class<?> targetImplementation = weakType.getObjectType().getJavaImplementation();
                    String weakReference = this.characterBuffer.toString().trim();
                    MetadataObject target = null;
                    if (weakReference.startsWith("urn:")) {
                        if (ClassDefinition.class.isAssignableFrom(targetImplementation)) {
                            target = Warehouse.lookForClass(Forge.parseAUID(weakReference));
                        } else if (TypeDefinition.class.isAssignableFrom(targetImplementation)) {
                            target = Warehouse.lookForType(Forge.parseAUID(weakReference));
                        } else {
                            Method referenceResolver = targetImplementation.getMethod("forIdentification", AUID.class);
                            target = (MetadataObject)referenceResolver.invoke(null, AUIDImpl.parseFactory(weakReference));
                        }
                    } else if (ClassDefinition.class.isAssignableFrom(targetImplementation)) {
                        target = Warehouse.lookForClass(weakReference);
                    } else if (TypeDefinition.class.isAssignableFrom(targetImplementation)) {
                        target = Warehouse.lookForType(weakReference);
                    } else {
                        Method referenceResolver = targetImplementation.getMethod("forName", String.class);
                        target = (MetadataObject)referenceResolver.invoke(null, weakReference);
                    }
                    PropertyValue propertyValue = weakType.createValue(target);
                    this.scanningValue.setPropertyValue(this.resultInstance, propertyValue);
                    break;
                }
                case Indirect: {
                    String typeName = this.getAttributeValueThisElement("aaf:actualType");
                    TypeDefinition indirectType = Warehouse.lookForType(typeName);
                    PropertyValue indirectValue = indirectType.createValue(this.characterBuffer.toString());
                    PropertyValue propertyValue = propertyType.createValue(indirectValue);
                    this.scanningValue.setPropertyValue(this.resultInstance, propertyValue);
                    break;
                }
                case Opaque: {
                    try {
                        AUID opaqueTypeID = Forge.parseAUID(this.getAttributeValueThisElement("aaf:actualType"));
                        byte[] valueBytes = Utilities.hexStringToBytes(this.characterBuffer.toString());
                        ByteBuffer opaqueBuffer = ByteBuffer.allocate(16 + valueBytes.length);
                        if (this.getAttributeValueThisElement("aaf:byteOrder").equals("BigEndian")) {
                            opaqueBuffer.order(ByteOrder.BIG_ENDIAN);
                        } else {
                            opaqueBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        if (opaqueTypeID.isUniversalLabel()) {
                            opaqueBuffer.put(opaqueTypeID.getAUIDValue(), 8, 8);
                            opaqueBuffer.put(opaqueTypeID.getAUIDValue(), 0, 8);
                        } else {
                            opaqueBuffer.put(opaqueTypeID.getAUIDValue());
                        }
                        opaqueBuffer.put(valueBytes);
                        opaqueBuffer.rewind();
                        PropertyValue propertyValue = propertyType.createValue(opaqueBuffer);
                        this.scanningValue.setPropertyValue(this.resultInstance, propertyValue);
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case FixedArray: 
                case VariableArray: 
                case Set: {
                    PropertyValue propertyValue = TypeDefinitions.DataValue.equals(propertyType) ? propertyType.createValue(this.characterBuffer.toString()) : propertyType.createValue(this.childHandler.getResult());
                    this.scanningValue.setPropertyValue(this.resultInstance, propertyValue);
                    break;
                }
                default: {
                    PropertyValue propertyValue = this.scanningValue.getName().equals("ByteOrder") ? (this.characterBuffer.toString().equals("BigEndian") ? TypeDefinitions.UInt16.createValue(tv.amwa.maj.enumeration.ByteOrder.Big.getAAFByteOrderCode()) : TypeDefinitions.UInt16.createValue(tv.amwa.maj.enumeration.ByteOrder.Little.getAAFByteOrderCode())) : propertyType.createValue(this.characterBuffer.toString());
                    this.scanningValue.setPropertyValue(this.resultInstance, propertyValue);
                }
            }
        }
        catch (Exception e) {
            System.err.println("When parsing XML, unable to set the value of property " + this.definingClass.getName() + "." + this.scanningValue.getName() + " because of a " + e.getClass().getName() + ": " + e.getMessage());
        }
        this.scanningValue = null;
        this.characterBuffer.setLength(0);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.definingClass == null) {
            return;
        }
        this.setAttributes(atts);
        if (this.recordEndTag != null) {
            this.characterBuffer.append("<" + localName + ">");
            return;
        }
        try {
            this.scanningValue = this.definingClass.lookupPropertyDefinition("{" + uri + "}" + localName);
        }
        catch (BadParameterException bpe) {
            this.scanningValue = null;
        }
        try {
            if (this.scanningValue == null) {
                this.scanningValue = this.definingClass.lookupPropertyDefinition(localName);
            }
        }
        catch (BadParameterException bpe) {
            System.err.println("Unable to resolve property " + this.definingClass.getName() + "." + localName + ".");
            return;
        }
        this.characterBuffer.setLength(0);
        switch (this.scanningValue.getTypeDefinition().getTypeCategory()) {
            case StrongObjRef: {
                this.childHandler = new ReferenceHandler(this, uri, localName, atts);
                this.getXMLReader().setContentHandler(this.childHandler);
                break;
            }
            case WeakObjRef: {
                break;
            }
            case Set: {
                TypeDefinition setElementType = ((TypeDefinitionSet)this.scanningValue.getTypeDefinition()).getElementType();
                this.childHandler = setElementType instanceof TypeDefinitionObjectReference ? new ReferenceListHandler(this, uri, localName, atts) : new ArrayListHandler(this, uri, localName, atts, setElementType);
                this.getXMLReader().setContentHandler(this.childHandler);
                break;
            }
            case FixedArray: {
                TypeDefinition fixedElementType = ((TypeDefinitionFixedArray)this.scanningValue.getTypeDefinition()).getType();
                this.childHandler = new ArrayListHandler(this, uri, localName, atts, fixedElementType);
                this.getXMLReader().setContentHandler(this.childHandler);
                break;
            }
            case VariableArray: {
                if (TypeDefinitions.DataValue.equals(this.scanningValue.getTypeDefinition())) break;
                TypeDefinition arrayElementType = ((TypeDefinitionVariableArray)this.scanningValue.getTypeDefinition()).getType();
                this.childHandler = arrayElementType instanceof TypeDefinitionObjectReference ? new ReferenceListHandler(this, uri, localName, atts) : new ArrayListHandler(this, uri, localName, atts, arrayElementType);
                this.getXMLReader().setContentHandler(this.childHandler);
                break;
            }
            case Record: {
                this.recordEndTag = localName;
                break;
            }
        }
    }

    @Override
    void setElementName(String namespace, String elementName) {
        super.setElementName(namespace, elementName);
        try {
            String fullElementName = this.getFullElementName();
            if (fullElementName.endsWith("WeakReference")) {
                fullElementName = fullElementName.substring(0, fullElementName.length() - 13);
            }
            this.definingClass = Warehouse.lookForClass(fullElementName);
            if (this.definingClass != null) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.definingClass = Warehouse.lookForClass(elementName);
            if (this.definingClass != null) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        System.err.println("Unable to resolve XML reference to " + elementName + ".");
    }

    class ArrayListHandler
    extends MasterContentHandler
    implements ContentHandler {
        List<PropertyValue> list = new Vector<PropertyValue>();
        String endTag = null;
        TypeDefinition arrayElementType;

        public ArrayListHandler(MasterContentHandler parentHandler, String namespace, String elementName, Attributes attributes, TypeDefinition arrayElementType) {
            this.setParentHandler(parentHandler);
            this.setElementName(namespace, elementName);
            this.setAttributes(attributes);
            this.arrayElementType = arrayElementType;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.endTag != null) {
                MetadataObjectHandler.this.characterBuffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (localName.equals(this.getElementName())) {
                this.getXMLReader().setContentHandler(this.getParentHandler());
                this.setResult(this.list);
                this.getParentHandler().endElement(uri, localName, name);
                return;
            }
            if (this.endTag != null && localName.equals(this.endTag)) {
                try {
                    PropertyValue propertyValue = this.arrayElementType.createValue(MetadataObjectHandler.this.characterBuffer.toString());
                    this.list.add(propertyValue);
                    MetadataObjectHandler.this.characterBuffer.setLength(0);
                    this.endTag = null;
                }
                catch (Exception e) {
                    System.err.println("Unable to create an array element of type " + this.arrayElementType.getName() + " for property " + MetadataObjectHandler.this.definingClass.getName() + "." + MetadataObjectHandler.this.scanningValue.getName() + " because of a " + e.getClass().getName() + ": " + e.getMessage());
                }
                return;
            }
            MetadataObjectHandler.this.characterBuffer.append("</" + name + ">");
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            if (this.endTag == null) {
                this.endTag = localName;
                MetadataObjectHandler.this.characterBuffer.setLength(0);
            } else {
                MetadataObjectHandler.this.characterBuffer.append("<" + name + ">");
            }
        }
    }

    class ReferenceListHandler
    extends MasterContentHandler
    implements ContentHandler {
        List<MetadataObject> list = new Vector<MetadataObject>();
        MetadataObjectHandler currentHandler = null;

        public ReferenceListHandler(MasterContentHandler parentHandler, String namespace, String elementName, Attributes attributes) {
            this.setParentHandler(parentHandler);
            this.setElementName(namespace, elementName);
            this.setAttributes(attributes);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.currentHandler != null) {
                this.list.add((MetadataObject)this.currentHandler.getResult());
            }
            this.getXMLReader().setContentHandler(this.getParentHandler());
            this.setResult(this.list);
            this.getParentHandler().endElement(uri, localName, name);
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            if (this.currentHandler != null) {
                this.list.add((MetadataObject)this.currentHandler.getResult());
            }
            this.currentHandler = new MetadataObjectHandler();
            this.currentHandler.setElementName(uri, localName);
            this.currentHandler.setParentHandler(this);
            this.currentHandler.setAttributes(atts);
            this.getXMLReader().setContentHandler(this.currentHandler);
        }
    }

    class ReferenceHandler
    extends MasterContentHandler
    implements ContentHandler {
        MetadataObject mdObject = null;
        MetadataObjectHandler currentHandler = null;

        public ReferenceHandler(MasterContentHandler parentHandler, String namespace, String elementName, Attributes attributes) {
            this.setParentHandler(parentHandler);
            this.setElementName(namespace, elementName);
            this.setAttributes(attributes);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.getXMLReader().setContentHandler(this.getParentHandler());
            this.setResult(this.currentHandler.getResult());
            this.getParentHandler().endElement(uri, localName, name);
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            this.currentHandler = new MetadataObjectHandler();
            this.currentHandler.setElementName(uri, localName);
            this.currentHandler.setParentHandler(this);
            this.currentHandler.setAttributes(atts);
            this.getXMLReader().setContentHandler(this.currentHandler);
        }
    }
}

