/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RP224ToJava {
    static final String ofInterest = ",([^,]*|\"[^\"]*\")";
    static final String notOfInterest = ",([^,]*|\"[^\"]*\")";
    static final Pattern leafPattern = Pattern.compile("Leaf,([^,]*|\"[^\"]*\"),([^,]*|\"[^\"]*\"),([^,]*|\"[^\"]*\"),([^,]*|\"[^\"]*\"),([^,]*|\"[^\"]*\"),([^,]*|\"[^\"]*\"),([^,]*|\"[^\"]*\"),");
    static final Pattern idPattern = Pattern.compile("([0-9a-fA-F]{2})\\.([0-9a-fA-F]{2})\\.([0-9a-fA-F]{2})\\.([0-9a-fA-F]{2})\\.([0-9a-fA-F]{2})\\.([0-9a-fA-F]{2})\\.([0-9a-fA-F]{2})\\.([0-9a-fA-F]{2})");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("RP224 spreadsheet expected as input.");
            System.exit(1);
        }
        BufferedReader reader = null;
        try {
            File rp224File = new File(args[0]);
            rp224File = rp224File.getAbsoluteFile();
            if (!rp224File.exists()) {
                throw new IOException("The given rp224 file does not exist.");
            }
            if (!rp224File.canRead()) {
                throw new IOException("The given rp224 file cannot be read.");
            }
            if (!rp224File.isFile()) {
                throw new IOException("The given rp224 file is not a regular file.");
            }
            reader = new BufferedReader(new FileReader(rp224File));
            System.out.println("package tv.amwa.maj.constant;\n");
            System.out.println("import tv.amwa.maj.record.AUID;");
            System.out.println("import tv.amwa.maj.industry.Forge;\n");
            System.out.println("public interface RP224 {\n");
            String currentLine = reader.readLine();
            while (currentLine != null) {
                Matcher matcher = leafPattern.matcher(currentLine);
                if (matcher.matches() && matcher.group(3).length() != 0) {
                    System.out.println("    /**");
                    System.out.println("     * <p>" + matcher.group(4) + ".</p>");
                    System.out.println("     */");
                    System.out.println("    public final static AUID " + RP224ToJava.toJavaName(matcher.group(4)) + " = Forge.makeAUID(");
                    Matcher id1Matcher = idPattern.matcher(matcher.group(1));
                    id1Matcher.matches();
                    Matcher id2Matcher = idPattern.matcher(matcher.group(2));
                    id2Matcher.matches();
                    System.out.println("            0x" + id2Matcher.group(1) + id2Matcher.group(2) + id2Matcher.group(3) + id2Matcher.group(4) + ", (short) 0x" + id2Matcher.group(5) + id2Matcher.group(6) + ", (short) 0x" + id2Matcher.group(7) + id2Matcher.group(8) + ",");
                    System.out.print("            new byte[] { ");
                    for (int x = 1; x < 8; ++x) {
                        System.out.print("0x" + id1Matcher.group(x) + ", ");
                    }
                    System.out.println("0x" + id1Matcher.group(8) + " } );\n");
                }
                currentLine = reader.readLine();
            }
            System.out.println("}\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final String toJavaName(String smpteName) {
        String javaName = smpteName.replace("  ", "_");
        javaName = javaName.replace("-", "");
        javaName = javaName.replace(".", "");
        javaName = javaName.replace("@", "at");
        javaName = javaName.replace('/', '_');
        javaName = javaName.replace(' ', '_');
        return javaName;
    }
}

