/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.exception.BadParameterException;
import tv.amwa.maj.exception.IllegalPropertyException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.io.aaf.AAFConstants;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.impl.MetaDefinitionImpl;
import tv.amwa.maj.meta.impl.MethodBag;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionSetImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionVariableArrayImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.misctype.Bool;
import tv.amwa.maj.model.ApplicationPluginObject;
import tv.amwa.maj.model.InterchangeObject;
import tv.amwa.maj.model.impl.ApplicationPluginObjectImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.util.Utilities;

@MediaClass(uuid1=0xD010101, uuid2=514, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="PropertyDefinition", description="The PropertyDefinition class describes properties allowed for a class.", symbol="PropertyDefinition")
public class PropertyDefinitionImpl
extends MetaDefinitionImpl
implements PropertyDefinition,
Serializable,
XMLSerializable,
CommonConstants,
Comparable<PropertyDefinition> {
    private static final long serialVersionUID = -784815624516057438L;
    private TypeDefinition propertyType = null;
    private transient String typeName;
    private boolean isOptional;
    private short localIdentification = 0;
    private Boolean isUniqueIdentifier = null;
    private WeakReference<ClassDefinition> memberOf;
    private MethodBag methodBag = null;
    private Method getter = null;
    private boolean isXMLCDATA = false;
    private boolean isXMLAttribute = false;
    private boolean flattenXML = false;
    private int weight = 0;
    private static Map<String, String> propertyNameMap = null;

    public static final void initalizePropertyNameMap() {
        int propertyMapSize = AAFConstants.propertyNameAliases.length / 2;
        propertyNameMap = Collections.synchronizedMap(new HashMap(propertyMapSize));
        for (int x = 0; x < propertyMapSize; ++x) {
            propertyNameMap.put(AAFConstants.propertyNameAliases[x * 2], AAFConstants.propertyNameAliases[x * 2 + 1]);
        }
    }

    protected PropertyDefinitionImpl() {
    }

    public PropertyDefinitionImpl(AUID identification, @AAFString String name, String type, ClassDefinition memberOf, @Bool boolean isOptional) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new property definition using a null identification.");
        }
        if (type == null) {
            throw new NullPointerException("Cannot create a new property definition using a null type definition.");
        }
        this.setIdentification(identification);
        this.setName(name);
        this.setSymbol(name);
        this.typeName = type;
        this.setIsOptional(isOptional);
        this.setMemberOf(memberOf);
    }

    @Override
    @MediaProperty(uuid1=50397698, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="IsOptional", aliases={"Optional"}, typeName="Boolean", optional=false, uniqueIdentifier=false, pid=12, symbol="IsOptional")
    public boolean getIsOptional() {
        return this.isOptional;
    }

    @MediaPropertySetter(value="IsOptional")
    public void setIsOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public static final boolean initializeIsOptional() {
        return true;
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=1536, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="IsUniqueIdentifier", aliases={"UniqueIdentifier", "IsUnique", "Unique"}, typeName="Boolean", optional=true, uniqueIdentifier=false, pid=14, symbol="IsUniqueIdentifier")
    public boolean getIsUniqueIdentifier() throws PropertyNotPresentException {
        if (this.isUniqueIdentifier == null) {
            throw new PropertyNotPresentException("The optional is unique identifier property is not present for this property definition.");
        }
        return this.isUniqueIdentifier;
    }

    @MediaPropertySetter(value="IsUniqueIdentifier")
    public void setIsUniqueIdentifier(Boolean isUniqueIdentifier) {
        this.isUniqueIdentifier = isUniqueIdentifier;
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PropertyType", aliases={"Type", "PropertyDefinitionType"}, typeName="AUID", optional=false, uniqueIdentifier=false, pid=11, symbol="PropertyType")
    public AUID getPropertyType() {
        return this.getTypeDefinition().getAUID();
    }

    @MediaPropertySetter(value="PropertyType")
    public void setPropertyType(AUID propertyType) throws NullPointerException {
        if (propertyType == null) {
            throw new NullPointerException("Cannot set the type of this property with a null value.");
        }
        this.propertyType = Warehouse.lookForType(propertyType);
        if (this.propertyType != null) {
            this.typeName = this.propertyType.getName();
        }
    }

    public static final AUID initializePropertyType() {
        return TypeDefinitions.UTF16String.getAUID();
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        if (this.propertyType == null) {
            this.propertyType = Warehouse.lookForType(this.typeName);
        }
        return this.propertyType;
    }

    public void setTypeDefinition(TypeDefinition type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("Cannot set the type definition of this class definition with a null value.");
        }
        this.propertyType = type;
        this.typeName = type.getName();
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="LocalIdentification", typeName="UInt16", optional=false, uniqueIdentifier=false, pid=13, symbol="LocalIdentification")
    public short getLocalIdentification() {
        return this.localIdentification;
    }

    @MediaPropertySetter(value="LocalIdentification")
    public void setLocalIdentification(Short localIdentification) {
        this.localIdentification = localIdentification == null ? (short)0 : localIdentification;
    }

    public static final short initializeLocalIdentification() {
        return 0;
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=8704, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 13}, definedName="MemberOf", typeName="ClassDefinitionWeakReference", optional=true, uniqueIdentifier=false, pid=43, symbol="MemberOf", description="Specifies the class in which this property may be present.")
    public ClassDefinition getMemberOf() throws PropertyNotPresentException {
        if (this.memberOf == null) {
            throw new PropertyNotPresentException("The optional member of a class property is not present in this property definition: " + this.getName() + ".");
        }
        return this.memberOf.getTarget();
    }

    @Override
    @MediaPropertySetter(value="MemberOf")
    public void setMemberOf(ClassDefinition memberOf) {
        this.memberOf = memberOf == null ? null : new WeakReference<ClassDefinition>(memberOf);
    }

    @Override
    public void setPropertyValue(MetadataObject metadataObject, PropertyValue propertyValue) throws IllegalArgumentException {
        try {
            if (this.memberOf == null) {
                this.getTypeDefinition().setPropertyValue(metadataObject, this, propertyValue);
            } else {
                try {
                    this.memberOf.getTarget().lookupPropertyDefinition(this.getAUID());
                    this.getTypeDefinition().setPropertyValue(metadataObject, this, propertyValue);
                }
                catch (BadParameterException bpe) {
                    if (!(metadataObject instanceof InterchangeObject)) {
                        throw new IllegalArgumentException("Cannot set an extension property value on a non interchange object.");
                    }
                    InterchangeObject interchangeable = (InterchangeObject)metadataObject;
                    ApplicationPluginObject plugin = null;
                    if (interchangeable.countApplicationPlugins() > 0) {
                        for (ApplicationPluginObject pluginItem : interchangeable.getApplicationPlugins()) {
                            if (!pluginItem.getApplicationScheme().getSchemeURI().equals(this.getNamespace())) continue;
                            plugin = pluginItem;
                            break;
                        }
                    }
                    if (plugin == null) {
                        plugin = new ApplicationPluginObjectImpl();
                        plugin.setApplicationPluginInstanceID(Forge.randomAUID());
                        plugin.setApplicationScheme(Warehouse.lookupExtensionScheme(this.getNamespace()));
                        interchangeable.addApplicationPlugin(plugin);
                    }
                    plugin.putExtensionProperty(this.getAUID(), propertyValue);
                }
            }
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            if (this.memberOf != null) {
                throw new IllegalArgumentException("Unable to set the value of property " + this.getMemberOf().getName() + "." + this.getName() + " due to a local " + target.getClass().getName() + ": " + target.getMessage());
            }
            throw new IllegalArgumentException("Unable to set the value of a property named " + this.getName() + " with unknown membership due to a local " + target.getClass().getName() + ": " + target.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.memberOf != null) {
                throw new IllegalArgumentException("Unable to set the value of property " + this.getMemberOf().getName() + "." + this.getName() + " becuase of a " + e.getClass().getName() + ": " + e.getMessage());
            }
            throw new IllegalArgumentException("Unable to set the value of a property named " + this.getName() + " with unknown membership due to a " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public PropertyValue getPropertyValue(MetadataObject metadataObject) throws NullPointerException, IllegalPropertyException, IllegalArgumentException, PropertyNotPresentException {
        try {
            return this.getTypeDefinition().getPropertyValue(metadataObject, this);
        }
        catch (Exception e) {
            if (e.getCause() instanceof PropertyNotPresentException) {
                throw (PropertyNotPresentException)e.getCause();
            }
            IllegalArgumentException iae = new IllegalArgumentException("Unable to get the value of property " + this.getMemberOf().getName() + "." + this.getName() + " becuase of a " + e.getClass().getName() + ": " + (e.getCause() != null ? e.getCause().getMessage() : ""));
            if (e instanceof InvocationTargetException) {
                iae.initCause(e.getCause());
            }
            throw iae;
        }
    }

    public MethodBag getMethodBag() {
        if (this.memberOf == null) {
            System.err.println("*-*-*: " + this.getName());
        }
        if (this.methodBag == null) {
            this.methodBag = TypeDefinitionImpl.makeMethodBagForType(this.getTypeDefinition(), this.getter, this.getMemberOf().getJavaImplementation().getDeclaredMethods(), this.getName());
        }
        return this.methodBag;
    }

    public void setAnnotatedGetter(Method getter) {
        this.getter = getter;
    }

    @Override
    public boolean isPropertyPresent(MetadataObject metadataObject) throws NullPointerException, IllegalPropertyException {
        if (metadataObject == null) {
            throw new NullPointerException("Cannot check if a property is present on a null object.");
        }
        ClassDefinition metaClass = Warehouse.lookForClass(metadataObject.getClass());
        try {
            metaClass.lookupPropertyDefinition(this.getAUID());
        }
        catch (BadParameterException bpe) {
            throw new IllegalPropertyException("Property " + this.getName() + " is not defined for class + " + metaClass.getName() + " so its presence cannot be tested for.");
        }
        if (!this.isOptional) {
            return true;
        }
        try {
            this.getter.invoke((Object)metadataObject, new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw new IllegalPropertyException("The given metadata object does not contain this property.");
            }
            return false;
        }
        return true;
    }

    @Override
    public void omitOptionalProperty(MetadataObject metadataObject) throws NullPointerException, IllegalPropertyException, IllegalArgumentException {
        if (metadataObject == null) {
            throw new NullPointerException("Cannot omit an optional property for a null object.");
        }
        ClassDefinition metaClass = Warehouse.lookForClass(metadataObject.getClass());
        try {
            metaClass.lookupPropertyDefinition(this.getAUID());
        }
        catch (BadParameterException bpe) {
            throw new IllegalPropertyException("Property " + this.getName() + " is not a member of " + metaClass.getName() + " and so cannot be omitted.");
        }
        if (!this.isOptional) {
            throw new IllegalPropertyException("Property " + this.getName() + " is not optional in the context of " + metaClass.getName() + " and so cannot be omitted.");
        }
        try {
            switch (this.getTypeDefinition().getTypeCategory()) {
                case Set: {
                    TypeDefinitionSetImpl.SetMethodBag setMethods = (TypeDefinitionSetImpl.SetMethodBag)this.getMethodBag();
                    setMethods.clear(metadataObject);
                    break;
                }
                case VariableArray: {
                    TypeDefinitionVariableArrayImpl.VariableArrayMethodBag arrayMethods = (TypeDefinitionVariableArrayImpl.VariableArrayMethodBag)this.getMethodBag();
                    arrayMethods.clear(metadataObject);
                    break;
                }
                default: {
                    SingletonTypeDefinitionImpl.SingletonMethodBag singletonMethods = (SingletonTypeDefinitionImpl.SingletonMethodBag)this.getMethodBag();
                    singletonMethods.set(metadataObject, null);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to omit optional property " + metaClass.getName() + "." + this.getName() + " due to an " + e.getCause().getClass().getName() + ": " + e.getCause().getMessage(), e);
        }
    }

    @Override
    public void appendXMLChildren(Node parent) {
        XMLBuilder.appendComment(parent, "Symbol is " + this.symbol);
    }

    @Override
    public String getNamespace() {
        if (this.namespace == null) {
            return this.memberOf.getTarget().getNamespace();
        }
        return this.namespace;
    }

    @Override
    public String getPrefix() {
        if (this.prefix == null) {
            return this.memberOf.getTarget().getPrefix();
        }
        return this.prefix;
    }

    void setIsXMLCDATA(boolean isXMLCDATA) {
        this.isXMLCDATA = isXMLCDATA;
    }

    @Override
    public boolean getIsXMLCDATA() {
        return this.isXMLCDATA;
    }

    void setIsXMLAttribute(boolean isXMLAttribute) {
        this.isXMLAttribute = isXMLAttribute;
    }

    @Override
    public boolean getIsXMLAttribute() {
        return this.isXMLAttribute;
    }

    void setFlattenXML(boolean flattenXML) {
        this.flattenXML = flattenXML;
    }

    @Override
    public boolean getFlattenXML() {
        return this.flattenXML;
    }

    @Override
    public int compareTo(PropertyDefinition o) {
        if (this.weight < o.getWeight()) {
            return -1;
        }
        if (this.weight > o.getWeight()) {
            return 1;
        }
        return this.getAUID().compareTo(o.getAUID());
    }

    void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public String nameToAAFName(String name) {
        if (this.getAUID().equals(AAFConstants.IdentificationGenerationIDProperty)) {
            return "GenerationAUID";
        }
        if (propertyNameMap != null) {
            String mappedName = propertyNameMap.get(name);
            return mappedName != null ? mappedName : name;
        }
        return name;
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element propertyElement = XMLBuilder.createChild(metadict, namespace, prefix, "PropertyDefinition");
        super.appendMetadictXML(propertyElement, namespace, prefix);
        XMLBuilder.appendElement((Node)propertyElement, namespace, prefix, "MemberOf", this.memberOf.getTarget().getName());
        XMLBuilder.appendElement((Node)propertyElement, namespace, prefix, "Type", this.typeName);
        if (this.getTypeDefinition() == null) {
            XMLBuilder.appendComment(propertyElement, "Warning: Unable to resolve type at runtime.");
            System.err.println("Unable to resolve type name " + this.typeName + " for property " + this.getMemberOf().getName() + "." + this.getName() + ".");
        }
        XMLBuilder.appendElement((Node)propertyElement, namespace, prefix, "IsOptional", this.isOptional);
        StringBuilder pidBuilder = new StringBuilder(6);
        pidBuilder.append(Utilities.bytesToHexChars(new byte[]{(byte)(this.localIdentification >>> 8 & 0xFF), (byte)(this.localIdentification & 0xFF)}));
        while (pidBuilder.length() < 4) {
            pidBuilder.insert(0, ' ');
        }
        pidBuilder.insert(0, "0x");
        XMLBuilder.appendElement((Node)propertyElement, namespace, prefix, "LocalIdentification", pidBuilder.toString());
    }

    @Override
    public PropertyDefinition clone() {
        return (PropertyDefinition)super.clone();
    }
}

