/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.ProductReleaseType;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.Identification;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.ProductVersion;
import tv.amwa.maj.record.TimeStamp;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.record.impl.ProductVersionImpl;
import tv.amwa.maj.record.impl.TimeStampImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=12288, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Identification", description="The Identification class provides information about the application that created or modified the file.", symbol="Identification")
public class IdentificationImpl
extends InterchangeObjectImpl
implements Identification,
Serializable,
Cloneable {
    public static final String APICompanyName = "portability 4 media";
    public static final String APIProductName = "MAJ API";
    public static final ProductVersion APIProductVersion = new ProductVersionImpl(0, 0, 1, 0, ProductReleaseType.PrivateBuild);
    public static final String APIProductVersionString = "0.0.1 development";
    public static final AUID APIProductID = AUIDImpl.parseFactory("urn:uuid:2234694c-39f5-11dc-8314-0800200c9a66");
    public static final ProductVersion APIToolkitVersion = new ProductVersionImpl(1, 1, 4, 0, ProductReleaseType.Beta);
    private static final long serialVersionUID = 7333971490704276839L;
    private String applicationSupplierName;
    private String applicationName;
    private ProductVersion applicationVersion = null;
    private String applicationVersionString;
    private AUID applicationProductID;
    private TimeStamp fileModificationDate;
    private ProductVersion toolkitVersion = null;
    private String applicationPlatform = null;
    private AUID generationID;

    public IdentificationImpl() {
    }

    public IdentificationImpl(@AAFString String companyName, @AAFString String productName, @AAFString String productVersionString, AUID productID) throws NullPointerException {
        if (companyName == null) {
            throw new NullPointerException("Cannot create an identification with a null company name.");
        }
        if (productName == null) {
            throw new NullPointerException("Cannot create an identification with a null application name.");
        }
        if (productVersionString == null) {
            throw new NullPointerException("Cannot create an identification with a null application version string.");
        }
        if (productID == null) {
            throw new NullPointerException("Cannot create an identification with a null application identifier (AUID).");
        }
        this.applicationSupplierName = companyName;
        this.applicationName = productName;
        this.applicationVersionString = productVersionString;
        this.applicationProductID = productID.clone();
        this.fileModificationDate = new TimeStampImpl();
        this.generationID = AUIDImpl.timebasedAUID();
        this.applicationPlatform = "MAJ API (Java " + System.getProperty("java.version") + ")";
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=513, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ApplicationSupplierName", aliases={"CompanyName"}, typeName="UTF16String", optional=false, uniqueIdentifier=false, pid=15361, symbol="ApplicationSupplierName")
    public String getApplicationSupplierName() {
        return this.applicationSupplierName;
    }

    @MediaPropertySetter(value="ApplicationSupplierName")
    public void setApplicationSupplierName(String applicationSupplierName) throws NullPointerException {
        if (applicationSupplierName == null) {
            throw new NullPointerException("Cannot set the company name of this identification to a null value.");
        }
        this.applicationSupplierName = applicationSupplierName;
    }

    public static final String initializeApplicationSupplierName() {
        return "DefaultApplicationSupplierName";
    }

    @Override
    @MediaProperty(uuid1=117571856, uuid2=515, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FileModificationDate", aliases={"Date", "ModificationDate"}, typeName="TimeStamp", optional=false, uniqueIdentifier=false, pid=15366, symbol="FileModificationDate")
    public TimeStamp getFileModificationDate() {
        return this.fileModificationDate.clone();
    }

    @MediaPropertySetter(value="FileModificationDate")
    public void setFileModificationDate(TimeStamp fileModificationDate) throws NullPointerException {
        if (fileModificationDate == null) {
            throw new NullPointerException("Cannot set the date of this identification to null.");
        }
        this.fileModificationDate = fileModificationDate.clone();
    }

    public static final TimeStamp initializeFileModificationDate() {
        return new TimeStampImpl();
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="GenerationID", aliases={"GenerationAUID"}, typeName="AUID", optional=false, uniqueIdentifier=false, pid=15369, symbol="GenerationID")
    public AUID getGenerationID() {
        return this.generationID.clone();
    }

    @MediaPropertySetter(value="GenerationID")
    public void setGenerationID(AUID generationID) throws NullPointerException {
        if (generationID == null) {
            throw new NullPointerException("Cannot set the generatuin AUID of this identification to null.");
        }
        this.generationID = generationID.clone();
    }

    public static final AUID initializeGenerationID() {
        return AUIDImpl.randomAUID();
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=1537, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ApplicationPlatform", aliases={"Platform", "IdentificationPlatform"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=15368, symbol="ApplicationPlatform")
    public String getApplicationPlatform() throws PropertyNotPresentException {
        if (this.applicationPlatform == null) {
            throw new PropertyNotPresentException("The optional application platform property is not present for this identification.");
        }
        return this.applicationPlatform;
    }

    @MediaPropertySetter(value="ApplicationPlatform")
    public void setApplicationPlatform(String applicationPlatform) {
        this.applicationPlatform = applicationPlatform;
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=1792, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ApplicationProductID", aliases={"ProductID"}, typeName="AUID", optional=false, uniqueIdentifier=false, pid=15365, symbol="ApplicationProductID")
    public AUID getApplicationProductID() {
        return this.applicationProductID.clone();
    }

    @MediaPropertySetter(value="ApplicationProductID")
    public void setApplicationProductID(AUID applicationProductID) throws NullPointerException {
        if (applicationProductID == null) {
            throw new NullPointerException("Cannot set the application product ID of this identification to null.");
        }
        this.applicationProductID = applicationProductID.clone();
    }

    public static final AUID initializeApplicationProductID() {
        return AUIDImpl.randomAUID();
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=769, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ApplicationName", aliases={"ProductName"}, typeName="UTF16String", optional=false, uniqueIdentifier=false, pid=15362, symbol="ApplicationName")
    public String getApplicationName() {
        return this.applicationName;
    }

    @MediaPropertySetter(value="ApplicationName")
    public void setApplicationName(String applicationName) throws NullPointerException {
        if (applicationName == null) {
            throw new NullPointerException("Cannot set the application name of this identification to null.");
        }
        this.applicationName = applicationName;
    }

    public static final String initializeApplicationName() {
        return "DefaultApplicationName";
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ApplicationVersion", aliases={"ProductVersion"}, typeName="ProductVersionType", optional=true, uniqueIdentifier=false, pid=15363, symbol="ApplicationVersion")
    public ProductVersion getApplicationVersion() throws PropertyNotPresentException {
        if (this.applicationVersion == null) {
            throw new PropertyNotPresentException("The optional application version property is not present in this indentification.");
        }
        return this.applicationVersion.clone();
    }

    @Override
    @MediaPropertySetter(value="ApplicationVersion")
    public void setApplicationVersion(ProductVersion applicationVersion) {
        this.applicationVersion = applicationVersion == null ? null : applicationVersion.clone();
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=1281, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ApplicationVersionString", aliases={"ProductVersionString"}, typeName="UTF16String", optional=false, uniqueIdentifier=false, pid=15364, symbol="ApplicationVersionString")
    public String getApplicationVersionString() {
        return this.applicationVersionString;
    }

    @MediaPropertySetter(value="ApplicationVersionString")
    public void setApplicationVersionString(String applicationVersionString) throws NullPointerException {
        if (applicationVersionString == null) {
            throw new NullPointerException("Cannot set the application version string of this identification to null.");
        }
        this.applicationVersionString = applicationVersionString;
    }

    public static final String initializeApplicationVersionString() {
        return "DefaultVersionString";
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=2560, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ToolkitVersion", typeName="ProductVersionType", optional=true, uniqueIdentifier=false, pid=15367, symbol="ToolkitVersion")
    public ProductVersion getToolkitVersion() throws PropertyNotPresentException {
        if (this.toolkitVersion == null) {
            throw new PropertyNotPresentException("The toolkit version is not present in this identificiation.");
        }
        return this.toolkitVersion.clone();
    }

    @MediaPropertySetter(value="ToolkitVersion")
    public void setToolkitVersion(ProductVersion toolkitVersion) {
        if (toolkitVersion == null) {
            this.toolkitVersion = null;
            return;
        }
        this.toolkitVersion = toolkitVersion.clone();
    }

    @Override
    public ProductVersion getRefImplVersion() throws PropertyNotPresentException {
        return this.getToolkitVersion();
    }

    @Override
    public Identification getGeneration() {
        return this;
    }

    @Override
    public Identification clone() {
        return (Identification)super.clone();
    }

    public String getApplicationVersionPersist() {
        return ProductVersionImpl.toPersistentForm(this.applicationVersion);
    }

    public void setApplicationVersionPersist(String applicationVersion) {
        this.applicationVersion = ProductVersionImpl.fromPersistentForm(applicationVersion);
    }

    public String getApplicationProductIDString() {
        return AUIDImpl.toPersistentForm(this.applicationProductID);
    }

    public void setApplicationProductIDString(String applicationProductID) {
        this.applicationProductID = AUIDImpl.fromPersistentForm(applicationProductID);
    }

    public String getFileModificationDateString() {
        return TimeStampImpl.toPersistentForm(this.fileModificationDate);
    }

    public void setFileModificationDateString(String fileModificationDate) {
        this.fileModificationDate = TimeStampImpl.fromPersistentForm(fileModificationDate);
    }

    public String getToolkitVersionString() {
        return ProductVersionImpl.toPersistentForm(this.toolkitVersion);
    }

    public void setToolkitVersionString(String toolkitVersion) {
        this.toolkitVersion = ProductVersionImpl.fromPersistentForm(toolkitVersion);
    }

    public String getGenerationIDString() {
        return AUIDImpl.toPersistentForm(this.generationID);
    }

    public void setGenerationIDString(String generationID) {
        this.generationID = AUIDImpl.fromPersistentForm(generationID);
    }
}

