/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.model.Component;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.DescriptiveClip;
import tv.amwa.maj.model.Event;
import tv.amwa.maj.model.EventTrack;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.Sequence;
import tv.amwa.maj.model.impl.CommentMarkerImpl;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.EventImpl;
import tv.amwa.maj.model.impl.SequenceImpl;
import tv.amwa.maj.model.impl.TrackImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.RationalImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=14592, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="EventTrack", aliases={"EventMobSlot"}, description="The EventTrack class has a Sequence of Events.", symbol="EventTrack")
public class EventTrackImpl
extends TrackImpl
implements EventTrack,
Serializable,
Cloneable {
    private Rational eventTrackEditRate;
    @PositionType
    private Long eventTrackOrigin = null;
    private static final long serialVersionUID = -2413811904896253033L;

    public EventTrackImpl() {
    }

    public EventTrackImpl(@UInt32 int trackId, Segment segment, Rational editRate) throws NullPointerException, IllegalArgumentException {
        if (segment == null) {
            throw new NullPointerException("Cannot create a new event track with a null value.");
        }
        if (editRate == null) {
            throw new NullPointerException("Cannot create a new event track with a null edit rate value.");
        }
        this.setTrackID(trackId);
        this.setTrackSegment(segment);
        this.setEventTrackEditRate(editRate);
    }

    @Override
    @MediaProperty(uuid1=87032834, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="EventTrackEditRate", aliases={"EditRate", "EventMobSlotEditRate", "EditTrackEditRate"}, typeName="Rational", optional=false, uniqueIdentifier=false, pid=18689, symbol="EventTrackEditRate")
    public Rational getEventTrackEditRate() {
        return this.eventTrackEditRate.clone();
    }

    @Override
    @MediaPropertySetter(value="EventTrackEditRate")
    public void setEventTrackEditRate(Rational eventTrackEditRate) throws NullPointerException {
        if (eventTrackEditRate == null) {
            throw new NullPointerException("Cannot set the edit rate for this event track with a null value.");
        }
        this.eventTrackEditRate = eventTrackEditRate.clone();
    }

    public static final Rational initializeEventTrackEditRate() {
        return new RationalImpl(1, 1);
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=267, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="EventTrackOrigin", aliases={"EventSlotOrigin"}, typeName="PositionType", optional=true, uniqueIdentifier=false, pid=18690, symbol="EventTrackOrigin")
    public long getEventTrackOrigin() throws PropertyNotPresentException {
        if (this.eventTrackOrigin == null) {
            throw new PropertyNotPresentException("The optional event track origin property is not present in this event track.");
        }
        return this.eventTrackOrigin;
    }

    @Override
    @MediaPropertySetter(value="EventTrackOrigin")
    public void setEventTrackOrigin(Long eventTrackOrigin) {
        this.eventTrackOrigin = eventTrackOrigin;
    }

    @Override
    public void setTrackSegment(Segment segment) throws NullPointerException, IllegalArgumentException {
        if (segment == null) {
            throw new NullPointerException("Cannot set the segment for this package using a null value.");
        }
        if (!(segment instanceof Sequence || segment instanceof Event || segment instanceof DescriptiveClip)) {
            throw new IllegalArgumentException("The segment for an event track must be either a sequence, an event segment or a descriptive clip.");
        }
        if (segment instanceof Event || segment instanceof DescriptiveClip) {
            super.setTrackSegment(segment);
            return;
        }
        Sequence sequence = (Sequence)segment;
        int numberOfComponents = sequence.countComponentObjects();
        if (numberOfComponents <= 0) {
            throw new IllegalArgumentException("An event track sequence must contain at least one element.");
        }
        DataDefinition sequenceDataDefinition = sequence.getComponentDataDefinition();
        Component firstComponent = sequence.getComponentObjectAt(0);
        if (!firstComponent.getComponentDataDefinition().doesDataDefConvertTo(sequenceDataDefinition)) {
            throw new IllegalArgumentException("Components of a sequence in an event track must have the same data kind as that of the sequence itself and the first component does not.");
        }
        if (!(firstComponent instanceof EventImpl)) {
            throw new IllegalArgumentException("Components of a sequence in an event track must be events and the first component is not.");
        }
        Event firstEvent = (Event)firstComponent;
        try {
            long previousPosition = firstEvent.getEventPosition();
            for (int x = 1; x < numberOfComponents; ++x) {
                Component componentItem = sequence.getComponentObjectAt(x);
                if (!componentItem.getComponentDataDefinition().doesDataDefConvertTo(sequenceDataDefinition)) {
                    throw new IllegalArgumentException("Components of a sequence in an event track must have the same data kind as that of the sequence itself and the component at index " + x + " does not.");
                }
                if (!(componentItem instanceof Event)) {
                    throw new IllegalArgumentException("Components of a sequence in an event track must have be events and the component at index " + x + " is not.");
                }
                Event eventItem = (Event)componentItem;
                if (!firstEvent.getClass().isInstance(eventItem)) {
                    throw new IllegalArgumentException("Components of a sequence in an event track must all be for the same kind of event and the element at index " + x + " does not match the first event of the sequence.");
                }
                long currentPosition = eventItem.getEventPosition();
                if (currentPosition < previousPosition) {
                    throw new IllegalArgumentException("Components of a sequence in an event track must be in increasing position order and the component at index " + x + " has an earlier position than its previous component.");
                }
                previousPosition = currentPosition;
            }
        }
        catch (BadPropertyException bpe) {
            throw new IllegalArgumentException("Unexpected bad property exception thrown when checking the validity of a sequence for an event track.");
        }
        super.setTrackSegment(sequence);
    }

    @Override
    public Segment initializeTrackSegment() {
        CommentMarkerImpl marker = new CommentMarkerImpl(DataDefinitionImpl.forName("Unknown"));
        SequenceImpl sequence = new SequenceImpl(marker.getComponentDataDefinition());
        try {
            sequence.appendComponentObject(marker);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sequence;
    }

    @Override
    public EventTrack clone() {
        return (EventTrack)super.clone();
    }

    public String getEventTrackEditRateString() {
        return RationalImpl.toPersistentForm(this.eventTrackEditRate);
    }

    public void setEventTrackEditRateString(String eventTrackEditRate) {
        this.eventTrackEditRate = RationalImpl.fromPersistentForm(eventTrackEditRate);
    }
}

