/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.misctype.DataValue;
import tv.amwa.maj.misctype.LengthType;
import tv.amwa.maj.model.AIFCDescriptor;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.impl.AAFFileDescriptorImpl;
import tv.amwa.maj.record.Rational;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=9728, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="AIFCDescriptor", description="The AIFCDescriptor class specifies that a File SourcePackage is associated with audio essence formatted according to the Audio Interchange File Format with Compression (AIFC).", symbol="AIFCDescriptor")
public class AIFCDescriptorImpl
extends AAFFileDescriptorImpl
implements AIFCDescriptor,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = -2028438976071340542L;
    private byte[] aifcSummary = null;

    public AIFCDescriptorImpl() {
    }

    public AIFCDescriptorImpl(ContainerDefinition containerFormat, Rational sampleRate, @LengthType long length, @DataValue byte[] summary) throws NullPointerException, BadLengthException {
        if (sampleRate == null) {
            throw new NullPointerException("Cannot create a new AIFC file descriptor using a null sample rate value.");
        }
        if (summary == null) {
            throw new NullPointerException("Cannot create a new AIFC file descriptor using a null summary value.");
        }
        this.setContainerFormat(containerFormat);
        this.setDescribesTimeVaryingEssence(sampleRate, length);
        this.setAIFCSummary(summary);
    }

    @Override
    @MediaProperty(uuid1=0x3030302, uuid2=512, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="AIFCSummary", aliases={"Summary", "AIFCDescriptorSummary"}, typeName="DataValue", optional=false, uniqueIdentifier=false, pid=12545, symbol="AIFCSummary")
    public byte[] getAIFCSummary() {
        return (byte[])this.aifcSummary.clone();
    }

    @Override
    public int getSummaryBufferSize() {
        return this.aifcSummary.length;
    }

    @Override
    @MediaPropertySetter(value="AIFCSummary")
    public void setAIFCSummary(byte[] aifcSummary) throws NullPointerException {
        if (aifcSummary == null) {
            throw new NullPointerException("Cannot set the summary of an AIFC file descriptor using a null value.");
        }
        this.aifcSummary = (byte[])aifcSummary.clone();
    }

    public static final byte[] initializeAIFCSummary() {
        return new byte[0];
    }

    @Override
    public AIFCDescriptor clone() {
        return (AIFCDescriptor)super.clone();
    }
}

