/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.union.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.model.Component;
import tv.amwa.maj.model.FindSourceInformation;
import tv.amwa.maj.model.OperationGroup;
import tv.amwa.maj.model.Package;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.PackageIDImpl;
import tv.amwa.maj.union.impl.SourceReferenceValueImpl;

public class FindSourceInformationImpl
implements FindSourceInformation,
Serializable,
Cloneable {
    private static final long serialVersionUID = 280671475967906329L;
    private Package mob = null;
    private Component component = null;
    private Rational editRate = null;
    private Integer trackID;
    private Long position = 0L;
    private Long length = 0L;
    private OperationGroup operationGroup = null;

    private FindSourceInformationImpl() {
    }

    public FindSourceInformationImpl(Package mob, Integer trackID, Long position, Rational editRate, Long length, Component component) {
        this.mob = mob;
        this.trackID = trackID;
        this.position = position;
        this.editRate = editRate;
        this.length = length;
        this.component = component;
    }

    @Override
    public Rational getEditRate() {
        return this.editRate;
    }

    @Override
    public long getLength() throws BadPropertyException {
        if (this.length == null) {
            throw new BadPropertyException("A length property is not present in this find source information value.");
        }
        return this.length;
    }

    @Override
    public Package getPackage() {
        return this.mob;
    }

    @Override
    public SourceReferenceValueImpl getSourceReference() {
        SourceReferenceValueImpl sourceReference = new SourceReferenceValueImpl(PackageIDImpl.getZeroPackageID(), 0, 0L);
        if (this.mob != null) {
            sourceReference.setSourcePackageID(this.mob.getPackageID());
            sourceReference.setSourceTrackID(this.trackID);
            sourceReference.setStartPosition(this.position);
        }
        return sourceReference;
    }
}

