/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.exception.BadParameterException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.integer.Int64;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.integer.UInt64;
import tv.amwa.maj.io.mxf.BodyPartition;
import tv.amwa.maj.io.mxf.FooterPartition;
import tv.amwa.maj.io.mxf.HeaderPartition;
import tv.amwa.maj.io.mxf.KLVObject;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.MXFFile;
import tv.amwa.maj.io.mxf.MXFLength;
import tv.amwa.maj.io.mxf.MXFPosition;
import tv.amwa.maj.io.mxf.Partition;
import tv.amwa.maj.io.mxf.PartitionPack;
import tv.amwa.maj.io.mxf.PrimerPack;
import tv.amwa.maj.io.mxf.RandomIndexItem;
import tv.amwa.maj.io.mxf.RandomIndexPack;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.impl.BodyClosedCompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.BodyClosedIncompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.BodyOpenCompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.BodyOpenIncompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.BodyPartitionImpl;
import tv.amwa.maj.io.mxf.impl.FooterClosedCompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.FooterClosedIncompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.FooterPartitionImpl;
import tv.amwa.maj.io.mxf.impl.HeaderClosedCompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.HeaderClosedIncompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.HeaderOpenCompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.HeaderOpenIncompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.HeaderPartitionImpl;
import tv.amwa.maj.io.mxf.impl.Helper;
import tv.amwa.maj.io.mxf.impl.LocalTagEntryImpl;
import tv.amwa.maj.io.mxf.impl.PartitionImpl;
import tv.amwa.maj.io.mxf.impl.PartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.Primer;
import tv.amwa.maj.io.mxf.impl.PrimerPackImpl;
import tv.amwa.maj.io.mxf.impl.RandomIndexPackImpl;
import tv.amwa.maj.io.mxf.impl.ResolutionEntry;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.impl.ClassDefinitionImpl;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.model.impl.PrefaceImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

public class MXFFileImpl
implements MXFFile,
Cloneable {
    static final int ALLOCATION_SIZE = 65536;
    private boolean isOpen = false;
    private boolean isMemoryFile = false;
    private File fileHandle;
    private FileChannel fileChannel;
    @UInt32
    private int runInSize = 0;
    private FileLock lock = null;
    private ByteBuffer buffer;
    @UInt64
    private long bufferCurrentPosition;
    @UInt64
    private long bufferOffset = 0L;
    @UInt32
    private int blockAlign;
    @UInt32
    private int blockAlignEssenceOffset;
    @Int32
    private int blockAlignIndexOffset;
    private RandomIndexPack fileRIP;
    private ByteBuffer runIn;
    private List<Partition> partitions = Collections.synchronizedList(new ArrayList());
    private MessageDigest digest = null;

    @Override
    @UInt32
    public int getRunInSize() {
        return this.runInSize;
    }

    @Override
    public boolean hasRunIn() {
        return this.runInSize > 0;
    }

    @Override
    public boolean open(String fileName, boolean readOnly) throws IOException {
        if (this.isOpen) {
            this.close();
        }
        this.isMemoryFile = false;
        this.fileHandle = new File(fileName);
        this.fileHandle = this.fileHandle.getAbsoluteFile();
        if (!this.fileHandle.exists()) {
            System.err.println("File " + this.fileHandle.toString() + " does not exist!");
        }
        try {
            this.fileChannel = new RandomAccessFile(this.fileHandle, readOnly ? "r" : "rw").getChannel();
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        this.isOpen = true;
        return this.readRunIn();
    }

    public boolean open(String fileName) throws IOException {
        return this.open(fileName, false);
    }

    public boolean openNew(String fileName) throws IOException {
        this.fileHandle = new File(fileName);
        if (this.fileHandle.exists()) {
            return false;
        }
        return this.open(fileName, false);
    }

    public boolean openMemory(ByteBuffer buffer, @MXFPosition long offset) {
        if (this.isOpen) {
            this.close();
        }
        this.isMemoryFile = true;
        this.runInSize = 0;
        if (buffer == null) {
            this.buffer = ByteBuffer.allocate(65536);
            this.buffer.limit(0);
        } else {
            this.buffer = buffer.duplicate();
        }
        this.bufferOffset = offset;
        this.bufferCurrentPosition = 0L;
        this.buffer.position(0);
        this.isOpen = true;
        return true;
    }

    public boolean openMemory() {
        return this.openMemory(null, 0L);
    }

    @Override
    public boolean close() {
        block3: {
            this.buffer = null;
            try {
                if (this.fileChannel != null) {
                    this.fileChannel.close();
                }
            }
            catch (IOException ioe) {
                if (!this.isOpen) break block3;
                System.err.println("Failed to close MXF file " + this.fileHandle.getName() + " with IO exception: " + ioe.getMessage());
                return false;
            }
        }
        this.isOpen = false;
        this.isMemoryFile = false;
        return true;
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public boolean readRunIn() throws IOException {
        this.runInSize = 0;
        this.runIn = null;
        if (this.fileChannel.size() < 16L) {
            return false;
        }
        this.fileChannel.position(0L);
        ByteBuffer startKey = ByteBuffer.allocate(16);
        this.fileChannel.read(startKey);
        ClassDefinition closedHeaderClass = Warehouse.lookForClass(HeaderClosedCompletePartitionPackImpl.class);
        ByteBuffer closedHeader = ByteBuffer.wrap(((UL)closedHeaderClass.getAUID()).getUniversalLabel());
        boolean headerKey = true;
        startKey.rewind();
        for (int u = 0; u < 11; ++u) {
            if (startKey.get() == closedHeader.get()) continue;
            headerKey = false;
            break;
        }
        this.fileChannel.position(0L);
        if (headerKey) {
            return true;
        }
        ByteBuffer runInSearchZone = ByteBuffer.allocate(65547);
        this.fileChannel.read(runInSearchZone);
        runInSearchZone.flip();
        byte firstByte = closedHeader.get(0);
        for (int u = 1; u < runInSearchZone.limit(); ++u) {
            if (runInSearchZone.get(u) != firstByte) continue;
            boolean keyFound = true;
            for (int v = 1; v < 11; ++v) {
                if (runInSearchZone.get(u + v) == closedHeader.get(v)) continue;
                keyFound = false;
                break;
            }
            if (!keyFound) continue;
            this.runInSize = u;
            byte[] runInBytes = new byte[this.runInSize];
            runInSearchZone.get(runInBytes);
            this.runIn = ByteBuffer.wrap(runInBytes);
            this.fileChannel.position(this.runInSize);
            return true;
        }
        System.err.println("Cannot find a valid key in the first 65536 bytes in file " + this.getName() + ".");
        this.fileChannel.position(0L);
        return false;
    }

    public boolean readRIP() throws IOException {
        int ripLength = -1;
        if (this.isMemoryFile) {
            ripLength = this.buffer.getInt(this.buffer.limit() - 4);
        } else {
            ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
            this.fileChannel.read(lengthBuffer, this.fileChannel.size() - 4L);
            lengthBuffer.rewind();
            ripLength = lengthBuffer.getInt();
        }
        if (ripLength < 20 || (long)ripLength > this.fileChannel.size()) {
            return false;
        }
        ByteBuffer ripBytes = null;
        if (!this.isMemoryFile) {
            ripBytes = ByteBuffer.allocate(ripLength);
            this.fileChannel.read(ripBytes, this.fileChannel.size() - (long)ripLength);
        }
        this.clearRIP();
        ripBytes.rewind();
        this.fileRIP = RandomIndexPackImpl.createFromBytes(ripBytes);
        return this.fileRIP != null;
    }

    @Override
    public RandomIndexPack getRandomIndexPack() {
        if (this.fileRIP == null) {
            return null;
        }
        return this.fileRIP.clone();
    }

    public void clearRIP() {
        this.fileRIP = null;
    }

    @Override
    public boolean buildPartitionsTable() throws IOException, EndOfDataException {
        if (this.fileRIP == null) {
            this.readRIP();
        }
        this.partitions.clear();
        this.readRunIn();
        if (this.fileRIP != null) {
            for (RandomIndexItem item : this.fileRIP.getPartitionIndex()) {
                this.seek(item.getByteOffset());
                this.partitions.add(PartitionImpl.partitionFactory(this));
            }
            return true;
        }
        this.partitions.add(PartitionImpl.partitionFactory(this));
        return this.buildPartitionsBackwards(this.getHeaderPartition().getPartitionPack());
    }

    public boolean buildPartitionsBackwards(PartitionPack headerPartitionPack) throws EndOfDataException {
        long footerPosition = headerPartitionPack.getFooterPartition();
        if (footerPosition == 0L) {
            return false;
        }
        long lastPosition = footerPosition;
        while (lastPosition > 0L) {
            this.seek(lastPosition);
            Partition insertable = PartitionImpl.partitionFactory(this);
            this.partitions.add(1, insertable);
            lastPosition = insertable.getPartitionPack().getPreviousPartition();
        }
        return true;
    }

    @Override
    public int countPartitions() {
        return this.partitions.size();
    }

    @Override
    public HeaderPartition addHeaderPartition(boolean closed, boolean complete, long initialDataSize, int bodySID, int indexSID, UL ... containerFormats) {
        HeaderPartitionImpl partition = new HeaderPartitionImpl();
        if (closed) {
            if (complete) {
                partition.setPartitionPack(new HeaderClosedCompletePartitionPackImpl());
            } else {
                partition.setPartitionPack(new HeaderClosedIncompletePartitionPackImpl());
            }
        } else if (complete) {
            partition.setPartitionPack(new HeaderOpenCompletePartitionPackImpl());
        } else {
            partition.setPartitionPack(new HeaderOpenIncompletePartitionPackImpl());
        }
        for (UL format : containerFormats) {
            partition.getPartitionPack().addEssenceContainer(format);
        }
        partition.getPartitionPack().setBodySID(bodySID < 0 ? 0 : bodySID);
        partition.getPartitionPack().setIndexSID(indexSID < 0 ? 0 : indexSID);
        ((PartitionImpl)partition).setMXFFile(this);
        partition.setInitialDataSize(initialDataSize);
        if (this.partitions.size() != 0 && this.partitions.get(0) instanceof HeaderPartition) {
            this.partitions.remove(0);
        }
        this.partitions.add(0, partition);
        return partition;
    }

    @Override
    public void setFileOperationalPattern(UL operationalPattern) throws NullPointerException {
        if (operationalPattern == null) {
            throw new NullPointerException("Cannot set the operational pattern for this whole file to null.");
        }
        for (Partition partition : this.partitions) {
            partition.getPartitionPack().setOperationalPattern(operationalPattern);
        }
    }

    @Override
    public void setFileKAG(@UInt32 int kag) throws IllegalArgumentException {
        if (kag < 0) {
            throw new IllegalArgumentException("Cannot set the KLV alignment grid for the file to a negative value.");
        }
        for (Partition partition : this.partitions) {
            partition.getPartitionPack().setKagSize(kag);
        }
    }

    @Override
    public void setFileMXFByteLevelVersion(@UInt16 short major, @UInt16 short minor) throws IllegalArgumentException {
        if (major < 0) {
            throw new IllegalArgumentException("Cannot set the MXF byte level major version number for the file to a negative value.");
        }
        if (minor < 0) {
            throw new IllegalArgumentException("Cannot set the MXF byte level minor version number for this file to a negatuve value.");
        }
        for (Partition partition : this.partitions) {
            partition.getPartitionPack().setMajorVersion(major);
            partition.getPartitionPack().setMinorVersion(minor);
        }
    }

    @Override
    public FooterPartition addFooterPartition(boolean complete, long initialSize, int indexSID, UL ... containerFormats) {
        Partition firstPartition;
        AUID likelyOP;
        FooterPartitionImpl partition = new FooterPartitionImpl();
        if (complete) {
            partition.setPartitionPack(new FooterClosedCompletePartitionPackImpl());
        } else {
            partition.setPartitionPack(new FooterClosedIncompletePartitionPackImpl());
        }
        for (UL format : containerFormats) {
            partition.getPartitionPack().addEssenceContainer(format);
        }
        partition.getPartitionPack().setIndexSID(indexSID < 0 ? 0 : indexSID);
        ((PartitionImpl)partition).setMXFFile(this);
        partition.setInitialDataSize(initialSize);
        if (this.partitions.size() > 0 && (likelyOP = (firstPartition = this.partitions.get(0)).getPartitionPack().getOperationalPattern()) != null) {
            partition.getPartitionPack().setOperationalPattern(likelyOP);
        }
        if (this.partitions.size() == 0) {
            this.partitions.add(partition);
            return partition;
        }
        if (this.partitions.get(this.partitions.size() - 1) instanceof FooterPartition) {
            this.partitions.remove(this.partitions.size() - 1);
        }
        this.partitions.add(partition);
        return partition;
    }

    @Override
    public BodyPartition addBodyPartition(boolean closed, boolean complete, long initialDataSize, int bodySID, int indexSID, UL ... containerFormats) {
        Partition firstPartition;
        AUID likelyOP;
        BodyPartitionImpl partition = new BodyPartitionImpl();
        if (closed) {
            if (complete) {
                partition.setPartitionPack(new BodyClosedCompletePartitionPackImpl());
            } else {
                partition.setPartitionPack(new BodyClosedIncompletePartitionPackImpl());
            }
        } else if (complete) {
            partition.setPartitionPack(new BodyOpenCompletePartitionPackImpl());
        } else {
            partition.setPartitionPack(new BodyOpenIncompletePartitionPackImpl());
        }
        for (UL format : containerFormats) {
            partition.getPartitionPack().addEssenceContainer(format);
        }
        partition.getPartitionPack().setBodySID(bodySID < 0 ? 0 : bodySID);
        partition.getPartitionPack().setIndexSID(indexSID < 0 ? 0 : indexSID);
        ((PartitionImpl)partition).setMXFFile(this);
        partition.setInitialDataSize(initialDataSize);
        if (this.partitions.size() > 0 && (likelyOP = (firstPartition = this.partitions.get(0)).getPartitionPack().getOperationalPattern()) != null) {
            partition.getPartitionPack().setOperationalPattern(likelyOP);
        }
        if (this.partitions.size() == 0) {
            this.partitions.add(partition);
            return partition;
        }
        if (this.partitions.get(this.partitions.size() - 1) instanceof FooterPartition) {
            this.partitions.add(this.partitions.size() - 1, partition);
        } else {
            this.partitions.add(partition);
        }
        return partition;
    }

    @Override
    public Partition getPartitionAt(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.partitions.size()) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the current list of partitions.");
        }
        return this.partitions.get(index);
    }

    public Partition getNextPartition(Partition current) {
        int currentIndex = this.partitions.indexOf(current);
        if (currentIndex == -1 || currentIndex == this.partitions.size() - 1) {
            return null;
        }
        return this.partitions.get(currentIndex + 1);
    }

    @Override
    public void updatePackSizes() {
        for (Partition partition : this.partitions) {
            partition.updateSizes();
        }
        long previous = 0L;
        long fileOffset = this.runInSize;
        for (Partition partition : this.partitions) {
            partition.getPartitionPack().setThisPartition(fileOffset);
            partition.getPartitionPack().setPreviousPartition(previous);
            previous = fileOffset;
            fileOffset += partition.getActualSize();
        }
        long footer = 0L;
        if (this.partitions.get(this.partitions.size() - 1) instanceof FooterPartition) {
            footer = previous;
        }
        for (Partition partition : this.partitions) {
            partition.getPartitionPack().setFooterPartition(footer);
        }
    }

    @Override
    public HeaderPartition getHeaderPartition() {
        if (this.partitions.size() == 0) {
            return null;
        }
        if (!(this.partitions.get(0) instanceof HeaderPartition)) {
            return null;
        }
        return (HeaderPartition)this.partitions.get(0);
    }

    @Override
    public FooterPartition getFooterPartition() {
        int partitionsLastIndex = this.partitions.size() - 1;
        if (partitionsLastIndex < 1) {
            return null;
        }
        if (!(this.partitions.get(partitionsLastIndex) instanceof FooterPartition)) {
            return null;
        }
        return (FooterPartition)this.partitions.get(partitionsLastIndex);
    }

    public boolean scanRIP(@MXFLength long maxScan) {
        return false;
    }

    public boolean scanRIP() {
        return this.scanRIP(0x100000L);
    }

    @Override
    public boolean buildRIP() {
        this.fileRIP = new RandomIndexPackImpl();
        for (Partition partition : this.partitions) {
            this.fileRIP.addRandomIndexItem(partition.getPartitionPack().getBodySID(), partition.getPartitionPack().getThisPartition());
        }
        return true;
    }

    public boolean getRIP(@MXFLength long maxScan) {
        return false;
    }

    public PartitionImpl readMasterPartition(@Int64 long maxScan) {
        return null;
    }

    public PartitionImpl readMasterPartition() {
        return this.readMasterPartition(0x100000L);
    }

    public PartitionImpl readFooterPartition(@MXFLength long maxScan) {
        return null;
    }

    public PartitionImpl readFooterPartition() {
        return this.readFooterPartition(0x100000L);
    }

    @MXFPosition
    public long tell() {
        if (!this.isOpen) {
            return 0L;
        }
        if (this.isMemoryFile) {
            return this.bufferCurrentPosition - (long)this.runInSize;
        }
        try {
            return this.fileChannel.position() - (long)this.runInSize;
        }
        catch (IOException ioe) {
            return 0L;
        }
    }

    public int seek(@MXFPosition long position) {
        if (!this.isOpen) {
            return 0;
        }
        if (this.isMemoryFile) {
            this.bufferCurrentPosition = position + (long)this.runInSize;
            return 0;
        }
        try {
            this.fileChannel.position(position + (long)this.runInSize);
            return 0;
        }
        catch (IOException ioe) {
            return 1;
        }
    }

    public int seekEnd() {
        if (!this.isOpen) {
            return 0;
        }
        if (this.isMemoryFile) {
            this.bufferCurrentPosition = (long)this.buffer.limit() + this.bufferOffset;
            return 0;
        }
        try {
            this.fileChannel.position(this.fileChannel.size());
            return 0;
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    @Override
    public boolean atEOF() {
        if (!this.isOpen) {
            return true;
        }
        if (this.isMemoryFile) {
            return this.bufferCurrentPosition - this.bufferOffset >= (long)this.buffer.limit();
        }
        try {
            return this.fileChannel.position() >= this.fileChannel.size();
        }
        catch (IOException ioe) {
            return true;
        }
    }

    public ByteBuffer read(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Cannot read a negative number of bytes.");
        }
        ByteBuffer readBuffer = null;
        if (size > 0) {
            if (this.isMemoryFile) {
                byte[] fromMemory = new byte[size];
                int countBytesRead = this.memoryRead(fromMemory);
                readBuffer = ByteBuffer.wrap(fromMemory);
                readBuffer.limit(countBytesRead);
            } else {
                try {
                    readBuffer = ByteBuffer.allocate(size);
                    int countBytesRead = this.fileChannel.read(readBuffer);
                    readBuffer.flip();
                }
                catch (IOException ioe) {
                    System.err.println("Error reading file " + this.getName() + " at position 0x" + Long.toHexString(this.tell()) + ": " + ioe.getMessage());
                    boolean countBytesRead = false;
                }
            }
            return readBuffer;
        }
        return ByteBuffer.allocate(0);
    }

    public int read(byte[] buffer) {
        int countBytesRead;
        if (this.isMemoryFile) {
            countBytesRead = this.memoryRead(buffer);
        } else {
            try {
                ByteBuffer fileBytes = ByteBuffer.wrap(buffer);
                countBytesRead = this.fileChannel.read(fileBytes);
            }
            catch (IOException ioe) {
                System.err.println("Error reading file " + this.getName() + " at position 0x" + Long.toHexString(this.tell()) + ": " + ioe.getMessage());
                countBytesRead = 0;
            }
        }
        return countBytesRead == -1 ? 0 : countBytesRead;
    }

    public MetadataObject readObject() throws BadParameterException {
        long propertyLength;
        UL key = this.readKey();
        ClassDefinition classDef = ClassDefinitionImpl.forAUID(key);
        MetadataObject mdObject = classDef.createInstance();
        for (long length = this.readBER(); length > 0L; length -= propertyLength) {
            UL propertyKey = this.readKey();
            propertyLength = this.readBER();
            ByteBuffer propertyBytes = this.read((int)propertyLength);
            PropertyDefinition propertyDef = classDef.lookupPropertyDefinition(propertyKey);
            TypeDefinition propertyType = propertyDef.getTypeDefinition();
            PropertyValue propertyValue = propertyType.createValue(propertyBytes);
            propertyDef.setPropertyValue(mdObject, propertyValue);
        }
        return null;
    }

    public MetadataObject readObject(Primer primer) {
        return null;
    }

    public Partition readPartition() throws EndOfDataException {
        Partition partition = PartitionImpl.partitionFactory(this);
        if (partition == null) {
            return null;
        }
        if (!this.partitions.contains(partition)) {
            this.partitions.add(partition);
        }
        return partition;
    }

    public KLVObject readKLV() {
        KLVObject klv = new KLVObject();
        klv.setSource(this);
        if (klv.readKL() < 17) {
            return null;
        }
        return klv;
    }

    public void writePartitionPack(PartitionImpl partition, Primer primer) {
    }

    public void writePartitionPack(PartitionImpl partition) {
        this.writePartitionPack(partition, null);
    }

    public void writePartition(PartitionImpl partition, @UInt32 int padding, @UInt32 int minPartitionSize) {
        this.writePartition(partition, true, null, padding, minPartitionSize);
    }

    public void writePartition(PartitionImpl partition) {
        this.writePartition(partition, true, null, 0, 0);
    }

    public void writePartitionWithIndex(PartitionImpl partition, ByteBuffer indexData, @UInt32 int padding, @UInt32 int minPartitionSize) {
        this.writePartitionWithIndex(partition, indexData, true, null, padding, minPartitionSize);
    }

    public void writePartitionWithIndex(PartitionImpl partition, ByteBuffer indexData) {
        this.writePartitionWithIndex(partition, indexData, true, null, 0, 0);
    }

    public void writePartition(PartitionImpl partition, Primer primer, @UInt32 int padding, @UInt32 int minPartitionSize) {
        this.writePartition(partition, true, primer, padding, minPartitionSize);
    }

    public void writePartition(PartitionImpl partition, Primer primer) {
        this.writePartition(partition, true, primer, 0, 0);
    }

    public void writePartitionWithIndex(PartitionImpl partition, ByteBuffer indexData, Primer primer, @UInt32 int padding, @UInt32 int minPartitionSize) {
        this.writePartitionWithIndex(partition, indexData, true, primer, padding, minPartitionSize);
    }

    public void writePartitionWithIndex(PartitionImpl partition, ByteBuffer indexData, Primer primer) {
        this.writePartitionWithIndex(partition, indexData, true, primer, 0, 0);
    }

    public void writePartition(PartitionImpl partition, boolean includeMetadata, Primer primer, @UInt32 int padding, @UInt32 int minPartitionSize) {
        this.writePartitionInternal(false, partition, includeMetadata, null, primer, padding, minPartitionSize);
    }

    public void writePartition(PartitionImpl partition, boolean includeMetadata) {
        this.writePartitionInternal(false, partition, includeMetadata, null, null, 0, 0);
    }

    public void writePartitionWithIndex(PartitionImpl partition, ByteBuffer indexData, boolean includeMetadata, Primer primer, @UInt32 int padding, @UInt32 int minPartitionSize) {
        this.writePartitionInternal(false, partition, includeMetadata, indexData, primer, padding, minPartitionSize);
    }

    public void writePartitionWithIndex(PartitionImpl partition, ByteBuffer indexData, boolean includeMetadata) {
        this.writePartitionInternal(false, partition, includeMetadata, indexData, null, 0, 0);
    }

    public boolean reWritePartition(PartitionImpl partition, Primer primer) {
        return this.writePartitionInternal(true, partition, true, null, primer, 0, 0);
    }

    public boolean reWritePartition(PartitionImpl partition) {
        return this.writePartitionInternal(true, partition, true, null, null, 0, 0);
    }

    public boolean reWritePartitionWithIndex(PartitionImpl partition, ByteBuffer indexData, Primer primer) {
        return this.writePartitionInternal(true, partition, true, indexData, primer, 0, 0);
    }

    public boolean reWritePartitionWithIndex(PartitionImpl partition, ByteBuffer indexData) {
        return this.writePartitionInternal(true, partition, true, indexData, null, 0, 0);
    }

    boolean writePartitionInternal(boolean reWrite, PartitionImpl partition, boolean includeMetadata, ByteBuffer indexData, Primer primer, @UInt32 int padding, @UInt32 int minPartitionSize) {
        return false;
    }

    @Override
    public boolean writeRIP() throws IOException {
        ByteBuffer ripBytes;
        long ripPosition;
        int ripLength = -1;
        if (this.isMemoryFile) {
            ripLength = this.buffer.getInt(this.buffer.limit() - 4);
        } else {
            ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
            this.fileChannel.read(lengthBuffer, this.fileChannel.size() - 4L);
            lengthBuffer.rewind();
            ripLength = lengthBuffer.getInt();
        }
        if (ripLength < 20 || (long)ripLength > this.fileChannel.size()) {
            ripPosition = this.fileChannel.size();
        } else {
            ripBytes = null;
            if (!this.isMemoryFile) {
                ripBytes = ByteBuffer.allocate(ripLength);
                this.fileChannel.read(ripBytes, this.fileChannel.size() - (long)ripLength);
            }
            ripBytes.rewind();
            RandomIndexPack testRIP = RandomIndexPackImpl.createFromBytes(ripBytes);
            ripPosition = testRIP == null ? this.fileChannel.size() : this.fileChannel.size() - (long)ripLength;
        }
        ripBytes = ByteBuffer.allocate(this.fileRIP.getLength());
        try {
            this.fileRIP.writeAsBytes(ripBytes);
            ripBytes.rewind();
            if (this.digest != null) {
                this.digest.update(ripBytes);
                ripBytes.rewind();
            }
            this.fileChannel.write(ripBytes, ripPosition);
        }
        catch (InsufficientSpaceException ise) {
            return false;
        }
        return true;
    }

    @UInt32
    public int fillerSize(@UInt64 long fillPosition, @UInt32 int kagSize, @UInt32 int minSize) {
        return this.fillerSize(false, fillPosition, kagSize, minSize);
    }

    @UInt32
    public int fillerSize(@UInt64 long fillPosition, @UInt32 int kagSize) {
        return this.fillerSize(false, fillPosition, kagSize, 0);
    }

    @UInt32
    public int fillerSize(boolean forceeBER4, @UInt64 long fillPosition, @UInt32 int kagSize, @UInt32 int minSize) {
        return 0;
    }

    @UInt32
    public int fillerSize(boolean forceeBER4, @UInt64 long fillPosition, @UInt32 int kagSize) {
        return this.fillerSize(forceeBER4, fillPosition, kagSize, 0);
    }

    @UInt64
    public long align(@UInt32 int kagSize, @UInt32 int minSize) {
        return this.align(false, kagSize, minSize);
    }

    @UInt64
    public long align(@UInt32 int kagSize) {
        return this.align(false, kagSize, 0);
    }

    @UInt64
    public long align(boolean forceBER4, @UInt32 int kagSize, @UInt32 int minSize) {
        return 0L;
    }

    @UInt64
    public long align(boolean forceBER4, @UInt32 int kagSize) {
        return this.align(forceBER4, kagSize, 0);
    }

    public UL readKey() {
        ByteBuffer keyData = this.read(16);
        if (keyData.limit() < 16) {
            return null;
        }
        byte[] keySwap = new byte[16];
        keyData.get(keySwap, 8, 8);
        keyData.get(keySwap, 0, 8);
        return new AUIDImpl(keySwap);
    }

    @MXFLength
    public long readBER() {
        ByteBuffer lengthBuffer = this.read(1);
        if (lengthBuffer.limit() < 1) {
            System.err.println("Incomplete BER length in MXF file " + this.getName() + " at 0x" + Long.toHexString(this.tell()));
            return -1L;
        }
        byte first = lengthBuffer.get();
        if (first >= 0) {
            return first;
        }
        int berTailLength = first & 0x7F;
        lengthBuffer = this.read(berTailLength);
        if (lengthBuffer.limit() != berTailLength) {
            System.err.println("Incomplete BER length in MXF file " + this.getName() + " at 0x" + Long.toHexString(this.tell()));
            return -1L;
        }
        long lengthValue = 0L;
        byte[] lengthData = new byte[berTailLength];
        lengthBuffer.get(lengthData);
        for (int u = 0; u < lengthData.length; ++u) {
            lengthValue = (lengthValue << 8) + (long)(lengthData[u] >= 0 ? lengthData[u] : 256 + lengthData[u]);
        }
        return lengthValue;
    }

    @UInt32
    public int writeBER(@UInt64 long length, @UInt32 int size) throws IOException {
        ByteBuffer ber = Helper.makeBER(length, size);
        this.write(ber);
        return ber.capacity();
    }

    @UInt32
    public int writeBER(@UInt64 long length) throws IOException {
        return this.writeBER(length, 0);
    }

    public int write(byte[] buffer) {
        if (this.isMemoryFile) {
            return this.memoryWrite(buffer);
        }
        return 0;
    }

    public int write(ByteBuffer data) throws NullPointerException, IOException {
        if (data == null) {
            throw new NullPointerException("Cannot write null data to an MXF file.");
        }
        if (this.isMemoryFile) {
            return this.memoryWrite(data);
        }
        if (this.fileChannel == null) {
            throw new IOException("Cannot write data to an MXF file that is not yet open.");
        }
        if (this.digest != null) {
            data.mark();
            this.digest.update(data);
            data.reset();
        }
        return this.fileChannel.write(data);
    }

    public void setMemoryBuffer(ByteBuffer buffer, @UInt32 int offset) {
        if (this.isMemoryFile) {
            this.buffer = buffer;
            this.bufferOffset = offset;
        }
    }

    public void setBlockAlign(@UInt32 int size, @Int32 int essenceOffset, @Int32 int indexOffset) {
        this.blockAlign = size;
        this.blockAlignEssenceOffset = essenceOffset;
        this.blockAlignIndexOffset = indexOffset;
    }

    public void setBlockAlign(@UInt32 int size) {
        this.blockAlign = size;
        this.blockAlignEssenceOffset = 0;
        this.blockAlignIndexOffset = 0;
    }

    public boolean isBlockAligned() {
        return this.blockAlign != 0;
    }

    @MXFPosition
    long scanRIPFindFooter(@MXFLength long maxScan) {
        return 0L;
    }

    int memoryWrite(byte[] data) {
        return this.memoryWrite(ByteBuffer.wrap(data));
    }

    int memoryWrite(ByteBuffer data) {
        if (this.bufferCurrentPosition < this.bufferOffset) {
            System.err.println("Cannot write to a memory file before the buffer start.");
            return 0;
        }
        int actualPosition = (int)(this.bufferCurrentPosition - this.bufferOffset);
        int countBytesToWrite = data.remaining();
        int minimumBufferLimit = actualPosition + countBytesToWrite;
        this.buffer.position(actualPosition);
        if (minimumBufferLimit > this.buffer.capacity()) {
            ByteBuffer biggerBuffer = ByteBuffer.allocate((minimumBufferLimit / 65536 + 1) * 65536);
            biggerBuffer.limit(minimumBufferLimit);
            this.buffer.flip();
            biggerBuffer.put(this.buffer);
            this.buffer = biggerBuffer;
        }
        if (minimumBufferLimit > this.buffer.limit()) {
            this.buffer.limit(minimumBufferLimit);
        }
        this.bufferCurrentPosition += (long)countBytesToWrite;
        this.buffer.put(data);
        return countBytesToWrite;
    }

    int memoryRead(byte[] data) {
        if (this.bufferCurrentPosition < this.bufferOffset) {
            System.err.println("Cannot read from a memory file before the buffer start.");
            return 0;
        }
        int actualPosition = (int)(this.bufferCurrentPosition - this.bufferOffset);
        if (actualPosition >= this.buffer.limit()) {
            System.err.println("Cannot read beyond the end of a memory buffer.");
            return 0;
        }
        int maxBytes = this.buffer.limit() - actualPosition;
        this.buffer.position(actualPosition);
        int readSize = data.length > maxBytes ? maxBytes : data.length;
        this.buffer.get(data, 0, readSize);
        this.bufferCurrentPosition += (long)readSize;
        return readSize;
    }

    ByteBuffer getMemoryBuffer() {
        return this.buffer;
    }

    boolean isMemoryFile() {
        return this.isMemoryFile;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    long getBufferOffset() {
        return this.bufferOffset;
    }

    public String getName() {
        if (this.isMemoryFile) {
            return "memory file";
        }
        return this.fileHandle.getName();
    }

    @Override
    public boolean lock() {
        if (!this.isOpen || this.isMemoryFile) {
            return false;
        }
        try {
            if (this.lock != null) {
                if (!this.lock.isValid()) {
                    this.lock = null;
                } else if (this.lock.position() != 0L) {
                    this.lock.release();
                } else {
                    return true;
                }
            }
            this.lock = this.fileChannel.tryLock();
        }
        catch (IOException ioe) {
            return false;
        }
        return this.lock != null;
    }

    @Override
    public boolean lockForward() {
        if (!this.isOpen || this.isMemoryFile) {
            return false;
        }
        try {
            if (this.lock != null) {
                if (!this.lock.isValid()) {
                    this.lock = null;
                } else if (this.lock.position() != this.fileChannel.position()) {
                    this.lock.release();
                } else {
                    return true;
                }
            }
            this.lock = this.fileChannel.tryLock(this.fileChannel.position(), Long.MAX_VALUE - this.fileChannel.position(), false);
        }
        catch (IOException ioe) {
            return false;
        }
        return this.lock != null;
    }

    @Override
    public void unlock() {
        try {
            if (this.lock != null) {
                this.lock.release();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.lock = null;
        }
    }

    @Override
    public void startDigest(String digestType) throws NoSuchAlgorithmException {
        this.digest = MessageDigest.getInstance(digestType);
    }

    @Override
    public byte[] getDigestValue() {
        if (this.digest == null) {
            return null;
        }
        return this.digest.digest();
    }

    @Override
    public long getFileSize() throws IOException {
        return this.fileChannel.size();
    }

    @Override
    public MXFFile clone() {
        try {
            return (MXFFile)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    public static final Preface readPrefaceFromMXF(String fileName) throws Exception {
        PrefaceImpl preface = null;
        File mxfFileReference = new File(fileName);
        try (MXFFileImpl material = new MXFFileImpl();){
            ByteBuffer buffer;
            long length;
            material.open(mxfFileReference.getAbsolutePath());
            material.readRunIn();
            PartitionPack partitionPack = PartitionPackImpl.readPartitionPack(material);
            System.err.println(XMLBuilder.toXML(partitionPack));
            long headerLimit = material.tell() + partitionPack.getHeaderByteCount();
            UL key = material.readKey();
            if (MXFBuilder.isKLVFill(key)) {
                length = material.readBER();
                buffer = material.read((int)length);
            } else {
                material.seek(material.tell() - 16L);
            }
            PrimerPack primerPack = MXFFileImpl.readPrimerPack(material);
            key = material.readKey();
            System.out.println(key.toString());
            if (MXFBuilder.isKLVFill(key)) {
                length = material.readBER();
                buffer = material.read((int)length);
            } else {
                material.seek(material.tell() - 16L);
            }
            HashMap<AUIDImpl, MetadataObject> referenceTable = new HashMap<AUIDImpl, MetadataObject>();
            Vector<ResolutionEntry> resolutions = new Vector<ResolutionEntry>();
            while (material.tell() < headerLimit) {
                MetadataObject metadataFromFile;
                key = material.readKey();
                length = material.readBER();
                buffer = material.read((int)length);
                buffer.rewind();
                if (MXFBuilder.isKLVFill(key) || !((metadataFromFile = MXFBuilder.readLocalSet((AUIDImpl)key, buffer, primerPack, referenceTable, resolutions)) instanceof PrefaceImpl)) continue;
                preface = (PrefaceImpl)metadataFromFile;
            }
            for (ResolutionEntry resolutionEntry : resolutions) {
                resolutionEntry.resolve(referenceTable);
            }
        }
        return preface;
    }

    public static final void main(String[] args) {
        if (args.length == 0) {
            System.exit(1);
        }
        if (args.length > 1) {
            for (int u = 1; u < args.length; ++u) {
                MXFBuilder.ignoreProperty(args[u]);
            }
        }
        long initStartTime = System.nanoTime();
        MediaEngine.initializeAAF();
        long initEndTime = System.nanoTime();
        try {
            Preface preface = MXFFileImpl.readPrefaceFromMXF(args[0]);
            System.out.println("Initializing AAF classes took :" + (initEndTime - initStartTime) + "ns");
            long fileReadEntTime = System.nanoTime();
            System.out.println("Time to read file is " + (fileReadEntTime - initEndTime) + "ns.");
            System.out.println("\nFile as XML is:");
            System.out.println(preface.toString());
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static final PrimerPack readPrimerPack(MXFFileImpl material) throws EndOfDataException {
        Warehouse.lookForClass(LocalTagEntryImpl.class);
        Warehouse.lookForClass(PrimerPackImpl.class);
        UL key = material.readKey();
        long length = material.readBER();
        ByteBuffer buffer = material.read((int)length);
        buffer.rewind();
        return (PrimerPack)MXFBuilder.readFixedLengthPack(key, buffer);
    }
}

