/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.enumeration;

import tv.amwa.maj.industry.MediaEnumerationValue;
import tv.amwa.maj.integer.Int64;

public enum RGBAComponentKind implements MediaEnumerationValue
{
    Red('R'),
    Green('G'),
    Blue('B'),
    Alpha('A'),
    Fill('F'),
    Palette('P'),
    None('0'),
    Null('\u0000');

    private final char value;

    private RGBAComponentKind(char value) {
        this.value = value;
    }

    public char charValue() {
        return this.value;
    }

    public static final RGBAComponentKind fromSpecifiedCode(char code) {
        switch (code) {
            case 'R': {
                return Red;
            }
            case 'G': {
                return Green;
            }
            case 'B': {
                return Blue;
            }
            case 'A': {
                return Alpha;
            }
            case 'F': {
                return Fill;
            }
            case 'P': {
                return Palette;
            }
            case '0': {
                return None;
            }
            case '\u0000': {
                return Null;
            }
        }
        return null;
    }

    @Override
    @Int64
    public long value() {
        return this.value;
    }

    @Override
    public String symbol() {
        return "Comp" + this.name();
    }
}

