/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.exception.NotImplementedException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.model.ControlPoint;
import tv.amwa.maj.model.InterpolationDefinition;
import tv.amwa.maj.model.ParameterDefinition;
import tv.amwa.maj.model.VaryingValue;
import tv.amwa.maj.model.impl.ControlPointImpl;
import tv.amwa.maj.model.impl.InterpolationDefinitionImpl;
import tv.amwa.maj.model.impl.ParameterDefinitionImpl;
import tv.amwa.maj.model.impl.ParameterImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.RationalImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=15872, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="VaryingValue", description="The VaryingValue class specifies a changing data value for an effect control value.", symbol="VaryingValue")
public class VaryingValueImpl
extends ParameterImpl
implements VaryingValue,
Serializable,
Cloneable {
    private static final long serialVersionUID = 9169919354845468382L;
    private WeakReference<InterpolationDefinition> interpolation;
    private List<ControlPoint> pointList = Collections.synchronizedList(new Vector());

    public VaryingValueImpl() {
    }

    public VaryingValueImpl(ParameterDefinition parameterDefinition, InterpolationDefinition interpolation) throws NullPointerException {
        if (parameterDefinition == null) {
            throw new NullPointerException("Cannot create a new varying value with a null parameter definition.");
        }
        if (interpolation == null) {
            throw new NullPointerException("Cannot create a new varying value with a null interpolation definition.");
        }
        this.setParameterDefinition(parameterDefinition);
        this.setInterpolationDefinition(interpolation);
    }

    @MediaProperty(uuid1=100729092, uuid2=1542, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PointList", typeName="ControlPointStrongReferenceVector", optional=false, uniqueIdentifier=false, pid=19970, symbol="PointList")
    public List<ControlPoint> getControlPoints() {
        return StrongReferenceVector.getRequiredList(this.pointList);
    }

    public final List<ControlPoint> initializePointList() {
        ArrayList<ControlPoint> initialPoints = new ArrayList<ControlPoint>(1);
        this.setParameterDefinition(ParameterDefinitionImpl.forName("Level"));
        initialPoints.add(new ControlPointImpl(TypeDefinitions.Rational, (Rational)new RationalImpl(0, 1), TypeDefinitions.Rational.createValue("0/1")));
        return initialPoints;
    }

    @Override
    @MediaListAppend(value="PointList")
    public void appendControlPoint(ControlPoint controlPoint) throws NullPointerException, IllegalArgumentException {
        if (controlPoint == null) {
            throw new NullPointerException("Cannot add to the list of control points with a null value.");
        }
        try {
            if (!this.getTypeDefinition().equals(controlPoint.getTypeDefinition())) {
                throw new IllegalArgumentException("Cannot add the given control point to the list of control points of this varying value as it is of the wrong type.");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        StrongReferenceVector.append(this.pointList, controlPoint);
    }

    @Override
    @MediaPropertyCount(value="PointList")
    public int countControlPoints() {
        return this.pointList.size();
    }

    @MediaPropertyClear(value="PointList")
    public void clearControlPoints() {
        this.pointList = Collections.synchronizedList(new Vector());
    }

    @Override
    @MediaListGetAt(value="PointList")
    public ControlPoint getControlPointAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.pointList, index);
    }

    @Override
    @MediaListRemoveAt(value="PointList")
    public void removeControlPointAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.pointList, index);
    }

    @Override
    public Object getInterpolatedValue(Rational inputValue) throws NullPointerException, NotImplementedException {
        return null;
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=261, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Interpolation", typeName="InterpolationDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=19969, symbol="Interpolation")
    public InterpolationDefinition getInterpolationDefinition() {
        return this.interpolation.getTarget();
    }

    @MediaPropertySetter(value="Interpolation")
    public void setInterpolationDefinition(InterpolationDefinition interpolation) throws NullPointerException {
        if (interpolation == null) {
            throw new NullPointerException("Cannot set the interpolation definition of this varying value with a null value.");
        }
        this.interpolation = new WeakReference<InterpolationDefinition>(interpolation);
    }

    public static final InterpolationDefinition initializeInterpolation() {
        return InterpolationDefinitionImpl.forName("None");
    }

    @Override
    public VaryingValue clone() {
        return (VaryingValue)super.clone();
    }
}

