/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.impl.TypeDefinitionRecordImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

public class GenerationCore {
    protected static Map<String, ClassData> classList = new HashMap<String, ClassData>();
    protected static Map<String, PropertyData> propertyList = new HashMap<String, PropertyData>();
    protected static Map<String, TypeData> typeList = new HashMap<String, TypeData>();
    protected static Map<String, String> weakReferenceTargets = new HashMap<String, String>();
    public static final int LINE_WIDTH = 80;
    static final String[] NoImports = new String[0];

    protected static TypeData typeByName(String name) {
        if (name.startsWith("urn:smpte:ul")) {
            name = name.toLowerCase();
        }
        if (typeList.containsKey(name)) {
            return typeList.get(name);
        }
        TypeDefinition widerType = Warehouse.lookForType(name);
        if (widerType == null) {
            return null;
        }
        DocumentFragment fragment = XMLBuilder.createDocumentFragment();
        widerType.appendMetadictXML(fragment, "", "");
        return GenerationCore.processTypeDefinition((Element)fragment.getFirstChild());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final boolean writeFile(File directory, String name, String content) {
        File fileToWrite = new File(directory, name);
        FileWriter writer = null;
        try {
            writer = new FileWriter(fileToWrite);
            writer.append(content);
            writer.flush();
        }
        catch (IOException ioe) {
            System.err.println("Unable to write to file " + fileToWrite.getAbsolutePath() + ".");
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    protected static DictionaryContext processRoot(Node node) {
        int x;
        String schemeIDAsString;
        if (node.getNodeName().equals("DataModel")) {
            node = GenerationCore.getFirstChildElement(node);
        }
        DictionaryContext context = new DictionaryContext();
        if (node.getNodeName().equals("Baseline")) {
            context.baseline = true;
        } else if (!node.getNodeName().equals("Extension")) {
            return null;
        }
        context.schemeURI = GenerationCore.getChildNodeByName("Symbolspace", (Element)node);
        if (context.schemeURI == null || context.schemeURI.length() == 0) {
            context.schemeURI = GenerationCore.getChildNodeByName("SchemeURI", (Element)node);
        }
        if ((schemeIDAsString = GenerationCore.getChildNodeByName("Identification", (Element)node)) == null || schemeIDAsString.length() == 0) {
            schemeIDAsString = GenerationCore.getChildNodeByName("SchemeID", (Element)node);
        }
        context.schemeID = AUIDImpl.parseFactory(schemeIDAsString);
        context.extensionDescription = GenerationCore.getChildNodeByName("Description", (Element)node);
        if (context.extensionDescription == null || context.extensionDescription.length() == 0) {
            context.extensionDescription = GenerationCore.getChildNodeByName("ExtensionDescription", (Element)node);
        }
        context.preferredPrefix = GenerationCore.getChildNodeByName("PreferredPrefix", (Element)node);
        NodeList childNodes = null;
        for (x = 0; x < node.getChildNodes().getLength(); ++x) {
            Node nodeToCheck = node.getChildNodes().item(x);
            if (!nodeToCheck.getNodeName().equals("Definitions")) continue;
            childNodes = nodeToCheck.getChildNodes();
            break;
        }
        if (childNodes == null) {
            return context;
        }
        for (x = 0; x < childNodes.getLength(); ++x) {
            if (!(childNodes.item(x) instanceof Element)) continue;
            Element child = (Element)childNodes.item(x);
            if (child.getNodeName().equals("ClassDefinition")) {
                GenerationCore.processClassDefinition(child);
                continue;
            }
            if (child.getNodeName().equals("PropertyDefinition")) {
                GenerationCore.processPropertyDefinition(child);
                continue;
            }
            if (child.getNodeName().startsWith("TypeDefinition")) {
                TypeData typeData = GenerationCore.processTypeDefinition(child);
                typeList.put(typeData.name, typeData);
                typeList.put(typeData.symbol, typeData);
                typeList.put(typeData.identification.toString(), typeData);
                continue;
            }
            if (!child.getNodeName().equals("ExtendibleEnumerationElement")) continue;
            GenerationCore.processExtendibleEnumerationElement(child);
        }
        return context;
    }

    static TypeData childToTypeData(Element child) {
        TypeData typeData = null;
        if (child.getNodeName().contains("Character")) {
            typeData = new TypeDataCharacter();
            return typeData;
        }
        if (child.getNodeName().contains("nEnumeration")) {
            typeData = new TypeDataEnumeration();
            ((TypeDataEnumeration)typeData).elementType = GenerationCore.getChildNodeByName("ElementType", child);
            NodeList children = child.getChildNodes();
            for (int x = 0; x < children.getLength(); ++x) {
                if (!(children.item(x) instanceof Element) || !children.item(x).getNodeName().equals("Elements")) continue;
                Element elements = (Element)children.item(x);
                NodeList elementsNodes = elements.getChildNodes();
                for (int y = 0; y < elementsNodes.getLength(); ++y) {
                    if (elementsNodes.item(y) instanceof Element && elementsNodes.item(y).getNodeName().equals("Name")) {
                        ((TypeDataEnumeration)typeData).names.add(elementsNodes.item(y).getTextContent());
                        continue;
                    }
                    if (!(elementsNodes.item(y) instanceof Element) || !elementsNodes.item(y).getNodeName().equals("Value")) continue;
                    ((TypeDataEnumeration)typeData).values.add(elementsNodes.item(y).getTextContent());
                }
                break;
            }
            return typeData;
        }
        if (child.getNodeName().contains("ExtendibleEnumeration")) {
            typeData = new TypeDataExtendibleEnumeration();
            return typeData;
        }
        if (child.getNodeName().contains("FixedArray")) {
            typeData = new TypeDataFixedArray();
            ((TypeDataFixedArray)typeData).elementCount = Integer.parseInt(GenerationCore.getChildNodeByName("ElementCount", child));
            ((TypeDataFixedArray)typeData).elementType = GenerationCore.getChildNodeByName("ElementType", child);
            return typeData;
        }
        if (child.getNodeName().contains("Indirect")) {
            typeData = new TypeDataIndirect();
            return typeData;
        }
        if (child.getNodeName().contains("Integer")) {
            typeData = new TypeDataInteger();
            ((TypeDataInteger)typeData).size = Integer.parseInt(GenerationCore.getChildNodeByName("Size", child));
            ((TypeDataInteger)typeData).isSigned = Boolean.parseBoolean(GenerationCore.getChildNodeByName("IsSigned", child));
            return typeData;
        }
        if (child.getNodeName().contains("Opaque")) {
            typeData = new TypeDataOpaque();
            return typeData;
        }
        if (child.getNodeName().contains("Record")) {
            typeData = new TypeDataRecord();
            NodeList children = child.getChildNodes();
            for (int x = 0; x < children.getLength(); ++x) {
                if (!(children.item(x) instanceof Element) || !children.item(x).getNodeName().equals("Members")) continue;
                Element members = (Element)children.item(x);
                NodeList elementsNodes = members.getChildNodes();
                for (int y = 0; y < elementsNodes.getLength(); ++y) {
                    if (elementsNodes.item(y) instanceof Element && elementsNodes.item(y).getNodeName().equals("Name")) {
                        ((TypeDataRecord)typeData).memberNames.add(elementsNodes.item(y).getTextContent());
                        continue;
                    }
                    if (!(elementsNodes.item(y) instanceof Element) || !elementsNodes.item(y).getNodeName().equals("Type")) continue;
                    ((TypeDataRecord)typeData).memberTypes.add(elementsNodes.item(y).getTextContent());
                }
                break;
            }
            return typeData;
        }
        if (child.getNodeName().contains("Rename")) {
            typeData = new TypeDataRename();
            ((TypeDataRename)typeData).renamedType = GenerationCore.getChildNodeByName("RenamedType", child);
            return typeData;
        }
        if (child.getNodeName().contains("Set")) {
            typeData = new TypeDataSet();
            ((TypeDataSet)typeData).elementType = GenerationCore.getChildNodeByName("ElementType", child);
            return typeData;
        }
        if (child.getNodeName().contains("Stream")) {
            typeData = new TypeDataStream();
            return typeData;
        }
        if (child.getNodeName().contains("String")) {
            typeData = new TypeDataString();
            ((TypeDataString)typeData).elementType = GenerationCore.getChildNodeByName("ElementType", child);
            return typeData;
        }
        if (child.getNodeName().contains("StrongObjectReference")) {
            typeData = new TypeDataStrongObjectReference();
            ((TypeDataStrongObjectReference)typeData).referencedType = GenerationCore.getChildNodeByName("ReferencedType", child);
            return typeData;
        }
        if (child.getNodeName().contains("VariableArray")) {
            typeData = new TypeDataVariableArray();
            ((TypeDataVariableArray)typeData).elementType = GenerationCore.getChildNodeByName("ElementType", child);
            return typeData;
        }
        if (child.getNodeName().contains("WeakObjectReference")) {
            typeData = new TypeDataWeakObjectReference();
            ((TypeDataWeakObjectReference)typeData).referencedType = GenerationCore.getChildNodeByName("ReferencedType", child);
            return typeData;
        }
        System.err.println("Unable to process a type definition with element name " + child.getNodeName() + ".");
        return null;
    }

    static TypeData processTypeDefinition(Element child) {
        TypeData typeData = GenerationCore.childToTypeData(child);
        if (typeData == null) {
            return null;
        }
        GenerationCore.setMetaProperties(child, typeData);
        return typeData;
    }

    static void processExtendibleEnumerationElement(Element child) {
        String extendibleEnumerationName = GenerationCore.getChildNodeByName("ElementOf", child);
        String elementName = GenerationCore.getChildNodeByName("Name", child);
        AUIDImpl elementValue = AUIDImpl.parseFactory(GenerationCore.getChildNodeByName("Value", child));
        TypeDataExtendibleEnumeration enumByName = (TypeDataExtendibleEnumeration)GenerationCore.typeByName(extendibleEnumerationName);
        Warehouse.registerExtendibleEnumerationElement(enumByName.symbol, elementName, elementValue);
    }

    static void processPropertyDefinition(Element child) {
        PropertyData propertyData = new PropertyData();
        GenerationCore.setMetaProperties(child, propertyData);
        propertyData.memberOf = GenerationCore.getChildNodeByName("MemberOf", child);
        propertyData.isOptional = Boolean.parseBoolean(GenerationCore.getChildNodeByName("IsOptional", child));
        propertyData.type = GenerationCore.getChildNodeByName("Type", child);
        String localIdentificationString = GenerationCore.getChildNodeByName("LocalIdentification", child);
        propertyData.localIdentification = localIdentificationString.startsWith("0x") ? (short)Integer.parseInt(localIdentificationString.substring(2), 16) : Short.parseShort(localIdentificationString);
        String unique = GenerationCore.getChildNodeByName("IsUniqueIdentifier", child);
        if (unique != null) {
            propertyData.isUniqueIdentifier = Boolean.parseBoolean(unique);
            if (propertyData.type.equals("AUID")) {
                weakReferenceTargets.put(propertyData.memberOf, propertyData.name);
            }
        }
        propertyList.put(propertyData.memberOf + "_" + propertyData.name, propertyData);
    }

    static void processClassDefinition(Element child) {
        ClassData classData = new ClassData();
        GenerationCore.setMetaProperties(child, classData);
        classData.parentClass = GenerationCore.getChildNodeByName("ParentClass", child);
        classData.isConcrete = Boolean.parseBoolean(GenerationCore.getChildNodeByName("IsConcrete", child));
        classList.put(classData.name, classData);
    }

    static void setMetaProperties(Element parent, MetaData metaData) {
        metaData.name = GenerationCore.getChildNodeByName("Name", parent);
        metaData.description = GenerationCore.getChildNodeByName("Description", parent);
        metaData.symbol = GenerationCore.getChildNodeByName("Symbol", parent);
        metaData.identification = AUIDImpl.parseFactory(GenerationCore.getChildNodeByName("Identification", parent));
    }

    static String getChildNodeByName(String childName, Element parent) {
        NodeList nodes = parent.getChildNodes();
        String result = null;
        for (int x = 0; x < nodes.getLength(); ++x) {
            if (!(nodes.item(x) instanceof Element)) continue;
            String localChildName = childName;
            if (nodes.item(x).getPrefix() != null) {
                localChildName = nodes.item(x).getPrefix() + ":" + localChildName;
            }
            if (!nodes.item(x).getNodeName().equals(localChildName)) continue;
            NodeList children = nodes.item(x).getChildNodes();
            if (children.getLength() > 0) {
                result = children.item(0).getNodeValue().trim();
                break;
            }
            result = "";
            break;
        }
        if (result != null && result.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(result);
            result = tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                result = result + " " + tokenizer.nextToken();
            }
        }
        return result;
    }

    static Node getFirstChildElement(Node parent) {
        NodeList nodes = parent.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            if (!(nodes.item(x) instanceof Element)) continue;
            return nodes.item(x);
        }
        return null;
    }

    protected static final String lowerFirstLetter(String changeMe) {
        if (Character.isUpperCase(changeMe.charAt(0))) {
            StringBuffer replacement = new StringBuffer(changeMe);
            replacement.setCharAt(0, Character.toLowerCase(changeMe.charAt(0)));
            return replacement.toString();
        }
        return changeMe;
    }

    protected static final String upperFirstLetter(String changeMe) {
        if (Character.isLowerCase(changeMe.charAt(0))) {
            StringBuffer replacement = new StringBuffer(changeMe);
            replacement.setCharAt(0, Character.toTitleCase(changeMe.charAt(0)));
            return replacement.toString();
        }
        return changeMe;
    }

    protected static final String firstSentence(String changeMe) {
        int firstDot = -1;
        for (int x = 1; x < changeMe.length(); ++x) {
            if (changeMe.charAt(x - 1) != '.' || !Character.isWhitespace(changeMe.charAt(x))) continue;
            firstDot = x - 1;
            break;
        }
        if (firstDot == -1 && changeMe.charAt(changeMe.length() - 1) == '.') {
            return changeMe;
        }
        return changeMe.substring(0, firstDot + 1);
    }

    protected static final String camelToWords(String changeMe) {
        Vector<String> words = new Vector<String>();
        if (changeMe == null || changeMe.length() == 0) {
            return "";
        }
        StringBuffer currentWord = new StringBuffer();
        currentWord.append(Character.toLowerCase(changeMe.charAt(0)));
        for (int x = 1; x < changeMe.length(); ++x) {
            char currentChar = changeMe.charAt(x);
            if (Character.isUpperCase(currentChar)) {
                words.add(currentWord.toString());
                currentWord = new StringBuffer();
                currentWord.append(Character.toLowerCase(currentChar));
                continue;
            }
            currentWord.append(currentChar);
        }
        if (currentWord.length() > 0) {
            words.add(currentWord.toString());
        }
        StringBuffer result = new StringBuffer((String)words.get(0));
        for (int x = 1; x < words.size(); ++x) {
            result.append(' ');
            result.append((String)words.get(x));
        }
        return result.toString();
    }

    protected static String makeSingular(String changeMe) {
        if (changeMe.endsWith("s") || changeMe.endsWith("S")) {
            return changeMe.substring(0, changeMe.length() - 1);
        }
        return changeMe;
    }

    protected static String aOrAn(String noun) {
        if (noun == null || noun.length() == 0) {
            return "a";
        }
        switch (noun.charAt(0)) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': 
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return "an " + noun;
            }
        }
        return "a " + noun;
    }

    protected static String padHexTo8(int value) {
        StringBuffer buffer = new StringBuffer(Integer.toHexString(value));
        int zerosToPad = 8 - buffer.length();
        for (int x = 0; x < zerosToPad; ++x) {
            buffer.insert(0, '0');
        }
        return buffer.toString();
    }

    protected static String padHexTo4(short value) {
        StringBuffer buffer = new StringBuffer(Integer.toHexString(value));
        if (buffer.length() > 4) {
            buffer.delete(0, buffer.length() - 4);
        }
        int zerosToPad = 4 - buffer.length();
        for (int x = 0; x < zerosToPad; ++x) {
            buffer.insert(0, '0');
        }
        return buffer.toString();
    }

    protected static String bytesToText(byte[] value) {
        StringBuffer buffer = new StringBuffer();
        for (int x = 0; x < value.length; ++x) {
            int current;
            int n = current = value[x] >= 0 ? value[x] : 256 + value[x];
            if (current > 127) {
                buffer.append("(byte) ");
            }
            buffer.append("0x");
            if (current < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(current));
            if (x >= value.length - 1) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    protected static final boolean isNullableType(TypeData type) {
        switch (type.getTypeCategory()) {
            case Int: {
                return false;
            }
            case Enum: {
                return !type.name.equals("Boolean");
            }
            case Character: {
                return false;
            }
        }
        return true;
    }

    public static final boolean makeDirectories(DictionaryContext context) {
        boolean success = true;
        context.rootDir = new File(".");
        if (!context.rootDir.isDirectory()) {
            return false;
        }
        if (!context.rootDir.canWrite()) {
            return false;
        }
        File srcRootDir = new File(context.rootDir, "src");
        File testRootDir = new File(context.rootDir, "test");
        if (!srcRootDir.exists()) {
            success &= srcRootDir.mkdir();
        }
        if (!testRootDir.exists()) {
            success &= testRootDir.mkdir();
        }
        if (context.baseline) {
            context.testModelDir = GenerationCore.makePackageDir(testRootDir, context.basePackageName + ".model.impl");
            context.testMetaDir = GenerationCore.makePackageDir(testRootDir, context.basePackageName + ".meta.impl");
            if (context.testModelDir == null || context.testMetaDir == null) {
                return false;
            }
        } else {
            context.interfaceDir = GenerationCore.makePackageDir(srcRootDir, context.basePackageName);
            context.implementationDir = GenerationCore.makePackageDir(srcRootDir, context.basePackageName + ".impl");
            context.testModelDir = GenerationCore.makePackageDir(testRootDir, context.basePackageName + ".impl");
            if (context.interfaceDir == null || context.implementationDir == null || context.testModelDir == null) {
                return false;
            }
        }
        return success;
    }

    static final File makePackageDir(File rootDir, String packageName) {
        File parent;
        StringTokenizer splitPackage = new StringTokenizer(packageName, ".");
        File child = parent = rootDir;
        boolean success = true;
        while (splitPackage.hasMoreElements()) {
            String pathPart = (String)splitPackage.nextElement();
            child = new File(parent, pathPart);
            if (!child.exists()) {
                success &= child.mkdir();
            }
            parent = child;
        }
        if (!success) {
            return null;
        }
        return child;
    }

    protected static class DictionaryContext {
        AUID schemeID;
        String schemeURI;
        String preferredPrefix;
        String extensionDescription;
        String basePackageName;
        String factoryName;
        File rootDir;
        File interfaceDir;
        File implementationDir;
        File testModelDir;
        File testMetaDir;
        boolean baseline;
    }

    protected static class StringIndenter {
        public static final int INDENT_SIZE = 4;
        private StringBuffer buffer = new StringBuffer();
        private int indent = 0;
        private SortedSet<String> imports = new TreeSet<String>();
        private String packageName = null;

        public void addImport(String canonicalName) {
            if (canonicalName != null && canonicalName.length() > 0) {
                this.imports.add(canonicalName);
            }
        }

        public void addImport(String[] imports) {
            for (String imported : imports) {
                this.addImport(imported);
            }
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        private void indent() {
            for (int x = 0; x < this.indent; ++x) {
                this.buffer.append(' ');
            }
        }

        public void append(String line) {
            this.indent();
            this.buffer.append(line);
            this.buffer.append('\n');
        }

        public void appendNL(String line) {
            this.append(line);
            this.buffer.append('\n');
        }

        public void increment(String line) {
            this.indent += 4;
            this.append(line);
        }

        public void incrementNL(String line) {
            this.indent += 4;
            this.appendNL(line);
        }

        public void decrement(String line) {
            this.indent -= 4;
            this.append(line);
        }

        public void decrementNL(String line) {
            this.indent -= 4;
            this.appendNL(line);
        }

        public void reset(String line) {
            this.indent = 0;
            this.append(line);
        }

        public void resetNL(String line) {
            this.indent = 0;
            this.appendNL(line);
        }

        public void wrapComment(String comment, int lineWidth) {
            StringTokenizer tokenizer = new StringTokenizer(comment);
            StringBuffer currentLine = new StringBuffer(lineWidth + 10);
            currentLine.append(" *");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                currentLine.append(" ");
                currentLine.append(token);
                if (currentLine.length() <= lineWidth || !tokenizer.hasMoreElements()) continue;
                this.append(currentLine.toString());
                currentLine = new StringBuffer(lineWidth + 10);
                currentLine.append(" *");
            }
            this.append(currentLine.toString());
        }

        public void startJavadoc() {
            this.append("/**");
        }

        public void blankComment() {
            this.append(" *");
        }

        public void endComment() {
            this.append(" */");
        }

        public void backWrite(String previousLineEnding) {
            this.buffer.insert(this.buffer.length() - 1, previousLineEnding);
        }

        public void addThrowsClause(List<String> exceptions, boolean isInterface) {
            if (exceptions == null || exceptions.size() == 0) {
                this.backWrite(isInterface ? ";\n" : " {\n");
                if (!isInterface) {
                    this.indent += 4;
                }
                return;
            }
            this.indent();
            this.buffer.append("    throws " + exceptions.get(0));
            for (int x = 1; x < exceptions.size(); ++x) {
                this.buffer.append(",\n");
                this.indent();
                this.buffer.append("        " + exceptions.get(x));
            }
            this.buffer.append(isInterface ? ";\n\n" : " {\n\n");
            if (!isInterface) {
                this.indent += 4;
            }
        }

        public String toString() {
            if (this.imports.size() > 0) {
                this.buffer.insert(0, '\n');
            }
            Vector<String> orderedImports = new Vector<String>(this.imports);
            for (int x = orderedImports.size() - 1; x >= 0; --x) {
                this.buffer.insert(0, "import " + (String)orderedImports.get(x) + ";\n");
            }
            if (this.packageName != null && this.packageName.length() > 0) {
                this.buffer.insert(0, "package " + this.packageName + ";\n\n");
            }
            return this.buffer.toString();
        }
    }

    protected static class TypeDataWeakObjectReference
    extends TypeData {
        String referencedType;
        List<String> targetSet = new Vector<String>();

        @Override
        String getJavaGetName() {
            return this.referencedType;
        }

        @Override
        String getJavaSetName(boolean optional) {
            return this.referencedType;
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.WeakObjRef;
        }

        @Override
        String[] getImports() {
            try {
                Class<?> referencedClass = Warehouse.lookForClass(this.referencedType).getJavaImplementation();
                if (referencedClass == null) {
                    return NoImports;
                }
                for (Class<?> iface : referencedClass.getInterfaces()) {
                    if (!iface.getName().contains(this.referencedType)) continue;
                    return new String[]{iface.getCanonicalName()};
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return NoImports;
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionWeakObjectReference");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionWeakObjectReferenceImpl");
            building.addImport("tv.amwa.maj.industry.Warehouse");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", a weak object reference to " + GenerationCore.aOrAn(GenerationCore.camelToWords(this.referencedType)) + ".</p>", 80);
            }
            building.blankComment();
            building.wrapComment("@see tv.amwa.maj.industry.WeakReference", 80);
            building.wrapComment("@see tv.amwa.maj.industry.WeakReferenceTarget", 80);
            building.endComment();
            building.append("public final static TypeDefinitionWeakObjectReference " + this.name + " = new TypeDefinitionWeakObjectReferenceImpl(");
            super.appendTypeDescription(building);
            building.append("        \"" + this.name + "\",");
            if (classList.containsKey(this.referencedType)) {
                building.addImport(building.getPackageName() + ".impl." + this.referencedType + "Impl");
                building.append("        Warehouse.lookForClass(" + this.referencedType + "Impl.class),");
            } else {
                ClassDefinition baselineClass = Warehouse.lookForClass(this.referencedType);
                building.append("        Warehouse.lookForClass(" + baselineClass.getJavaImplementation().getCanonicalName() + ".class),");
            }
            building.appendNL("        new AUID[] { } );");
        }
    }

    protected static class TypeDataVariableArray
    extends TypeData {
        String elementType;

        @Override
        String getJavaGetName() {
            return GenerationCore.typeByName(this.elementType).getJavaGetName();
        }

        @Override
        String getJavaSetName(boolean optional) {
            return GenerationCore.typeByName(this.elementType).getJavaSetName(optional);
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.VariableArray;
        }

        @Override
        public String[] getImports() {
            return GenerationCore.typeByName(this.elementType).getImports();
        }

        @Override
        boolean getThrowsIllegal() {
            return GenerationCore.typeByName(this.elementType).getThrowsIllegal();
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionVariableArray");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionVariableArrayImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", a variable array type definition with " + GenerationCore.camelToWords(this.elementType) + " elements.</p>", 80);
            }
            building.blankComment();
            building.wrapComment("@see tv.amwa.maj.industry.StrongReferenceVector", 80);
            building.wrapComment("@see tv.amwa.maj.industry.WeakReferenceVector", 80);
            if (typeList.containsKey(this.elementType)) {
                building.wrapComment("@see #" + this.elementType, 80);
            } else {
                building.wrapComment("@see tv.amwa.maj.industry.TypeDefinitions#" + this.elementType, 80);
            }
            building.endComment();
            building.append("public final static TypeDefinitionVariableArray " + this.name + " = new TypeDefinitionVariableArrayImpl(");
            super.appendTypeDescription(building);
            building.append("        \"" + this.name + "\",");
            if (typeList.containsKey(this.elementType)) {
                building.appendNL("        " + this.elementType + ");");
            } else {
                building.appendNL("        tv.amwa.maj.industry.TypeDefinitions." + this.elementType + ");");
            }
        }
    }

    protected static class TypeDataStrongObjectReference
    extends TypeData {
        String referencedType;

        @Override
        String getJavaGetName() {
            return Warehouse.javaClassAlias(this.referencedType);
        }

        @Override
        String getJavaSetName(boolean optional) {
            return Warehouse.javaClassAlias(this.referencedType);
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.StrongObjRef;
        }

        @Override
        public String[] getImports() {
            try {
                Class<?> referencedClass = Warehouse.lookForClass(this.referencedType).getJavaImplementation();
                if (referencedClass == null) {
                    return NoImports;
                }
                for (Class<?> iface : referencedClass.getInterfaces()) {
                    if (!iface.getName().contains(this.referencedType)) continue;
                    return new String[]{iface.getCanonicalName()};
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return NoImports;
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionStrongObjectReference");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionStrongObjectReferenceImpl");
            building.addImport("tv.amwa.maj.industry.Warehouse");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", a strong object reference to " + GenerationCore.aOrAn(GenerationCore.camelToWords(this.referencedType)) + ".</p>", 80);
            }
            building.endComment();
            building.append("public final static TypeDefinitionStrongObjectReference " + this.name + " = new TypeDefinitionStrongObjectReferenceImpl(");
            super.appendTypeDescription(building);
            building.append("        \"" + this.name + "\",");
            if (classList.containsKey(this.referencedType)) {
                building.addImport(building.getPackageName() + ".impl." + this.referencedType + "Impl");
                building.appendNL("        Warehouse.lookForClass(" + this.referencedType + "Impl.class) );");
            } else {
                ClassDefinition baselineClass = Warehouse.lookForClass(this.referencedType);
                building.appendNL("        Warehouse.lookForClass(" + baselineClass.getJavaImplementation().getCanonicalName() + ".class) );");
            }
        }
    }

    protected static class TypeDataString
    extends TypeData {
        String elementType;

        @Override
        String getJavaGetName() {
            return "String";
        }

        @Override
        String getJavaSetName(boolean optional) {
            return "String";
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.String;
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionString");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionStringImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", a string type definition.</p>", 80);
            }
            building.blankComment();
            building.wrapComment("@see tv.amwa.maj.industry.TypeDefinitions#UTF16String", 80);
            if (typeList.containsKey(this.elementType)) {
                building.wrapComment("@see #" + this.elementType, 80);
            } else {
                building.wrapComment("@see tv.amwa.maj.industry.TypeDefinitions#" + this.elementType, 80);
            }
            building.endComment();
            building.append("public final static TypeDefinitionString " + this.name + " = new TypeDefinitionStringImpl(");
            super.appendTypeDescription(building);
            building.append("        \"" + this.name + "\",");
            if (typeList.containsKey(this.elementType)) {
                building.appendNL("        " + this.elementType + ");");
            } else {
                building.appendNL("        tv.amwa.maj.industry.TypeDefinitions." + this.elementType + ");");
            }
        }
    }

    protected static class TypeDataStream
    extends TypeData {
        @Override
        String getJavaGetName() {
            if (this.name.equals("Stream")) {
                return "Stream";
            }
            return "byte[]";
        }

        @Override
        String getJavaSetName(boolean optional) {
            return this.getJavaGetName();
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.Stream;
        }

        @Override
        public String getAnnotation() {
            if (this.name.equals("Stream")) {
                return "DataBuffer";
            }
            return "DataValue";
        }

        @Override
        public String[] getImports() {
            if (this.name.equals("Stream")) {
                return new String[]{"tv.amwa.maj.industry.Stream"};
            }
            return new String[]{"tv.amwa.maj.misctype.DataValue"};
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionStream");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionStreamImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", a stream type definition.</p>", 80);
            }
            building.blankComment();
            building.wrapComment("@see tv.amwa.maj.industry.Stream", 80);
            building.endComment();
            building.append("public final static TypeDefinitionStream " + this.name + " = new TypeDefinitionStreamImpl(");
            super.appendTypeDescription(building);
            building.appendNL("        \"" + this.name + "\");");
        }
    }

    protected static class TypeDataSet
    extends TypeData {
        String elementType;

        @Override
        String getJavaGetName() {
            return GenerationCore.typeByName(this.elementType).getJavaGetName();
        }

        @Override
        String getJavaSetName(boolean optional) {
            return GenerationCore.typeByName(this.elementType).getJavaSetName(optional);
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.Set;
        }

        @Override
        String[] getImports() {
            return GenerationCore.typeByName(this.elementType).getImports();
        }

        @Override
        boolean getThrowsIllegal() {
            return GenerationCore.typeByName(this.elementType).getThrowsIllegal();
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionSet");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionSetImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", a set type definition with " + GenerationCore.camelToWords(this.elementType) + " elements.</p>", 80);
            }
            building.blankComment();
            building.wrapComment("@see tv.amwa.maj.industry.StrongReferenceSet", 80);
            building.wrapComment("@see tv.amwa.maj.industry.WeakReferenceSet", 80);
            if (typeList.containsKey(this.elementType)) {
                building.wrapComment("@see #" + this.elementType, 80);
            } else {
                building.wrapComment("@see tv.amwa.maj.industry.TypeDefinitions#" + this.elementType, 80);
            }
            building.endComment();
            building.append("public final static TypeDefinitionSet " + this.name + " = new TypeDefinitionSetImpl(");
            super.appendTypeDescription(building);
            building.append("        \"" + this.name + "\",");
            if (typeList.containsKey(this.elementType)) {
                building.appendNL("        " + this.elementType + ");");
            } else {
                building.appendNL("        tv.amwa.maj.industry.TypeDefinitions." + this.elementType + ");");
            }
        }
    }

    protected static class TypeDataRename
    extends TypeData {
        String renamedType;

        @Override
        String getJavaGetName() {
            return GenerationCore.typeByName(this.renamedType).getJavaGetName();
        }

        @Override
        String getJavaSetName(boolean optional) {
            return GenerationCore.typeByName(this.renamedType).getJavaSetName(optional);
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.Rename;
        }

        @Override
        String getAnnotation() {
            return this.renamedType;
        }

        @Override
        String[] getImports() {
            return GenerationCore.typeByName(this.renamedType).getImports();
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionRename");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionRenameImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", an alias for type definition " + GenerationCore.camelToWords(this.renamedType) + ".</p>", 80);
            }
            building.blankComment();
            if (typeList.containsKey(this.renamedType)) {
                building.wrapComment("@see #" + this.renamedType, 80);
            } else {
                building.wrapComment("@see tv.amwa.maj.industry.TypeDefinitions#" + this.renamedType, 80);
            }
            building.endComment();
            building.append("public final static TypeDefinitionRename " + this.name + " = new TypeDefinitionRenameImpl(");
            super.appendTypeDescription(building);
            building.append("        \"" + this.name + "\",");
            if (typeList.containsKey(this.renamedType)) {
                building.appendNL("        " + this.renamedType + ");");
            } else {
                building.appendNL("        tv.amwa.maj.industry.TypeDefinitions." + this.renamedType + ");");
            }
        }
    }

    protected static class TypeDataRecord
    extends TypeData {
        List<String> memberNames = new Vector<String>();
        List<String> memberTypes = new Vector<String>();

        @Override
        String getJavaGetName() {
            TypeDefinitionRecordImpl externalType = (TypeDefinitionRecordImpl)Warehouse.lookForType(this.name);
            if (externalType != null) {
                return externalType.getSpecification().getSimpleName();
            }
            return this.name;
        }

        @Override
        String getJavaSetName(boolean optional) {
            return this.getJavaGetName();
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.Record;
        }

        @Override
        public String[] getImports() {
            try {
                TypeDefinitionRecordImpl externalType = (TypeDefinitionRecordImpl)Warehouse.lookForType(this.name);
                if (externalType != null) {
                    return new String[]{externalType.getSpecification().getCanonicalName()};
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return NoImports;
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionRecord");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionRecordImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", a record type definition.</p>", 80);
            }
            building.blankComment();
            building.wrapComment("@see " + this.name, 80);
            building.wrapComment("@see Factory#parse" + this.name + "(String)", 80);
            building.endComment();
            building.append("public final static TypeDefinitionRecord " + this.name + " = new TypeDefinitionRecordImpl(");
            super.appendTypeDescription(building);
            building.append("        \"" + this.name + "\",");
            building.append("        " + building.getPackageName() + "." + this.name + ".MEMBER_NAMES,");
            building.append("        " + building.getPackageName() + "." + this.name + ".MEMBER_TYPES,");
            building.appendNL("        " + this.name + ".class);");
        }
    }

    protected static class TypeDataOpaque
    extends TypeData {
        static final String[] bufferImport = new String[]{"java.nio.ByteBuffer"};

        @Override
        String getJavaGetName() {
            return "ByteBuffer";
        }

        @Override
        String getJavaSetName(boolean optional) {
            return "ByteBuffer";
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.Opaque;
        }

        @Override
        public String[] getImports() {
            return bufferImport;
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionOpaque");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionOpaqueImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", an opaque type definition.</p>", 80);
            }
            building.endComment();
            building.append("public final static TypeDefinitionOpaque " + this.name + " = new TypeDefinitionOpaqueImpl(");
            super.appendTypeDescription(building);
            building.appendNL("        \"" + this.name + "\");");
        }
    }

    protected static class TypeDataInteger
    extends TypeData {
        int size;
        boolean isSigned;

        @Override
        String getJavaGetName() {
            switch (this.size) {
                case 1: {
                    return "byte";
                }
                case 2: {
                    return "short";
                }
                case 4: {
                    return "int";
                }
                case 8: {
                    return "long";
                }
            }
            return "int";
        }

        @Override
        String getJavaSetName(boolean optional) {
            switch (this.size) {
                case 1: {
                    return optional ? "Byte" : "byte";
                }
                case 2: {
                    return optional ? "Short" : "short";
                }
                case 4: {
                    return optional ? "Integer" : "integer";
                }
                case 8: {
                    return optional ? "Long" : "long";
                }
            }
            return optional ? "Integer" : "int";
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.Int;
        }

        @Override
        boolean getThrowsIllegal() {
            return !this.isSigned;
        }

        @Override
        String getAnnotation() {
            switch (this.size) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return (this.isSigned ? "" : "U") + "Int" + this.size * 8;
                }
            }
            return null;
        }

        @Override
        public String[] getImports() {
            switch (this.size) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return new String[]{"tv.amwa.maj.integer." + this.getAnnotation()};
                }
            }
            return NoImports;
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionInteger");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionIntegerImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", an integer type definition.</p>", 80);
            }
            building.endComment();
            building.append("public final static TypeDefinitionInteger " + this.name + " = new TypeDefinitionIntegerImpl(");
            super.appendTypeDescription(building);
            building.append("        \"" + this.name + "\",");
            building.append("        (byte) " + this.size + ",");
            building.appendNL("        " + this.isSigned + ");");
        }
    }

    protected static class TypeDataIndirect
    extends TypeData {
        static final String[] propertyValueImports = new String[]{"tv.amwa.maj.industry.PropertyValue"};

        @Override
        String getJavaGetName() {
            return "PropertyValue";
        }

        @Override
        String getJavaSetName(boolean optional) {
            return "PropertyValue";
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.Indirect;
        }

        @Override
        public String[] getImports() {
            return propertyValueImports;
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionIndirect");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionIndirectImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", an indirect type definition.</p>", 80);
            }
            building.endComment();
            building.append("public final static TypeDefinitionIndirect " + this.name + " = new TypeDefinitionIndirectImpl(");
            super.appendTypeDescription(building);
            building.appendNL("        \"" + this.name + "\");");
        }
    }

    protected static class TypeDataFixedArray
    extends TypeData {
        public int elementCount;
        public String elementType;

        @Override
        String getJavaGetName() {
            return GenerationCore.typeByName(this.elementType).getJavaGetName() + "[]";
        }

        @Override
        String getJavaSetName(boolean optional) {
            return GenerationCore.typeByName(this.elementType).getJavaSetName(optional) + "[]";
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.FixedArray;
        }

        @Override
        public String getAnnotation() {
            return GenerationCore.typeByName(this.elementType).getAnnotation();
        }

        @Override
        public String[] getImports() {
            return GenerationCore.typeByName(this.elementType).getImports();
        }

        @Override
        boolean getThrowsIllegal() {
            return GenerationCore.typeByName(this.elementType).getThrowsIllegal();
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionFixedArray");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionFixedArrayImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", a fixed array with " + this.elementCount + " elements of " + GenerationCore.camelToWords(this.elementType) + ".</p>", 80);
            }
            building.blankComment();
            if (typeList.containsKey(this.elementType)) {
                building.wrapComment("@see #" + this.elementType, 80);
            } else {
                building.wrapComment("@see tv.amwa.maj.industry.TypeDefintions#" + this.elementType, 80);
            }
            building.endComment();
            building.append("public final static TypeDefinitionFixedArray " + this.name + " = new TypeDefinitionFixedArrayImpl(");
            super.appendTypeDescription(building);
            building.append("        \"" + this.name + "\",");
            if (typeList.containsKey(this.elementType)) {
                building.append("        " + this.elementType + ",");
            } else {
                building.append("        tv.amwa.maj.industry.TypeDefinitions." + this.elementType + ",");
            }
            building.appendNL("        " + this.elementCount + ");");
        }
    }

    protected static class TypeDataExtendibleEnumeration
    extends TypeData {
        @Override
        String getJavaGetName() {
            return "AUID";
        }

        @Override
        String getJavaSetName(boolean optional) {
            return "AUID";
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.ExtEnum;
        }

        @Override
        boolean getThrowsIllegal() {
            return true;
        }

        @Override
        public String[] getImports() {
            return new String[]{"tv.amwa.maj.record.AUID"};
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionExtendibleEnumeration");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionExtendibleEnumerationImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", an extendible enumeration type definition.</p>", 80);
            }
            building.blankComment();
            building.wrapComment("@see " + this.name, 80);
            building.endComment();
            building.append("public final static TypeDefinitionExtendibleEnumeration " + this.name + " = new TypeDefinitionExtendibleEnumerationImpl(");
            super.appendTypeDescription(building);
            building.append("        \"" + this.name + "\",");
            building.appendNL("        \"" + this.symbol + "\");");
        }
    }

    protected static class TypeDataEnumeration
    extends TypeData {
        String elementType;
        List<String> names = new Vector<String>();
        List<String> values = new Vector<String>();

        @Override
        String getJavaGetName() {
            return this.name.equals("Boolean") ? "boolean" : this.name;
        }

        @Override
        String getJavaSetName(boolean optional) {
            if (this.name.equals("Boolean")) {
                return optional ? "Boolean" : "boolean";
            }
            return this.name;
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.Enum;
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionEnumeration");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionEnumerationImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", an enumeration type definition.</p>", 80);
            }
            building.blankComment();
            building.wrapComment("@see " + this.name, 80);
            building.endComment();
            building.append("public final static TypeDefinitionEnumeration " + this.name + " = new TypeDefinitionEnumerationImpl(");
            super.appendTypeDescription(building);
            building.append("        \"" + this.name + "\",");
            building.append("        " + this.name + ".class,");
            if (typeList.containsKey(this.elementType)) {
                building.appendNL("        " + this.elementType + ");");
            } else {
                building.appendNL("        tv.amwa.maj.industry.TypeDefinitions." + this.elementType + ");");
            }
        }
    }

    protected static class TypeDataCharacter
    extends TypeData {
        @Override
        String getJavaGetName() {
            return "char";
        }

        @Override
        String getJavaSetName(boolean optional) {
            return optional ? "Character" : "char";
        }

        @Override
        TypeCategory getTypeCategory() {
            return TypeCategory.Character;
        }

        @Override
        void appendTypeDescription(StringIndenter building) {
            building.addImport("tv.amwa.maj.meta.TypeDefinitionCharacter");
            building.addImport("tv.amwa.maj.meta.impl.TypeDefinitionCharacterImpl");
            building.startJavadoc();
            if (this.description != null && this.description.length() > 0) {
                building.wrapComment("<p>" + this.description + "</p>", 80);
            } else {
                building.wrapComment("<p>" + GenerationCore.upperFirstLetter(GenerationCore.camelToWords(this.name)) + ", a character type definition.</p>", 80);
            }
            building.endComment();
            building.append("public final static TypeDefinitionCharacter " + this.name + " = new TypeDefinitionCharacterImpl(");
            super.appendTypeDescription(building);
            building.appendNL("        \"" + this.name + "\");");
        }
    }

    protected static abstract class TypeData
    extends MetaData {
        abstract String getJavaGetName();

        abstract String getJavaSetName(boolean var1);

        abstract TypeCategory getTypeCategory();

        boolean getThrowsIllegal() {
            return false;
        }

        String getAnnotation() {
            return null;
        }

        void appendTypeDescription(StringIndenter building) {
            building.append("        Forge.makeAUID(0x" + GenerationCore.padHexTo8(this.identification.getData1()) + ", (short) 0x" + GenerationCore.padHexTo4(this.identification.getData2()) + ", (short) 0x" + GenerationCore.padHexTo4(this.identification.getData3()) + ",");
            building.append("                new byte[] { " + GenerationCore.bytesToText(this.identification.getData4()) + " }),");
        }
    }

    protected static class PropertyData
    extends MetaData {
        String memberOf = "";
        String type = "";
        boolean isOptional = true;
        boolean isUniqueIdentifier = false;
        short localIdentification = 0;
    }

    protected static class ClassData
    extends MetaData {
        String parentClass = "";
        boolean isConcrete = true;

        public boolean isInterchangeable() {
            if (this.name.equals("InterchangeObject")) {
                return true;
            }
            if (this.isRoot()) {
                return false;
            }
            return classList.get(this.parentClass).isInterchangeable();
        }

        public boolean isRoot() {
            return this.parentClass == null || this.parentClass == "" || this.parentClass.equals(this.name);
        }
    }

    protected static abstract class MetaData {
        String name = "";
        String symbol = "";
        String description = "";
        AUID identification = null;

        public String toString() {
            return this.name;
        }

        String[] getImports() {
            return NoImports;
        }
    }
}

