/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.ColorSitingType;
import tv.amwa.maj.enumeration.LayoutType;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.Int64;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.misctype.VideoLineMap;
import tv.amwa.maj.model.CDCIDescriptor;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.impl.PictureDescriptorImpl;
import tv.amwa.maj.record.Rational;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=10240, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="CDCIDescriptor", description="The CDCIDescriptor class specifies that a file SourcePackage is associated with video essence formatted with one luminance component and two color-difference components as specified in this document.", symbol="CDCIDescriptor")
public class CDCIDescriptorImpl
extends PictureDescriptorImpl
implements CDCIDescriptor,
tv.amwa.maj.extensions.avid.CDCIDescriptor,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = 710646891409730144L;
    private Integer alphaSampleDepth = null;
    private Integer blackRefLevel = null;
    private ColorSitingType colorSiting = null;
    private Integer colorRange = null;
    private int componentDepth;
    private int horizontalSubsampling;
    private Short paddingBits = null;
    private Boolean reversedByteOrder = null;
    private Integer verticalSubsampling = null;
    private Integer whiteRefLevel = null;
    private int maximumLevel = 0;
    @Int64
    private Long offsetToFrameIndexes64 = null;

    public CDCIDescriptorImpl() {
    }

    public CDCIDescriptorImpl(ContainerDefinition containerFormat, @UInt32 int storedHeight, @UInt32 int storedWidth, LayoutType frameLayout, @VideoLineMap int[] videoLineMap, Rational imageAspectRatio, @UInt32 int horizontalSubsampling, @UInt32 int componentDepth) throws NullPointerException, IllegalArgumentException {
        if (frameLayout == null) {
            throw new NullPointerException("Cannot create a CDCI descriptor using a null frame layout value.");
        }
        if (videoLineMap == null) {
            throw new NullPointerException("Cannot create a CDCI descriptor using a null video line map value.");
        }
        if (imageAspectRatio == null) {
            throw new NullPointerException("Cannot create a CDCI descriptor using a null image aspect ratio.");
        }
        this.setContainerFormat(containerFormat);
        this.setStoredView(storedHeight, storedWidth);
        this.setFrameLayout(frameLayout);
        this.setVideoLineMap(videoLineMap);
        this.setImageAspectRatio(imageAspectRatio);
        this.setHorizontalSubsampling(horizontalSubsampling);
        this.setComponentDepth(componentDepth);
        this.setWhiteRefLevel(null);
        this.setColorRange(null);
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=1792, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="AlphaSampleDepth", aliases={"AlphaSamplingWidth"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=13065, symbol="AlphaSampleDepth")
    public int getAlphaSampleDepth() {
        if (this.alphaSampleDepth == null) {
            return 0;
        }
        return this.alphaSampleDepth;
    }

    @Override
    @MediaPropertySetter(value="AlphaSampleDepth")
    public void setAlphaSampleDepth(Integer alphaSampleDepth) throws IllegalArgumentException {
        if (alphaSampleDepth == null) {
            this.alphaSampleDepth = null;
            return;
        }
        if (alphaSampleDepth < 0) {
            throw new IllegalArgumentException("Cannot set a negative alpha sampling width value for this CDCI descriptor.");
        }
        this.alphaSampleDepth = alphaSampleDepth;
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="BlackRefLevel", aliases={"BlackReferenceLevel"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=13060, symbol="BlackRefLevel")
    public int getBlackRefLevel() {
        if (this.blackRefLevel == null) {
            return 0;
        }
        return this.blackRefLevel;
    }

    @Override
    public void setBlackRefLevel(Integer blackRefLevel) throws IllegalArgumentException {
        if (blackRefLevel == null) {
            this.blackRefLevel = null;
            return;
        }
        if (blackRefLevel < 0 || blackRefLevel > this.maximumLevel) {
            throw new IllegalArgumentException("Cannot set the black reference level of this CDCI descriptor to a negative value or greater than the maximum range for the component size.");
        }
        this.blackRefLevel = blackRefLevel;
    }

    @MediaPropertySetter(value="BlackRefLevel")
    public void setBlackRefLevelFromStream(Integer blackRefLevel) throws IllegalArgumentException {
        if (blackRefLevel == null) {
            this.blackRefLevel = null;
            return;
        }
        if (blackRefLevel < 0) {
            throw new IllegalArgumentException("Cannot set the black reference level of this CDCI descriptor to a negative value.");
        }
        this.blackRefLevel = blackRefLevel;
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ColorRange", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=13062, symbol="ColorRange")
    public int getColorRange() {
        if (this.colorRange == null) {
            return this.maximumLevel;
        }
        return this.colorRange;
    }

    @Override
    public void setColorRange(Integer colorRange) throws IllegalArgumentException {
        if (colorRange == null) {
            this.colorRange = null;
            return;
        }
        if (colorRange < 0 || colorRange > this.maximumLevel) {
            throw new IllegalArgumentException("Cannot set the color range of this CDCI descriptor to a negative value or a value greater than that allowable for the component size.");
        }
        this.colorRange = colorRange;
    }

    @MediaPropertySetter(value="ColorRange")
    public void setColorRangeFromStream(Integer colorRange) throws IllegalArgumentException {
        if (colorRange == null) {
            this.colorRange = null;
            return;
        }
        if (colorRange < 0) {
            throw new IllegalArgumentException("Cannot set the color range of this CDCI descriptor to a negative value.");
        }
        this.colorRange = colorRange;
    }

    @Override
    @MediaProperty(uuid1=67175681, uuid2=1536, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="ColorSiting", typeName="ColorSitingType", optional=true, uniqueIdentifier=false, pid=13059, symbol="ColorSiting")
    public ColorSitingType getColorSiting() {
        if (this.colorSiting == null) {
            return COLORSITING_DEFAULT;
        }
        return this.colorSiting;
    }

    @Override
    @MediaPropertySetter(value="ColorSiting")
    public void setColorSiting(ColorSitingType colorSiting) {
        this.colorSiting = colorSiting;
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=2560, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ComponentDepth", aliases={"ComponentWidth"}, typeName="UInt32", optional=false, uniqueIdentifier=false, pid=13057, symbol="ComponentDepth")
    public int getComponentDepth() {
        return this.componentDepth;
    }

    @Override
    @MediaPropertySetter(value="ComponentDepth")
    public void setComponentDepth(int componentDepth) throws IllegalArgumentException {
        if (componentDepth < 0) {
            throw new IllegalArgumentException("Cannot set the component depth of this CDCI descriptor to a negative value.");
        }
        this.componentDepth = componentDepth;
        this.calculateMaximumLevel();
    }

    public static final int initializeComponentDepth() {
        return 0;
    }

    @Override
    @MediaProperty(uuid1=67175681, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="HorizontalSubsampling", typeName="UInt32", optional=false, uniqueIdentifier=false, pid=13058, symbol="HorizontalSubsampling")
    public int getHorizontalSubsampling() {
        return this.horizontalSubsampling;
    }

    @Override
    @MediaPropertySetter(value="HorizontalSubsampling")
    public void setHorizontalSubsampling(int horizontalSubsampling) throws IllegalArgumentException {
        if (horizontalSubsampling < 0) {
            throw new IllegalArgumentException("Cannot set the horizontal subsampling value of this CDCI descriptor with a negative value.");
        }
        this.horizontalSubsampling = horizontalSubsampling;
    }

    public static final int initializeHorizontalSubsampling() {
        return 0;
    }

    @Override
    @MediaProperty(uuid1=68681988, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PaddingBits", typeName="Int16", optional=true, uniqueIdentifier=false, pid=13063, symbol="PaddingBits")
    public short getPaddingBits() {
        if (this.paddingBits == null) {
            return 0;
        }
        return this.paddingBits;
    }

    @Override
    @MediaPropertySetter(value="PaddingBits")
    public void setPaddingBits(Short paddingBits) {
        this.paddingBits = paddingBits;
    }

    @Override
    @MediaProperty(uuid1=50397697, uuid2=2560, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="ReversedByteOrder", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=13067, symbol="ReversedByteOrder")
    public boolean getReversedByteOrder() {
        if (this.reversedByteOrder == null) {
            return false;
        }
        return this.reversedByteOrder;
    }

    @Override
    @MediaPropertySetter(value="ReversedByteOrder")
    public void setReversedByteOrder(Boolean reversedByteOrder) {
        this.reversedByteOrder = reversedByteOrder;
    }

    @Override
    @MediaProperty(uuid1=67175681, uuid2=4096, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="VerticalSubsampling", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=13064, symbol="VerticalSubsampling")
    public int getVerticalSubsampling() {
        if (this.verticalSubsampling == null) {
            return 1;
        }
        return this.verticalSubsampling;
    }

    @Override
    @MediaPropertySetter(value="VerticalSubsampling")
    public void setVerticalSubsampling(Integer verticalSubsampling) throws IllegalArgumentException {
        if (verticalSubsampling == null) {
            this.verticalSubsampling = null;
            return;
        }
        if (verticalSubsampling < 0) {
            throw new IllegalArgumentException("Cannot set the vertical subsampling value of thsi CDCI descriptor to a negative value.");
        }
        this.verticalSubsampling = verticalSubsampling;
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="WhiteRefLevel", aliases={"WhiteReferenceLevel"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=13061, symbol="WhiteRefLevel")
    public int getWhiteRefLevel() {
        if (this.whiteRefLevel == null) {
            return this.maximumLevel;
        }
        return this.whiteRefLevel;
    }

    @Override
    public void setWhiteRefLevel(Integer whiteRefLevel) throws IllegalArgumentException {
        if (whiteRefLevel == null) {
            this.whiteRefLevel = null;
            return;
        }
        if (whiteRefLevel < 0 || whiteRefLevel > this.maximumLevel) {
            throw new IllegalArgumentException("Cannot set the white reference level of this CDCI descriptor to a negative value or greater than the maximum range for the component size.");
        }
        this.whiteRefLevel = whiteRefLevel;
    }

    @MediaPropertySetter(value="WhiteRefLevel")
    public void setWhiteRefLevelFromStream(Integer whiteRefLevel) throws IllegalArgumentException {
        if (whiteRefLevel == null) {
            this.whiteRefLevel = null;
            return;
        }
        if (whiteRefLevel < 0) {
            throw new IllegalArgumentException("Cannot set the white reference level of this CDCI descriptor to a negative value.");
        }
        this.whiteRefLevel = whiteRefLevel;
    }

    private void calculateMaximumLevel() {
        this.maximumLevel = (1 << this.componentDepth) - 1;
    }

    @Override
    public CDCIDescriptor clone() {
        return (CDCIDescriptor)super.clone();
    }

    @Override
    @MediaProperty(uuid1=697217632, uuid2=12470, uuid3=20016, uuid4={-116, -112, -49, 99, -86, 121, 60, 52}, definedName="OffsetToFrameIndexes64", typeName="Int64", optional=true, uniqueIdentifier=false, pid=0, symbol="OffsetToFrameIndexes64", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    @Int64
    public long getOffsetToFrameIndexes64() throws PropertyNotPresentException {
        if (this.offsetToFrameIndexes64 == null) {
            throw new NullPointerException("The optional offset to frame indexes 64 property is not present for this CDCI descriptor.");
        }
        return this.offsetToFrameIndexes64;
    }

    @Override
    @MediaPropertySetter(value="OffsetToFrameIndexes64")
    public void setOffsetToFrameIndexes64(@Int64 Long offsetToFrameIndexes64) {
        this.offsetToFrameIndexes64 = offsetToFrameIndexes64;
    }
}

