/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.record.impl;

import java.io.Serializable;
import java.text.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.record.Rational;

public final class RationalImpl
extends Number
implements Rational,
Serializable,
XMLSerializable,
Cloneable,
Comparable<Rational> {
    private static final long serialVersionUID = -7948422399183603311L;
    @Int32
    private int numerator;
    @Int32
    private int denominator;
    public static final String MYSQL_COLUMN_DEFINITION = "VARCHAR(30) CHARACTER SET ascii COLLATE ascii_general_ci";

    public RationalImpl(@Int32 int numerator, @Int32 int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public static final RationalImpl parseFactory(String rationalAsString) throws NullPointerException, ParseException {
        int denominator;
        int numerator;
        if (rationalAsString == null) {
            throw new NullPointerException("Cannot create a rational value from a null string.");
        }
        int slashIndex = rationalAsString.indexOf(47);
        if (slashIndex == -1) {
            throw new ParseException("The given string does not contain the required slash ('/') separator character for a rational value.", 0);
        }
        String topNumber = rationalAsString.substring(0, slashIndex);
        String bottomNumber = rationalAsString.substring(slashIndex + 1);
        try {
            numerator = Integer.parseInt(topNumber);
        }
        catch (NumberFormatException nfeNumerator) {
            throw new ParseException("Number format exception thrown when parsing numerator: " + nfeNumerator.getMessage(), 0);
        }
        try {
            denominator = Integer.parseInt(bottomNumber);
        }
        catch (NumberFormatException nfeDenominator) {
            throw new ParseException("Number foramt exception thrown when parsing denominator:" + nfeDenominator.getMessage(), 0);
        }
        return new RationalImpl(numerator, denominator);
    }

    public RationalImpl() {
        this.numerator = 0;
        this.denominator = 1;
    }

    @Override
    @Int32
    public final int getDenominator() {
        return this.denominator;
    }

    @Override
    public final void setDenominator(@Int32 int denominator) {
        this.denominator = denominator;
    }

    @Override
    @Int32
    public final int getNumerator() {
        return this.numerator;
    }

    @Override
    public final void setNumerator(@Int32 int numerator) {
        this.numerator = numerator;
    }

    @Override
    public final void setRational(@Int32 int numerator, @Int32 int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public final int hashCode() {
        return this.numerator ^ this.denominator;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Rational)) {
            return false;
        }
        Rational testRational = (Rational)o;
        if (testRational.getDenominator() != this.denominator) {
            return false;
        }
        return testRational.getNumerator() == this.numerator;
    }

    @Override
    public final String toString() {
        return this.numerator + "/" + this.denominator;
    }

    @Override
    public final double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    @Override
    public final float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    @Override
    public final int intValue() throws ArithmeticException {
        return this.numerator / this.denominator;
    }

    @Override
    public final long longValue() throws ArithmeticException {
        return (long)this.numerator / (long)this.denominator;
    }

    @Override
    public final int compareTo(Rational o) throws NullPointerException {
        double testValue;
        if (o == null) {
            throw new NullPointerException("The given value to compare with this rational value is null.");
        }
        double thisValue = this.doubleValue();
        if (thisValue < (testValue = (double)o.getNumerator() / (double)o.getDenominator())) {
            return -1;
        }
        if (thisValue > testValue) {
            return 1;
        }
        return 0;
    }

    public final int compareToNumber(Number n) throws NullPointerException {
        double testValue;
        double thisValue = this.doubleValue();
        if (thisValue < (testValue = n.doubleValue())) {
            return -1;
        }
        if (thisValue > testValue) {
            return 1;
        }
        return 0;
    }

    @Override
    public final Rational clone() {
        try {
            return (Rational)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    @Override
    public void appendXMLChildren(Node parent) {
        Document document = parent.getOwnerDocument();
        Text rationalText = document.createTextNode(this.toString());
        parent.appendChild(rationalText);
    }

    @Override
    public String getComment() {
        return null;
    }

    public static final String toPersistentForm(Rational rational) {
        if (rational == null) {
            return null;
        }
        return rational.toString();
    }

    public static final Rational fromPersistentForm(String rational) {
        if (rational == null) {
            return null;
        }
        try {
            return RationalImpl.parseFactory(rational);
        }
        catch (ParseException pe) {
            return null;
        }
    }
}

