/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.enumeration;

import tv.amwa.maj.industry.MediaEnumerationValue;
import tv.amwa.maj.integer.Int16;
import tv.amwa.maj.integer.Int64;

public enum ByteOrder implements MediaEnumerationValue
{
    Little(0),
    Big(1);

    private final int value;

    private ByteOrder(int value) {
        this.value = value;
    }

    @Override
    @Int64
    public long value() {
        return this.value;
    }

    @Override
    public String symbol() {
        return this.name() + "Endian";
    }

    @Int16
    public short getAAFByteOrderCode() {
        if (this.value == 1) {
            return 19789;
        }
        return 18761;
    }

    public static final ByteOrder getByteOrderFromAAFCode(@Int16 short code) throws IllegalArgumentException {
        switch (code) {
            case 18761: 
            case 19532: 
            case 27756: {
                return Little;
            }
            case 19789: 
            case 28013: {
                return Big;
            }
        }
        throw new IllegalArgumentException("Unknown byte order code. Should be one of 'II' or 'MM'.");
    }
}

