/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import tv.amwa.maj.exception.InvalidParameterException;
import tv.amwa.maj.exception.ObjectNotAttachedException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyContains;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertyRemove;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.model.ApplicationPluginObject;
import tv.amwa.maj.model.Identification;
import tv.amwa.maj.model.InterchangeObject;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=256, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="InterchangeObject", description="The InterchangeObject class is a root class. All classes defined in an AAF file shall be sub-classes of InterchangeObject with the exception of the MetaDefinition classes defined by this document.", symbol="InterchangeObject", namespace="http://www.smpte-ra.org/schemas/2001-2/2007/aaf", prefix="aaf", aliases={"AAFObject"}, isConcrete=false)
public class InterchangeObjectImpl
implements InterchangeObject,
Serializable,
Cloneable {
    private static final long serialVersionUID = 4120720187157154133L;
    private AUID originalAUID = null;
    private AUID linkedGenerationID = null;
    private boolean generationTracking = false;
    private WeakReference<ClassDefinition> objectClass = null;
    private Long persistentID = null;
    private int persistentIndex = 0;
    private Map<AUID, ApplicationPluginObject> applicationPlugins = null;
    public static final AUID ObjectClassPropertyID = new AUIDImpl(100729092, 257, 0, new byte[]{6, 14, 43, 52, 1, 1, 1, 2});

    @Override
    public void setOriginalAUID(AUID originalAUID) {
        this.originalAUID = originalAUID;
    }

    @Override
    public AUID getOriginalAUID() {
        return this.originalAUID;
    }

    @Override
    public void disableGenerationTracking() {
        this.linkedGenerationID = null;
        this.generationTracking = false;
    }

    @Override
    public void enableGenerationTracking() {
        this.linkedGenerationID = new AUIDImpl(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        this.generationTracking = true;
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=257, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ObjectClass", aliases={"ObjClass"}, typeName="ClassDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=257, symbol="ObjectClass")
    public ClassDefinition getObjectClass() {
        if (this.objectClass == null) {
            this.objectClass = new WeakReference<ClassDefinition>(Warehouse.lookForClass(this.getClass()));
        }
        return this.objectClass.getTarget();
    }

    @Override
    @MediaPropertySetter(value="ObjectClass")
    public void setObjectClass(ClassDefinition objectClass) {
        if (objectClass == null) {
            this.objectClass = null;
            return;
        }
        this.objectClass = new WeakReference<ClassDefinition>(objectClass);
    }

    @Override
    public Identification getGeneration() throws InvalidParameterException, ObjectNotAttachedException {
        throw new ObjectNotAttachedException("This object has not been accessed through a preface.");
    }

    @Override
    @MediaProperty(uuid1=85985025, uuid2=2048, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="LinkedGenerationID", aliases={"Generation"}, typeName="AUID", optional=true, uniqueIdentifier=false, pid=258, symbol="LinkedGenerationID")
    public AUID getLinkedGenerationID() throws PropertyNotPresentException, ObjectNotAttachedException {
        if (!this.generationTracking) {
            throw new PropertyNotPresentException("Generation tracking is not enabled so the optional linked generation property is not present.");
        }
        if (this.linkedGenerationID.isNil()) {
            throw new ObjectNotAttachedException("This object is not attached to a file.");
        }
        return this.linkedGenerationID;
    }

    @Override
    @MediaPropertySetter(value="LinkedGenerationID")
    public void setLinkedGenerationID(AUID linkedGenerationID) {
        if (linkedGenerationID == null) {
            this.linkedGenerationID = null;
            this.generationTracking = false;
            return;
        }
        this.linkedGenerationID = linkedGenerationID.clone();
        if (!linkedGenerationID.isNil()) {
            this.generationTracking = true;
        }
    }

    void onSave(AUID generationAUID) {
        if (this.generationTracking) {
            this.linkedGenerationID = generationAUID;
        }
    }

    @Override
    public boolean isGenerationTracked() {
        return this.generationTracking;
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=526, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="ApplicationPlugins", aliases={"ApplicationPlugIns", "ApplicationPlug-InBatch", "ApplicationPlug-In Batch"}, typeName="ApplicationPluginObjectStrongReferenceSet", pid=0, symbol="ApplicationPlugins", optional=true, uniqueIdentifier=false, description="Set of application metadata plugins attached to this interchange object, where each attached object contains application-specific description.")
    public Set<ApplicationPluginObject> getApplicationPlugins() throws PropertyNotPresentException {
        if (this.applicationPlugins == null) {
            throw new PropertyNotPresentException("The optional application plugins property is not present for this interchange object.");
        }
        return new HashSet<ApplicationPluginObject>(this.applicationPlugins.values());
    }

    @Override
    @MediaSetAdd(value="ApplicationPlugins")
    public void addApplicationPlugin(ApplicationPluginObject applicationPlugin) throws NullPointerException {
        if (applicationPlugin == null) {
            throw new NullPointerException("Cannot add an application plugin using a null value.");
        }
        if (this.applicationPlugins == null) {
            this.applicationPlugins = Collections.synchronizedMap(new HashMap());
        }
        this.applicationPlugins.put(applicationPlugin.getApplicationPluginInstanceID(), applicationPlugin);
    }

    @Override
    @MediaPropertyContains(value="ApplicationPlugins")
    public boolean containsApplicationPlugin(ApplicationPluginObject applicationPlugin) throws NullPointerException {
        if (applicationPlugin == null) {
            throw new NullPointerException("Cannot check for an application plugin using a null value.");
        }
        if (this.applicationPlugins == null) {
            return false;
        }
        return this.applicationPlugins.containsKey(applicationPlugin.getApplicationPluginInstanceID());
    }

    @Override
    public boolean containsApplicationPlugin(AUID applicationPluginInstanceID) throws NullPointerException {
        if (applicationPluginInstanceID == null) {
            throw new NullPointerException("Cannot check for an application plugin using a null value.");
        }
        if (this.applicationPlugins == null) {
            return false;
        }
        return this.applicationPlugins.containsKey(applicationPluginInstanceID);
    }

    @Override
    @MediaPropertyClear(value="ApplicationPlugins")
    public void clearApplicationPlugins() {
        if (this.applicationPlugins != null) {
            this.applicationPlugins.clear();
        }
    }

    @Override
    @MediaPropertyCount(value="ApplicationPlugins")
    public int countApplicationPlugins() {
        if (this.applicationPlugins == null) {
            return 0;
        }
        return this.applicationPlugins.size();
    }

    @Override
    @MediaPropertyRemove(value="ApplicationPlugins")
    public boolean removeApplicationPlugin(ApplicationPluginObject applicationPlugin) throws NullPointerException {
        if (applicationPlugin == null) {
            throw new NullPointerException("Cannot remove an application plugin object using a null value.");
        }
        if (this.applicationPlugins == null) {
            return false;
        }
        return this.applicationPlugins.remove(applicationPlugin.getAUID()) != null;
    }

    @Override
    public boolean removeApplicationPlugin(AUID applicationPluginInstanceID) throws NullPointerException {
        if (applicationPluginInstanceID == null) {
            throw new NullPointerException("Cannot remove an application plugin object using a null value.");
        }
        if (this.applicationPlugins == null) {
            return false;
        }
        return this.applicationPlugins.remove(applicationPluginInstanceID) != null;
    }

    @Override
    public final String toString() {
        return MediaEngine.toString(this);
    }

    public int hashCode() {
        return MediaEngine.hashCode(this);
    }

    @Override
    public boolean equals(Object o) {
        return MediaEngine.equals(this, o);
    }

    @Override
    public boolean deepEquals(Object o) {
        return MediaEngine.deepEquals(this, o);
    }

    @Override
    public InterchangeObject clone() {
        try {
            return (InterchangeObject)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    public void appendXMLChildren(Node parent) {
    }

    public String getComment() {
        return null;
    }

    @Override
    public Long getPersistentID() {
        return this.persistentID;
    }

    public void setPersistentID(Long persistentID) {
        this.persistentID = persistentID;
    }

    public int getPersistentIndex() {
        return this.persistentIndex;
    }

    @Override
    public void setPersistentIndex(int index) {
        this.persistentIndex = index;
    }

    public String getLinkedGenerationIDString() {
        return AUIDImpl.toPersistentForm(this.linkedGenerationID);
    }

    public void setLinkedGenerationIDString(String linkedGenerationID) {
        this.linkedGenerationID = AUIDImpl.fromPersistentForm(linkedGenerationID);
    }
}

