/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.record.impl;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.record.TimeStruct;
import tv.amwa.maj.util.Utilities;

public final class TimeStructImpl
implements TimeStruct,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7172172051477239720L;
    private Calendar timeValue;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSSZ");

    public TimeStructImpl(byte hour, byte minute, byte second, byte fraction) throws IllegalArgumentException {
        this.timeValue = new GregorianCalendar();
        this.timeValue.setTimeZone(formatter.getTimeZone());
        this.timeValue.setLenient(false);
        this.setTime(hour, minute, second, fraction);
    }

    public TimeStructImpl(byte hour, byte minute, byte second) throws IllegalArgumentException {
        this.timeValue = new GregorianCalendar();
        this.timeValue.setLenient(false);
        this.setTime(hour, minute, second, (byte)0);
    }

    public TimeStructImpl(Calendar timeItem) throws NullPointerException, IllegalArgumentException {
        this.setTimeValue(timeItem);
    }

    public TimeStructImpl() {
        this.timeValue = new GregorianCalendar();
        this.timeValue.setLenient(false);
    }

    @Override
    public final byte getFraction() {
        return (byte)(this.timeValue.get(14) / 4);
    }

    @Override
    public final void setFraction(byte fraction) throws IllegalArgumentException {
        this.timeValue.clear(14);
        int positiveFraction = fraction >= 0 ? fraction : 256 + fraction;
        this.timeValue.set(14, positiveFraction * 4);
        this.timeValue.getTime();
    }

    @Override
    public final byte getHour() {
        return (byte)this.timeValue.get(11);
    }

    @Override
    public final void setHour(byte hour) throws IllegalArgumentException {
        this.timeValue.clear(11);
        this.timeValue.set(11, hour);
        this.timeValue.getTime();
    }

    @Override
    public final byte getMinute() {
        return (byte)this.timeValue.get(12);
    }

    @Override
    public final void setMinute(byte minute) throws IllegalArgumentException {
        this.timeValue.clear(12);
        this.timeValue.set(12, minute);
        this.timeValue.getTime();
    }

    @Override
    public final byte getSecond() {
        return (byte)this.timeValue.get(13);
    }

    @Override
    public final void setSecond(byte second) throws IllegalArgumentException {
        this.timeValue.clear(13);
        this.timeValue.set(13, second);
        this.timeValue.getTime();
    }

    @Override
    public final void setTime(byte hour, byte minute, byte second) throws IllegalArgumentException {
        this.setTime(hour, minute, second, (byte)0);
    }

    @Override
    public final void setTime(byte hour, byte minute, byte second, byte fraction) throws IllegalArgumentException {
        this.timeValue.clear();
        this.timeValue.set(11, hour);
        this.timeValue.set(12, minute);
        this.timeValue.set(13, second);
        this.timeValue.set(14, fraction * 4);
        this.timeValue.getTime();
    }

    public final void setTimeValue(Calendar timeItem) throws NullPointerException, IllegalArgumentException {
        if (timeItem == null) {
            throw new NullPointerException("Cannot set time value from a null value.");
        }
        timeItem.setLenient(false);
        timeItem.getTime();
        this.timeValue = timeItem;
    }

    public final Calendar getTimeValue() {
        return (Calendar)this.timeValue.clone();
    }

    @Override
    public final String toString() {
        return formatter.format(this.timeValue.getTime());
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TimeStruct)) {
            return false;
        }
        TimeStruct testTime = (TimeStruct)o;
        if (this.getHour() != testTime.getHour()) {
            return false;
        }
        if (this.getMinute() != testTime.getMinute()) {
            return false;
        }
        if (this.getSecond() != testTime.getSecond()) {
            return false;
        }
        return this.getFraction() == testTime.getFraction();
    }

    public final int hashCode() {
        return this.getHour() << 24 | this.getMinute() << 16 | this.getSecond() << 8 | this.getFraction();
    }

    @Override
    public final TimeStruct clone() {
        try {
            TimeStructImpl cloned = (TimeStructImpl)super.clone();
            cloned.setTimeValue(this.getTimeValue());
            return cloned;
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    public static final TimeStructImpl parseFactory(String time) throws ParseException, NullPointerException {
        if (time == null) {
            throw new NullPointerException("Cannot create time value from a null string.");
        }
        int lastDot = time.lastIndexOf(46);
        if (lastDot > 0 && lastDot < time.length() - 3 && !Character.isDigit(time.charAt(lastDot + 3))) {
            time = time.substring(0, lastDot + 3) + "0" + time.substring(lastDot + 3);
        }
        if (time.endsWith("Z")) {
            time = time.substring(0, time.length() - 1) + "+0000";
        }
        if (lastDot == -1 && time.length() > 5) {
            time = time.substring(0, time.length() - 5) + ".000" + time.substring(time.length() - 5);
        }
        formatter.setLenient(false);
        Date parsedDate = formatter.parse(time);
        GregorianCalendar calenderValue = new GregorianCalendar();
        calenderValue.clear();
        calenderValue.setTimeZone(formatter.getTimeZone());
        calenderValue.setTime(parsedDate);
        return new TimeStructImpl(calenderValue);
    }

    public static final void generateEmbeddableORM(Node parent, String namespace, String prefix) {
        Element embeddable = XMLBuilder.createChild(parent, namespace, prefix, "embeddable");
        XMLBuilder.setAttribute(embeddable, namespace, prefix, "class", TimeStructImpl.class.getCanonicalName());
        XMLBuilder.setAttribute(embeddable, namespace, prefix, "access", "FIELD");
        Element embeddableAttributes = XMLBuilder.createChild(embeddable, namespace, prefix, "attributes");
        Element basic = XMLBuilder.createChild(embeddableAttributes, namespace, prefix, "basic");
        XMLBuilder.setAttribute(basic, namespace, prefix, "name", "timeValue");
        XMLBuilder.appendElement((Node)basic, namespace, prefix, "temporal", "TIME");
    }

    public static final void generateEmbeddedORM(Node parent, String ownerName, String namespace, String prefix) {
        Element embedded = XMLBuilder.createChild(parent, namespace, prefix, "embedded");
        XMLBuilder.setAttribute(embedded, namespace, prefix, "name", Utilities.lowerFirstLetter(ownerName));
        Element attributeOverride = XMLBuilder.createChild(embedded, namespace, prefix, "attribute-override");
        XMLBuilder.setAttribute(attributeOverride, namespace, prefix, "name", "timeValue");
        Element column = XMLBuilder.createChild(attributeOverride, namespace, prefix, "column");
        XMLBuilder.setAttribute(column, namespace, prefix, "name", ownerName);
    }

    static {
        formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
    }
}

