/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.record.impl;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.record.DateStruct;
import tv.amwa.maj.record.TimeStamp;
import tv.amwa.maj.record.TimeStruct;
import tv.amwa.maj.record.impl.DateStructImpl;
import tv.amwa.maj.record.impl.TimeStructImpl;
import tv.amwa.maj.util.Utilities;

public final class TimeStampImpl
implements TimeStamp,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = 1822101767409444066L;
    private Calendar timestamp;
    private TimeStructImpl timeValue;
    private DateStructImpl dateValue;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final String MYSQL_COLUMN_DEFINITION = "CHAR(23) CHARACTER SET ascii COLLATE ascii_general_ci";

    public TimeStampImpl() {
        this.timestamp = new GregorianCalendar();
        this.timeValue = new TimeStructImpl(this.timestamp);
        this.dateValue = new DateStructImpl(this.timestamp);
    }

    public TimeStampImpl(Calendar calendarItem) throws IllegalArgumentException, NullPointerException {
        this.timeValue = new TimeStructImpl();
        this.dateValue = new DateStructImpl();
        this.setTimeStamp(calendarItem);
    }

    public TimeStampImpl(DateStruct date, TimeStruct time) throws NullPointerException, IllegalArgumentException {
        this();
        this.setStamp(date, time);
    }

    @Override
    public final DateStruct getDate() {
        this.syncValues();
        return this.dateValue.clone();
    }

    @Override
    public final void setDate(DateStruct date) throws NullPointerException, IllegalArgumentException {
        this.setDateInternal(date);
    }

    private void setDateInternal(DateStruct date) throws NullPointerException {
        if (date == null) {
            throw new NullPointerException("Cannot set date of time stamp from a null value.");
        }
        this.timestamp.clear(5);
        this.timestamp.set(5, date.getDay());
        this.timestamp.clear(2);
        this.timestamp.set(2, date.getMonth() - 1);
        this.timestamp.clear(1);
        this.timestamp.set(1, date.getYear());
        this.syncValues();
    }

    @Override
    public final TimeStruct getTime() {
        this.syncValues();
        return this.timeValue.clone();
    }

    @Override
    public final void setTime(TimeStruct time) throws NullPointerException, IllegalArgumentException {
        this.setTimeInternal(time);
    }

    private void setTimeInternal(TimeStruct time) throws NullPointerException {
        if (time == null) {
            throw new NullPointerException("Cannot set time of time stamp from a null value.");
        }
        this.timestamp.clear(11);
        this.timestamp.set(11, time.getHour());
        this.timestamp.clear(12);
        this.timestamp.set(12, time.getMinute());
        this.timestamp.clear(13);
        this.timestamp.set(13, time.getSecond());
        this.timestamp.clear(14);
        int fraction = time.getFraction();
        fraction = fraction >= 0 ? fraction : 256 + fraction;
        this.timestamp.set(14, fraction * 4);
        this.syncValues();
    }

    @Override
    public final void setStamp(DateStruct date, TimeStruct time) throws NullPointerException, IllegalArgumentException {
        this.setTimeInternal(time);
        this.setDateInternal(date);
        this.timestamp.getTime();
    }

    @Override
    public final Calendar getTimeStamp() {
        return (Calendar)this.timestamp.clone();
    }

    public final void setTimeStamp(Calendar timestampItem) throws NullPointerException, IllegalArgumentException {
        if (timestampItem == null) {
            throw new NullPointerException("Cannot set the value of a time stamp from null.");
        }
        timestampItem.setLenient(false);
        timestampItem.getTime();
        this.timestamp = Calendar.getInstance();
        this.timestamp.setTime(timestampItem.getTime());
        this.timestamp.setTimeZone(timestampItem.getTimeZone());
        this.syncValues();
    }

    private void syncValues() {
        this.dateValue.setDateValue(this.timestamp);
        this.timeValue.setTimeValue(this.timestamp);
    }

    @Override
    public final String toString() {
        String formatted = formatter.format(this.timestamp.getTime());
        if (formatted.endsWith("+0000")) {
            formatted = formatted.substring(0, formatted.length() - 6) + "Z";
        }
        return formatted;
    }

    public final int hashCode() {
        return this.timestamp.hashCode();
    }

    public static final TimeStampImpl parseFactory(String stamp) throws ParseException, NullPointerException {
        if (stamp == null) {
            throw new NullPointerException("Cannot create a time stamp from a null value.");
        }
        if (stamp.length() < 20) {
            throw new ParseException("Timestamp values does not have a sufficient number of characters.", 0);
        }
        int lastDot = stamp.lastIndexOf(46);
        if (lastDot > 0 && lastDot < stamp.length() - 3 && !Character.isDigit(stamp.charAt(lastDot + 3))) {
            stamp = stamp.substring(0, lastDot + 3) + "0" + stamp.substring(lastDot + 3);
        }
        if (stamp.endsWith("Z")) {
            stamp = stamp.substring(0, stamp.length() - 1) + "+0000";
        }
        if (lastDot == -1 && stamp.length() > 5) {
            stamp = stamp.substring(0, stamp.length() - 5) + ".000" + stamp.substring(stamp.length() - 5);
        }
        formatter.setLenient(false);
        Date parsedDate = formatter.parse(stamp);
        GregorianCalendar calendarValue = new GregorianCalendar();
        calendarValue.clear();
        ((Calendar)calendarValue).setTimeZone(formatter.getTimeZone());
        calendarValue.setTime(parsedDate);
        return new TimeStampImpl(calendarValue);
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TimeStamp)) {
            return false;
        }
        TimeStamp testStamp = (TimeStamp)o;
        if (!this.getDate().equals(testStamp.getDate())) {
            return false;
        }
        return this.getTime().equals(testStamp.getTime());
    }

    @Override
    public final TimeStamp clone() {
        try {
            TimeStampImpl cloned = (TimeStampImpl)super.clone();
            cloned.setTimeStamp(this.getTimeStamp());
            return cloned;
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    @Override
    public final void appendXMLChildren(Node parent) {
        Document document = parent.getOwnerDocument();
        Text textTimestamp = document.createTextNode(this.toString());
        parent.appendChild(textTimestamp);
    }

    @Override
    public String getComment() {
        return null;
    }

    public static final void generateEmbeddableORM(Node parent, String namespace, String prefix) {
        Element embeddable = XMLBuilder.createChild(parent, namespace, prefix, "embeddable");
        XMLBuilder.setAttribute(embeddable, namespace, prefix, "class", TimeStampImpl.class.getCanonicalName());
        XMLBuilder.setAttribute(embeddable, namespace, prefix, "access", "FIELD");
        Element embeddableAttributes = XMLBuilder.createChild(embeddable, namespace, prefix, "attributes");
        Element basic = XMLBuilder.createChild(embeddableAttributes, namespace, prefix, "basic");
        XMLBuilder.setAttribute(basic, namespace, prefix, "name", "timestamp");
        XMLBuilder.appendElement((Node)basic, namespace, prefix, "temporal", "TIMESTAMP");
        Element transientOne = XMLBuilder.createChild(embeddableAttributes, namespace, prefix, "transient");
        XMLBuilder.setAttribute(transientOne, namespace, prefix, "name", "timeValue");
        Element transientTwo = XMLBuilder.createChild(embeddableAttributes, namespace, prefix, "transient");
        XMLBuilder.setAttribute(transientTwo, namespace, prefix, "name", "dateValue");
    }

    public static final void generateEmbeddedORM(Node parent, String ownerName, String namespace, String prefix) {
        Element embedded = XMLBuilder.createChild(parent, namespace, prefix, "embedded");
        XMLBuilder.setAttribute(embedded, namespace, prefix, "name", Utilities.lowerFirstLetter(ownerName));
        Element attributeOverride = XMLBuilder.createChild(embedded, namespace, prefix, "attribute-override");
        XMLBuilder.setAttribute(attributeOverride, namespace, prefix, "name", "timestamp");
        Element column = XMLBuilder.createChild(attributeOverride, namespace, prefix, "column");
        XMLBuilder.setAttribute(column, namespace, prefix, "name", ownerName);
    }

    public static final String toPersistentForm(TimeStamp timeStamp) {
        if (timeStamp == null) {
            return null;
        }
        return timeStamp.toString();
    }

    public static final TimeStamp fromPersistentForm(String timeStamp) {
        if (timeStamp == null) {
            return null;
        }
        try {
            return TimeStampImpl.parseFactory(timeStamp);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    static {
        formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
    }
}

