/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.NotImplementedException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.misctype.LengthType;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.model.EssenceData;
import tv.amwa.maj.model.SourcePackage;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.model.impl.PackageImpl;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.impl.PackageIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=8960, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="EssenceData", description="The EssenceData class contains essence.", symbol="EssenceData")
public class EssenceDataImpl
extends InterchangeObjectImpl
implements EssenceData,
Serializable,
Cloneable {
    private static final long serialVersionUID = 5290980225454498543L;
    private PackageID linkedPackageID;
    private Stream essenceStream = null;
    private Stream sampleIndex = null;
    private Integer indexSID = null;
    private Integer bodySID = null;
    private transient SourcePackage filePackage = null;

    public EssenceDataImpl() {
    }

    public EssenceDataImpl(SourcePackage sourcePackage, Stream data) throws NullPointerException {
        if (sourcePackage == null) {
            throw new NullPointerException("Cannot create a new item of essence data witn a null file package.");
        }
        if (data == null) {
            throw new NullPointerException("Cannot create a new item of essence data with null data.");
        }
        this.setFilePackage(sourcePackage);
        this.setEssenceStream(data);
    }

    @Override
    @MediaProperty(uuid1=0x6010106, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="LinkedPackageID", aliases={"MobID", "EssenceDataMobID"}, typeName="PackageIDType", optional=false, uniqueIdentifier=true, pid=9985, symbol="LinkedPackageID")
    public PackageID getLinkedPackageID() {
        return this.linkedPackageID.clone();
    }

    @MediaPropertySetter(value="LinkedPackageID")
    public void setLinkedPackageID(PackageID linkedPackageID) {
        this.linkedPackageID = linkedPackageID.clone();
    }

    public static final PackageID initializeLinkedPackageID() {
        return PackageImpl.initializePackageID();
    }

    @Override
    public SourcePackage getFilePackage() {
        return this.filePackage;
    }

    @Override
    public void setFilePackage(SourcePackage packageToSet) throws NullPointerException {
        if (packageToSet == null) {
            throw new NullPointerException("Cannot create a new item of essence data witn a null file package.");
        }
        this.filePackage = packageToSet;
        this.setLinkedPackageID(this.filePackage.getPackageID());
    }

    @Override
    public long getPosition() throws IOException {
        return this.essenceStream.getPosition();
    }

    @Override
    public long getSampleIndexPosition() throws PropertyNotPresentException, IOException {
        if (this.sampleIndex == null) {
            throw new PropertyNotPresentException("The optional sample index property is not present for this essence data.");
        }
        return this.sampleIndex.getPosition();
    }

    @Override
    public long getSampleIndexSize() throws PropertyNotPresentException, IOException {
        if (this.sampleIndex == null) {
            throw new PropertyNotPresentException("The optional sample index property is not present for this essence data.");
        }
        return this.sampleIndex.getLength();
    }

    @Override
    public void setSampleIndexSize(@LengthType long sampleIndexSize) throws IllegalArgumentException, NotImplementedException {
        if (sampleIndexSize == 0L) {
            this.sampleIndex = null;
            return;
        }
        if (this.sampleIndex == null) {
            throw new NotImplementedException("Extending a not present sample index is not supported in this release of MAJ.");
        }
        this.sampleIndex.setLimit(sampleIndexSize);
    }

    @Override
    public long getSize() throws IOException {
        return this.essenceStream.getLength();
    }

    @Override
    public ByteBuffer read(int bytes) throws IOException, EndOfDataException {
        return this.essenceStream.read(bytes);
    }

    @Override
    public ByteBuffer readSampleIndex(int size) throws PropertyNotPresentException, IOException, EndOfDataException {
        if (this.sampleIndex == null) {
            throw new PropertyNotPresentException("The optional sample index property is not present for this essence data.");
        }
        return this.sampleIndex.read(size);
    }

    @Override
    public void setPosition(long offset) throws IllegalArgumentException, IOException {
        this.essenceStream.setPosition(offset);
    }

    @Override
    public void setSampleIndexPosition(@PositionType long offset) throws PropertyNotPresentException, IllegalArgumentException, IOException {
        if (this.sampleIndex == null) {
            throw new PropertyNotPresentException("The optional sample index property is not present for this essence data.");
        }
        this.sampleIndex.setPosition(offset);
    }

    @Override
    public int write(ByteBuffer buffer) throws EndOfDataException, IOException {
        return this.essenceStream.write(buffer);
    }

    @Override
    public int writeSampleIndex(ByteBuffer buffer) throws PropertyNotPresentException, EndOfDataException, IOException {
        if (this.sampleIndex == null) {
            throw new PropertyNotPresentException("The optional sample index property is not present in for this essence data.");
        }
        return this.sampleIndex.write(buffer);
    }

    @Override
    @MediaProperty(uuid1=67568128, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="EssenceStream", aliases={"Data"}, typeName="Stream", optional=true, uniqueIdentifier=false, pid=9986, symbol="EssenceStream")
    public Stream getEssenceStream() throws PropertyNotPresentException {
        if (this.essenceStream == null) {
            throw new PropertyNotPresentException("The optional essence data is not present, indicating that this is an MXF application using body stream identifiers instead.");
        }
        return this.essenceStream.clone();
    }

    @Override
    @MediaPropertySetter(value="EssenceStream")
    public void setEssenceStream(Stream data) {
        if (data == null) {
            this.essenceStream = null;
            return;
        }
        this.essenceStream = data.clone();
    }

    @Override
    @MediaProperty(uuid1=100729090, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="SampleIndex", typeName="Stream", optional=true, uniqueIdentifier=false, pid=11009, symbol="SampleIndex")
    public Stream getSampleIndex() throws PropertyNotPresentException {
        if (this.sampleIndex == null) {
            throw new PropertyNotPresentException("Sample index data is not present for this essence data.");
        }
        return this.sampleIndex.clone();
    }

    @Override
    @MediaPropertySetter(value="SampleIndex")
    public void setSampleIndex(Stream sampleIndex) {
        if (sampleIndex == null) {
            this.sampleIndex = null;
            return;
        }
        this.sampleIndex = sampleIndex.clone();
    }

    @Override
    public EssenceData clone() {
        return (EssenceData)super.clone();
    }

    public String getLinkedPackageIDString() {
        return PackageIDImpl.toPersistentForm(this.linkedPackageID);
    }

    public void setLinkedPackageIDString(String linkedPackageID) {
        this.linkedPackageID = PackageIDImpl.fromPersistentForm(linkedPackageID);
    }

    @Override
    @MediaProperty(uuid1=16974853, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="IndexSID", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=16134, symbol="IndexSID")
    @UInt32
    public int getIndexSID() throws PropertyNotPresentException {
        if (this.indexSID == null) {
            throw new PropertyNotPresentException("The optional index stream identifier property is not present for this essence data.");
        }
        return this.indexSID;
    }

    @Override
    @MediaPropertySetter(value="IndexSID")
    public void setIndexSID(@UInt32 Integer indexSID) throws IllegalArgumentException {
        if (indexSID == null) {
            this.indexSID = null;
            return;
        }
        if (indexSID < 0) {
            throw new IllegalArgumentException("Cannot set the index stream identifier to a negative value.");
        }
        this.indexSID = indexSID;
    }

    @Override
    @MediaProperty(uuid1=16974852, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="BodySID", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=16135, symbol="BodySID")
    @UInt32
    public int getBodySID() throws PropertyNotPresentException {
        if (this.bodySID == null) {
            throw new PropertyNotPresentException("The optional body stream identifier property is not present for this essence data.");
        }
        return this.bodySID;
    }

    @Override
    @MediaPropertySetter(value="BodySID")
    public void setBodySID(@UInt32 Integer bodySID) throws IllegalArgumentException {
        if (bodySID == null) {
            this.bodySID = null;
            return;
        }
        if (bodySID < 0) {
            throw new IllegalArgumentException("Cannot set the body stream identifier to a negative value.");
        }
        this.bodySID = bodySID;
    }
}

