/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.exception.AdjacentTransitionException;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.EventSemanticsException;
import tv.amwa.maj.exception.InsufficientTransitionMaterialException;
import tv.amwa.maj.exception.InvalidDataDefinitionException;
import tv.amwa.maj.exception.LeadingTransitionException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.extensions.quantel.QSequence;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.integer.Int64;
import tv.amwa.maj.model.Component;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.Event;
import tv.amwa.maj.model.Filler;
import tv.amwa.maj.model.Sequence;
import tv.amwa.maj.model.Transition;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.FillerImpl;
import tv.amwa.maj.model.impl.SegmentImpl;
import tv.amwa.maj.model.impl.TransitionImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=3840, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Sequence", description="The Sequence class combines an ordered list of Segments and Transitions.", symbol="Sequence")
public class SequenceImpl
extends SegmentImpl
implements Sequence,
QSequence,
Serializable,
Cloneable {
    private static final long serialVersionUID = 2801133940754656994L;
    private List<Component> componentObjects = Collections.synchronizedList(new Vector());
    private Integer compositeRushIndicator = null;
    private String compositionRushID = null;
    private Long compositeRushOffset = null;

    public SequenceImpl() {
    }

    public SequenceImpl(DataDefinition dataDefinition) throws NullPointerException {
        if (dataDefinition == null) {
            throw new NullPointerException("Cannot create a new sequence with a null data definition value.");
        }
        this.setComponentDataDefinition(dataDefinition);
        this.setLengthPresent(true);
    }

    @MediaProperty(uuid1=100729092, uuid2=1545, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ComponentObjects", aliases={"Components"}, typeName="ComponentStrongReferenceVector", optional=false, uniqueIdentifier=false, pid=4097, symbol="ComponentObjects")
    public List<Component> getComponentObjects() {
        return StrongReferenceVector.getRequiredList(this.componentObjects);
    }

    public static final List<Component> initializeComponentObjects() {
        ArrayList<Component> initialComponents = new ArrayList<Component>();
        initialComponents.add(new FillerImpl(DataDefinitionImpl.forName("Unknown"), 0L));
        return initialComponents;
    }

    @Override
    @MediaListAppend(value="ComponentObjects")
    public void appendComponentObject(Component componentObject) throws NullPointerException, InvalidDataDefinitionException, LeadingTransitionException, EventSemanticsException, BadPropertyException, BadLengthException, AdjacentTransitionException, InsufficientTransitionMaterialException {
        if (this.componentObjects.size() == 1 && this.componentObjects.get(0) instanceof Filler && ((Filler)this.componentObjects.get(0)).getComponentLength() == 0L) {
            this.clearComponentObjects();
        }
        if (this.componentObjects.size() == 0) {
            this.checkFirstComponentSemantics(componentObject);
            if (componentObject instanceof Event) {
                this.updateSequenceLength((Event)componentObject);
            } else {
                this.updateSequenceLength(componentObject);
            }
        } else if (this.componentObjects.get(0) instanceof Event) {
            Event event;
            try {
                event = (Event)componentObject;
            }
            catch (ClassCastException cce) {
                throw new EventSemanticsException("Cannot append a non-event component to a sequence of events.");
            }
            this.checkTypeSemantics(event);
            this.checkPositionSemantics(event);
            this.checkLengthSemantics(event);
            this.updateSequenceLength(event);
        } else {
            this.checkTypeSemantics(componentObject);
            this.checkPositionSemantics(componentObject);
            this.checkLengthSemantics(componentObject);
            this.updateSequenceLength(componentObject);
        }
        StrongReferenceVector.append(this.componentObjects, componentObject);
    }

    private void checkFirstComponentSemantics(Component component) throws LeadingTransitionException {
        if (component instanceof Transition) {
            throw new LeadingTransitionException("The first element of a sequence cannot be a transition.");
        }
    }

    private void checkTypeSemantics(Event event) throws EventSemanticsException {
        if (!event.getClass().equals(this.componentObjects.get(this.componentObjects.size() - 1).getClass())) {
            throw new EventSemanticsException("The given event does not match the type of events stored in this sequence of events.");
        }
    }

    private void checkTypeSemantics(Component component) throws AdjacentTransitionException {
        if (component instanceof TransitionImpl && this.componentObjects.get(this.componentObjects.size() - 1) instanceof TransitionImpl) {
            throw new AdjacentTransitionException("Cannot append the given transition to the list of compositions of this sequence as this would result in adjacent transitions.");
        }
    }

    private void checkPositionSemantics(Event event) throws EventSemanticsException {
        try {
            long posNext = event.getEventPosition();
            Event lastEvent = (Event)this.componentObjects.get(this.componentObjects.size() - 1);
            long posLast = lastEvent.getEventPosition();
            if (posLast > posNext) {
                throw new EventSemanticsException("The position of an event must be greater than or equal to the position of the last event.");
            }
        }
        catch (BadPropertyException bpe) {
            throw new EventSemanticsException("The given event does not have a position set in its current context.");
        }
        catch (ClassCastException cce) {
            throw new EventSemanticsException("The event is being added to a list of components of a sequence that does not appear to contain events.");
        }
    }

    private void checkPositionSemantics(Component component) {
    }

    private void checkLengthSemantics(Event event) {
    }

    private void checkLengthSemantics(Component component) throws InsufficientTransitionMaterialException, BadPropertyException {
        try {
            long lengthNext = component.getComponentLength();
            Component lastComponent = this.componentObjects.get(this.componentObjects.size() - 1);
            long lengthLast = lastComponent.getComponentLength();
            if (component instanceof TransitionImpl && lengthLast < lengthNext || lastComponent instanceof TransitionImpl && lengthNext < lengthLast) {
                throw new InsufficientTransitionMaterialException("There is not enough material to achieve the transition to be appended or at the end of the list of components of this sequence.");
            }
        }
        catch (BadPropertyException bpe) {
            throw new BadPropertyException("Components in sequences must have the otherwise optional length property set.");
        }
    }

    private void updateSequenceLength(Event event) throws BadPropertyException, BadLengthException {
        if (!this.getLengthPresent() || !event.getLengthPresent()) {
            return;
        }
        long posNext = event.getEventPosition();
        long lengthNext = 0L;
        try {
            lengthNext = event.getComponentLength();
        }
        catch (BadPropertyException badPropertyException) {
            // empty catch block
        }
        if (this.componentObjects.size() == 0) {
            this.setLengthPresent(true);
            this.setComponentLength(lengthNext);
            return;
        }
        Event firstEvent = (Event)this.componentObjects.get(0);
        long posFirst = firstEvent.getEventPosition();
        long seqLength = 0L;
        try {
            seqLength = this.getComponentLength();
        }
        catch (BadPropertyException bpe) {
            bpe.printStackTrace();
            throw bpe;
        }
        if (posNext + lengthNext - posFirst > seqLength) {
            seqLength = posNext + lengthNext - posFirst;
        }
        this.setComponentLength(seqLength);
    }

    private void updateSequenceLength(Component component) throws BadPropertyException {
        long seqLength = 0L;
        for (Component componentInList : this.componentObjects) {
            if (componentInList instanceof Transition) {
                seqLength -= componentInList.getComponentLength();
                continue;
            }
            seqLength += componentInList.getComponentLength();
        }
        if (component != null && component.getLengthPresent()) {
            seqLength = component instanceof Transition ? (seqLength -= component.getComponentLength()) : (seqLength += component.getComponentLength());
        }
        this.setLengthPresent(true);
        try {
            this.setComponentLength(seqLength);
        }
        catch (BadLengthException ble) {
            ble.printStackTrace();
        }
    }

    @Override
    @MediaPropertyCount(value="ComponentObjects")
    public int countComponentObjects() {
        return this.componentObjects.size();
    }

    @Override
    @MediaPropertyClear(value="ComponentObjects")
    public void clearComponentObjects() {
        this.componentObjects.clear();
    }

    @Override
    @MediaListGetAt(value="ComponentObjects")
    public Component getComponentObjectAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.componentObjects, index);
    }

    void setNthComponent(Component component, int index) throws IndexOutOfBoundsException {
        this.componentObjects.set(index, component.clone());
        component.setPersistentIndex(index);
    }

    static void setNthComponent(Sequence sequence, Component component, int index) throws IndexOutOfBoundsException {
        ((SequenceImpl)sequence).setNthComponent(component, index);
    }

    @Override
    @MediaListInsertAt(value="ComponentObjects")
    public void insertComponentObjectAt(int index, Component component) throws NullPointerException, IndexOutOfBoundsException, InvalidDataDefinitionException, LeadingTransitionException, AdjacentTransitionException, InsufficientTransitionMaterialException {
        StrongReferenceVector.insert(this.componentObjects, index, component);
    }

    @Override
    @MediaListPrepend(value="ComponentObjects")
    public void prependComponentObject(Component component) throws NullPointerException, InvalidDataDefinitionException, LeadingTransitionException {
        StrongReferenceVector.prepend(this.componentObjects, component);
    }

    @Override
    @MediaListRemoveAt(value="ComponentObjects")
    public void removeComponentObjectAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.componentObjects, index);
    }

    @Override
    @MediaProperty(uuid1=-1316340416, uuid2=12272, uuid3=16729, uuid4={-106, -117, 58, -70, 71, 101, -119, -97}, definedName="Composite rush indicator", symbol="Composite_rush_indicator", aliases={"Composite_rush_indicator"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getCompositeRushIndicator() throws PropertyNotPresentException {
        if (this.compositeRushIndicator == null) {
            throw new PropertyNotPresentException("The optional composite rush indicator property is not present for this Quantel sequence.");
        }
        return this.compositeRushIndicator;
    }

    @Override
    @MediaPropertySetter(value="Composite rush indicator")
    public void setCompositeRushIndicator(@Int32 Integer compositeRushIndicator) {
        this.compositeRushIndicator = compositeRushIndicator;
    }

    @Override
    @MediaProperty(uuid1=-343627627, uuid2=29603, uuid3=19676, uuid4={-110, -102, -103, -21, -32, -110, 27, 67}, definedName="Composite rush id", symbol="Composite_rush_id", aliases={"Composite_rush_id"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public String getCompositeRushID() throws PropertyNotPresentException {
        if (this.compositionRushID == null) {
            throw new PropertyNotPresentException("The optional composite rush ID property is not present for this Quantel sequence.");
        }
        return this.compositionRushID;
    }

    @Override
    @MediaPropertySetter(value="Composite rush id")
    public void setCompositeRushID(String compositeRushID) {
        this.compositionRushID = compositeRushID;
    }

    @Override
    @MediaProperty(uuid1=2129586645, uuid2=29370, uuid3=18873, uuid4={-98, -68, -29, -105, -109, 47, -119, -63}, definedName="Composite rush offset", symbol="Composite_rush_offset", aliases={"Composite_rush_offset"}, typeName="Int64", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int64
    public long getCompositeRushOffset() throws PropertyNotPresentException {
        if (this.compositeRushOffset == null) {
            throw new PropertyNotPresentException("The optional composition rush offset property is not present for this Quantel sequnce.");
        }
        return this.compositeRushOffset;
    }

    @Override
    @MediaPropertySetter(value="CompositeRushOffset")
    public void setCompositeRushOffset(@Int64 Long compositeRushOffset) {
        this.compositeRushOffset = compositeRushOffset;
    }

    @Override
    public Sequence clone() {
        return (Sequence)super.clone();
    }
}

