/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.BadSampleOffsetException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.exception.TimecodeNotFoundException;
import tv.amwa.maj.extensions.quantel.QTimecode;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.model.TimecodeSegment;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.SegmentImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.TimecodeValue;
import tv.amwa.maj.record.impl.TimecodeValueImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=5120, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Timecode", description="The Timecode class stores videotape or audio tape timecode information.", symbol="Timecode")
public class TimecodeSegmentImpl
extends SegmentImpl
implements TimecodeSegment,
QTimecode,
Serializable,
Cloneable {
    private static final long serialVersionUID = 5112267590769722595L;
    private TimecodeValue timecode;
    private Integer timecodeModifiedFlag = null;

    public TimecodeSegmentImpl() {
    }

    public TimecodeSegmentImpl(long length, TimecodeValue timecode) throws NullPointerException, BadLengthException {
        if (timecode == null) {
            throw new NullPointerException("Cannot create a timecode segment with a null timecode value.");
        }
        this.setComponentDataDefinition(DataDefinitionImpl.forIdentification(DataDefinitionImpl.Timecode));
        this.setLengthPresent(true);
        this.setComponentLength(length);
        this.setTimecode(timecode);
    }

    @Override
    public TimecodeValue getTimecode() {
        return this.timecode.clone();
    }

    @Override
    public void setTimecode(TimecodeValue timecode) throws NullPointerException {
        if (timecode == null) {
            throw new NullPointerException("Cannot set the timecode value of this timecode segment using a null value.");
        }
        this.timecode = timecode.clone();
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=261, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="StartTimecode", aliases={"Start", "TimecodeStart"}, typeName="PositionType", optional=false, uniqueIdentifier=false, pid=5377, symbol="StartTimecode")
    public long getStartTimecode() {
        return this.timecode.getStartTimecode();
    }

    @MediaPropertySetter(value="StartTimecode")
    public void setStartTimecode(long startFrame) {
        if (this.timecode == null) {
            this.timecode = new TimecodeValueImpl();
        }
        this.timecode.setStartTimecode(startFrame);
    }

    public static final long initializeStartTimecode() {
        return 0L;
    }

    @Override
    @MediaProperty(uuid1=0x4040101, uuid2=518, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FramesPerSecond", aliases={"FPS"}, typeName="UInt16", optional=false, uniqueIdentifier=false, pid=5378, symbol="FramesPerSecond")
    public short getFramesPerSecond() {
        return this.timecode.getFramesPerSecond();
    }

    @MediaPropertySetter(value="FramesPerSecond")
    public void setFPS(short fps) throws IllegalArgumentException {
        if (fps < 0) {
            throw new IllegalArgumentException("Cannot set the number of frames per second to a negative value.");
        }
        if (this.timecode == null) {
            this.timecode = new TimecodeValueImpl();
        }
        this.timecode.setFramesPerSecond(fps);
    }

    public static final short initializeFramesPerSecond() {
        return 1;
    }

    @Override
    @MediaProperty(uuid1=0x4040101, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="DropFrame", aliases={"Drop"}, typeName="Boolean", optional=false, uniqueIdentifier=false, pid=5379, symbol="DropFrame")
    public boolean getDropFrame() {
        return this.timecode.getDropFrame();
    }

    @MediaPropertySetter(value="DropFrame")
    public void setDropFrame(boolean dropFrame) {
        if (this.timecode == null) {
            this.timecode = new TimecodeValueImpl();
        }
        this.timecode.setDropFrame(dropFrame);
    }

    @Override
    @MediaProperty(uuid1=1830128499, uuid2=3398, uuid3=17769, uuid4={-99, 88, 8, 95, 69, -8, 50, 117}, definedName="Timecode modified flag", symbol="Timecode_modified_flag", aliases={"Timecode_modified_flag"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getTimecodeModifiedFlag() throws PropertyNotPresentException {
        if (this.timecodeModifiedFlag == null) {
            throw new PropertyNotPresentException("The optional timecode modified flag property is not present for this Quantel timecode segment.");
        }
        return this.timecodeModifiedFlag;
    }

    @Override
    @MediaPropertySetter(value="Timecode modified flag")
    public void setTimecodeModifiedFlag(@Int32 Integer timecodeModifiedFlag) {
        this.timecodeModifiedFlag = timecodeModifiedFlag;
    }

    public static final boolean initializeDropFrame() {
        return false;
    }

    @Override
    public TimecodeValue segmentOffsetToTC(long offset) {
        TimecodeValue offsetTimecode = this.timecode.clone();
        offsetTimecode.setStartTimecode(offsetTimecode.getStartTimecode() + offset);
        return offsetTimecode;
    }

    @Override
    public long segmentTCToOffset(TimecodeValue timecode, Rational editrate) throws NullPointerException, TimecodeNotFoundException, BadSampleOffsetException {
        if (timecode == null) {
            throw new NullPointerException("Cannot calculate an offset value for this timecode segment using a null timecode value.");
        }
        if (editrate == null) {
            throw new NullPointerException("Cannot calculate an offset value for this timecode segment using a null edit rate value.");
        }
        try {
            if (timecode.getStartTimecode() < this.timecode.getStartTimecode()) {
                throw new BadSampleOffsetException("The given timecode value is outside of lower bound of this timecode segment.");
            }
            if (timecode.getStartTimecode() > this.timecode.getStartTimecode() + this.getComponentLength()) {
                throw new BadSampleOffsetException("The given timecode value is outside of the upper bound of this timecode segment.");
            }
        }
        catch (BadPropertyException bpe) {
            throw new BadSampleOffsetException("This component does not have a length property present, preventing the calculation of the offset value.");
        }
        return timecode.getStartTimecode() - this.timecode.getStartTimecode();
    }

    @Override
    public TimecodeSegment clone() {
        return (TimecodeSegment)super.clone();
    }
}

