/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import tv.amwa.maj.constant.ParameterConstant;
import tv.amwa.maj.constant.ParameterDescription;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.ParameterDefinition;
import tv.amwa.maj.model.impl.DefinitionObjectImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=7424, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="ParameterDefinition", description="The ParameterDefinition class defines a kind of Parameter for an effect.", symbol="ParameterDefinition")
public class ParameterDefinitionImpl
extends DefinitionObjectImpl
implements ParameterDefinition,
Serializable,
ParameterConstant,
Cloneable {
    private static final long serialVersionUID = 5172982416984376588L;
    private WeakReference<TypeDefinition> parameterType;
    private String parameterDisplayUnits = null;
    private static final Map<String, ParameterDefinition> definitionsByName = new HashMap<String, ParameterDefinition>();
    private static final Map<AUID, ParameterDefinition> definitionsById = new HashMap<AUID, ParameterDefinition>();

    public static final int registerParametersFromClass(Class<?> classWithParameters) throws NullPointerException {
        Field[] fields;
        if (classWithParameters == null) {
            throw new NullPointerException("Cannot register parameter definitions using a null class.");
        }
        int registered = 0;
        for (Field field : fields = classWithParameters.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) continue;
            try {
                Object value = field.get(null);
                if (!(value instanceof AUID) || !field.isAnnotationPresent(ParameterDescription.class)) continue;
                ParameterDescription parameterMetadata = field.getAnnotation(ParameterDescription.class);
                TypeDefinition parameterType = Warehouse.lookForType(parameterMetadata.typeName());
                ParameterDefinitionImpl definedParameter = new ParameterDefinitionImpl((AUID)value, field.getName(), parameterType);
                if (parameterMetadata.description().length() > 0) {
                    definedParameter.setDescription(parameterMetadata.description());
                }
                if (parameterMetadata.displayUnits().length() > 0) {
                    definedParameter.setParameterDisplayUnits(parameterMetadata.displayUnits());
                }
                ParameterDefinitionImpl.registerParameterDefinition(definedParameter);
                for (String alias : parameterMetadata.aliases()) {
                    definitionsByName.put(alias, definedParameter);
                }
                ++registered;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return registered;
    }

    public static final boolean registerParameterDefinition(ParameterDefinition parameterDefinition) throws NullPointerException {
        if (parameterDefinition == null) {
            throw new NullPointerException("Cannot register a new parameter definition using a null value.");
        }
        boolean alreadyContained = definitionsById.containsKey(parameterDefinition.getAUID());
        definitionsByName.put(parameterDefinition.getName(), parameterDefinition);
        definitionsByName.put("ParameterDef_" + parameterDefinition.getName(), parameterDefinition);
        definitionsById.put(parameterDefinition.getAUID(), parameterDefinition);
        return alreadyContained;
    }

    public static final ParameterDefinition forName(String parameterName) throws NullPointerException {
        if (parameterName == null) {
            throw new NullPointerException("Cannot retrieve a parameter definition with a null name.");
        }
        return definitionsByName.get(parameterName);
    }

    public static final ParameterDefinition forIdentification(AUID identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot retrieve a parameter definition with a null identification.");
        }
        return definitionsById.get(identification);
    }

    public static final ParameterDefinition forAUID(AUID identification) throws NullPointerException {
        return ParameterDefinitionImpl.forIdentification(identification);
    }

    public static final Collection<String> inventory() {
        TreeSet<String> inventory = new TreeSet<String>();
        for (AUID definitionID : definitionsById.keySet()) {
            inventory.add(definitionsById.get(definitionID).getName());
        }
        return inventory;
    }

    public static final int count() {
        return definitionsById.size();
    }

    public ParameterDefinitionImpl() {
    }

    public ParameterDefinitionImpl(AUID identification, @AAFString String name, TypeDefinition type) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a parameter definition with a null id.");
        }
        if (type == null) {
            throw new NullPointerException("Cannot create a parameter definition with a null type definition.");
        }
        this.setAUID(identification);
        this.setName(name);
        this.setParameterType(type);
    }

    @Override
    @MediaProperty(uuid1=87033099, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ParameterDisplayUnits", aliases={"DisplayUnits"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=7939, symbol="ParameterDisplayUnits")
    public String getParameterDisplayUnits() throws PropertyNotPresentException {
        if (this.parameterDisplayUnits == null) {
            throw new PropertyNotPresentException("The optional display units property is not present in this parameter definition.");
        }
        return this.parameterDisplayUnits;
    }

    @Override
    @MediaPropertySetter(value="ParameterDisplayUnits")
    public void setParameterDisplayUnits(String displayUnits) {
        this.parameterDisplayUnits = displayUnits;
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=262, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ParameterType", aliases={"Type", "ParameterDefinitionType"}, typeName="TypeDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=7937, symbol="ParameterType")
    public TypeDefinition getParameterType() {
        return this.parameterType.getTarget();
    }

    @MediaPropertySetter(value="ParameterType")
    public void setParameterType(TypeDefinition parameterType) throws NullPointerException {
        if (parameterType == null) {
            throw new NullPointerException("Cannot set the type of a parameter definition to a null value.");
        }
        this.parameterType = new WeakReference<TypeDefinition>(parameterType);
    }

    public static final TypeDefinition initializeParameterType() {
        return TypeDefinitions.Int32;
    }

    @Override
    public ParameterDefinition clone() {
        return (ParameterDefinition)super.clone();
    }

    static {
        ParameterDefinitionImpl.registerParametersFromClass(ParameterConstant.class);
    }
}

