/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf;

import java.io.IOException;
import tv.amwa.maj.io.mxf.DeltaEntry;
import tv.amwa.maj.io.mxf.EssenceElement;
import tv.amwa.maj.io.mxf.EssencePartition;
import tv.amwa.maj.io.mxf.FooterPartition;
import tv.amwa.maj.io.mxf.HeaderMetadata;
import tv.amwa.maj.io.mxf.HeaderPartition;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.MXFFile;
import tv.amwa.maj.io.mxf.Partition;
import tv.amwa.maj.io.mxf.RandomIndexPack;
import tv.amwa.maj.io.mxf.impl.DeltaEntryImpl;
import tv.amwa.maj.io.mxf.impl.MXFFileImpl;

public class MXFFactory {
    public static final boolean logging = true;

    public static final MXFFile readPartitions(String fileName) throws NullPointerException {
        if (fileName == null) {
            throw new NullPointerException("Cannot open a file using a null filename.");
        }
        MXFFileImpl mxfFile = new MXFFileImpl();
        try {
            if (!mxfFile.open(fileName, false)) {
                System.err.println("Could not open file " + fileName + ".");
                return null;
            }
            System.out.println("MXF file " + fileName + " opened successfully. Run-in size is " + mxfFile.getRunInSize() + ".");
            mxfFile.readRunIn();
            boolean bl = mxfFile.buildPartitionsTable();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + " when reading file '" + fileName + "': " + e.getMessage());
            e.printStackTrace();
        }
        return mxfFile;
    }

    public static final String dumpFile(String mxfFileName) throws NullPointerException, IOException {
        Partition partition;
        StringBuffer dumpBuffer = new StringBuffer(65536);
        MXFFile mxfFile = MXFFactory.readPartitions(mxfFileName);
        if (!mxfFile.isOpen()) {
            throw new IOException("Cannot dump file " + mxfFileName + " as the file could not be opened.");
        }
        dumpBuffer.append("MXF file " + mxfFileName + " openned and contains " + mxfFile.countPartitions() + ".\n\n");
        dumpBuffer.append("************************\n");
        dumpBuffer.append("* Header partition pack:\n");
        dumpBuffer.append(mxfFile.getHeaderPartition().toString());
        dumpBuffer.append("\n\n");
        for (int x = 1; x < mxfFile.countPartitions(); ++x) {
            dumpBuffer.append("Partition " + x);
            Partition partition2 = mxfFile.getPartitionAt(x);
            if (partition2 instanceof FooterPartition) {
                dumpBuffer.append(" footer partition:\n");
            } else {
                dumpBuffer.append(" body partition:\n");
            }
            if (partition2 != null) {
                dumpBuffer.append(partition2.toString());
            }
            dumpBuffer.append("\n\n");
        }
        dumpBuffer.append("**********************************************************************\n");
        dumpBuffer.append("* Header metadata from the header partition - primer pack and preface:\n");
        HeaderMetadata fromTheHeader = mxfFile.getHeaderPartition().readHeaderMetadata();
        dumpBuffer.append(fromTheHeader.getPrimerPack().toString());
        dumpBuffer.append("\n");
        dumpBuffer.append(fromTheHeader.getPreface().toString());
        dumpBuffer.append("\n\n");
        dumpBuffer.append("**********************************************************************\n");
        dumpBuffer.append("* Essence elements in the header and body partitions:\n");
        for (int x = 0; x < mxfFile.countPartitions() && !((partition = mxfFile.getPartitionAt(x)) instanceof FooterPartition); ++x) {
            dumpBuffer.append("Partition " + x);
            if (partition instanceof HeaderPartition) {
                dumpBuffer.append(" header partition:\n");
            } else {
                dumpBuffer.append(" body partition:\n");
            }
            EssencePartition containerPartition = (EssencePartition)partition;
            if (containerPartition == null) continue;
            EssenceElement element = containerPartition.readEssenceElement();
            while (element != null) {
                dumpBuffer.append(element.toString());
                dumpBuffer.append("\n");
                element = containerPartition.readEssenceElement();
            }
        }
        if (mxfFile.getFooterPartition() == null) {
            dumpBuffer.append("**********************************\n");
            dumpBuffer.append("* No footer partition in the file.\n\n");
        } else if (mxfFile.getFooterPartition().readHeaderMetadata() == null) {
            dumpBuffer.append("***********************************************\n");
            dumpBuffer.append("* No header metadata found in this file footer.\n\n");
        } else {
            HeaderMetadata fromTheFooter = null;
            fromTheFooter = mxfFile.getFooterPartition().readHeaderMetadata();
            dumpBuffer.append("*********************************************************************\n");
            dumpBuffer.append("* Header metadata from the footer parition - primer pack and preface:\n");
            dumpBuffer.append(fromTheFooter.getPrimerPack().toString());
            dumpBuffer.append("\n");
            dumpBuffer.append(fromTheFooter.getPreface().toString());
            dumpBuffer.append("\n\n");
        }
        RandomIndexPack rip = mxfFile.getRandomIndexPack();
        if (rip == null) {
            dumpBuffer.append("***********************************\n");
            dumpBuffer.append("* No random index pack in the file.\n");
        } else {
            dumpBuffer.append("********************\n");
            dumpBuffer.append("* Random index pack:");
            dumpBuffer.append(rip.toString());
        }
        mxfFile.close();
        return dumpBuffer.toString();
    }

    public static final MXFFile emptyFile() {
        MXFFileImpl emptyFile = new MXFFileImpl();
        return emptyFile;
    }

    public static final DeltaEntry makeDeltaEntry(byte posTableIndex, byte slice, int elementDelta) throws IllegalArgumentException {
        return new DeltaEntryImpl(posTableIndex, slice, elementDelta);
    }

    public static final DeltaEntry makeDeltaEntry(int elementDelta) throws IllegalArgumentException {
        return new DeltaEntryImpl(elementDelta);
    }

    public static final void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Please provide the name of an MXF file to analyse.");
            System.exit(1);
        }
        String fileName = args[0];
        System.out.println(MXFFactory.dumpFile(fileName));
    }

    static {
        MXFBuilder.registerMXF();
    }
}

