/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.constant.PluginCategoryType;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.Locator;
import tv.amwa.maj.model.NetworkLocator;
import tv.amwa.maj.model.PluginDefinition;
import tv.amwa.maj.model.impl.DefinitionObjectImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.VersionType;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.record.impl.VersionTypeImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=7680, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="PluginDefinition", description="The PluginDefinition class identifies code objects that provide an implementation for a DefinitionObject.", symbol="PluginDefinition")
public class PluginDefinitionImpl
extends DefinitionObjectImpl
implements PluginDefinition,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7691293334720278493L;
    private AUID pluginCategory;
    private VersionType pluginVersion;
    private String pluginVersionString = null;
    private String deviceManufacturerName = null;
    private NetworkLocator manufacturerInfo = null;
    private AUID manufacturerID = null;
    private AUID pluginPlatform = null;
    private VersionType minPlatformVersion = null;
    private VersionType maxPlatformVersion = null;
    private AUID engine = null;
    private VersionType minEngineVersion = null;
    private VersionType maxEngineVersion = null;
    private AUID pluginAPI = null;
    private VersionType minPluginAPI = null;
    private VersionType maxPluginAPI = null;
    private Boolean softwareOnly = null;
    private Boolean accelerator = null;
    private List<Locator> pluginLocators = Collections.synchronizedList(new Vector());
    private Boolean authentication = null;
    private AUID implementedClass = null;

    public PluginDefinitionImpl() {
    }

    public PluginDefinitionImpl(AUID identification, @AAFString String name, AUID pluginCategory, VersionType versionNumber, AUID definitionObject) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a plugin definition with a null id.");
        }
        if (pluginCategory == null) {
            throw new NullPointerException("Cannot create a plugin definition with a null plugin category.");
        }
        if (versionNumber == null) {
            throw new NullPointerException("Cannot create a plugin definition with a null version number.");
        }
        if (definitionObject == null) {
            throw new NullPointerException("Cannot create a plugin definition with a null data definition object.");
        }
        this.setAUID(identification);
        this.setName(name);
        this.setCategoryClass(pluginCategory);
        this.setPluginVersion(versionNumber);
        this.setImplementedClass(definitionObject);
    }

    @Override
    @MediaProperty(uuid1=85985537, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PluginCategory", typeName="PluginCategoryType", optional=false, uniqueIdentifier=false, pid=8707, symbol="PluginCategory")
    public AUID getCategoryClass() {
        return this.pluginCategory.clone();
    }

    @Override
    @MediaPropertySetter(value="PluginCategory")
    public void setCategoryClass(AUID categoryClass) throws NullPointerException {
        if (categoryClass == null) {
            throw new NullPointerException("Cannot set the category type for this plugin with a null value.");
        }
        this.pluginCategory = categoryClass.clone();
    }

    public static final AUID initializePluginCategory() {
        return PluginCategoryType.Codec;
    }

    @Override
    @MediaProperty(uuid1=85985551, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ImplementedClass", aliases={"DefinitionObject", "PluginDefinitionDefinitionObject"}, typeName="AUID", optional=true, uniqueIdentifier=false, pid=8726, symbol="ImplementedClass")
    public AUID getImplementedClass() throws PropertyNotPresentException {
        if (this.implementedClass == null) {
            throw new PropertyNotPresentException("The implemented class property is not present for this plugin definition, indicating a plugin definition from AAF version 1.0.");
        }
        return this.implementedClass.clone();
    }

    @MediaPropertySetter(value="ImplementedClass")
    public void setImplementedClassLegacy(AUID implementedClass) {
        if (implementedClass == null) {
            this.implementedClass = null;
        } else {
            this.setImplementedClass(implementedClass);
        }
    }

    @Override
    public void setImplementedClass(AUID implementedClass) throws NullPointerException {
        if (implementedClass == null) {
            throw new NullPointerException("Cannot set the definition object of this plugin definition using a null id.");
        }
        this.implementedClass = implementedClass.clone();
    }

    @Override
    @MediaProperty(uuid1=85985541, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Engine", typeName="AUID", optional=true, uniqueIdentifier=false, pid=8716, symbol="Engine")
    public AUID getEngine() throws PropertyNotPresentException {
        if (this.engine == null) {
            throw new PropertyNotPresentException("The optional engine property is not present in this plugin definition.");
        }
        return this.engine.clone();
    }

    @Override
    @MediaPropertySetter(value="Engine")
    public void setEngine(AUID engine) {
        if (engine == null) {
            this.engine = null;
            return;
        }
        this.engine = engine.clone();
    }

    @Override
    public VersionType[] getEngineVersionRange() throws PropertyNotPresentException {
        if (this.minEngineVersion == null || this.maxEngineVersion == null) {
            throw new PropertyNotPresentException("The optional engine version range is not fully specified for this plugin definition.");
        }
        return new VersionType[]{this.minEngineVersion.clone(), this.maxEngineVersion.clone()};
    }

    @Override
    @MediaProperty(uuid1=85985542, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="MinEngineVersion", typeName="VersionType", optional=true, uniqueIdentifier=false, pid=8717, symbol="MinEngineVersion")
    public VersionType getEngineMinimumVersion() throws PropertyNotPresentException {
        if (this.minEngineVersion == null) {
            throw new PropertyNotPresentException("The optional engine minimum property is not present in this plugin definition.");
        }
        return this.minEngineVersion.clone();
    }

    @Override
    @MediaPropertySetter(value="MinEngineVersion")
    public void setEngineMinimumVersion(VersionType minVersion) {
        if (minVersion == null) {
            this.minEngineVersion = null;
            return;
        }
        this.minEngineVersion = minVersion.clone();
    }

    @Override
    @MediaProperty(uuid1=85985543, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="MaxEngineVersion", typeName="VersionType", optional=true, uniqueIdentifier=false, pid=8718, symbol="MaxEngineVersion")
    public VersionType getEngineMaximumVersion() throws PropertyNotPresentException {
        if (this.maxEngineVersion == null) {
            throw new PropertyNotPresentException("The optional engine maximum version is not present for this plugin definition.");
        }
        return this.maxEngineVersion.clone();
    }

    @Override
    @MediaPropertySetter(value="MaxEngineVersion")
    public void setEngineMaximumVersion(VersionType maxEngineVersion) {
        if (maxEngineVersion == null) {
            this.maxEngineVersion = null;
            return;
        }
        this.maxEngineVersion = maxEngineVersion.clone();
    }

    @Override
    @MediaProperty(uuid1=85985538, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PluginPlatform", aliases={"Platform", "PluginDefinitionPlatform"}, typeName="AUID", optional=true, uniqueIdentifier=false, pid=8713, symbol="PluginPlatform")
    public AUID getPluginPlatform() throws PropertyNotPresentException {
        if (this.pluginPlatform == null) {
            throw new PropertyNotPresentException("The optional platform property is not present for this plugin definition.");
        }
        return this.pluginPlatform.clone();
    }

    @Override
    @MediaPropertySetter(value="PluginPlatform")
    public void setPluginPlatform(AUID pluginPlatform) {
        if (pluginPlatform == null) {
            this.pluginPlatform = null;
            return;
        }
        this.pluginPlatform = pluginPlatform.clone();
    }

    @MediaProperty(uuid1=85985549, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PluginLocators", aliases={"Locators"}, typeName="LocatorStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=8724, symbol="PluginLocators")
    public List<Locator> getPluginLocators() throws PropertyNotPresentException {
        if (this.pluginLocators.size() == 0) {
            throw new PropertyNotPresentException("No optional locators are provided for this plugin definition.");
        }
        return StrongReferenceVector.getOptionalList(this.pluginLocators);
    }

    @Override
    @MediaListGetAt(value="PluginLocators")
    public Locator getPluginLocatorAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.pluginLocators, index);
    }

    @Override
    @MediaListAppend(value="PluginLocators")
    public void appendPluginLocator(Locator pluginLocator) throws NullPointerException {
        if (pluginLocator == null) {
            throw new NullPointerException("Cannot append a null locator to the list of locators for this plugin definition.");
        }
        StrongReferenceVector.append(this.pluginLocators, pluginLocator);
    }

    @Override
    @MediaPropertyCount(value="PluginLocators")
    public int countPluginLocators() {
        return this.pluginLocators.size();
    }

    @Override
    @MediaListPrepend(value="PluginLocators")
    public void prependPluginLocator(Locator pluginLocator) throws NullPointerException {
        if (pluginLocator == null) {
            throw new NullPointerException("Cannot prepend a null locator to the list of locators for this plugin definition.");
        }
        StrongReferenceVector.prepend(this.pluginLocators, pluginLocator);
    }

    @Override
    @MediaListInsertAt(value="PluginLocators")
    public void insertPluginLocatorAt(int index, Locator pluginLocator) throws NullPointerException, IndexOutOfBoundsException {
        if (pluginLocator == null) {
            throw new NullPointerException("Cannot insert a null locator into the list of locators for this plugin definition.");
        }
        StrongReferenceVector.insert(this.pluginLocators, index, pluginLocator);
    }

    @Override
    @MediaListRemoveAt(value="PluginLocators")
    public void removePluginLocatorAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.pluginLocators, index);
    }

    @Override
    @MediaPropertyClear(value="PluginLocators")
    public void clearPluginLocators() {
        this.pluginLocators = Collections.synchronizedList(new Vector());
    }

    @Override
    @MediaProperty(uuid1=0x10A0101, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ManufacturerID", aliases={"PluginDefinitionManufacturerID"}, typeName="AUID", optional=true, uniqueIdentifier=false, pid=8712, symbol="ManufacturerID")
    public AUID getManufacturerID() throws PropertyNotPresentException {
        if (this.manufacturerID == null) {
            throw new PropertyNotPresentException("The optional manufacturer id property is not present in this plugin definition.");
        }
        return this.manufacturerID.clone();
    }

    @Override
    @MediaPropertySetter(value="ManufacturerID")
    public void setManufacturerID(AUID manufacturerId) {
        if (manufacturerId == null) {
            this.manufacturerID = null;
            return;
        }
        this.manufacturerID = manufacturerId.clone();
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=523, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ManufacturerInfo", typeName="NetworkLocatorStrongReference", optional=true, uniqueIdentifier=false, pid=8711, symbol="ManufacturerInfo")
    public NetworkLocator getManufacturerInfo() throws PropertyNotPresentException {
        if (this.manufacturerInfo == null) {
            throw new PropertyNotPresentException("The optional manufacturer information is not present for this plugin definition.");
        }
        return this.manufacturerInfo;
    }

    @Override
    @MediaPropertySetter(value="ManufacturerInfo")
    public void setManufacturerInfo(NetworkLocator manufacturerInfo) throws NullPointerException {
        if (manufacturerInfo == null) {
            this.manufacturerInfo = null;
            return;
        }
        this.manufacturerInfo = manufacturerInfo;
    }

    @Override
    public VersionType[] getPlatformVersionRange() throws PropertyNotPresentException {
        if (this.minPlatformVersion == null || this.maxPlatformVersion == null) {
            throw new PropertyNotPresentException("The optional platform version range is not fully specified for this plugin definition.");
        }
        return new VersionType[]{this.minPlatformVersion.clone(), this.maxPlatformVersion.clone()};
    }

    @Override
    @MediaProperty(uuid1=85985539, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="MinPlatformVersion", typeName="VersionType", optional=true, uniqueIdentifier=false, pid=8714, symbol="MinPlatformVersion")
    public VersionType getPlatformMinimumVersion() throws PropertyNotPresentException {
        if (this.minPlatformVersion == null) {
            throw new PropertyNotPresentException("The optional platform minimum version property is not set for this plugin definition.");
        }
        return this.minPlatformVersion.clone();
    }

    @Override
    @MediaPropertySetter(value="MinPlatformVersion")
    public void setPlatformMinimumVersion(VersionType minVersion) {
        if (minVersion == null) {
            this.minPlatformVersion = null;
            return;
        }
        this.minPlatformVersion = minVersion.clone();
    }

    @Override
    @MediaProperty(uuid1=85985540, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="MaxPlatformVersion", typeName="VersionType", optional=true, uniqueIdentifier=false, pid=8715, symbol="MaxPlatformVersion")
    public VersionType getPlatformMaximumVersion() throws PropertyNotPresentException {
        if (this.maxPlatformVersion == null) {
            throw new PropertyNotPresentException("The optional platform maximum version property is not set for this plugin definition.");
        }
        return this.maxPlatformVersion.clone();
    }

    @Override
    @MediaPropertySetter(value="MaxPlatformVersion")
    public void setPlatformMaximumVersion(VersionType maxVersion) {
        if (maxVersion == null) {
            this.maxPlatformVersion = null;
            return;
        }
        this.maxPlatformVersion = maxVersion.clone();
    }

    @Override
    @MediaProperty(uuid1=85985544, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PluginAPI", typeName="AUID", optional=true, uniqueIdentifier=false, pid=8719, symbol="PluginAPI")
    public AUID getPluginAPI() throws PropertyNotPresentException {
        if (this.pluginAPI == null) {
            throw new PropertyNotPresentException("The optional plugin API property is not present in this plugin definition.");
        }
        return this.pluginAPI.clone();
    }

    @Override
    @MediaPropertySetter(value="PluginAPI")
    public void setPluginAPI(AUID pluginAPI) {
        if (pluginAPI == null) {
            this.pluginAPI = null;
            return;
        }
        this.pluginAPI = pluginAPI.clone();
    }

    @Override
    public VersionType[] getPluginAPIVersionRange() throws PropertyNotPresentException {
        if (this.minPluginAPI == null || this.maxPluginAPI == null) {
            throw new PropertyNotPresentException("The optional plugin API version range is not fully specified for this plugin definition.");
        }
        return new VersionType[]{this.minPluginAPI.clone(), this.maxPluginAPI.clone()};
    }

    @Override
    @MediaProperty(uuid1=85985545, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="MinPluginAPI", typeName="VersionType", optional=true, uniqueIdentifier=false, pid=8720, symbol="MinPluginAPI")
    public VersionType getPluginAPIMinimumVersion() throws PropertyNotPresentException {
        if (this.minPluginAPI == null) {
            throw new PropertyNotPresentException("The optional plugin API minimum version property is not set for this plugin definition.");
        }
        return this.minPluginAPI.clone();
    }

    @Override
    @MediaPropertySetter(value="MinPluginAPI")
    public void setPluginAPIMinimumVersion(VersionType minVersion) {
        if (minVersion == null) {
            this.minPluginAPI = null;
            return;
        }
        this.minPluginAPI = minVersion.clone();
    }

    @Override
    @MediaProperty(uuid1=85985546, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="MaxPluginAPI", typeName="VersionType", optional=true, uniqueIdentifier=false, pid=8721, symbol="MaxPluginAPI")
    public VersionType getPluginAPIMaximumVersion() throws PropertyNotPresentException {
        if (this.maxPluginAPI == null) {
            throw new PropertyNotPresentException("The optional plugin API maximum version is not set for this plugin definition.");
        }
        return this.maxPluginAPI.clone();
    }

    @Override
    @MediaPropertySetter(value="MaxPluginAPI")
    public void setPluginAPIMaximumVersion(VersionType maxVersion) {
        if (maxVersion == null) {
            this.maxPluginAPI = null;
            return;
        }
        this.maxPluginAPI = maxVersion.clone();
    }

    @Override
    @MediaProperty(uuid1=0x10A0101, uuid2=257, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="DeviceManufacturerName", aliases={"Manufacturer", "PluginDefinitionManufacturer"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=8710, symbol="DeviceManufacturerName")
    public String getDeviceManufacturerName() throws PropertyNotPresentException {
        if (this.deviceManufacturerName == null) {
            throw new PropertyNotPresentException("Cannot set the manufacturer name property for this plugin definition with a null value.");
        }
        return this.deviceManufacturerName;
    }

    @Override
    @MediaPropertySetter(value="DeviceManufacturerName")
    public void setDeviceManufacturerName(String deviceManufacturerName) {
        this.deviceManufacturerName = deviceManufacturerName;
    }

    @Override
    @MediaProperty(uuid1=0x3030301, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PluginVersion", aliases={"VersionNumber"}, typeName="VersionType", optional=false, uniqueIdentifier=false, pid=8708, symbol="PluginVersion")
    public VersionType getPluginVersion() {
        return this.pluginVersion.clone();
    }

    @Override
    @MediaPropertySetter(value="PluginVersion")
    public void setPluginVersion(VersionType version) throws NullPointerException {
        if (version == null) {
            throw new NullPointerException("Cannot set the plugin version number of this plugin definition using a null value.");
        }
        this.pluginVersion = version.clone();
    }

    public static final VersionType initializePluginVersion() {
        return new VersionTypeImpl(0, 0);
    }

    @Override
    @MediaProperty(uuid1=0x3030301, uuid2=513, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PluginVersionString", aliases={"VersionString"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=8709, symbol="PluginVersionString")
    public String getPluginVersionString() throws PropertyNotPresentException {
        if (this.pluginVersionString == null) {
            throw new PropertyNotPresentException("The optional plugin version string is not set for this plugin definition.");
        }
        return this.pluginVersionString;
    }

    @Override
    @MediaPropertySetter(value="PluginVersionString")
    public void setPluginVersionString(String pluginVersionString) {
        this.pluginVersionString = pluginVersionString;
    }

    @Override
    public boolean isAccelerated() {
        return this.getIsAccelerated();
    }

    @Override
    @MediaProperty(uuid1=85985548, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Accelerator", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=8723, symbol="Accelerator")
    public boolean getIsAccelerated() {
        if (this.accelerator == null) {
            return false;
        }
        return this.accelerator;
    }

    @Override
    @MediaPropertySetter(value="Accelerator")
    public void setIsAccelerated(Boolean isAccelerated) {
        this.accelerator = isAccelerated;
    }

    @Override
    public boolean isSoftwareOnly() {
        return this.getIsSoftwareOnly();
    }

    @Override
    @MediaProperty(uuid1=85985547, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="SoftwareOnly", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=8722, symbol="SoftwareOnly")
    public boolean getIsSoftwareOnly() {
        if (this.softwareOnly == null) {
            return false;
        }
        return this.softwareOnly;
    }

    @Override
    @MediaPropertySetter(value="SoftwareOnly")
    public void setIsSoftwareOnly(Boolean isSoftwareOnly) {
        this.softwareOnly = isSoftwareOnly;
    }

    @Override
    public boolean supportsAuthentication() {
        return this.getSupportsAuthentication();
    }

    @Override
    @MediaProperty(uuid1=85985550, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Authentication", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=8725, symbol="Authentication")
    public boolean getSupportsAuthentication() {
        if (this.authentication == null) {
            return false;
        }
        return this.authentication;
    }

    @Override
    @MediaPropertySetter(value="Authentication")
    public void setSupportsAuthentication(Boolean supportsAuthentication) {
        this.authentication = supportsAuthentication;
    }

    @Override
    public PluginDefinition clone() {
        return (PluginDefinition)super.clone();
    }

    public String getPluginCategoryString() {
        return AUIDImpl.toPersistentForm(this.pluginCategory);
    }

    public void setPluginCategoryString(String pluginCategory) {
        this.pluginCategory = AUIDImpl.fromPersistentForm(pluginCategory);
    }

    public String getPluginVersionPersist() {
        return VersionTypeImpl.toPersistentForm(this.pluginVersion);
    }

    public void setPluginVersionPersist(String pluginVersion) {
        this.pluginVersion = VersionTypeImpl.fromPersistentForm(pluginVersion);
    }

    public String getManufacturerIDString() {
        return AUIDImpl.toPersistentForm(this.manufacturerID);
    }

    public void setManufacturerIDString(String manufacturerID) {
        this.manufacturerID = AUIDImpl.fromPersistentForm(manufacturerID);
    }

    public String getPluginPlatformString() {
        return AUIDImpl.toPersistentForm(this.pluginPlatform);
    }

    public void setPluginPlatformString(String pluginPlatform) {
        this.pluginPlatform = AUIDImpl.fromPersistentForm(pluginPlatform);
    }

    public String getMaxPlatformVersionString() {
        return VersionTypeImpl.toPersistentForm(this.maxPlatformVersion);
    }

    public void setMaxPlatformVersionString(String maxPlatformVersion) {
        this.maxPlatformVersion = VersionTypeImpl.fromPersistentForm(maxPlatformVersion);
    }

    public String getMinPlatformVersionString() {
        return VersionTypeImpl.toPersistentForm(this.minPlatformVersion);
    }

    public void setMinPlatformVersionString(String minPlatformVersion) {
        this.minPlatformVersion = VersionTypeImpl.fromPersistentForm(minPlatformVersion);
    }

    public String getEngineString() {
        return AUIDImpl.toPersistentForm(this.engine);
    }

    public void setEngineString(String engine) {
        this.engine = AUIDImpl.fromPersistentForm(engine);
    }

    public String getMinEngineVersionString() {
        return VersionTypeImpl.toPersistentForm(this.minEngineVersion);
    }

    public void setMinEngineVersionString(String minEngineVersionString) {
        this.minEngineVersion = VersionTypeImpl.fromPersistentForm(minEngineVersionString);
    }

    public String getMaxEngineVersionString() {
        return VersionTypeImpl.toPersistentForm(this.maxEngineVersion);
    }

    public void setMaxEngineVersionString(String maxEngineVersion) {
        this.maxEngineVersion = VersionTypeImpl.fromPersistentForm(maxEngineVersion);
    }

    public String getPluginAPIString() {
        return AUIDImpl.toPersistentForm(this.pluginAPI);
    }

    public void setPluginAPIString(String pluginAPI) {
        this.pluginAPI = AUIDImpl.fromPersistentForm(pluginAPI);
    }

    public String getMinPluginAPIString() {
        return VersionTypeImpl.toPersistentForm(this.minPluginAPI);
    }

    public void setMinPluginAPIString(String minPluginAPI) {
        this.minPluginAPI = VersionTypeImpl.fromPersistentForm(minPluginAPI);
    }

    public String getMaxPluginAPIString() {
        return VersionTypeImpl.toPersistentForm(this.maxPluginAPI);
    }

    public void setMaxPluginAPIString(String maxPluginAPI) {
        this.maxPluginAPI = VersionTypeImpl.fromPersistentForm(maxPluginAPI);
    }

    public String getImplementedClassString() {
        return AUIDImpl.toPersistentForm(this.implementedClass);
    }

    public void setImplementedClassString(String implementedClass) {
        this.implementedClass = AUIDImpl.fromPersistentForm(implementedClass);
    }
}

