/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.DuplicateParameterException;
import tv.amwa.maj.exception.ParameterNotFoundException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.extensions.quantel.QOperationGroup;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.integer.Int64;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.OperationDefinition;
import tv.amwa.maj.model.OperationGroup;
import tv.amwa.maj.model.Parameter;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.SourceReferenceSegment;
import tv.amwa.maj.model.impl.OperationDefinitionImpl;
import tv.amwa.maj.model.impl.SegmentImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=2560, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="OperationGroup", description="The OperationGroup class contains an ordered set of Segments and an operation that is performed on these Segments.", symbol="OperationGroup")
public class OperationGroupImpl
extends SegmentImpl
implements OperationGroup,
QOperationGroup,
Serializable,
Cloneable {
    private static final long serialVersionUID = -919233865311520609L;
    private WeakReference<OperationDefinition> operation;
    private List<Segment> inputSegments = Collections.synchronizedList(new Vector());
    private List<Parameter> parameters = Collections.synchronizedList(new Vector());
    private SourceReferenceSegment rendering = null;
    private Integer bypassOverride = null;
    private Long effectOffset = null;
    private Stream transitionBlob = null;
    private Long effectLength = null;
    private String effectName = null;
    private Integer effectRenderKey = null;
    private Integer repeatFinteTails = null;
    private Integer effectEnabled = null;
    private Integer repeatRushAttributes = null;
    private PropertyValue effectSourceOffset = null;
    private Stream packBlob = null;
    private String repeatRushID = null;
    private Segment renderKey = null;
    private Segment packRenderSequence = null;
    private Long repeatRushOffset = null;
    private Integer effectSourceAttached = null;
    private Long packOffset = null;
    private PropertyValue effectSourceLength = null;

    public OperationGroupImpl() {
    }

    public OperationGroupImpl(DataDefinition dataDefinition, long length, OperationDefinition operation) throws NullPointerException, BadLengthException {
        if (dataDefinition == null) {
            throw new NullPointerException("Cannot create a new operation group with a null data definition.");
        }
        if (operation == null) {
            throw new NullPointerException("Cannot create a new operation group with a null operation definition.");
        }
        if (length < 0L) {
            throw new BadLengthException("Cannot set the length of an operation group to a negative value.");
        }
        this.setComponentDataDefinition(dataDefinition);
        this.setLengthPresent(true);
        this.setComponentLength(length);
        this.setOperationDefinition(operation);
    }

    @MediaProperty(uuid1=100729092, uuid2=1546, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Parameters", typeName="ParameterStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=2819, symbol="Parameters")
    public List<Parameter> getParameters() throws PropertyNotPresentException {
        if (this.parameters.size() == 0) {
            throw new PropertyNotPresentException("No parameters are present for this operation group.");
        }
        return StrongReferenceVector.getOptionalList(this.parameters);
    }

    @Override
    @MediaListAppend(value="Parameters")
    public void addParameter(Parameter parameter) throws DuplicateParameterException, NullPointerException {
        if (parameter == null) {
            throw new NullPointerException("Cannot add a null-valued parameter to the list of parameters of this operation group.");
        }
        if (this.parameters.contains(parameter)) {
            throw new DuplicateParameterException("Cannot add the given parameter to the operation group as it is already contained.");
        }
        StrongReferenceVector.append(this.parameters, parameter);
    }

    @Override
    @MediaPropertyCount(value="Parameters")
    public int countParameters() {
        return this.parameters.size();
    }

    @Override
    @MediaPropertyClear(value="Parameters")
    public void clearParameters() {
        this.parameters = Collections.synchronizedList(new Vector());
    }

    @Override
    public Parameter lookupParameter(AUID argID) throws ParameterNotFoundException, NullPointerException {
        if (argID == null) {
            throw new NullPointerException("Cannot lookup a parameter in an operation group using a null AUID value.");
        }
        for (Parameter parameter : this.parameters) {
            if (!parameter.getParameterDefinition().getAUID().equals(argID)) continue;
            return parameter;
        }
        throw new ParameterNotFoundException("A parameter with the given id was not found in this operation group.");
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=1538, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="InputSegments", typeName="SegmentStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=2818, symbol="InputSegments")
    public List<Segment> getInputSegments() throws PropertyNotPresentException {
        if (this.inputSegments.size() == 0) {
            throw new PropertyNotPresentException("No input segments are defined for this operation group.");
        }
        return StrongReferenceVector.getOptionalList(this.inputSegments);
    }

    @Override
    @MediaListGetAt(value="InputSegments")
    public Segment getInputSegmentAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.inputSegments, index);
    }

    @Override
    @MediaListAppend(value="InputSegments")
    public void appendInputSegment(Segment segment) throws NullPointerException {
        if (segment == null) {
            throw new NullPointerException("Cannot append a null valued segment to the list of input segments of this operation group.");
        }
        StrongReferenceVector.append(this.inputSegments, segment);
    }

    @Override
    @MediaPropertyCount(value="InputSegments")
    public int countInputSegments() {
        return this.inputSegments.size();
    }

    @Override
    @MediaListInsertAt(value="InputSegments")
    public void insertInputSegmentAt(int index, Segment segment) throws NullPointerException, IndexOutOfBoundsException {
        if (segment == null) {
            throw new NullPointerException("Cannot insert a null valued segment into the list of segments of this operation group.");
        }
        StrongReferenceVector.insert(this.inputSegments, index, segment);
    }

    @Override
    @MediaListPrepend(value="InputSegments")
    public void prependInputSegment(Segment segment) throws NullPointerException {
        if (segment == null) {
            throw new NullPointerException("Cannot prepend a null valued segment to the list of segments of this operation group.");
        }
        StrongReferenceVector.prepend(this.inputSegments, segment);
    }

    @Override
    @MediaListRemoveAt(value="InputSegments")
    public void removeInputSegmentAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.inputSegments, index);
    }

    @Override
    @MediaPropertyClear(value="InputSegments")
    public void clearInputSegments() {
        this.inputSegments = Collections.synchronizedList(new Vector());
    }

    @Override
    @MediaProperty(uuid1=87033100, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="BypassOverride", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=2820, symbol="BypassOverride")
    public int getBypassOverride() throws PropertyNotPresentException {
        if (this.bypassOverride == null) {
            throw new PropertyNotPresentException("The optional bypass override property is not present for this operation group.");
        }
        return this.bypassOverride;
    }

    @Override
    @MediaPropertySetter(value="BypassOverride")
    public void setBypassOverride(Integer bypassOverride) throws IllegalArgumentException {
        if (bypassOverride == null) {
            this.bypassOverride = null;
            return;
        }
        if (bypassOverride < 1) {
            throw new IllegalArgumentException("The bypass override value must be a 1-based index value.");
        }
        this.bypassOverride = bypassOverride;
    }

    @Override
    @MediaProperty(uuid1=87033094, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Operation", aliases={"OperationDefinition"}, typeName="OperationDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=2817, symbol="Operation")
    public OperationDefinition getOperationDefinition() {
        return this.operation.getTarget();
    }

    @Override
    @MediaPropertySetter(value="Operation")
    public void setOperationDefinition(OperationDefinition operationDefinition) throws NullPointerException {
        if (operationDefinition == null) {
            throw new NullPointerException("Cannot set the operation of this operation group using a null value.");
        }
        this.operation = new WeakReference<OperationDefinition>(operationDefinition);
    }

    public static final OperationDefinition initializeOperation() {
        return OperationDefinitionImpl.forName("Unknown");
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=518, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Rendering", aliases={"OperationGroupRendering"}, typeName="SourceReferenceStrongReference", optional=true, uniqueIdentifier=false, pid=2821, symbol="Rendering")
    public SourceReferenceSegment getRendering() throws PropertyNotPresentException {
        if (this.rendering == null) {
            throw new PropertyNotPresentException("The optional rendering property is not present for this operation group.");
        }
        return this.rendering;
    }

    @Override
    @MediaPropertySetter(value="Rendering")
    public void setRendering(SourceReferenceSegment sourceReference) {
        if (sourceReference == null) {
            this.rendering = null;
            return;
        }
        this.rendering = sourceReference;
    }

    @Override
    public boolean isTimeWarp() {
        return this.operation.getTarget().isTimeWarp();
    }

    @Override
    public boolean isValidTransitionOperation() {
        return this.operation.getTarget().getOperationInputCount() == 2;
    }

    @Override
    @MediaProperty(uuid1=1840896776, uuid2=12696, uuid3=16704, uuid4={-109, 2, 10, -77, -80, 21, 23, -65}, definedName="Effect offset", symbol="Effect_offset", aliases={"Effect_offset"}, typeName="Int64", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int64
    public long getEffectOffset() throws PropertyNotPresentException {
        if (this.effectOffset == null) {
            throw new PropertyNotPresentException("The optional effect offset property is not present for this Quantel operation group.");
        }
        return this.effectOffset;
    }

    @Override
    @MediaPropertySetter(value="Effect offset")
    public void setEffectOffset(@Int64 Long effectOffset) {
        this.effectOffset = effectOffset;
    }

    @Override
    @MediaProperty(uuid1=756262420, uuid2=-1847, uuid3=18448, uuid4={-109, 77, 77, -98, 32, 0, 104, 96}, definedName="Transition blob", symbol="Transition_blob", aliases={"Transition_blob"}, typeName="Stream", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Stream getTransitionBlob() throws PropertyNotPresentException {
        if (this.transitionBlob == null) {
            throw new PropertyNotPresentException("The optional transition blob property is not present for this Quantel operation group.");
        }
        return this.transitionBlob;
    }

    @Override
    @MediaPropertySetter(value="Transition blob")
    public void setTransitionBlob(Stream transitionBlob) {
        this.transitionBlob = transitionBlob;
    }

    @Override
    @MediaProperty(uuid1=-398950123, uuid2=-19186, uuid3=16793, uuid4={-121, 25, -37, -84, 47, 53, 120, -65}, definedName="Effect length", symbol="Effect_length", aliases={"Effect_length"}, typeName="Int64", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int64
    public long getEffectLength() throws PropertyNotPresentException {
        if (this.effectLength == null) {
            throw new PropertyNotPresentException("The optional effect length property is not present for this Quantel operation group.");
        }
        return this.effectLength;
    }

    @Override
    @MediaPropertySetter(value="Effect length")
    public void setEffectLength(@Int64 Long effectLength) {
        this.effectLength = effectLength;
    }

    @Override
    @MediaProperty(uuid1=-1704639198, uuid2=5205, uuid3=16422, uuid4={-113, -47, 85, 38, -83, 98, -33, 90}, definedName="Effect name", symbol="Effect_name", aliases={"Effect_name"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public String getEffectName() throws PropertyNotPresentException {
        if (this.effectName == null) {
            throw new PropertyNotPresentException("The optional effect name property is not present for this Quantel operation group.");
        }
        return this.effectName;
    }

    @Override
    @MediaPropertySetter(value="Effect name")
    public void setEffectName(String effectName) {
        this.effectName = effectName;
    }

    @Override
    @MediaProperty(uuid1=-1245835738, uuid2=15372, uuid3=20265, uuid4={-93, 44, 87, 97, 76, 62, 109, 21}, definedName="Effect render key", symbol="Effect_render_key", aliases={"Effect_render_key"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getEffectRenderKey() throws PropertyNotPresentException {
        if (this.effectRenderKey == null) {
            throw new PropertyNotPresentException("The optional effect render key property is not present for this Quantel operation group.");
        }
        return this.effectRenderKey;
    }

    @Override
    @MediaPropertySetter(value="Effect render key")
    public void setEffectRenderKey(@Int32 Integer effectRenderKey) {
        this.effectRenderKey = effectRenderKey;
    }

    @Override
    @MediaProperty(uuid1=-2097721542, uuid2=11216, uuid3=17974, uuid4={-66, -11, -84, 49, 115, 107, 31, 17}, definedName="Repeat finite tails", symbol="Repeat_finite_tails", aliases={"Repeat_finite_tails"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getRepeatFiniteTails() throws PropertyNotPresentException {
        if (this.repeatFinteTails == null) {
            throw new PropertyNotPresentException("The optional repeat finite tails property is not present for this Quantel operation group.");
        }
        return this.repeatFinteTails;
    }

    @Override
    @MediaPropertySetter(value="Repeat finite tails")
    public void setRepeatFiniteTails(@Int32 Integer repeatFiniteTails) {
        this.repeatFinteTails = repeatFiniteTails;
    }

    @Override
    @MediaProperty(uuid1=1028895568, uuid2=26001, uuid3=19665, uuid4={-112, -34, -14, -47, 117, -46, -32, -72}, definedName="Effect enabled", symbol="Effect_enabled", aliases={"Effect_enabled"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getEffectEnabled() throws PropertyNotPresentException {
        if (this.effectEnabled == null) {
            throw new PropertyNotPresentException("The optional effect enabled property is not present for this Quantel operation group.");
        }
        return this.effectEnabled;
    }

    @Override
    @MediaPropertySetter(value="Effect enabled")
    public void setEffectEnabled(@Int32 Integer effectEnabled) {
        this.effectEnabled = effectEnabled;
    }

    @Override
    @MediaProperty(uuid1=1687655765, uuid2=12816, uuid3=18489, uuid4={-68, -49, 83, 71, -62, -50, -76, -11}, definedName="Repeat rush attributes", symbol="Repeat_rush_attributes", aliases={"Repeat_rush_attributes"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getRepeatRushAttributes() throws PropertyNotPresentException {
        if (this.repeatRushAttributes == null) {
            throw new PropertyNotPresentException("The optional repeat rush attributes property is not present for this Quantel operation group.");
        }
        return this.repeatRushAttributes;
    }

    @Override
    @MediaPropertySetter(value="Repeat rush attributes")
    public void setRepeatRushAttributes(@Int32 Integer repeatRushAttributes) {
        this.repeatRushAttributes = repeatRushAttributes;
    }

    @Override
    @MediaProperty(uuid1=1528138854, uuid2=-15900, uuid3=19721, uuid4={-83, -19, -35, 5, 6, 1, 41, 24}, definedName="Effect source offset", symbol="Effect_source_offset", aliases={"Effect_source_offset"}, typeName="Indirect", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public PropertyValue getEffectSourceOffset() throws PropertyNotPresentException {
        if (this.effectSourceOffset == null) {
            throw new PropertyNotPresentException("The optional effect source offset property is not present for this Quantel operation group.");
        }
        return this.effectSourceOffset;
    }

    @Override
    @MediaPropertySetter(value="Effect source offset")
    public void setEffectSourceOffset(PropertyValue effectSourceOffset) {
        this.effectSourceOffset = effectSourceOffset;
    }

    @Override
    @MediaProperty(uuid1=1231274346, uuid2=-5116, uuid3=17013, uuid4={-80, -64, -104, 19, -80, -8, -69, 116}, definedName="Pack blob", symbol="Pack_blob", aliases={"Pack_blob"}, typeName="Stream", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Stream getPackBlob() throws PropertyNotPresentException {
        if (this.packBlob == null) {
            throw new PropertyNotPresentException("The optional pack blob property is not present for this Quantel operation group.");
        }
        return this.packBlob;
    }

    @Override
    @MediaPropertySetter(value="Pack blob")
    public void setPackBlob(Stream packBlob) {
        this.packBlob = packBlob;
    }

    @Override
    @MediaProperty(uuid1=-1878368096, uuid2=17624, uuid3=17829, uuid4={-119, 51, -116, -2, 88, 16, -124, 32}, definedName="Repeat rush id", symbol="Repeat_rush_id", aliases={"Repeat_rush_id"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public String getRepeatRushID() throws PropertyNotPresentException {
        if (this.repeatRushID == null) {
            throw new PropertyNotPresentException("The optional repeat rush ID property is not present for this Quantel operation group.");
        }
        return this.repeatRushID;
    }

    @Override
    @MediaPropertySetter(value="Repeat rush id")
    public void setRepeatRushID(String repeatRushID) {
        this.repeatRushID = repeatRushID;
    }

    @Override
    @MediaProperty(uuid1=1408683687, uuid2=-23197, uuid3=17548, uuid4={-121, 34, 30, -118, -63, -17, -59, -84}, definedName="Render key", symbol="Render_key", aliases={"Render_key"}, typeName="SegmentStrongReference", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Segment getRenderKey() throws PropertyNotPresentException {
        if (this.renderKey == null) {
            throw new PropertyNotPresentException("The optional render key property is not present for this Quantel operation group.");
        }
        return this.renderKey;
    }

    @Override
    @MediaPropertySetter(value="Render key")
    public void setRenderKey(Segment renderKey) {
        this.renderKey = renderKey;
    }

    @Override
    @MediaProperty(uuid1=1603302589, uuid2=3551, uuid3=17859, uuid4={-68, 13, 95, 96, -81, -42, 21, -77}, definedName="Pack render sequence", symbol="Pack_render_sequence", aliases={"Pack_render_sequence"}, typeName="SegmentStrongReference", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Segment getPackRenderSequence() throws PropertyNotPresentException {
        if (this.packRenderSequence == null) {
            throw new PropertyNotPresentException("The optional pack render sequence property is not present for this Quantel operation group.");
        }
        return this.packRenderSequence;
    }

    @Override
    @MediaPropertySetter(value="Pack render sequence")
    public void setPackRenderSequence(Segment packRenderSequence) {
        this.packRenderSequence = packRenderSequence;
    }

    @Override
    @MediaProperty(uuid1=-1419734580, uuid2=-14658, uuid3=17546, uuid4={-67, 105, 110, -119, 55, 85, 54, 122}, definedName="Repeat rush offset", symbol="Repeat_rush_offset", aliases={"Repeat_rush_offset"}, typeName="Int64", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int64
    public long getRepeatRushOffset() throws PropertyNotPresentException {
        if (this.repeatRushOffset == null) {
            throw new PropertyNotPresentException("The optional repeat rush offset property is not present for this Quantel operation group.");
        }
        return this.repeatRushOffset;
    }

    @Override
    @MediaPropertySetter(value="Repeat rush offset")
    public void setRepeatRushOffset(@Int64 Long repeatRushOffset) {
        this.repeatRushOffset = repeatRushOffset;
    }

    @Override
    @MediaProperty(uuid1=-282280238, uuid2=21204, uuid3=19160, uuid4={-104, 22, -113, -25, -23, 81, 71, 104}, definedName="Effect source attached", symbol="Effect_source_attached", aliases={"Effect_source_attached"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getEffectSourceAttached() throws PropertyNotPresentException {
        if (this.effectSourceAttached == null) {
            throw new PropertyNotPresentException("The optional effect source attached property is not present for this Quantel operation group.");
        }
        return this.effectSourceAttached;
    }

    @Override
    @MediaPropertySetter(value="Effect source attached")
    public void setEffectSourceAttached(@Int32 Integer effectSourceAttached) {
        this.effectSourceAttached = effectSourceAttached;
    }

    @Override
    @MediaProperty(uuid1=-896045349, uuid2=-25168, uuid3=20038, uuid4={-92, -46, 45, 78, 69, 3, -16, 32}, definedName="Pack offset", symbol="Pack_offset", aliases={"Pack_offset"}, typeName="Int64", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int64
    public long getPackOffset() throws PropertyNotPresentException {
        if (this.packOffset == null) {
            throw new PropertyNotPresentException("The optional pack offset property is not present for this Quantel operation group.");
        }
        return this.packOffset;
    }

    @Override
    @MediaPropertySetter(value="Pack offset")
    public void setPackOffset(@Int64 Long packOffset) {
        this.packOffset = packOffset;
    }

    @Override
    @MediaProperty(uuid1=1298672126, uuid2=13113, uuid3=16496, uuid4={-95, 123, -125, 24, 95, 12, 61, -118}, definedName="Effect source length", symbol="Effect_source_length", aliases={"Effect_source_length"}, typeName="Indirect", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public PropertyValue getEffectSourceLength() throws PropertyNotPresentException {
        if (this.effectSourceLength == null) {
            throw new PropertyNotPresentException("The optional effect source length property is not present for this Quantel operation group.");
        }
        return this.effectSourceLength;
    }

    @Override
    @MediaPropertySetter(value="Effect source length")
    public void setEffectSourceLength(PropertyValue effectSourceLength) {
        this.effectSourceLength = effectSourceLength;
    }

    @Override
    public OperationGroup clone() {
        return (OperationGroup)super.clone();
    }
}

