/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.BadTypeException;
import tv.amwa.maj.exception.DataSizeException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MemoryResidentStream;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionStream;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.util.Utilities;

@MediaClass(uuid1=0xD010101, uuid2=524, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionStream", description="The TypeDefinitionStream class defines a property type that is stored in a stream and has a value that consists of a varying number of the bytes.", symbol="TypeDefinitionStream")
public final class TypeDefinitionStreamImpl
extends SingletonTypeDefinitionImpl
implements TypeDefinitionStream,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7778646178736728937L;

    protected TypeDefinitionStreamImpl() {
    }

    public TypeDefinitionStreamImpl(AUID identification, @AAFString String typeName) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new stream type definition with a null identification.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
    }

    @Override
    public void append(PropertyValue streamProperty, byte[] data) throws NullPointerException, IllegalPropertyValueException, DataSizeException {
        if (streamProperty == null) {
            throw new NullPointerException("Cannot append to a null stream property value.");
        }
        if (!this.equals(streamProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        if (data == null) {
            throw new NullPointerException("Cannot append null data to a stream property value.");
        }
        this.appendToStream(streamProperty, data);
    }

    private void appendToStream(PropertyValue streamProperty, byte[] data) throws DataSizeException {
        Stream stream = (Stream)streamProperty.getValue();
        try {
            stream.write(ByteBuffer.wrap(data));
        }
        catch (Exception e) {
            throw new DataSizeException("Could not write data to the underlying stream because of a " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public void appendElements(PropertyValue streamProperty, TypeDefinition elementType, PropertyValue[] data) throws NullPointerException, IllegalPropertyValueException, BadTypeException, DataSizeException {
        throw new UnsupportedOperationException("This operation is not supported in the current version of the API.");
    }

    @Override
    public void clearStoredByteOrder(PropertyValue streamProperty) throws NullPointerException, IllegalPropertyValueException {
        if (streamProperty == null) {
            throw new NullPointerException("Cannot change the stored byte order from a null stream property value.");
        }
        if (!this.equals(streamProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        ((StreamValue)streamProperty.getValue()).byteOrder = null;
    }

    @Override
    public long getPosition(PropertyValue streamProperty) throws NullPointerException, IllegalPropertyValueException, IOException {
        if (streamProperty == null) {
            throw new NullPointerException("Cannot find the current position of a null stream property value.");
        }
        if (!this.equals(streamProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        return ((StreamValue)streamProperty).getValue().getPosition();
    }

    @Override
    public long getSize(PropertyValue streamProperty) throws NullPointerException, IllegalPropertyValueException, IOException {
        if (streamProperty == null) {
            throw new NullPointerException("Cannot find the size of a null stream property value.");
        }
        if (!this.equals(streamProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        return ((StreamValue)streamProperty).getValue().getLength();
    }

    @Override
    public tv.amwa.maj.enumeration.ByteOrder getStoredByteOrder(PropertyValue streamProperty) throws NullPointerException, IllegalPropertyValueException, PropertyNotPresentException {
        if (streamProperty == null) {
            throw new NullPointerException("Cannot retrieve the stored byte order from a null stream property value.");
        }
        if (!this.equals(streamProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        tv.amwa.maj.enumeration.ByteOrder storedByteOrder = ((StreamValue)streamProperty.getValue()).byteOrder;
        if (storedByteOrder == null) {
            throw new PropertyNotPresentException("The optional byte order is not stored with the stream value.");
        }
        return storedByteOrder;
    }

    @Override
    public boolean hasStoredByteOrder(PropertyValue streamProperty) throws NullPointerException, IllegalPropertyValueException {
        if (streamProperty == null) {
            throw new NullPointerException("Cannot retrieve the stored byte order from a null stream property value.");
        }
        if (!this.equals(streamProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        tv.amwa.maj.enumeration.ByteOrder storedByteOrder = ((StreamValue)streamProperty.getValue()).byteOrder;
        return storedByteOrder != null;
    }

    @Override
    public byte[] read(PropertyValue streamProperty, int dataSize) throws NullPointerException, IllegalArgumentException, EndOfDataException, IllegalPropertyValueException, IOException {
        if (streamProperty == null) {
            throw new NullPointerException("Cannot read data from a null stream property value.");
        }
        if (!this.equals(streamProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        if (dataSize < 0) {
            throw new IllegalArgumentException("Cannot read a negative number of bytes from a stream property value.");
        }
        Stream stream = ((StreamValue)streamProperty).getValue();
        ByteBuffer buffer = stream.read(dataSize);
        return buffer.array();
    }

    @Override
    public PropertyValue[] readElements(PropertyValue streamProperty, TypeDefinition elementType, int numElements) throws NullPointerException, IllegalPropertyValueException, BadTypeException, EndOfDataException {
        throw new UnsupportedOperationException("This operation is not supported in the current version of the API.");
    }

    @Override
    public void setPosition(PropertyValue streamProperty, long newPosition) throws NullPointerException, IllegalArgumentException, IllegalPropertyValueException, IOException {
        if (streamProperty == null) {
            throw new NullPointerException("Cannot set the buffer position for a null stream property value.");
        }
        if (!this.equals(streamProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        ((StreamValue)streamProperty).getValue().setPosition(newPosition);
    }

    @Override
    public void setSize(PropertyValue streamProperty, long newSize) throws NullPointerException, IllegalArgumentException, IllegalPropertyValueException {
        if (streamProperty == null) {
            throw new NullPointerException("Cannot set the size of a null stream property value.");
        }
        if (!this.equals(streamProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        if (newSize < 0L) {
            throw new IllegalArgumentException("Cannot set the size of the given stream property value to a negative value.");
        }
        if (streamProperty instanceof StreamValue) {
            throw new IllegalArgumentException("Cannot set the size for a stream.");
        }
        throw new IllegalArgumentException("This version of MAJ does not support setting the size of streams.");
    }

    @Override
    public void setStoredByteOrder(PropertyValue streamProperty, tv.amwa.maj.enumeration.ByteOrder byteOrder) throws NullPointerException, IllegalPropertyValueException {
        if (streamProperty == null) {
            throw new NullPointerException("Cannot set the stored byte order of a null stream value.");
        }
        if (!this.equals(streamProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        ((StreamValue)streamProperty.getValue()).byteOrder = byteOrder;
    }

    @Override
    public void write(PropertyValue streamProperty, byte[] data) throws NullPointerException, IllegalPropertyValueException, EndOfDataException, IOException {
        if (streamProperty == null) {
            throw new NullPointerException("Cannot write to a null stream value.");
        }
        if (!this.equals(streamProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        Stream stream = ((StreamValue)streamProperty).getValue();
        stream.write(ByteBuffer.wrap(data));
    }

    @Override
    public void writeElements(PropertyValue streamProperty, TypeDefinition elementType, PropertyValue[] data) throws NullPointerException, IllegalPropertyValueException, BadTypeException, EndOfDataException {
        throw new UnsupportedOperationException("This operation is not supported in the current version of the API.");
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        if (javaValue == null) {
            throw new ClassCastException("Cannot create a new stream property value from a null value.");
        }
        if (javaValue instanceof Stream) {
            return new StreamValue(this, (Stream)javaValue);
        }
        if (javaValue instanceof byte[]) {
            ByteBuffer wrappedBytes = ByteBuffer.wrap((byte[])javaValue);
            MemoryResidentStream wrappedStream = new MemoryResidentStream(wrappedBytes);
            return new StreamValue(this, wrappedStream, wrappedBytes.order() == ByteOrder.BIG_ENDIAN ? tv.amwa.maj.enumeration.ByteOrder.Big : tv.amwa.maj.enumeration.ByteOrder.Little);
        }
        if (javaValue instanceof ByteBuffer) {
            ByteBuffer wrappedBytes = (ByteBuffer)javaValue;
            MemoryResidentStream wrappedStream = new MemoryResidentStream(wrappedBytes);
            return new StreamValue(this, wrappedStream, wrappedBytes.order() == ByteOrder.BIG_ENDIAN ? tv.amwa.maj.enumeration.ByteOrder.Big : tv.amwa.maj.enumeration.ByteOrder.Little);
        }
        if (javaValue instanceof String) {
            try {
                byte[] bytes = Utilities.hexStringToBytes((String)javaValue);
                ByteBuffer wrappedBytes = ByteBuffer.wrap(bytes);
                MemoryResidentStream wrappedStream = new MemoryResidentStream(wrappedBytes);
                return new StreamValue(this, wrappedStream, wrappedBytes.order() == ByteOrder.BIG_ENDIAN ? tv.amwa.maj.enumeration.ByteOrder.Big : tv.amwa.maj.enumeration.ByteOrder.Little);
            }
            catch (Exception e) {
                throw new ClassCastException("Cannot convert the given hex string to a stream property value.");
            }
        }
        throw new ClassCastException("Cannot cast the given value to the value of this stream data type.");
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.Stream;
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) {
        return this.createValue(buffer);
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionStream");
        super.appendMetadictXML(typeElement, namespace, prefix);
    }

    @Override
    public TypeDefinitionStream clone() {
        return (TypeDefinitionStream)super.clone();
    }

    public static class StreamValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionStreamImpl type;
        private Stream value;
        private tv.amwa.maj.enumeration.ByteOrder byteOrder = null;

        private StreamValue(TypeDefinitionStreamImpl type, Stream value) {
            this.type = type;
            this.setValue(value);
            this.byteOrder = null;
        }

        private StreamValue(TypeDefinitionStreamImpl type, Stream value, tv.amwa.maj.enumeration.ByteOrder order) {
            this.type = type;
            this.setValue(value);
            this.byteOrder = order;
        }

        @Override
        public TypeDefinitionImpl getType() {
            return this.type;
        }

        @Override
        public Stream getValue() {
            return this.value;
        }

        public boolean isDefinedType() {
            return true;
        }

        private void setValue(Stream value) {
            this.value = value;
        }

        public tv.amwa.maj.enumeration.ByteOrder getByteOrder() {
            return this.byteOrder;
        }
    }
}

